/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.workflow.po.FlowWorkTeam;
import com.centit.workflow.po.FlowWorkTeamId;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FlowWorkTeamDao
extends BaseDaoImpl<FlowWorkTeam, FlowWorkTeamId> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("flowInstid", "flowInstId=:flowInstId");
        filterField.put("userCode", "userCode=:userCode");
        filterField.put("roleCode", "roleCode=:roleCode");
        filterField.put("authDesc", "LIKE");
        filterField.put("authTime", "EQUAL");
        filterField.put("ORDER BY", "userOrder");
        return filterField;
    }

    @Transactional
    public void deleteFlowWorkTeam(String flowInstId, String roleCode) {
        List<FlowWorkTeam> team = this.listFlowWorkTeamByRole(flowInstId, roleCode);
        if (team == null || team.size() == 0) {
            return;
        }
        for (FlowWorkTeam t : team) {
            this.deleteObject((Serializable)t);
        }
    }

    @Transactional
    public List<FlowWorkTeam> listFlowWorkTeam(String flowInstId) {
        return this.listObjectsByFilter("where flow_Inst_Id = ? order by role_Code, user_Order", new Object[]{flowInstId});
    }

    @Transactional
    public List<FlowWorkTeam> listFlowWorkTeam(List<String> flowInstIds) {
        HashMap<String, Object[]> filterMap = new HashMap<String, Object[]>();
        filterMap.put("flowInstIds", flowInstIds.toArray());
        return this.listObjectsByFilter("where 1=1 and FLOW_INST_ID in (:flowInstIds) order by role_Code, user_Order", filterMap);
    }

    @Transactional
    public List<FlowWorkTeam> listFlowWorkTeamByRole(String flowInstId, String roleCode) {
        return this.listObjectsByFilter("where flow_Inst_Id = ? and role_Code = ? order by user_Order", new Object[]{flowInstId, roleCode});
    }

    @Transactional
    public List<FlowWorkTeam> listFlowWorkTeamByRole(String flowInstId, String roleCode, String runtoken) {
        return this.listObjectsByFilter("where flow_Inst_Id = ? and role_Code = ? and RUN_TOKEN = ? order by user_Order", new Object[]{flowInstId, roleCode, runtoken});
    }

    @Transactional
    public List<FlowWorkTeam> listFlowWorkTeam(String flowInstId, String roleCode, String authdesc) {
        return this.listObjectsByFilter("where flow_Inst_Id = ? and role_Code = ? and auth_Desc = ? order by user_Order", new Object[]{flowInstId, roleCode, authdesc});
    }
}

