/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.workflow.po.NodeInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class NodeInfoDao
extends BaseDaoImpl<NodeInfo, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("nodeId", "EQUAL");
        filterField.put("flowCode", "EQUAL");
        filterField.put("version", "EQUAL");
        filterField.put("nodeType", "EQUAL");
        filterField.put("nodeName", "LIKE");
        filterField.put("optType", "EQUAL");
        filterField.put("optCode", "EQUAL");
        filterField.put("subFlowCode", "EQUAL");
        filterField.put("nodeCode", "EQUAL");
        filterField.put("nodeDesc", "LIKE");
        filterField.put("roleType", "EQUAL");
        filterField.put("roleCode", "EQUAL");
        return filterField;
    }

    @Transactional
    public Set<String> getUnitExp(String flowCode, Long version) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("flowCode", flowCode);
        paramMap.put("version", version);
        List nodeList = this.listObjectsByFilter("where unit_Exp is not null", paramMap);
        HashSet<String> unitExpSet = new HashSet<String>();
        for (NodeInfo node : nodeList) {
            if (!StringUtils.isNotBlank((CharSequence)node.getUnitExp())) continue;
            unitExpSet.add(node.getUnitExp());
        }
        return unitExpSet;
    }

    @Transactional
    public List<NodeInfo> listNodeByNodecode(String flowCode, Long version, String nodeCode) {
        return this.listObjectsByFilter("where FLOW_CODE=? and version=? and node_Code=?", new Object[]{flowCode, version, nodeCode});
    }

    @Transactional
    public NodeInfo getNodeByNodeInstId(String nodeInstId) {
        List nodes = this.listObjectsBySql("select a.* from WF_NODE_INSTANCE b join WF_NODE a on b.NODE_ID = a.NODE_ID where b.NODE_INST_ID = ?", new Object[]{nodeInstId});
        return nodes == null ? null : (NodeInfo)nodes.get(0);
    }
}

