/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.NodeInstance;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class NodeInstanceDao
extends BaseDaoImpl<NodeInstance, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("nodeInstId", "EQUAL");
        filterField.put("flowInstId", "EQUAL");
        filterField.put("nodeId", "EQUAL");
        filterField.put("(date)createTime", "createTime like :createTime");
        filterField.put("(date)lastUpdateTime", "lastUpdateTime like :createTime");
        filterField.put("lastUpdateUser", "EQUAL");
        filterField.put("startTime", "EQUAL");
        filterField.put("nodeState", "EQUAL");
        filterField.put("roleCode", "EQUAL");
        filterField.put("subFlowInstId", "EQUAL");
        filterField.put("unitCode", "EQUAL");
        filterField.put("transId", "EQUAL");
        filterField.put("runToken", "EQUAL");
        filterField.put("taskAssigned", "EQUAL");
        filterField.put("userCode", "EQUAL");
        filterField.put("ORDER BY", "nodeInstId desc");
        return filterField;
    }

    @Transactional
    public long getNextNodeInstId() {
        return DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_NODEINSTNO");
    }

    @Transactional
    public void updtNodeInstState(String nodeInstId, String state) {
        NodeInstance nodeInst = (NodeInstance)this.getObjectById(nodeInstId);
        nodeInst.setNodeState(state);
        this.updateObject((Serializable)nodeInst);
    }

    @Transactional
    public void updtNodeInstParam(String nodeInstId, String nodeParam) {
        NodeInstance nodeInst = (NodeInstance)this.getObjectById(nodeInstId);
        nodeInst.setNodeParam(nodeParam);
        this.updateObject((Serializable)nodeInst);
    }

    @Transactional
    public List<NodeInstance> listNodeInstByState(String flowInstId, String nodeState) {
        return this.listObjectsByFilter("where node_State= ? and flow_Inst_Id= ?", new Object[]{nodeState, flowInstId});
    }

    @Transactional
    public List<NodeInstance> listNodesWithoutOpt() {
        return this.listObjectsByFilter("where (node_State='N' or node_State='R') and  node_Inst_Id not in (select node_Inst_Id from v_user_task_list) and flow_Inst_Id in (select flow_Inst_Id from WF_FLOW_INSTANCE where inst_State='N' )order by node_Inst_Id desc", new Object[0]);
    }

    @Transactional
    public List<NodeInstance> listNearExpireNodeInstance(long leaveTime) {
        return this.listObjectsByFilter(" where time_Limit <= ? and node_State='N' and (is_Timer='T' or is_Timer='R')", new Object[]{leaveTime});
    }

    @Transactional
    public List<NodeInstance> listLastUpdateNodeInst(String userCode, String state) {
        return this.listObjectsByFilter(" where last_Update_User = ? and node_State = ? order by last_Update_Time ", new Object[]{userCode, state});
    }

    @Transactional
    public List<NodeInstance> listNodeInstByTimer(String userCode, String isTimer, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson(" where last_Update_User = ? and is_Timer = ? order by last_Update_Time ", new Object[]{userCode, isTimer}, pageDesc).toJavaList(NodeInstance.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public void updateNodeTimerState(String instid, String isTimer, String mangerUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.getObjectById(instid);
        nodeInst.setIsTimer(isTimer);
        nodeInst.setLastUpdateUser(mangerUserCode);
        nodeInst.setLastUpdateTime(new Date(System.currentTimeMillis()));
        this.updateObject((Serializable)nodeInst);
    }

    @Transactional
    public List<NodeInstance> listActiveTimerNodeByFlow(String flowInstId) {
        return this.listObjectsByFilter(" where node_state in ('N','W','S','T') and flow_Inst_Id = ? and is_Timer = 'T' ", new Object[]{flowInstId});
    }

    @Transactional
    public List<NodeInstance> listActiveTimerNodeByFlowStage(String flowInstId, String flowStage) {
        return this.listObjectsByFilter(" where flow_Inst_Id = ? and STAGE_CODE = ? and is_Timer = 'T'", new Object[]{flowInstId, flowStage});
    }

    @Transactional
    public JSONArray viewFlowNodes(Map<String, Object> filterMap) {
        String sql = " select n.NODE_ID,n.NODE_CODE,n.NODE_NAME,  t.NODE_INST_ID, t.NODE_STATE, t.CREATE_TIME, t.LAST_UPDATE_TIME,t.last_update_user  from wf_node n  left join (select * from wf_node_instance where 1=1  [ :flowInstId| and FLOW_INST_ID = :flowInstId]) t  on n.NODE_ID = t.NODE_ID   where n.NODE_TYPE = 'C'  [ :flowCode| and n.FLOW_CODE = :flowCode] [ :version| and n.VERSION = :version]  order by t.last_update_time is null, t.last_update_time asc ,NODE_STATE desc";
        QueryAndNamedParams queryAndNamedParams = QueryUtils.translateQuery((String)sql, filterMap);
        return DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)queryAndNamedParams.getQuery(), (Map)queryAndNamedParams.getParams());
    }

    public void updateNodeStateById(FlowInstance wfFlowInst) {
        String sql = "update WF_NODE_INSTANCE set NODE_STATE=?, LAST_UPDATE_TIME=?,LAST_UPDATE_USER=? where NODE_STATE = 'N' and FLOW_INST_ID=?";
        this.getJdbcTemplate().update(sql, new Object[]{wfFlowInst.getInstState(), wfFlowInst.getLastUpdateTime(), wfFlowInst.getLastUpdateUser(), wfFlowInst.getFlowInstId()});
    }
}

