/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import com.centit.workflow.po.OptTeamRole;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class OptTeamRoleDao
extends BaseDaoImpl<OptTeamRole, String> {
    public Map<String, String> getFilterField() {
        return null;
    }

    @Transactional
    public Map<String, String> getRoleByFlowCode(String flowCode, Long version) {
        LinkedHashMap<String, String> roleMap = new LinkedHashMap<String, String>();
        String sql = "select role.* from WF_OPT_TEAM_ROLE role left join WF_FLOW_DEFINE define on role.OPT_ID=define.OPT_ID where 1=1 [ :flowCode | and define.FLOW_CODE = :flowCode ] [ :version | and define.VERSION = :version ] order by TEAM_ROLE_ORDER asc";
        QueryAndNamedParams queryAndNamedParams = QueryUtils.translateQuery((String)sql, (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"flowCode", flowCode, "version", version}));
        JSONArray dataList = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)queryAndNamedParams.getQuery(), (Map)queryAndNamedParams.getParams());
        if (dataList == null) {
            return roleMap;
        }
        List optTeamRoles = dataList.toJavaList(OptTeamRole.class, new JSONReader.Feature[0]);
        optTeamRoles.forEach(role -> roleMap.put(role.getRoleCode(), role.getRoleName()));
        return roleMap;
    }

    @Transactional
    public OptTeamRole getItemRole(String flowCode, Long version, String roleCode) {
        String sql = "select role.* from WF_OPT_TEAM_ROLE role left join WF_FLOW_DEFINE define on role.OPT_ID=define.OPT_ID where 1=1 [ :flowCode | and define.FLOW_CODE = :flowCode] [ :version | and define.VERSION = :version] [ :roleCode | and role.ROLE_CODE = :roleCode]";
        QueryAndNamedParams queryAndNamedParams = QueryUtils.translateQuery((String)sql, (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"flowCode", flowCode, "version", version, "roleCode", roleCode}));
        JSONObject data = DatabaseOptUtils.getObjectBySqlAsJson((BaseDaoImpl)this, (String)queryAndNamedParams.getQuery(), (Map)queryAndNamedParams.getParams());
        if (null != data) {
            return (OptTeamRole)data.toJavaObject(OptTeamRole.class, new JSONReader.Feature[0]);
        }
        return null;
    }

    public int updateObject(OptTeamRole o) {
        return super.updateObjectWithNullField((Serializable)o);
    }

    @Transactional
    public Map<String, String> getRoleByOptId(String optId) {
        LinkedHashMap<String, String> roleMap = new LinkedHashMap<String, String>();
        List optTeamRoles = this.listObjectsByFilter("where opt_id = ? order by TEAM_ROLE_ORDER asc", new Object[]{optId});
        if (optTeamRoles == null || optTeamRoles.size() == 0) {
            return roleMap;
        }
        optTeamRoles.forEach(role -> roleMap.put(role.getRoleCode(), role.getRoleName()));
        return roleMap;
    }

    @Transactional
    public OptTeamRole getItemRole(String optId, String roleCode) {
        return (OptTeamRole)this.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId, "roleCode", roleCode}));
    }
}

