/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.adapter.OperationLogWriter;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.common.WorkTimeSpan;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.commons.NodeEventSupport;
import com.centit.workflow.commons.SubmitOptOptions;
import com.centit.workflow.dao.FlowInfoDao;
import com.centit.workflow.dao.FlowInstanceDao;
import com.centit.workflow.dao.FlowInstanceGroupDao;
import com.centit.workflow.dao.FlowOrganizeDao;
import com.centit.workflow.dao.FlowTransitionDao;
import com.centit.workflow.dao.FlowWorkTeamDao;
import com.centit.workflow.dao.NodeInfoDao;
import com.centit.workflow.dao.NodeInstanceDao;
import com.centit.workflow.dao.RoleRelegateDao;
import com.centit.workflow.dao.StageInstanceDao;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowInfoId;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.FlowInstanceGroup;
import com.centit.workflow.po.FlowOrganize;
import com.centit.workflow.po.FlowTransition;
import com.centit.workflow.po.FlowWorkTeam;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.po.RoleRelegate;
import com.centit.workflow.po.StageInstance;
import com.centit.workflow.service.FlowEngine;
import com.centit.workflow.service.FlowManager;
import com.centit.workflow.service.impl.FlowOptUtils;
import com.centit.workflow.service.impl.NodeEventSupportFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowManagerImpl
implements FlowManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(FlowManagerImpl.class);
    @Autowired
    FlowInstanceDao flowInstanceDao;
    @Autowired
    NodeInstanceDao nodeInstanceDao;
    @Autowired
    NodeInfoDao flowNodeDao;
    @Autowired
    FlowTransitionDao flowTransitionDao;
    @Autowired
    FlowInfoDao flowDefDao;
    @Autowired
    StageInstanceDao stageInstanceDao;
    @Autowired
    RoleRelegateDao flowRoleRelegateDao;
    @Autowired
    FlowEngine flowEngine;
    @Autowired
    FlowInstanceGroupDao flowInstanceGroupDao;
    @Autowired
    private FlowOrganizeDao flowOrganizeDao;
    @Autowired
    private FlowWorkTeamDao flowTeamDao;
    @Autowired(required=false)
    private OperationLogWriter optLogManager;

    public Map<String, Object> viewFlowInstance(String flowInstId) {
        FlowInstance wfInst = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(flowInstId);
        FlowInfoId id = new FlowInfoId(wfInst.getVersion(), wfInst.getFlowCode());
        FlowInfo wfDef = (FlowInfo)this.flowDefDao.getObjectWithReferences(id);
        HashMap<String, String> nodeState = new HashMap<String, String>();
        HashMap<String, Integer> nodeInstCount = new HashMap<String, Integer>();
        HashMap<String, Object> nodeMap = new HashMap<String, Object>();
        HashMap<String, String> transState = new HashMap<String, String>();
        HashMap<String, FlowTransition> transMap = new HashMap<String, FlowTransition>();
        List nodeSet = wfDef.getNodeList();
        Boolean findTran = true;
        String benginNodeId = "";
        String endNodeID = "";
        for (Object node : nodeSet) {
            nodeState.put(node.getNodeId(), "ready");
            if (node.getNodeType().equals("A")) {
                nodeState.put(node.getNodeId(), "complete");
                benginNodeId = node.getNodeId();
            } else if (node.getNodeType().equals("F")) {
                endNodeID = node.getNodeId();
            }
            nodeInstCount.put(node.getNodeId(), 0);
            nodeMap.put(node.getNodeId(), node);
        }
        List transSet = wfDef.getTransList();
        for (FlowTransition trans : transSet) {
            if (trans.getStartNodeId().equals(benginNodeId)) {
                transState.put(String.valueOf(trans.getTransId()), "1");
            } else {
                transState.put(String.valueOf(trans.getTransId()), "-1");
            }
            transMap.put(String.valueOf(trans.getTransId()), trans);
        }
        List nodeInstSet = wfInst.getFlowNodeInstances();
        ArrayList<Object> completeNodeSet = new ArrayList<Object>();
        ArrayList<FlowTransition> completeTrans = new ArrayList<FlowTransition>();
        block2: for (Object nodeInst : nodeInstSet) {
            if (nodeInst.getNodeState().equals("N") || nodeInst.getNodeState().equals("W")) {
                nodeState.put(nodeInst.getNodeId(), "waiting");
            } else {
                String string = (String)nodeState.get(nodeInst.getNodeId());
                if (nodeInst.getNodeState().equals("P") && !"waiting".equals(string)) {
                    nodeState.put(nodeInst.getNodeId(), "suspend");
                }
                if ("ready".equals(string)) {
                    if (nodeInst.getNodeState().equals("F")) {
                        nodeState.put(nodeInst.getNodeId(), "suspend");
                    } else if (nodeInst.getNodeState().equals("C")) {
                        if (nodeInst.getNodeId().equals(endNodeID)) {
                            findTran = false;
                        }
                        nodeState.put(nodeInst.getNodeId(), "complete");
                        completeNodeSet.add(nodeInst);
                    }
                }
                if ("B".equals(nodeInst.getNodeState())) {
                    nodeState.put(nodeInst.getNodeId(), "suspend");
                }
                if ("C".equals(nodeInst.getNodeState())) {
                    nodeState.put(nodeInst.getNodeId(), "complete");
                    nodeState.put(nodeInst.getNodeId(), "complete");
                }
            }
            Integer n = (Integer)nodeInstCount.get(nodeInst.getNodeId());
            nodeInstCount.put(nodeInst.getNodeId(), n == null ? 1 : n + 1);
            String transPath = nodeInst.getTransPath();
            if (transPath == null && nodeInstSet.size() > 1) continue;
            if (StringUtils.isNotBlank((CharSequence)transPath)) {
                String[] transs = transPath.split(",");
                for (String strTransId : transs) {
                    transState.put(strTransId, "1");
                    FlowTransition trans = (FlowTransition)transMap.get(strTransId);
                    completeTrans.add(trans);
                    if (trans == null) continue;
                    NodeInfo node = (NodeInfo)nodeMap.get(trans.getStartNodeId());
                    if (node != null && "R".equals(node.getNodeType())) {
                        nodeState.put(trans.getStartNodeId(), "complete");
                    }
                    if ((node = (NodeInfo)nodeMap.get(trans.getEndNodeId())) == null || !"R".equals(node.getNodeType())) continue;
                    nodeState.put(trans.getEndNodeId(), "complete");
                    Integer n2 = (Integer)nodeInstCount.get(trans.getEndNodeId());
                    nodeInstCount.put(trans.getEndNodeId(), n2 == null ? 1 : n2 + 1);
                }
            }
            if (!findTran.booleanValue()) continue;
            for (FlowTransition trans : transSet) {
                if (!nodeInst.getNodeId().equals(trans.getStartNodeId()) || !trans.getEndNodeId().equals(endNodeID) || !"C".equals(wfInst.getInstState())) continue;
                transState.put(String.valueOf(trans.getTransId()), "1");
                findTran = false;
                continue block2;
            }
        }
        if (findTran.booleanValue()) {
            ArrayList finalTrans = new ArrayList();
            block5: for (FlowTransition flowTransition : transSet) {
                if (!flowTransition.getEndNodeId().equals(endNodeID) || !"C".equals(wfInst.getInstState())) continue;
                for (NodeInfo node : nodeSet) {
                    if (!flowTransition.getStartNodeId().equals(node.getNodeId()) || !"R".equals(node.getNodeType())) continue;
                    HashMap<NodeInfo, FlowTransition> map = new HashMap<NodeInfo, FlowTransition>();
                    map.put(node, flowTransition);
                    finalTrans.add(map);
                    continue block5;
                }
            }
            if (!finalTrans.isEmpty()) {
                block7: for (Map map : finalTrans) {
                    for (NodeInfo no : map.keySet()) {
                        for (NodeInstance nodeInstance : completeNodeSet) {
                            for (FlowTransition trans : transSet) {
                                if (!trans.getStartNodeId().equals(nodeInstance.getNodeId()) || !trans.getEndNodeId().equals(no.getNodeId())) continue;
                                if (!completeTrans.isEmpty()) {
                                    Boolean trueTrans = true;
                                    for (FlowTransition tr : completeTrans) {
                                        if (!trans.getStartNodeId().equals(tr.getStartNodeId()) || trans.getEndNodeId().equals(tr.getEndNodeId()) && !trans.getEndNodeId().equals(endNodeID)) continue;
                                        trueTrans = false;
                                    }
                                    if (!trueTrans.booleanValue()) continue;
                                    transState.put(String.valueOf(trans.getTransId()), "1");
                                    transState.put(String.valueOf(((FlowTransition)map.get(no)).getTransId()), "1");
                                    nodeState.put(no.getNodeId(), "complete");
                                    findTran = false;
                                    break block7;
                                }
                                transState.put(String.valueOf(trans.getTransId()), "1");
                                transState.put(String.valueOf(((FlowTransition)map.get(no)).getTransId()), "1");
                                nodeState.put(no.getNodeId(), "complete");
                                findTran = false;
                                break block7;
                            }
                        }
                    }
                }
            }
        }
        ArrayList<Map> nodes = new ArrayList<Map>();
        for (Map.Entry entry : nodeState.entrySet()) {
            nodes.add(CollectionsOpt.createHashMap((Object[])new Object[]{"id", entry.getKey(), "inststate", entry.getValue(), "instcount", nodeInstCount.get(entry.getKey())}));
        }
        ArrayList<Map> steps = new ArrayList<Map>();
        for (Map.Entry ts : transState.entrySet()) {
            steps.add(CollectionsOpt.createHashMap((Object[])new Object[]{"id", ts.getKey(), "inststate", ts.getValue()}));
        }
        return CollectionsOpt.createHashMap((Object[])new Object[]{"nodes", nodes, "steps", steps});
    }

    public String viewFlowNodeInstance(String flowInstId) {
        FlowInstance wfInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        Document viewDoc = DocumentHelper.createDocument();
        Element baseEle = viewDoc.addElement("flow");
        Element procsEle = baseEle.addElement("nodes");
        List nodeInstSet = wfInst.getFlowNodeInstances();
        for (NodeInstance wfInstNodes : nodeInstSet) {
            Element procEle = procsEle.addElement("node");
            procEle.addAttribute("id", String.valueOf(wfInstNodes.getNodeInstId()));
            procEle.addAttribute("pid", String.valueOf(wfInstNodes.getPrevNodeInstId()));
            procEle.addAttribute("nodeid", String.valueOf(wfInstNodes.getNodeId()));
            procEle.addAttribute("nodeCode", wfInstNodes.getNodeCode());
            procEle.addAttribute("token", wfInstNodes.getRunToken());
            procEle.addAttribute("nodeName", wfInstNodes.getNodeName());
            procEle.addAttribute("nodeState", wfInstNodes.getNodeState());
            procEle.addAttribute("createTime", DatetimeOpt.convertDatetimeToString((Date)wfInstNodes.getCreateTime()));
            procEle.addAttribute("lastUpdateTime", DatetimeOpt.convertDatetimeToString((Date)wfInstNodes.getLastUpdateTime()));
            procEle.addAttribute("lastUpdateUser", wfInstNodes.getLastUpdateUser());
        }
        return viewDoc.asXML();
    }

    private int updateInstanceState(String instid, String state, String userCode, String admindesc) {
        FlowInstance wfFlowInst = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(instid);
        if (wfFlowInst == null) {
            return 0;
        }
        Date updateTime = DatetimeOpt.currentUtilDate();
        wfFlowInst.setLastUpdateTime(updateTime);
        wfFlowInst.setLastUpdateUser(userCode);
        String actionDesc = "U";
        if ("P".equals(state) && "N".equals(wfFlowInst.getInstState())) {
            wfFlowInst.setInstState(state);
            actionDesc = "\u6302\u8d77\u6d41\u7a0b\uff1b";
        } else if ("F".equals(state) && !"C".equals(wfFlowInst.getInstState()) && !"F".equals(wfFlowInst.getInstState())) {
            actionDesc = "\u5f3a\u5236\u7ed3\u675f\u6d41\u7a0b\uff1b";
        } else if ("N".equals(state) && "P".equals(wfFlowInst.getInstState())) {
            actionDesc = "\u5524\u9192\u6d41\u7a0b\uff1b";
        }
        if ("U".equals(actionDesc)) {
            return -1;
        }
        wfFlowInst.setInstState(state);
        if ("N".equals(state)) {
            for (NodeInstance nodeInst : wfFlowInst.getFlowNodeInstances()) {
                if (!"P".equals(nodeInst.getNodeState())) continue;
                nodeInst.setNodeState(state);
                nodeInst.setLastUpdateTime(updateTime);
                nodeInst.setLastUpdateUser(userCode);
                this.nodeInstanceDao.updateObject((Serializable)nodeInst);
            }
        } else if ("P".equals(state)) {
            for (NodeInstance nodeInst : wfFlowInst.getFlowNodeInstances()) {
                if (!"N".equals(nodeInst.getNodeState())) continue;
                nodeInst.setNodeState(state);
                nodeInst.setLastUpdateTime(updateTime);
                nodeInst.setLastUpdateUser(userCode);
                this.nodeInstanceDao.updateObject((Serializable)nodeInst);
            }
        }
        this.flowInstanceDao.updateObject((Serializable)wfFlowInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(userCode, instid, "\u66f4\u6539\u6d41\u7a0b\u72b6\u6001\u4e3a" + state + ";" + admindesc);
        managerAct.setNewValue((Object)(actionDesc + admindesc));
        OperationLogCenter.log((OperationLog)managerAct);
        return 1;
    }

    public long updateNodeInstState(String nodeInstId, String newState, String mangerUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return 0L;
        }
        nodeInst.setLastUpdateUser(mangerUserCode);
        nodeInst.setLastUpdateTime(new Date(System.currentTimeMillis()));
        String actionDesc = "U";
        if ("P".equals(newState) && "N".equals(nodeInst.getNodeState())) {
            actionDesc = "\u6302\u8d77\u8282\u70b9\u3002";
        } else if ("F".equals(newState) && !"C".equals(nodeInst.getNodeState()) && !"F".equals(nodeInst.getNodeState())) {
            actionDesc = "\u5f3a\u5236\u7ed3\u675f\u8282\u70b9\u3002";
        } else if ("N".equals(newState) && ("S".equals(nodeInst.getNodeState()) || "P".equals(nodeInst.getNodeState()))) {
            actionDesc = "\u5524\u9192\u8282\u70b9\uff1b";
        }
        if ("U".equals(actionDesc)) {
            return -1L;
        }
        nodeInst.setNodeState(newState);
        this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, nodeInst, "\u5524\u9192\u6d41\u7a0b\u8282\u70b9\uff1b" + actionDesc, null);
        OperationLogCenter.log((OperationLog)managerAct);
        return 1L;
    }

    public long suspendNodeInstance(String nodeInstId, String mangerUserCode) {
        return this.updateNodeInstState(nodeInstId, "P", mangerUserCode);
    }

    public long activizeNodeInstance(String nodeInstId, String mangerUserCode) {
        return this.updateNodeInstState(nodeInstId, "N", mangerUserCode);
    }

    public void updateNodeState(String nodeInstId, String newState) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return;
        }
        nodeInst.setLastUpdateTime(new Date(System.currentTimeMillis()));
        nodeInst.setNodeState(newState);
        this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        OperationLog managerAct = FlowOptUtils.createActionLog("admin", nodeInst, "\u5f3a\u5236\u4fee\u6539\u6d41\u7a0b\u7684\u8282\u70b9\u72b6\u6001\u4e3a" + newState + "\uff1b", null);
        OperationLogCenter.log((OperationLog)managerAct);
    }

    public long resetNodeTimelimt(String nodeInstId, String timeLimit, String mangerUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return 0L;
        }
        nodeInst.setTimeLimit(Long.valueOf(new WorkTimeSpan(timeLimit).toNumberAsMinute()));
        this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, nodeInst, "\u91cd\u7f6e\u8282\u70b9\u671f\u9650\uff1a" + new WorkTimeSpan(timeLimit).getTimeSpanDesc(), null);
        OperationLogCenter.log((OperationLog)managerAct);
        return 1L;
    }

    public FlowInstance getFlowInstance(String flowInstId) {
        FlowInstance flowInstance = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(flowInstId);
        if (flowInstance != null) {
            this.initNodeInstances(flowInstance);
        }
        return flowInstance;
    }

    public void initNodeInstances(FlowInstance flowInstance) {
        if (flowInstance.getFlowNodeInstances() != null) {
            for (NodeInstance nodeInstance : flowInstance.getFlowNodeInstances()) {
                NodeInfo node = (NodeInfo)this.flowNodeDao.getObjectById(nodeInstance.getNodeId());
                if (node != null) {
                    nodeInstance.setNodeName(node.getNodeName());
                }
                nodeInstance.setFlowOptName(flowInstance.getFlowOptName());
                nodeInstance.setFlowOptTag(flowInstance.getFlowOptTag());
            }
        }
    }

    public JSONArray listFlowInstance(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.flowInstanceDao.listObjectsByPropertiesAsJson(filterMap, pageDesc);
    }

    @Transactional
    public int stopInstance(String flowInstId, String mangerUserCode, String admindesc) {
        FlowInstance wfFlowInst = this.flowEngine.getFlowInstById(flowInstId);
        if (wfFlowInst == null) {
            return 0;
        }
        if ("C".equals(wfFlowInst.getInstState()) || "F".equals(wfFlowInst.getInstState())) {
            return -1;
        }
        Date updateTime = DatetimeOpt.currentUtilDate();
        wfFlowInst.setLastUpdateTime(updateTime);
        wfFlowInst.setLastUpdateUser(mangerUserCode);
        wfFlowInst.setFlowInstId(flowInstId);
        wfFlowInst.setInstState("F");
        this.flowInstanceDao.updtFlowInstInfo(wfFlowInst);
        for (NodeInstance nodeInst : wfFlowInst.getFlowNodeInstances()) {
            if (!"N".equals(nodeInst.getNodeState()) && !"P".equals(nodeInst.getNodeState()) && !"S".equals(nodeInst.getNodeState())) continue;
            nodeInst.setNodeState("F");
            nodeInst.setLastUpdateTime(updateTime);
            nodeInst.setLastUpdateUser(mangerUserCode);
            this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        }
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, flowInstId, "\u5f3a\u5236\u7ed3\u675f\u6d41\u7a0b;" + admindesc);
        OperationLogCenter.log((OperationLog)managerAct);
        return 1;
    }

    public int suspendInstance(String flowInstId, String mangerUserCode, String admindesc) {
        return this.updateInstanceState(flowInstId, "P", mangerUserCode, admindesc);
    }

    public int activizeInstance(String flowInstId, String mangerUserCode, String admindesc) {
        return this.updateInstanceState(flowInstId, "N", mangerUserCode, admindesc);
    }

    public void updateFlowInstUnit(String flowInstId, String unitCode, String optUserCode) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (flowInst == null) {
            return;
        }
        flowInst.setUnitCode(unitCode);
        this.flowInstanceDao.updateObject((Serializable)flowInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(optUserCode, flowInstId, "\u4fee\u6539\u6d41\u7a0b\u673a\u6784\u4ee3\u7801\uff1a" + unitCode);
        OperationLogCenter.log((OperationLog)managerAct);
    }

    public void updateNodeInstUnit(String nodeInstId, String unitCode, String optUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return;
        }
        nodeInst.setUnitCode(unitCode);
        this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(optUserCode, nodeInst, "\u4fee\u6539\u8282\u70b9\uff1a" + nodeInstId + "\u673a\u6784\u4ee3\u7801\uff1a" + unitCode, null);
        OperationLogCenter.log((OperationLog)managerAct);
    }

    public void updateNodeRoleInfo(String nodeInstId, String roleType, String roleCode, String mangerUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return;
        }
        nodeInst.setRoleType(roleType);
        nodeInst.setRoleCode(roleCode);
        this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, nodeInst, "\u4fee\u6539\u8282\u70b9\uff1a" + nodeInstId + "\u89d2\u8272\u4ee3\u7801\u4e3a\uff1a" + roleType + ":" + roleCode + "\u3002", null);
        OperationLogCenter.log((OperationLog)managerAct);
    }

    public long resetFlowTimelimt(String flowInstId, String timeLimit, String mangerUserCode, String admindesc) {
        FlowInstance wfFlowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (wfFlowInst == null) {
            return 0L;
        }
        wfFlowInst.setLastUpdateTime(new Date(System.currentTimeMillis()));
        wfFlowInst.setLastUpdateUser(mangerUserCode);
        wfFlowInst.setTimeLimit(Long.valueOf(new WorkTimeSpan(timeLimit).toNumberAsMinute()));
        this.flowInstanceDao.updateObject((Serializable)wfFlowInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, flowInstId, "\u66f4\u6539\u6d41\u7a0b\u671f\u9650\uff1a" + new WorkTimeSpan(timeLimit).getTimeSpanDesc() + ";" + admindesc);
        OperationLogCenter.log((OperationLog)managerAct);
        return 1L;
    }

    public NodeInstance resetFlowToThisNode(String nodeInstId, String mangerUserCode) {
        NodeInstance thisnode = (NodeInstance)this.nodeInstanceDao.getObjectWithReferences(nodeInstId);
        if (thisnode == null) {
            return null;
        }
        FlowInstance flow = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(thisnode.getFlowInstId());
        if (flow == null) {
            return null;
        }
        if ("N".equals(thisnode.getNodeState())) {
            flow.setInstState("N");
            this.flowInstanceDao.updateObject((Serializable)flow);
            return null;
        }
        NodeInfo nodedef = (NodeInfo)this.flowNodeDao.getObjectById(thisnode.getNodeId());
        if ("A".equals(nodedef.getNodeType()) || "F".equals(nodedef.getNodeType())) {
            return null;
        }
        for (NodeInstance nodeInst : flow.getFlowNodeInstances()) {
            if (!"N".equals(nodeInst.getNodeState()) && !"W".equals(nodeInst.getNodeState()) || !nodeInst.getNodeId().equals(thisnode.getNodeId()) || !nodeInst.getRunToken().equals(thisnode.getRunToken())) continue;
            return null;
        }
        flow.setInstState("N");
        String thisToken = thisnode.getRunToken();
        Date updateTime = DatetimeOpt.currentUtilDate();
        for (NodeInstance nodeInst : flow.getFlowNodeInstances()) {
            FlowInstance subFlowInst;
            String currToken = nodeInst.getRunToken();
            if (!"N,W".contains(nodeInst.getNodeState()) || currToken == null || thisToken == null || !currToken.equals(thisToken) && !currToken.startsWith(thisToken + '.') && !thisToken.startsWith(currToken + '.') && !currToken.startsWith(thisToken + '.' + "R")) continue;
            if ("W".equals(nodeInst.getNodeState()) && (subFlowInst = (FlowInstance)this.flowInstanceDao.getObjectById(nodeInst.getSubFlowInstId())) != null) {
                FlowOptUtils.endInstance(subFlowInst, "F", mangerUserCode, this.flowInstanceDao);
                subFlowInst.setLastUpdateUser(mangerUserCode);
                this.flowInstanceDao.updateObject((Serializable)subFlowInst);
            }
            nodeInst.setNodeState("B");
            nodeInst.setLastUpdateUser(mangerUserCode);
            nodeInst.setLastUpdateTime(updateTime);
            this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        }
        thisnode.setNodeState("B");
        thisnode.setLastUpdateUser(mangerUserCode);
        thisnode.setLastUpdateTime(updateTime);
        this.nodeInstanceDao.updateObject((Serializable)thisnode);
        String lastNodeInstId = UuidOpt.getUuidAsString32();
        NodeInstance nextNodeInst = flow.newNodeInstance();
        nextNodeInst.copyNotNullProperty(thisnode);
        nextNodeInst.setNodeInstId(lastNodeInstId);
        nextNodeInst.setNodeState("N");
        nextNodeInst.setTaskAssigned(thisnode.getTaskAssigned());
        nextNodeInst.setLastUpdateUser(mangerUserCode);
        nextNodeInst.setLastUpdateTime(updateTime);
        flow.addNodeInstance(nextNodeInst);
        this.flowInstanceDao.updateObject((Serializable)flow);
        this.nodeInstanceDao.saveNewObject((Serializable)nextNodeInst);
        NodeEventSupport nodeEventExecutor = NodeEventSupportFactory.createNodeEventSupportBean(nodedef, this.flowEngine);
        nodeEventExecutor.runAfterCreate(flow, nextNodeInst, nodedef, mangerUserCode);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, nextNodeInst, "\u91cd\u65b0\u8fd0\u884c\u8282\u70b9\uff1a" + nodeInstId, nodedef);
        OperationLogCenter.log((OperationLog)managerAct);
        return nextNodeInst;
    }

    public String forceDissociateRuning(String nodeInstId, String mangerUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null || !"N".equals(nodeInst.getNodeState())) {
            return null;
        }
        FlowInstance flowinst = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(nodeInst.getFlowInstId());
        if (flowinst == null) {
            return null;
        }
        int otherRunNode = 0;
        for (NodeInstance tNode : flowinst.getFlowNodeInstances()) {
            if (tNode.getNodeInstId().equals(nodeInstId) || !"N".equals(tNode.getNodeState())) continue;
            ++otherRunNode;
        }
        if (otherRunNode == 0) {
            return null;
        }
        nodeInst.setRunToken(nodeInst.getRunToken() + "." + "R");
        nodeInst.setLastUpdateUser(mangerUserCode);
        nodeInst.setLastUpdateTime(new Date(System.currentTimeMillis()));
        this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, nodeInst, "\u5f3a\u5236\u8282\u70b9\u5206\u652f\u4e3a\u6e38\u79bb\u5206\u652f:" + nodeInstId, null);
        OperationLogCenter.log((OperationLog)managerAct);
        return nodeInstId;
    }

    public String forceCommit(String nodeInstId, String mangerUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return null;
        }
        Date updateTime = DatetimeOpt.currentUtilDate();
        List<FlowTransition> transList = this.flowTransitionDao.getNodeTrans(nodeInst.getNodeId());
        if (transList == null || transList.size() == 0) {
            nodeInst.setLastUpdateTime(updateTime);
            nodeInst.setLastUpdateUser(mangerUserCode);
            OperationLog wfactlog = FlowOptUtils.createActionLog(mangerUserCode, nodeInst, "\u5f3a\u5236\u63d0\u4ea4\u8282\u70b9:" + nodeInstId, null);
            wfactlog.time(updateTime);
            OperationLogCenter.log((OperationLog)wfactlog);
            nodeInst.setNodeState("F");
            this.nodeInstanceDao.updateObject((Serializable)nodeInst);
            return nodeInst.getRunToken().startsWith("R") ? "" : null;
        }
        if (transList.size() != 1) {
            return null;
        }
        FlowTransition trans = transList.get(0);
        String nextCode = transList.get(0).getEndNodeId();
        NodeInfo nextNode = (NodeInfo)this.flowNodeDao.getObjectById(nextCode);
        if (nextNode == null) {
            return null;
        }
        if (!"C".equals(nextNode.getNodeType()) && !"B".equals(nextNode.getNodeType())) {
            return null;
        }
        List nextNodeInstId = this.flowEngine.submitOpt(SubmitOptOptions.create().user(nodeInst.getUserCode()).unit(nodeInst.getUnitCode()).nodeInst(nodeInstId));
        nodeInst.setNodeState("F");
        this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        OperationLog wfactlog = FlowOptUtils.createActionLog(mangerUserCode, nodeInst, "\u5f3a\u5236\u63d0\u4ea4\u8282\u70b9:" + nodeInstId, null);
        wfactlog.time(updateTime);
        OperationLogCenter.log((OperationLog)wfactlog);
        return StringBaseOpt.castObjectToString((Object)nextNodeInstId);
    }

    public List<NodeInstance> listNodesWithoutOpt() {
        List<NodeInstance> tempList = this.nodeInstanceDao.listNodesWithoutOpt();
        if (tempList != null) {
            for (NodeInstance nodeInst : tempList) {
                FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(nodeInst.getFlowInstId());
                nodeInst.setFlowOptName(flowInst.getFlowOptName());
                nodeInst.setFlowOptTag(flowInst.getFlowOptTag());
                NodeInfo wfNode = (NodeInfo)this.flowNodeDao.getObjectById(nodeInst.getNodeId());
                nodeInst.setNodeName(wfNode.getNodeName());
            }
            return new ArrayList<NodeInstance>(tempList);
        }
        return new ArrayList<NodeInstance>();
    }

    public List<NodeInstance> listFlowActiveNodes(String wfinstid) {
        return this.nodeInstanceDao.listNodeInstByState(wfinstid, "N");
    }

    public List<NodeInstance> listFlowInstNodes(String wfinstid) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(wfinstid);
        if (flowInst == null) {
            throw new ObjectException(604, "\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728,flow_inst_id:" + wfinstid);
        }
        List nodeInstsSet = flowInst.getFlowNodeInstances();
        ArrayList<NodeInstance> nodeInstList = new ArrayList<NodeInstance>();
        for (NodeInstance nodeInst : nodeInstsSet) {
            NodeInfo node = (NodeInfo)this.flowNodeDao.getObjectById(nodeInst.getNodeId());
            if (node == null) continue;
            nodeInst.setNodeName(node.getNodeName());
            nodeInst.setOptUrl(JSON.toJSONString((Object)CollectionsOpt.createHashMap((Object[])new Object[]{"osId", node.getOsId(), "optId", node.getOptId(), "optCode", node.getOptCode(), "optParam", node.getOptParam(), "flowCode", node.getFlowCode()})));
            nodeInstList.add(nodeInst);
        }
        return new ArrayList<NodeInstance>(nodeInstList);
    }

    public int suspendNodeInstTimer(String nodeInstId, String mangerUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return -1;
        }
        this.nodeInstanceDao.updateNodeTimerState(nodeInstId, "P", mangerUserCode);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, nodeInst, "\u6682\u505c\u8282\u70b9\u8ba1\u65f6:" + nodeInstId, null);
        OperationLogCenter.log((OperationLog)managerAct);
        return 1;
    }

    public int activizeNodeInstTimer(String nodeInstId, String mangerUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return 0;
        }
        NodeInfo node = (NodeInfo)this.flowNodeDao.getObjectById(nodeInst.getNodeId());
        this.nodeInstanceDao.updateNodeTimerState(nodeInstId, node.getIsAccountTime(), mangerUserCode);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, nodeInst, "\u6062\u590d\u8282\u70b9\u8ba1\u65f6:" + nodeInstId, null);
        OperationLogCenter.log((OperationLog)managerAct);
        return 1;
    }

    public int suspendFlowInstTimer(String flowInstId, String mangerUserCode) {
        this.flowInstanceDao.updateFlowTimerState(flowInstId, "P", mangerUserCode);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, flowInstId, "\u6682\u505c\u6d41\u7a0b\u8ba1\u65f6: " + flowInstId);
        OperationLogCenter.log((OperationLog)managerAct);
        return 1;
    }

    public int activizeFlowInstTimer(String flowInstId, String mangerUserCode) {
        this.flowInstanceDao.updateFlowTimerState(flowInstId, "T", mangerUserCode);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, flowInstId, "\u6062\u590d\u6d41\u7a0b\u8ba1\u65f6: " + flowInstId);
        OperationLogCenter.log((OperationLog)managerAct);
        return 1;
    }

    public List<NodeInstance> listPauseTimerNodeInst(String userCode, PageDesc pageDesc) {
        List<NodeInstance> tempList = this.nodeInstanceDao.listNodeInstByTimer(userCode, "P", pageDesc);
        return new ArrayList<NodeInstance>(tempList);
    }

    public List<FlowInstance> listPauseTimerFlowInst(String userCode, PageDesc pageDesc) {
        List<FlowInstance> tempList = this.flowInstanceDao.listFlowInstByTimer(userCode, "P", pageDesc);
        return new ArrayList<FlowInstance>(tempList);
    }

    public List<StageInstance> listStageInstByFlowInstId(String flowInstId) {
        return new ArrayList<StageInstance>(this.stageInstanceDao.listStageInstByFlowInstId(flowInstId));
    }

    public long resetStageTimelimt(String flowInstId, String stageId, String timeLimit, String mangerUserCode, String admindesc) {
        FlowInstance wfFlowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (wfFlowInst == null) {
            return 0L;
        }
        StageInstance stageInst = this.stageInstanceDao.getObject(flowInstId, stageId);
        stageInst.setLastUpdateTime(new Date(System.currentTimeMillis()));
        stageInst.setTimeLimit(Long.valueOf(new WorkTimeSpan(timeLimit).toNumberAsMinute()));
        this.flowInstanceDao.updateObject((Serializable)wfFlowInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, flowInstId, "\u66f4\u6539\u9636\u6bb5" + stageId + "\u671f\u9650\uff1a" + new WorkTimeSpan(timeLimit).getTimeSpanDesc() + ";" + admindesc);
        OperationLogCenter.log((OperationLog)managerAct);
        return 1L;
    }

    public int moveUserTaskTo(String fromUserCode, String toUserCode, String optUserCode, String moveDesc) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("taskAssigned", "S");
        filterMap.put("userCode", fromUserCode);
        filterMap.put("nodeState", "N");
        List nodeInstances = this.nodeInstanceDao.listObjectsByProperties(filterMap);
        this.moveUserTaskTo(nodeInstances, fromUserCode, toUserCode, optUserCode);
        return 0;
    }

    private void moveUserTaskTo(List<NodeInstance> nodeInstIds, String fromUserCode, String toUserCode, String optUserCode) {
        if (nodeInstIds != null && nodeInstIds.size() > 0) {
            for (NodeInstance nodeInstance : nodeInstIds) {
                if (!StringUtils.equals((CharSequence)fromUserCode, (CharSequence)nodeInstance.getUserCode()) || !"S".equals(nodeInstance.getTaskAssigned())) continue;
                nodeInstance.setUserCode(toUserCode);
                nodeInstance.setLastUpdateTime(DatetimeOpt.currentUtilDate());
                nodeInstance.setLastUpdateUser(optUserCode);
                this.nodeInstanceDao.updateObject((Serializable)nodeInstance);
                OperationLog wfactlog = FlowOptUtils.createActionLog(optUserCode, nodeInstance, "\u4efb\u52a1\u4ece " + fromUserCode + " \u8f6c\u79fb\u5230" + toUserCode, null);
                OperationLogCenter.log((OperationLog)wfactlog);
            }
        }
    }

    public int moveUserTaskTo(List<String> nodeInstIds, String fromUserCode, String toUserCode, String optUserCode, String moveDesc) {
        ArrayList<NodeInstance> nodeInstanceList = new ArrayList<NodeInstance>();
        for (String id : nodeInstIds) {
            NodeInstance nodeInstance = (NodeInstance)this.nodeInstanceDao.getObjectById(id);
            nodeInstanceList.add(nodeInstance);
        }
        this.moveUserTaskTo(nodeInstanceList, fromUserCode, toUserCode, optUserCode);
        return 0;
    }

    public int assignNodeTask(String nodeInstId, String userCode, String mangerUserCode, String authDesc) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return -1;
        }
        nodeInst.setTaskAssigned("S");
        nodeInst.setUserCode(userCode);
        nodeInst.setLastUpdateUser(mangerUserCode);
        nodeInst.setLastUpdateTime(DatetimeOpt.currentUtilDate());
        this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        OperationLog wfactlog = FlowOptUtils.createActionLog(mangerUserCode, nodeInst, "\u6307\u5b9a\u64cd\u4f5c\u7528\u6237" + userCode + ":" + authDesc, null);
        OperationLogCenter.log((OperationLog)wfactlog);
        return 0;
    }

    public List<? extends OperationLog> listFlowActionLogs(String flowInstId, boolean withNodeAction) {
        if (this.optLogManager == null) {
            return null;
        }
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"optTag", flowInstId});
        if (!withNodeAction) {
            filterMap.put("optMethod", "flowOpt");
        }
        return this.optLogManager.listOptLog("workflow", filterMap, -1, -1);
    }

    public List<? extends OperationLog> listNodeActionLogs(String flowInstId, String nodeInstId) {
        if (this.optLogManager == null) {
            return null;
        }
        return this.optLogManager.listOptLog("workflow", CollectionsOpt.createHashMap((Object[])new Object[]{"optTag", flowInstId, "optMethod", nodeInstId}), -1, -1);
    }

    public List<? extends OperationLog> listNodeActionLogs(String nodeInstId) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return null;
        }
        return this.listNodeActionLogs(nodeInst.getFlowInstId(), nodeInstId);
    }

    public List<? extends OperationLog> listUserActionLogs(String userCode, Date lastTime, PageDesc pageDesc) {
        if (this.optLogManager == null) {
            return null;
        }
        Map filterMap = CollectionsOpt.createHashMap((Object[])new Object[]{"userCode", userCode, "optTime_gt", lastTime});
        List optLogs = this.optLogManager.listOptLog("workflow", filterMap, pageDesc.getRowStart(), pageDesc.getPageSize());
        pageDesc.setTotalRows(Integer.valueOf(this.optLogManager.countOptLog("workflow", filterMap)));
        return optLogs;
    }

    public RoleRelegate getRoleRelegateById(Long relegateno) {
        return (RoleRelegate)this.flowRoleRelegateDao.getObjectById(relegateno);
    }

    public void saveRoleRelegate(RoleRelegate roleRelegate) {
        roleRelegate.setRecordDate((Date)DatetimeOpt.currentSqlDate());
        this.flowRoleRelegateDao.saveObject(roleRelegate);
    }

    public List<RoleRelegate> listRoleRelegateByUser(String userCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("grantee", userCode);
        return this.flowRoleRelegateDao.listObjectsByProperties(filterMap, new PageDesc(-1, -1));
    }

    public List<RoleRelegate> listRoleRelegateByGrantor(String grantor) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("grantor", grantor);
        return this.flowRoleRelegateDao.listObjectsByProperties(filterMap, new PageDesc(-1, -1));
    }

    public void updateFlow(FlowInstance flowInstance) {
        this.flowInstanceDao.updateObject((Serializable)flowInstance);
    }

    public void updateFlowInstOptInfoAndUser(String flowInstId, String flowOptName, String flowOptTag, String userCode, String unitCode) {
        this.flowInstanceDao.updateFlowInstOptInfoAndUser(flowInstId, flowOptName, flowOptTag, userCode, unitCode);
    }

    public NodeInstance getFirstNodeInst(String flowInstId) {
        return this.getFlowInstance(flowInstId).getFirstNodeInstance();
    }

    public boolean deleteFlowInstById(String flowInstId, String userCode) {
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("flowInstId", flowInstId);
        filterMap.put("userCode", userCode);
        FlowInstance flowInstance = (FlowInstance)this.flowInstanceDao.getObjectByProperties(filterMap);
        if (flowInstance == null) {
            logger.info("\u7528\u6237 {} \u6ca1\u6709\u6743\u9650\u5220\u9664\u6d41\u7a0b {}", (Object)userCode, (Object)flowInstId);
            return false;
        }
        this.flowInstanceDao.deleteObjectById(flowInstId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flowInstId", flowInstId);
        this.nodeInstanceDao.deleteObjectsByProperties(map);
        return true;
    }

    public NodeInstance reStartFlow(String flowInstId, String managerUserCode, Boolean force) {
        FlowInstance flowInstance = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(flowInstId);
        if (!force.booleanValue() && !managerUserCode.equals(flowInstance.getLastUpdateUser())) {
            return null;
        }
        NodeInstance startNodeInst = this.resetFlowToThisNode(flowInstance.getFirstNodeInstance().getNodeInstId(), managerUserCode);
        this.flowEngine.deleteFlowVariable(flowInstId, "", "");
        return startNodeInst;
    }

    public List<JSONObject> getListRoleRelegateByGrantor(String grantor) {
        RoleRelegate newRelegate;
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("grantor", grantor);
        List roleRelegateList = this.flowRoleRelegateDao.listObjectsByProperties(filterMap, new PageDesc(-1, -1));
        HashMap hashMap = new HashMap();
        for (RoleRelegate roleRelegate : roleRelegateList) {
            List<String> roleCodeList;
            String grantee = roleRelegate.getGrantee();
            if (!hashMap.containsKey(grantee)) {
                roleCodeList = new ArrayList<String>();
                roleCodeList.add(roleRelegate.getRoleCode());
                HashMap<String, List<String>> stringObjectHashMap = new HashMap<String, List<String>>();
                hashMap.put(grantee, stringObjectHashMap);
                stringObjectHashMap.put("roleCodeList", roleCodeList);
                newRelegate = new RoleRelegate();
                newRelegate.copy(roleRelegate);
                newRelegate.setRoleCode(JSON.toJSONString(roleCodeList));
                stringObjectHashMap.put("newRelegate", (List<String>)newRelegate);
                continue;
            }
            roleCodeList = (List)((Map)hashMap.get(grantee)).get("roleCodeList");
            roleCodeList.add(roleRelegate.getRoleCode());
        }
        Set entries = hashMap.entrySet();
        ArrayList newList = new ArrayList(entries);
        ArrayList<JSONObject> roleRelegates = new ArrayList<JSONObject>();
        for (Map.Entry mapEntry : newList) {
            newRelegate = (RoleRelegate)((Map)mapEntry.getValue()).get("newRelegate");
            List roleCodeList = (List)((Map)mapEntry.getValue()).get("roleCodeList");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put((Object)"grantor", (Object)newRelegate.getGrantor());
            jsonObject.put((Object)"grantee", (Object)newRelegate.getGrantee());
            jsonObject.put((Object)"roleCode", (Object)roleCodeList);
            jsonObject.put((Object)"unitCode", (Object)newRelegate.getUnitCode());
            jsonObject.put((Object)"relegateTime", (Object)newRelegate.getRelegateTime());
            jsonObject.put((Object)"expireTime", (Object)newRelegate.getExpireTime());
            jsonObject.put((Object)"grantDesc", (Object)newRelegate.getGrantDesc());
            roleRelegates.add(jsonObject);
        }
        return roleRelegates;
    }

    public JSONArray listFlowInstGroup(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.flowInstanceGroupDao.listObjectsByPropertiesAsJson(filterMap, pageDesc);
    }

    public FlowInstanceGroup getFlowInstanceGroup(String flowInstGroupId) {
        return (FlowInstanceGroup)this.flowInstanceGroupDao.getObjectById(flowInstGroupId);
    }

    public List<NodeInstance> listNodeInstance(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return this.nodeInstanceDao.listObjectsByProperties(searchColumn, pageDesc);
    }

    public ResponseData dubboNodeInstance(Map<String, Object> searchColumn, PageDesc pageDesc) {
        PageDesc pageDescCopy = new PageDesc();
        pageDescCopy.copy(pageDesc);
        List<NodeInstance> nodeInstances = this.listNodeInstance(searchColumn, pageDescCopy);
        PageQueryResult pageQueryResult = PageQueryResult.createResultMapDict(nodeInstances, (PageDesc)pageDescCopy);
        return pageQueryResult.toResponseData();
    }

    public void updateFlowState(String flowInstId, String mangerUserCode, String instState, String desc) {
        FlowInstance wfFlowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (wfFlowInst == null) {
            return;
        }
        if ("C".equals(wfFlowInst.getInstState()) || "F".equals(wfFlowInst.getInstState())) {
            return;
        }
        Date updateTime = DatetimeOpt.currentUtilDate();
        wfFlowInst.setInstState(instState);
        wfFlowInst.setLastUpdateTime(updateTime);
        wfFlowInst.setLastUpdateUser(mangerUserCode);
        this.flowInstanceDao.updtFlowInstInfo(wfFlowInst);
        this.nodeInstanceDao.updateNodeStateById(wfFlowInst);
        OperationLog managerAct = FlowOptUtils.createActionLog(mangerUserCode, flowInstId, "\u5f3a\u5236\u4fee\u6539\u6d41\u7a0b\u72b6\u6001\u4e3a" + instState + ";" + desc);
        OperationLogCenter.log((OperationLog)managerAct);
    }

    public JSONArray listFlowInstDetailed(Map<String, Object> searchColumn, PageDesc pageDesc) {
        Object flowInstIds = searchColumn.get("flowInstIds");
        if (flowInstIds != null) {
            searchColumn.put("flowInstIds", flowInstIds.toString().split(","));
        }
        List flowInstances = this.flowInstanceDao.listObjectsByProperties(searchColumn, pageDesc);
        JSONArray flowInstArray = DictionaryMapUtils.objectsToJSONArray((Collection)flowInstances);
        if (flowInstances.isEmpty()) {
            return flowInstArray;
        }
        ArrayList<String> flowInstIdList = new ArrayList<String>();
        flowInstances.forEach(f -> flowInstIdList.add(f.getFlowInstId()));
        List<FlowOrganize> flowOrganizes = this.flowOrganizeDao.listFlowOrganize(flowInstIdList);
        JSONArray flowOrganizeArray = DictionaryMapUtils.objectsToJSONArray(flowOrganizes);
        List<FlowWorkTeam> flowWorkTeams = this.flowTeamDao.listFlowWorkTeam(flowInstIdList);
        JSONArray flowWorkTeamArray = DictionaryMapUtils.objectsToJSONArray(flowWorkTeams);
        for (int i = 0; i < flowInstArray.size(); ++i) {
            String roleCode;
            int j;
            String flowInstId = flowInstArray.getJSONObject(i).getString("flowInstId");
            for (j = 0; j < flowOrganizeArray.size(); ++j) {
                if (!flowInstId.equals(flowOrganizeArray.getJSONObject(j).getString("flowInstId"))) continue;
                roleCode = flowOrganizeArray.getJSONObject(j).getString("roleCode");
                if (flowInstArray.getJSONObject(i).getString(roleCode) == null) {
                    flowInstArray.getJSONObject(i).put((Object)roleCode, (Object)flowOrganizeArray.getJSONObject(j).getString("unitName"));
                    continue;
                }
                flowInstArray.getJSONObject(i).put((Object)roleCode, (Object)(flowInstArray.getJSONObject(i).getString(roleCode) + "," + flowOrganizeArray.getJSONObject(j).getString("unitName")));
            }
            for (j = 0; j < flowWorkTeamArray.size(); ++j) {
                if (!flowInstId.equals(flowWorkTeamArray.getJSONObject(j).getString("flowInstId"))) continue;
                roleCode = flowWorkTeamArray.getJSONObject(j).getString("roleCode");
                if (flowInstArray.getJSONObject(i).getString(roleCode) == null) {
                    flowInstArray.getJSONObject(i).put((Object)roleCode, (Object)flowWorkTeamArray.getJSONObject(j).getString("userName"));
                    continue;
                }
                flowInstArray.getJSONObject(i).put((Object)roleCode, (Object)(flowInstArray.getJSONObject(i).getString(roleCode) + "," + flowWorkTeamArray.getJSONObject(j).getString("userName")));
            }
        }
        return flowInstArray;
    }

    @Transactional
    public void deleteFlowInstByIds(List<String> flowInstIds) {
        for (String flowInstId : flowInstIds) {
            if (StringUtils.isBlank((CharSequence)flowInstId)) continue;
            this.flowInstanceDao.deleteObjectById(flowInstId);
            this.nodeInstanceDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"flowInstId", flowInstId}));
        }
    }

    private void innerUpgradeFlowVersion(String flowCode, long newVersion, long oldVersion) {
        String sqlUpdateNodeInst = "update WF_NODE_INSTANCE a set a.NODE_ID = (select max(b.NODE_ID) from WF_NODE b where b.FLOW_CODE=? and b.VERSION =? and b.NODE_CODE = (select c.NODE_CODE from WF_NODE c where c.NODE_ID = a.NODE_ID))  where FLOW_INST_ID in (select f.FLOW_INST_ID from  WF_FLOW_INSTANCE f where f.INST_STATE in ('N','P') and f.FLOW_CODE= ? and f.VERSION = ? ";
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.nodeInstanceDao, (String)sqlUpdateNodeInst, (Object[])new Object[]{flowCode, newVersion, flowCode, oldVersion});
        String sqlUpdateFlowInst = "update WF_FLOW_INSTANCE f set f.VERSION = ? where f.INST_STATE in ('N','P') and f.FLOW_CODE= ? and f.VERSION = ?  ";
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.nodeInstanceDao, (String)sqlUpdateFlowInst, (Object[])new Object[]{newVersion, flowCode, oldVersion});
    }

    @Transactional
    public void upgradeFlowVersion(String flowCode, long newVersion, long oldVersion) {
        if (newVersion <= 0L) {
            newVersion = this.flowDefDao.getLastVersion(flowCode);
        }
        if (oldVersion > 0L) {
            this.innerUpgradeFlowVersion(flowCode, newVersion, oldVersion);
            return;
        }
        for (long v = newVersion - 1L; v > 0L; --v) {
            this.innerUpgradeFlowVersion(flowCode, newVersion, v);
        }
    }
}

