/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.centit.framework.model.adapter.UserUnitFilterCalcContext;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserRole;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.common.WorkTimeSpan;
import com.centit.workflow.commons.FlowOptParamOptions;
import com.centit.workflow.dao.FlowInstanceDao;
import com.centit.workflow.dao.FlowVariableDao;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.FlowStage;
import com.centit.workflow.po.FlowTransition;
import com.centit.workflow.po.FlowVariable;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.po.StageInstance;
import com.centit.workflow.service.impl.FlowEngineImpl;
import com.centit.workflow.service.impl.FlowVariableTranslate;
import com.centit.workflow.service.impl.UserUnitCalcEngine;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public abstract class FlowOptUtils {
    public static FlowInstance createFlowInst(String topUnit, String unitcode, String usercode, FlowInfo wf, String flowInstId, String timeLimitStr) {
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(611, "topUnit\u5c5e\u6027\u4e3anull\u65e0\u6cd5\u521b\u5efa\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u8bf7\u548c\u5f00\u53d1\u4eba\u5458\u8054\u7cfb\u3002");
        }
        FlowInstance flowInst = new FlowInstance();
        flowInst.setFlowInstId(flowInstId);
        flowInst.setFlowCode(wf.getFlowCode());
        flowInst.setVersion(wf.getVersion());
        flowInst.setOsId(wf.getOsId());
        flowInst.setOptId(wf.getOptId());
        flowInst.setUnitCode(unitcode);
        flowInst.setUserCode(usercode);
        flowInst.setPreNodeInstId("");
        flowInst.setTopUnit(topUnit);
        flowInst.setPreInstId("");
        flowInst.setIsSubInst(Boolean.valueOf(false));
        flowInst.setInstState("N");
        flowInst.setCreateTime(new Date(System.currentTimeMillis()));
        String timeLimit = wf.getTimeLimit();
        if (StringUtils.isNotBlank((CharSequence)timeLimitStr)) {
            timeLimit = timeLimitStr;
        }
        flowInst.setIsTimer("F");
        for (FlowStage wfStage : wf.getFlowStages()) {
            StageInstance stageInst = flowInst.newFlowStageInstance();
            stageInst.setFlowInstId(flowInstId);
            stageInst.setStageCode(wfStage.getStageCode());
            stageInst.setStageId(wfStage.getStageId());
            stageInst.setStageBegin(StageInstance.STAGE_TIMER_STATE_NOT_START);
            if (BooleanBaseOpt.castObjectToBoolean((Object)wfStage.getIsAccountTime(), (Boolean)false).booleanValue()) {
                stageInst.setPromiseTime(Long.valueOf(new WorkTimeSpan(wfStage.getTimeLimit()).toNumberAsMinute()));
                stageInst.setTimeLimit(stageInst.getPromiseTime());
            } else {
                stageInst.setPromiseTime(Long.valueOf(-1L));
                stageInst.setTimeLimit(Long.valueOf(1L));
            }
            flowInst.addFlowStageInstance(stageInst);
        }
        if (StringUtils.isNotBlank((CharSequence)timeLimit)) {
            flowInst.setIsTimer("T");
            flowInst.setTimeLimit(Long.valueOf(new WorkTimeSpan(timeLimit).toNumberAsMinute()));
        } else {
            flowInst.setTimeLimit(null);
        }
        flowInst.setPromiseTime(flowInst.getTimeLimit());
        return flowInst;
    }

    public static void setNewNodeInstTimelimit(NodeInstance nodeInst, String timeLimit, FlowInstance flowInst, NodeInstance preNodeInst, FlowInfo flowInfo, NodeInfo node, FlowVariableTranslate varTrans) {
        long timeLimitInMinute = 0L;
        if (StringUtils.isNotBlank((CharSequence)timeLimit)) {
            String tlt = timeLimit.trim();
            if (tlt.startsWith("ref:")) {
                if (varTrans != null) {
                    tlt = StringBaseOpt.castObjectToString((Object)varTrans.getVarValue(tlt.substring(4)));
                    timeLimitInMinute = new WorkTimeSpan(tlt).toNumberAsMinute();
                }
            } else {
                timeLimitInMinute = new WorkTimeSpan(tlt).toNumberAsMinute();
            }
        }
        if ("1".equals(node.getInheritType())) {
            if (preNodeInst != null && preNodeInst.getTimeLimit() != null) {
                nodeInst.setTimeLimit(Long.valueOf(timeLimitInMinute + preNodeInst.getTimeLimit()));
            } else {
                nodeInst.setTimeLimit(Long.valueOf(timeLimitInMinute));
            }
        } else if ("2".equals(node.getInheritType())) {
            List nodes = flowInfo.listNodesByNodeCode(node.getInheritNodeCode());
            NodeInstance inhertInst = null;
            for (NodeInfo thisNode : nodes) {
                NodeInstance tempInst = flowInst.findLastSameNodeInst(thisNode.getNodeId(), nodeInst, nodeInst.getNodeInstId());
                if (inhertInst != null && !inhertInst.getCreateTime().before(tempInst.getCreateTime())) continue;
                inhertInst = tempInst;
            }
            if (inhertInst == null) {
                nodeInst.setTimeLimit(Long.valueOf(timeLimitInMinute));
            } else {
                nodeInst.setTimeLimit(Long.valueOf(timeLimitInMinute + inhertInst.getTimeLimit()));
            }
        } else {
            nodeInst.setTimeLimit(Long.valueOf(timeLimitInMinute));
        }
    }

    public static NodeInstance createNodeInst(String unitcode, String usercode, FlowInstance flowInst, NodeInstance preNodeInst, FlowInfo flowInfo, NodeInfo node, FlowTransition trans, FlowVariableTranslate varTrans) {
        String timeLimitType;
        String timeLimit;
        NodeInstance nodeInst = new NodeInstance();
        nodeInst.setFlowInstId(flowInst.getFlowInstId());
        Date updateTime = DatetimeOpt.currentUtilDate();
        nodeInst.setNodeId(node.getNodeId());
        nodeInst.setUnitCode(unitcode);
        nodeInst.setNodeState("N");
        nodeInst.setTaskAssigned("S");
        nodeInst.setRunToken("T");
        nodeInst.setLastUpdateUser(usercode);
        nodeInst.setCreateTime(updateTime);
        nodeInst.setRoleCode(node.getRoleCode());
        nodeInst.setRoleType(node.getRoleType());
        nodeInst.setStageCode(node.getStageCode());
        nodeInst.setIsTimer(node.getIsAccountTime());
        nodeInst.setTimeLimit(Long.valueOf(new WorkTimeSpan(node.getTimeLimit()).toNumberAsMinute()));
        if (preNodeInst != null) {
            nodeInst.setPrevNodeInstId(preNodeInst.getNodeInstId());
        }
        if (StringUtils.equalsAny((CharSequence)node.getIsAccountTime(), (CharSequence[])new CharSequence[]{"T", "F", "H"})) {
            flowInst.setIsTimer(node.getIsAccountTime());
        }
        if (trans == null || trans.getLimitType() == null || "I".equals(trans.getLimitType())) {
            timeLimit = node.getTimeLimit();
            timeLimitType = node.getLimitType();
        } else {
            timeLimit = trans.getTimeLimit();
            timeLimitType = trans.getLimitType();
        }
        if ("C".equals(timeLimitType)) {
            NodeInstance sameInst = flowInst.findLastSameNodeInst(nodeInst.getNodeId(), nodeInst, nodeInst.getNodeInstId());
            if (sameInst != null) {
                nodeInst.setTimeLimit(sameInst.getTimeLimit());
            } else {
                FlowOptUtils.setNewNodeInstTimelimit(nodeInst, timeLimit, flowInst, preNodeInst, flowInfo, node, varTrans);
            }
        } else if ("F".equals(timeLimitType)) {
            FlowOptUtils.setNewNodeInstTimelimit(nodeInst, timeLimit, flowInst, preNodeInst, flowInfo, node, varTrans);
        }
        nodeInst.setPromiseTime(nodeInst.getTimeLimit());
        return nodeInst;
    }

    public static OperationLog createActionLog(String usercode, String flowInstId, String logDetail) {
        return OperationLog.create().operation("workflow").tag(flowInstId).method("flowOpt").user(usercode).content(logDetail);
    }

    public static OperationLog createActionLog(String usercode, NodeInstance nodeInst, String logDetail, NodeInfo node) {
        OperationLog actionLog = FlowOptUtils.createActionLog(usercode, nodeInst.getFlowInstId(), logDetail).unit(nodeInst.getUnitCode()).method(nodeInst.getNodeInstId());
        if (node != null) {
            actionLog.setNewValue((Object)(usercode + ":" + node.getRoleType() + ":" + node.getRoleCode()));
        }
        return actionLog;
    }

    public static void endInstance(FlowInstance flowInst, String endType, String userCode, FlowInstanceDao flowInstanceDao) {
        flowInst.setInstState(endType);
        Date updateTime = DatetimeOpt.currentUtilDate();
        flowInst.setLastUpdateTime(updateTime);
        flowInst.setLastUpdateUser(userCode);
        for (NodeInstance ni : flowInst.getFlowNodeInstances()) {
            FlowInstance subFlowInst;
            if (!"W".equals(ni.getNodeState()) || (subFlowInst = (FlowInstance)flowInstanceDao.getObjectById(ni.getSubFlowInstId())) == null || "F,C".contains(subFlowInst.getInstState())) continue;
            FlowOptUtils.endInstance(subFlowInst, "F", userCode, flowInstanceDao);
        }
        flowInstanceDao.updateObject((Serializable)flowInst);
    }

    public static FlowVariableTranslate createVariableTranslate(NodeInstance nodeInstance, FlowInstance flowInstance, FlowVariableDao flowVariableDao, FlowEngineImpl flowEngine, FlowOptParamOptions options) {
        List<FlowVariable> defaultVariables;
        FlowVariableTranslate flowVarTrans = new FlowVariableTranslate(nodeInstance, flowInstance);
        boolean hasFlowGroup = StringUtils.isNotBlank((CharSequence)flowInstance.getFlowGroupId());
        if (nodeInstance == null) {
            nodeInstance = new NodeInstance();
        }
        if (options != null && options.getVariables() != null && !options.getVariables().isEmpty()) {
            for (Map.Entry ent : options.getVariables().entrySet()) {
                flowVarTrans.setInnerVariable((String)ent.getKey(), nodeInstance.getRunToken(), ent.getValue());
            }
        }
        if (options != null && options.getGlobalVariables() != null && !options.getGlobalVariables().isEmpty()) {
            for (Map.Entry ent : options.getGlobalVariables().entrySet()) {
                flowVarTrans.setInnerVariable((String)ent.getKey(), nodeInstance.getRunToken(), ent.getValue());
            }
        }
        List<FlowVariable> flowVariables = flowVariableDao.listFlowVariables(flowInstance.getFlowInstId());
        if (hasFlowGroup) {
            List<FlowVariable> groupVariables = flowVariableDao.listFlowVariables(flowInstance.getFlowGroupId());
            if (flowVariables == null) {
                flowVariables = groupVariables;
            } else {
                flowVariables.addAll(groupVariables);
            }
        }
        if ((defaultVariables = flowVariableDao.listFlowDefaultVariables(flowInstance.getFlowInstId(), flowInstance.getFlowCode(), flowInstance.getVersion())) != null) {
            flowVariables.addAll(defaultVariables);
        }
        flowVarTrans.setFlowVariables(flowVariables);
        Map<String, List<String>> flowOrgs = flowEngine.viewFlowOrganize(flowInstance.getFlowInstId());
        if (hasFlowGroup) {
            Map<String, List<String>> tempOrgs = flowEngine.viewFlowOrganize(flowInstance.getFlowGroupId());
            if (null != flowOrgs) {
                tempOrgs.putAll(flowOrgs);
            }
            flowOrgs = tempOrgs;
        }
        flowVarTrans.setFlowOrganizes(flowOrgs);
        Map<String, List<String>> flowTeams = flowEngine.viewFlowWorkTeam(flowInstance.getFlowInstId());
        if (hasFlowGroup) {
            Map<String, List<String>> tempTeams = flowEngine.viewFlowWorkTeam(flowInstance.getFlowGroupId());
            tempTeams.putAll(flowTeams);
            flowTeams = tempTeams;
        }
        flowVarTrans.setFlowWorkTeam(flowTeams);
        return flowVarTrans;
    }

    public static Map<String, Function<Object[], Object>> createExtendFuncMap(Supplier<UserUnitFilterCalcContext> supplierContent) {
        HashMap<String, Function<Object[], Object>> extendFuncs = new HashMap<String, Function<Object[], Object>>(12);
        extendFuncs.put("userRank", a -> {
            UserUnitFilterCalcContext context = (UserUnitFilterCalcContext)supplierContent.get();
            if (a == null || ((Object[])a).length < 1) {
                return null;
            }
            return context.getUserRank(StringBaseOpt.castObjectToString((Object)a[0]));
        });
        extendFuncs.put("userType", a -> {
            UserUnitFilterCalcContext context = (UserUnitFilterCalcContext)supplierContent.get();
            if (a == null || ((Object[])a).length < 1) {
                return null;
            }
            UserInfo ui = context.getUserInfoByCode(StringBaseOpt.castObjectToString((Object)a[0]));
            if (ui == null) {
                return "";
            }
            return ui.getUserType();
        });
        extendFuncs.put("unitType", a -> {
            UserUnitFilterCalcContext context = (UserUnitFilterCalcContext)supplierContent.get();
            if (a == null || ((Object[])a).length < 1) {
                return null;
            }
            UnitInfo ui = context.getUnitInfoByCode(StringBaseOpt.castObjectToString((Object)a[0]));
            if (ui == null) {
                return "";
            }
            return ui.getUnitType();
        });
        extendFuncs.put("userUnits", a -> {
            UserUnitFilterCalcContext context = (UserUnitFilterCalcContext)supplierContent.get();
            if (a == null || ((Object[])a).length < 1) {
                return null;
            }
            List userUnits = context.listUserUnits(StringBaseOpt.castObjectToString((Object)a[0]));
            return CollectionsOpt.mapCollectionToSet((Collection)userUnits, UserUnit::getUnitCode);
        });
        extendFuncs.put("unitUsers", a -> {
            UserUnitFilterCalcContext context = (UserUnitFilterCalcContext)supplierContent.get();
            if (a == null || ((Object[])a).length < 1) {
                return null;
            }
            List userUnits = context.listUnitUsers(StringBaseOpt.castObjectToString((Object)a[0]));
            return CollectionsOpt.mapCollectionToSet((Collection)userUnits, UserUnit::getUserCode);
        });
        extendFuncs.put("userRoles", a -> {
            UserUnitFilterCalcContext context = (UserUnitFilterCalcContext)supplierContent.get();
            if (a == null || ((Object[])a).length < 1) {
                return null;
            }
            String userCode = StringBaseOpt.castObjectToString((Object)a[0]);
            String userType = "XZ";
            if (((Object[])a).length > 1) {
                userType = StringBaseOpt.castObjectToString((Object)a[1]);
            }
            if ("RO".equals(userType)) {
                List roles = context.listUserRoles(userCode);
                return CollectionsOpt.mapCollectionToSet((Collection)roles, UserRole::getRoleCode);
            }
            if ("GW".equals(userType)) {
                List userUnits = context.listUserUnits(userCode);
                return CollectionsOpt.mapCollectionToSet((Collection)userUnits, UserUnit::getUserStation);
            }
            List userUnits = context.listUserUnits(userCode);
            return CollectionsOpt.mapCollectionToSet((Collection)userUnits, UserUnit::getUserRank);
        });
        extendFuncs.put("calcUnits", a -> {
            UserUnitFilterCalcContext context = (UserUnitFilterCalcContext)supplierContent.get();
            if (a == null || ((Object[])a).length < 1) {
                return null;
            }
            return UserUnitCalcEngine.calcUnitsByExp(context, StringBaseOpt.castObjectToString((Object)a[0]));
        });
        extendFuncs.put("calcUsers", a -> {
            UserUnitFilterCalcContext context = (UserUnitFilterCalcContext)supplierContent.get();
            if (a == null || ((Object[])a).length < 1) {
                return null;
            }
            return UserUnitCalcEngine.calcOperators(context, StringBaseOpt.castObjectToString((Object)a[0]));
        });
        return extendFuncs;
    }

    public static Map<String, Function<Object[], Object>> createExtendFuncMap(UserUnitFilterCalcContext calcContext) {
        return FlowOptUtils.createExtendFuncMap(() -> calcContext);
    }
}

