/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.centit.framework.model.adapter.UserUnitVariableTranslate;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.FlowVariable;
import com.centit.workflow.po.NodeInstance;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FlowVariableTranslate
implements UserUnitVariableTranslate {
    private Map<String, Map<String, Object>> innerVariable = new HashMap<String, Map<String, Object>>();
    private UserUnitVariableTranslate flowVarTrans;
    private List<FlowVariable> flowVariables;
    private Map<String, List<String>> flowOrganizes;
    private Map<String, List<String>> flowWorkTeam;
    private Map<String, Set<String>> nodeUnits;
    private Map<String, Set<String>> nodeUsers;
    private NodeInstance nodeInst;
    private FlowInstance flowInst;

    public void collectNodeUnitsAndUsers(FlowInstance flowInst) {
        String token;
        this.nodeUnits = new HashMap<String, Set<String>>();
        this.nodeUsers = new HashMap<String, Set<String>>();
        String string = token = this.nodeInst == null ? "T" : this.nodeInst.getRunToken();
        if (null != flowInst.getFlowNodeInstances()) {
            for (NodeInstance ni : flowInst.getFlowNodeInstances()) {
                String nc = ni.getNodeCode();
                if (nc == null || !token.equals(ni.getRunToken()) && !token.startsWith(ni.getRunToken() + ".")) continue;
                Set<String> nUnits = this.nodeUnits.get(nc);
                if (nUnits == null) {
                    nUnits = new HashSet<String>();
                }
                nUnits.add(ni.getUnitCode());
                this.nodeUnits.put(nc, nUnits);
                Set<String> nUsers = this.nodeUsers.get(nc);
                if (nUsers == null) {
                    nUsers = new HashSet<String>();
                }
                nUsers.add(ni.getUserCode());
                this.nodeUsers.put(nc, nUsers);
            }
        }
    }

    public FlowVariableTranslate(NodeInstance nodeInstance, FlowInstance flowInstance) {
        this.nodeInst = nodeInstance;
        this.flowInst = flowInstance;
        this.collectNodeUnitsAndUsers(this.flowInst);
    }

    public void setInnerVariable(String name, String token, Object value) {
        Map<String, Object> varMap = this.innerVariable.get(name);
        if (varMap == null) {
            varMap = new HashMap<String, Object>(4);
        }
        varMap.put(token, value);
        this.innerVariable.put(name, varMap);
    }

    public Object removeInnerVariable(String name, String token) {
        Map<String, Object> varMap = this.innerVariable.get(name);
        if (varMap == null) {
            return null;
        }
        if (varMap.containsKey(token)) {
            return varMap.remove(token);
        }
        return null;
    }

    public FlowVariable removeFLowVariable(String varName) {
        if (this.flowVariables == null || this.flowVariables.size() == 0) {
            return null;
        }
        String thisToken = this.nodeInst == null ? null : this.nodeInst.getRunToken();
        FlowVariable sValue = null;
        int nTL = 0;
        for (FlowVariable variable : this.flowVariables) {
            String currToken = variable.getRunToken();
            int cTL = currToken.length();
            if (!varName.equals(variable.getVarName()) || thisToken != null && !currToken.equals(thisToken) && !thisToken.startsWith(currToken + '.') || nTL >= cTL) continue;
            nTL = cTL;
            sValue = variable;
        }
        if (sValue != null) {
            this.flowVariables.remove(sValue);
        }
        return sValue;
    }

    public void setNodeInst(NodeInstance nodeInst) {
        this.nodeInst = nodeInst;
    }

    public void setFlowVarTrans(UserUnitVariableTranslate flowVarTrans) {
        this.flowVarTrans = flowVarTrans;
    }

    public void setFlowVariables(List<FlowVariable> flowVariables) {
        this.flowVariables = flowVariables;
    }

    public void setFlowOrganizes(Map<String, List<String>> flowOrganizes) {
        this.flowOrganizes = flowOrganizes;
    }

    public void setFlowWorkTeam(Map<String, List<String>> flowWorkTeam) {
        this.flowWorkTeam = flowWorkTeam;
    }

    private FlowVariable findFlowVariable(String varName) {
        if (this.flowVariables == null || this.flowVariables.size() == 0) {
            return null;
        }
        String thisToken = this.nodeInst == null ? null : this.nodeInst.getRunToken();
        FlowVariable sValue = null;
        int nTL = 0;
        for (FlowVariable variable : this.flowVariables) {
            String currToken = variable.getRunToken();
            int cTL = currToken.length();
            if (!varName.equals(variable.getVarName()) || thisToken != null && !currToken.equals(thisToken) && !thisToken.startsWith(currToken + '.') || nTL >= cTL) continue;
            nTL = cTL;
            sValue = variable;
        }
        return sValue;
    }

    public Object findInnerVariable(String varName) {
        Map<String, Object> varMap = this.innerVariable.get(varName);
        if (varMap == null || varMap.size() == 0) {
            return null;
        }
        String thisToken = this.nodeInst == null ? null : this.nodeInst.getRunToken();
        Object sValue = null;
        int nTL = 0;
        for (Map.Entry<String, Object> ent : varMap.entrySet()) {
            String currToken = ent.getKey();
            int cTL = currToken.length();
            if (!"T".equals(thisToken) && thisToken != null && !currToken.equals(thisToken) && !thisToken.startsWith(currToken + '.') || nTL >= cTL) continue;
            nTL = cTL;
            sValue = ent.getValue();
        }
        return sValue;
    }

    public Object getVarValue(String varName) {
        List<String> units;
        List<String> users;
        Object obj;
        Object objV = this.findInnerVariable(varName);
        if (objV != null) {
            return objV;
        }
        if (this.flowVarTrans != null && (obj = this.flowVarTrans.getVarValue(varName)) != null) {
            return obj;
        }
        FlowVariable v = this.findFlowVariable(varName);
        if (v != null) {
            String varStr = v.getVarValue();
            if (FlowVariable.FLOW_VARIABLE_TYPE_SINGLE.equals(v.getVarType())) {
                if (StringRegularOpt.isNumber((String)varStr)) {
                    return NumberBaseOpt.castObjectToNumber((Object)varStr);
                }
                return varStr;
            }
            return StringBaseOpt.objectToStringList((Object)varStr);
        }
        if (this.flowWorkTeam != null && (users = this.flowWorkTeam.get(varName)) != null) {
            return users;
        }
        if (this.flowOrganizes != null && (units = this.flowOrganizes.get(varName)) != null) {
            return units;
        }
        Set<String> userset = this.nodeUsers.get(varName);
        if (userset != null) {
            return userset;
        }
        Set<String> unitset = this.nodeUnits.get(varName);
        if (unitset != null) {
            return unitset;
        }
        if ("flowuser".equalsIgnoreCase(varName)) {
            return this.flowInst.getUserCode();
        }
        if ("flowunit".equalsIgnoreCase(varName)) {
            return this.flowInst.getUnitCode();
        }
        if (this.nodeInst != null && "nodeunit".equalsIgnoreCase(varName)) {
            return this.nodeInst.getUnitCode();
        }
        if (this.nodeInst != null && "nodeuser".equalsIgnoreCase(varName)) {
            return this.nodeInst.getUserCode();
        }
        return null;
    }

    public Set<String> getUsersVariable(String varName) {
        List<String> listUsers;
        Set sUsers = StringBaseOpt.objectToStringSet((Object)this.findInnerVariable(varName));
        if (sUsers != null && !sUsers.isEmpty()) {
            return sUsers;
        }
        if (this.flowVarTrans != null && (sUsers = this.flowVarTrans.getUsersVariable(varName)) != null && !sUsers.isEmpty()) {
            return sUsers;
        }
        FlowVariable v = this.findFlowVariable(varName);
        if (v != null) {
            return CollectionsOpt.cloneSet((Collection)v.getVarList());
        }
        if (this.flowWorkTeam != null && (listUsers = this.flowWorkTeam.get(varName)) != null && !listUsers.isEmpty()) {
            return new HashSet<String>(listUsers);
        }
        if ("flowuser".equalsIgnoreCase(varName)) {
            return CollectionsOpt.createHashSet((Object[])new String[]{this.flowInst.getUserCode()});
        }
        if (this.nodeInst != null && "nodeuser".equalsIgnoreCase(varName)) {
            return CollectionsOpt.createHashSet((Object[])new String[]{this.nodeInst.getUserCode()});
        }
        return this.nodeUsers.get(varName);
    }

    public Set<String> getUnitsVariable(String varName) {
        List<String> listUnits;
        Set sUnits = StringBaseOpt.objectToStringSet((Object)this.findInnerVariable(varName));
        if (sUnits != null && !sUnits.isEmpty()) {
            return sUnits;
        }
        if (this.flowVarTrans != null && (sUnits = this.flowVarTrans.getUnitsVariable(varName)) != null && !sUnits.isEmpty()) {
            return sUnits;
        }
        FlowVariable v = this.findFlowVariable(varName);
        if (v != null) {
            return CollectionsOpt.cloneSet((Collection)v.getVarList());
        }
        if (this.flowOrganizes != null && (listUnits = this.flowOrganizes.get(varName)) != null && !listUnits.isEmpty()) {
            return new HashSet<String>(listUnits);
        }
        if ("flowunit".equalsIgnoreCase(varName)) {
            return CollectionsOpt.createHashSet((Object[])new String[]{this.flowInst.getUnitCode()});
        }
        if (this.nodeInst != null && "nodeunit".equalsIgnoreCase(varName)) {
            return CollectionsOpt.createHashSet((Object[])new String[]{this.nodeInst.getUnitCode()});
        }
        return this.nodeUnits.get(varName);
    }

    public UserUnitVariableTranslate getFlowVarTrans() {
        return this.flowVarTrans;
    }
}

