/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.support;

import com.centit.workflow.commons.NodeEventSupport;
import com.centit.workflow.commons.WorkflowException;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.service.FlowEngine;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class LocalBeanNodeEventSupport
implements NodeEventSupport {
    private static Logger logger = LoggerFactory.getLogger(LocalBeanNodeEventSupport.class);
    private ServletContext application;
    private FlowEngine flowEngine;

    public LocalBeanNodeEventSupport(FlowEngine flowEngine) {
        this.flowEngine = flowEngine;
    }

    public void setApplication(ServletContext application) {
        this.application = application;
    }

    private boolean checkRunCondition(NodeInfo nodeInfo, NodeInstance nodeInst) {
        if (StringUtils.isBlank((CharSequence)nodeInfo.getOptBean())) {
            return false;
        }
        if (this.application == null) {
            throw new WorkflowException(659, "\u81ea\u52a8\u8fd0\u884c\u8282\u70b9 " + nodeInst.getNodeInstId() + "\u51fa\u9519\uff0c\u4f20\u9012\u7684\u53c2\u6570application\u4e3a\u7a7a");
        }
        return true;
    }

    private void logError(BeansException e, NodeInfo nodeInfo, NodeInstance nodeInst) {
        logger.error("\u81ea\u52a8\u8fd0\u884c\u8282\u70b9 " + nodeInst.getNodeInstId() + "\u51fa\u9519\uff0c\u53ef\u80fd\u662fbean:" + nodeInfo.getOptBean() + " \u627e\u4e0d\u5230 \u3002" + e.getMessage());
        throw new WorkflowException(660, "\u81ea\u52a8\u8fd0\u884c\u8282\u70b9 " + nodeInst.getNodeInstId() + "\u51fa\u9519\uff0c\u53ef\u80fd\u662fbean:" + nodeInfo.getOptBean() + " \u627e\u4e0d\u5230 \u3002" + e.getMessage());
    }

    public void runAfterCreate(FlowInstance flowInst, NodeInstance nodeInst, NodeInfo nodeInfo, String optUserCode) {
        if (!this.checkRunCondition(nodeInfo, nodeInst)) {
            return;
        }
        try {
            WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.application);
            NodeEventSupport autoRun = (NodeEventSupport)wac.getBean(nodeInfo.getOptBean());
            autoRun.runAfterCreate(flowInst, nodeInst, nodeInfo, optUserCode);
        }
        catch (BeansException e) {
            this.logError(e, nodeInfo, nodeInst);
        }
    }

    public void runBeforeSubmit(FlowInstance flowInst, NodeInstance nodeInst, NodeInfo nodeInfo, String optUserCode) {
        if (!this.checkRunCondition(nodeInfo, nodeInst)) {
            return;
        }
        try {
            WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.application);
            NodeEventSupport autoRun = (NodeEventSupport)wac.getBean(nodeInfo.getOptBean());
            autoRun.runBeforeSubmit(flowInst, nodeInst, nodeInfo, optUserCode);
        }
        catch (BeansException e) {
            this.logError(e, nodeInfo, nodeInst);
        }
    }

    public boolean runAutoOperator(FlowInstance flowInst, NodeInstance nodeInst, NodeInfo nodeInfo, String optUserCode) {
        if (!this.checkRunCondition(nodeInfo, nodeInst)) {
            throw new WorkflowException(660, "\u81ea\u52a8\u8fd0\u884c\u8282\u70b9 " + nodeInst.getNodeInstId() + "\u51fa\u9519\uff0c\u6d41\u7a0b\u8bbe\u7f6e\u65f6\u6ca1\u6709\u8bbe\u7f6e\u8282\u70b9\u7684\u81ea\u52a8\u8fd0\u884cbean\u5c5e\u6027\u3002");
        }
        try {
            WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.application);
            NodeEventSupport autoRun = (NodeEventSupport)wac.getBean(nodeInfo.getOptBean());
            return autoRun.runAutoOperator(flowInst, nodeInst, nodeInfo, optUserCode);
        }
        catch (BeansException e) {
            this.logError(e, nodeInfo, nodeInst);
            return false;
        }
    }

    public boolean canStepToNext(FlowInstance flowInst, NodeInstance nodeInst, NodeInfo nodeInfo, String optUserCode) {
        if (!this.checkRunCondition(nodeInfo, nodeInst)) {
            throw new WorkflowException(660, "\u6761\u4ef6\u5224\u65ad\u8282\u70b9 " + nodeInst.getNodeInstId() + "\u51fa\u9519\uff0c\u6d41\u7a0b\u8bbe\u7f6e\u65f6\u6ca1\u6709\u8bbe\u7f6e\u6761\u4ef6\u5224\u65ad\u7684bean\u5c5e\u6027\u3002");
        }
        try {
            WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.application);
            NodeEventSupport autoRun = (NodeEventSupport)wac.getBean(nodeInfo.getOptBean());
            return autoRun.canStepToNext(flowInst, nodeInst, nodeInfo, optUserCode);
        }
        catch (BeansException e) {
            this.logError(e, nodeInfo, nodeInst);
            return false;
        }
    }
}

