/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.oa.team.utils.ResourceBaseController;
import com.centit.product.oa.team.utils.ResourceLock;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowInfoId;
import com.centit.workflow.po.FlowStage;
import com.centit.workflow.po.OptTeamRole;
import com.centit.workflow.service.FlowDefine;
import com.centit.workflow.service.RoleFormulaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u6d41\u7a0b\u5b9a\u4e49", tags={"\u6d41\u7a0b\u5b9a\u4e49\u63a5\u53e3\u7c7b"})
@RequestMapping(value={"/flow/define"})
public class FlowDefineController
extends ResourceBaseController {
    @Autowired
    private FlowDefine flowDefine;
    @Autowired
    private RoleFormulaService roleFormulaService;

    @ApiOperation(value="\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868", notes="\u5217\u51fa\u6240\u6709\u7684\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868")
    @GetMapping(value={"/listFlow"})
    @WrapUpResponseBody
    public PageQueryResult<FlowInfo> listFlow(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = FlowDefineController.collectRequestParameters((HttpServletRequest)request);
        List listObjects = this.flowDefine.listLastVersionFlow(searchColumn, pageDesc);
        return PageQueryResult.createResult((Collection)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u5217\u4e3e\u6d41\u7a0b\u4e1a\u52a1\u76f8\u5173\u6d41\u7a0b", notes="\u5217\u4e3e\u6d41\u7a0b\u4e1a\u52a1\u76f8\u5173\u6d41\u7a0b")
    @WrapUpResponseBody
    @GetMapping(value={"/optFlow/{optId}"})
    public ResponseData listFlowByOpt(@PathVariable String optId) {
        JSONArray jsonArray = this.flowDefine.listFlowsByOptId(optId);
        if (jsonArray == null) {
            ResponseData.makeErrorMessage((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6d41\u7a0b\u3002");
            return null;
        }
        return ResponseData.makeResponseData((Object)jsonArray);
    }

    @ApiOperation(value="\u5217\u4e3e\u6d41\u7a0b\u4e1a\u52a1\u76f8\u5173\u6d41\u7a0b", notes="\u5217\u4e3e\u6d41\u7a0b\u4e1a\u52a1\u76f8\u5173\u6d41\u7a0b")
    @WrapUpResponseBody
    @GetMapping(value={"/osFlow/{osId}"})
    public ResponseData listFlowByOs(@PathVariable String osId) {
        JSONArray jsonArray = this.flowDefine.listFlowByOsId(osId);
        if (jsonArray == null) {
            ResponseData.makeErrorMessage((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6d41\u7a0b\u3002");
            return null;
        }
        return ResponseData.makeResponseData((Object)jsonArray);
    }

    @ApiOperation(value="\u5217\u4e3e\u6d41\u7a0b\u4e1a\u52a1\u76f8\u5173\u6d41\u7a0b(\u5305\u542b\u901a\u7528\u6a21\u5757\u4e2d\u7684\u6d41\u7a0b)", notes="\u5217\u4e3e\u6d41\u7a0b\u4e1a\u52a1\u76f8\u5173\u6d41\u7a0b(\u5305\u542b\u901a\u7528\u6a21\u5757\u4e2d\u7684\u6d41\u7a0b)")
    @WrapUpResponseBody
    @GetMapping(value={"/optAllFlow/{optId}"})
    public ResponseData listAllFlowByOpt(@PathVariable String optId) {
        JSONArray jsonArray = this.flowDefine.listAllFlowsByOptId(optId);
        if (jsonArray == null) {
            ResponseData.makeErrorMessage((String)"\u672a\u67e5\u8be2\u5230\u76f8\u5173\u6d41\u7a0b\u3002");
            return null;
        }
        return ResponseData.makeResponseData((Object)jsonArray);
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u7f16\u7801\u5217\u51fa\u6240\u6709\u7684\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868", notes="\u6839\u636e\u6d41\u7a0b\u7f16\u7801\u5217\u51fa\u6240\u6709\u7684\u6d41\u7a0b\u5b9a\u4e49\u5217\u8868")
    @WrapUpResponseBody
    @RequestMapping(value={"/allversions/{flowcode}"}, method={RequestMethod.GET})
    public PageQueryResult<FlowInfo> listFlowAllVisionByCode(PageDesc pageDesc, @PathVariable String flowcode) {
        List listObjects = this.flowDefine.listFlowsByCode(flowcode, pageDesc);
        return PageQueryResult.createResult((Collection)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6700\u65b0\u7248\u672c\u4fe1\u606f", notes="\u83b7\u53d6\u6d41\u7a0b\u6700\u65b0\u7248\u672c\u4fe1\u606f")
    @RequestMapping(value={"/lastversion/{flowcode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public FlowInfo listLastVersion(@PathVariable String flowcode) {
        return this.flowDefine.getFlowInfo(flowcode);
    }

    @RequestMapping(value={"/editfromthis/{flowCode}/{version}"}, method={RequestMethod.POST})
    public void editFromThis(@PathVariable String flowCode, @PathVariable long version, HttpServletRequest request, HttpServletResponse response) {
        FlowInfo flowDefine = this.flowDefine.getFlowInfo(flowCode, version);
        FlowInfo flowDefine_thisversion = this.flowDefine.getFlowInfo(flowCode, 0L);
        FlowInfo copy = new FlowInfo();
        copy.copyNotNullProperty(flowDefine_thisversion);
        copy.setFlowXmlDesc(flowDefine.getFlowXmlDesc());
        boolean saveSucced = this.flowDefine.saveDraftFlowDef(copy);
        JsonResultUtils.writeSingleDataJson((Object)saveSucced, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6d41\u7a0b\u8349\u7a3f", notes="\u67e5\u8be2\u5355\u4e2a\u6d41\u7a0b\u8349\u7a3f")
    @RequestMapping(value={"/draft/{flowcode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public FlowInfo getFlowDefineDraft(@PathVariable String flowcode, HttpServletResponse response) {
        FlowInfo flowInfo = this.flowDefine.getFlowInfo(flowcode, 0L);
        if (flowInfo == null) {
            flowInfo = new FlowInfo();
        }
        return flowInfo;
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6307\u5b9a\u7248\u672c\u4fe1\u606f", notes="\u83b7\u53d6\u6d41\u7a0b\u6307\u5b9a\u7248\u672c\u4fe1\u606f")
    @RequestMapping(value={"/{version}/{flowcode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public FlowInfo getFlowDefine(@PathVariable Long version, @PathVariable String flowcode, HttpServletResponse response) {
        if (version >= 0L) {
            return this.flowDefine.getFlowInfo(flowcode, version.longValue());
        }
        return this.flowDefine.getFlowInfo(flowcode);
    }

    @RequestMapping(value={"/copy/{flowcode}/{version}"}, method={RequestMethod.POST})
    public void copyFlowDefine(@PathVariable String flowcode, @PathVariable Long version, HttpServletResponse response) {
        FlowInfo obj = this.flowDefine.getFlowInfo(flowcode, version.longValue());
        FlowInfo copy = new FlowInfo();
        copy.copyNotNullProperty(obj);
        copy.setCid(new FlowInfoId(Long.valueOf(0L), UuidOpt.getUuidAsString22()));
        JsonResultUtils.writeSingleDataJson((Object)copy, (HttpServletResponse)response);
    }

    @RequestMapping(value={"/savexmldesc/{flowcode}"}, method={RequestMethod.POST})
    public void saveXmlDesc(@PathVariable String flowcode, HttpServletRequest request, HttpServletResponse response) {
        String flowxmldesc = request.getParameter("flowxmldesc");
        FlowInfo wfDefine = new FlowInfo();
        wfDefine.setFlowCode(flowcode);
        wfDefine.setFlowXmlDesc(flowxmldesc);
        wfDefine.setFlowName(request.getParameter("flowName"));
        wfDefine.setFlowDesc(request.getParameter("flowDesc"));
        wfDefine.setExpireOpt(request.getParameter("expireOpt"));
        wfDefine.setTimeLimit(request.getParameter("timeLimit"));
        boolean saveSucced = this.flowDefine.saveDraftFlowDef(wfDefine);
        if (saveSucced) {
            JsonResultUtils.writeSingleDataJson((Object)"\u6d41\u7a0b\u56fe\u8349\u7a3f\u8349\u7a3f\u4fdd\u5b58\u6210\u529f\uff01", (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeSingleDataJson((Object)"\u4fdd\u5b58\u51fa\u9519\uff01", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u590d\u5236\u6d41\u7a0b\u8349\u7a3f\u4e3a\u4e00\u4e2a\u65b0\u7684\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="flowCode", value="\u6d41\u7a0bcode", paramType="String", dataTypeClass=String.class, required=true), @ApiImplicitParam(name="version", value="\u7248\u672c\u53f7\uff0c\u4e0d\u4f20\u9ed8\u8ba4\u4e3a0", paramType="String", dataTypeClass=String.class), @ApiImplicitParam(name="flowName", value="\u65b0\u7684\u6d41\u7a0b\u540d", paramType="String", dataTypeClass=String.class, required=true)})
    @RequestMapping(value={"/copyWorkFlow"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public ResponseData copyWorkFlow(HttpServletRequest request) {
        Map parameters = FlowDefineController.collectRequestParameters((HttpServletRequest)request);
        String flowCode = MapUtils.getString((Map)parameters, (Object)"flowCode");
        String flowName = MapUtils.getString((Map)parameters, (Object)"flowName");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{flowCode, flowName})) {
            return ResponseData.makeErrorMessage((String)"flowCode,flowName\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String newFlowCode = this.flowDefine.copyWorkFlow(parameters);
        if (StringUtils.isBlank((CharSequence)newFlowCode)) {
            return ResponseData.makeErrorMessage((String)"flowCode\u6709\u8bef");
        }
        JSONObject json = new JSONObject();
        json.put((Object)"flowCode", (Object)newFlowCode);
        return ResponseData.makeResponseData((Map)json);
    }

    @ApiOperation(value="\u6839\u636e\u6d41\u7a0bxml\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9", notes="\u6839\u636e\u6d41\u7a0bxml\u83b7\u53d6\u6d41\u7a0b\u8282\u70b9")
    @RequestMapping(value={"/getFlowNode/{flowcode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData getFlowNode(@PathVariable String flowcode) {
        FlowInfo flowInfo = this.flowDefine.getFlowInfo(flowcode, 0L);
        if (flowInfo == null) {
            ResponseData.makeErrorMessage((String)"\u672a\u83b7\u53d6\u5230\u6d41\u7a0b\u8282\u70b9\uff0c\u53ef\u80fd\u662f\u6d41\u7a0b\u6ca1\u6709\u4fdd\u5b58\u3002");
            return null;
        }
        JSONArray nodeList = JSONObject.parseObject((String)new String(flowInfo.getFlowXmlDesc())).getJSONArray("nodeList");
        nodeList.removeIf(node -> !"C".equals(((JSONObject)node).getString("nodeType")) || ((JSONObject)node).getString("nodecode") == null || ((JSONObject)node).getString("nodecode").isEmpty());
        return ResponseData.makeResponseData((Object)nodeList);
    }

    @ApiOperation(value="\u67e5\u770b\u6d41\u7a0b\u56fe", notes="\u67e5\u770b\u6d41\u7a0b\u56fe")
    @RequestMapping(value={"/viewxml/{flowcode}/{version}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public String viewXml(@PathVariable Long version, @PathVariable String flowcode) {
        FlowInfo obj = this.flowDefine.getFlowInfo(flowcode, version.longValue());
        String flowXmlDesc = obj == null ? "" : obj.getFlowXmlDesc();
        return flowXmlDesc;
    }

    @ApiOperation(value="\u65b0\u5efa\u6d41\u7a0b\u7684\u57fa\u672c\u4fe1\u606f", notes="\u65b0\u5efa\u6d41\u7a0b\u7684\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(method={RequestMethod.POST})
    public void addFlowDefine(@RequestBody FlowInfo flowdefine, HttpServletResponse response) {
        boolean saveSucced = this.flowDefine.saveDraftFlowDef(flowdefine);
        if (saveSucced) {
            JsonResultUtils.writeSingleDataJson((Object)"\u5de5\u4f5c\u6d41\u5b9a\u4e49\u8349\u7a3f\u4fdd\u5b58\u6210\u529f\uff01", (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeSingleDataJson((Object)"\u4fdd\u5b58\u51fa\u9519\uff01", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6d41\u7a0b\u7684\u57fa\u672c\u4fe1\u606f", notes="\u4fee\u6539\u6d41\u7a0b\u7684\u57fa\u672c\u4fe1\u606f")
    @RequestMapping(value={"/{flowcode}"}, method={RequestMethod.POST})
    public void editFlowDefine(@Valid FlowInfo flowdefine, @PathVariable String flowcode, HttpServletRequest request, HttpServletResponse response) {
        ResourceLock.lockResource((String)flowcode, (String)WebOptUtils.getCurrentUserCode((HttpServletRequest)request), (HttpServletRequest)request);
        flowdefine.setFlowCode(flowcode);
        flowdefine.setVersion(Long.valueOf(0L));
        boolean saveSucced = this.flowDefine.saveDraftFlowDef(flowdefine);
        if (saveSucced) {
            JsonResultUtils.writeSingleDataJson((Object)"\u5de5\u4f5c\u6d41\u5b9a\u4e49\u8349\u7a3f\u4fdd\u5b58\u6210\u529f\uff01", (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"\u5de5\u4f5c\u6d41\u5b9a\u4e49\u8349\u7a3f\u4fdd\u5b58\u5931\u8d25\uff01", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u7684\u9636\u6bb5\u4fe1\u606f", notes="\u4fdd\u5b58\u6d41\u7a0b\u7684\u9636\u6bb5\u4fe1\u606f\uff0c\u9636\u6bb5\u4fe1\u606f\u4f5c\u4e3a\u6d41\u7a0b\u4fe1\u606f\u7684\u5c5e\u6027flowStages\u5c01\u88c5")
    @WrapUpResponseBody
    @PostMapping(value={"/stage/{flowcode}"})
    public ResponseData editFlowStage(@Valid FlowInfo flowdefine, @PathVariable String flowcode, HttpServletResponse response) {
        if (null != flowdefine.getFlowStages()) {
            for (FlowStage stage : flowdefine.getFlowStages()) {
                if (null == stage.getStageId()) {
                    stage.setStageId(UuidOpt.getUuidAsString32());
                }
                stage.setFlowDefine(flowdefine);
            }
        }
        flowdefine.setFlowCode(flowcode);
        flowdefine.setVersion(Long.valueOf(0L));
        boolean saveSucced = this.flowDefine.saveDraftFlowStage(flowdefine);
        if (saveSucced) {
            return ResponseData.makeResponseData((Object)flowdefine);
        }
        return ResponseData.makeErrorMessage((String)"\u6d41\u7a0b\u7684\u9636\u6bb5\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @ApiOperation(value="\u7f16\u8f91\u6d41\u7a0b\u89d2\u8272\u4fe1\u606f", notes="\u7f16\u8f91\u6d41\u7a0b\u89d2\u8272\u4fe1\u606f")
    @PostMapping(value={"/role/{flowcode}"})
    public void editRole(@Valid FlowInfo flowdefine, @PathVariable String flowcode, HttpServletResponse response) {
        flowdefine.setFlowCode(flowcode);
        flowdefine.setVersion(Long.valueOf(0L));
        boolean saveSucced = this.flowDefine.saveDraftFlowRole(flowdefine);
        if (saveSucced) {
            JsonResultUtils.writeSingleDataJson((Object)"\u5de5\u4f5c\u6d41\u5b9a\u4e49\u8349\u7a3f\u4fdd\u5b58\u6210\u529f\uff01", (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"\u5de5\u4f5c\u6d41\u5b9a\u4e49\u8349\u7a3f\u4fdd\u5b58\u5931\u8d25\uff01", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u7f16\u8f91\u6d41\u7a0b\u53d8\u91cf", notes="\u7f16\u8f91\u6d41\u7a0b\u53d8\u91cf")
    @PostMapping(value={"/variableDefine/{flowcode}"})
    @WrapUpResponseBody
    public void editVariable(@Valid FlowInfo flowdefine, @PathVariable String flowcode, HttpServletResponse response) {
        flowdefine.setFlowCode(flowcode);
        flowdefine.setVersion(Long.valueOf(0L));
        boolean saveSucced = this.flowDefine.saveDraftFlowVariableDef(flowdefine);
        if (saveSucced) {
            JsonResultUtils.writeSingleDataJson((Object)"\u5de5\u4f5c\u6d41\u5b9a\u4e49\u8349\u7a3f\u4fdd\u5b58\u6210\u529f\uff01", (HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((String)"\u5de5\u4f5c\u6d41\u5b9a\u4e49\u8349\u7a3f\u4fdd\u5b58\u5931\u8d25\uff01", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606f", notes="\u66f4\u65b0\u6d41\u7a0b\u4fe1\u606fdoCopyXML\u4e3a\u662f\u5426\u4fdd\u7559\u65e7\u7684\u6d41\u7a0b\u56fe\u4fe1\u606f")
    @RequestMapping(value={"/{oldflowcode}/{doCopyXML}"}, method={RequestMethod.POST})
    public void editCopyFlowDefine(@Valid FlowInfo flowdefine, @PathVariable String oldflowcode, @PathVariable String doCopyXML, HttpServletResponse response) {
        if ("F".equals(doCopyXML)) {
            this.flowDefine.saveDraftFlowDef(flowdefine);
        } else if ("T".equals(doCopyXML)) {
            FlowInfo oldFlowDef = this.flowDefine.getFlowInfo(oldflowcode, 0L);
            flowdefine.setFlowXmlDesc(oldFlowDef.getFlowXmlDesc());
            this.flowDefine.saveDraftFlowDef(flowdefine);
        }
    }

    @ApiOperation(value="\u7981\u7528\u6d41\u7a0b", notes="\u7981\u7528\u6d41\u7a0b")
    @RequestMapping(value={"/{flowcode}/{version}"}, method={RequestMethod.PUT})
    public void deleteFlowDefine(@PathVariable String flowcode, @PathVariable Long version, HttpServletResponse response) {
        FlowInfo obj = this.flowDefine.getFlowInfo(flowcode, version.longValue());
        if (null == obj) {
            JsonResultUtils.writeErrorMessageJson((String)"\u6b64\u6d41\u7a0b\u4e0d\u5b58\u5728", (HttpServletResponse)response);
        } else {
            this.flowDefine.disableFlow(flowcode);
        }
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49", notes="\u7269\u7406\u5220\u9664\u6d41\u7a0b\u5b9a\u4e49")
    @RequestMapping(value={"/deleteFlow/{flowcode}"}, method={RequestMethod.DELETE})
    public void deleteFlowDefine(@PathVariable String flowcode, HttpServletResponse response) {
        this.flowDefine.deleteFlowDef(flowcode);
        JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
    }

    @ApiOperation(value="\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49", notes="\u53d1\u5e03\u6d41\u7a0b\u5b9a\u4e49")
    @RequestMapping(value={"/publish/{flowcode}"}, method={RequestMethod.POST})
    public void publishFlow(@PathVariable String flowcode, HttpServletResponse response) {
        this.flowDefine.publishFlowDef(flowcode);
        JsonResultUtils.writeSingleDataJson((Object)"\u5df2\u53d1\u5e03\uff01", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u66f4\u65b0\u6d41\u7a0b\u72b6\u6001", notes="\u66f4\u65b0\u6d41\u7a0b\u72b6\u6001")
    @RequestMapping(value={"/changestate/{flowcode}/{newstate}"}, method={RequestMethod.GET})
    public void changeState(@PathVariable String flowcode, @PathVariable String newstate, HttpServletResponse response) {
        if ("D".equals(newstate)) {
            this.flowDefine.disableFlow(flowcode);
            JsonResultUtils.writeSingleDataJson((Object)"\u5df2\u7ecf\u7981\u7528\uff01", (HttpServletResponse)response);
        }
        if ("B".equals(newstate)) {
            this.flowDefine.enableFlow(flowcode);
            JsonResultUtils.writeSingleDataJson((Object)"\u5df2\u7ecf\u542f\u7528\uff01", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b", notes="\u6279\u91cf\u5220\u9664\u6d41\u7a0b,\u591a\u4e2aid\u4e4b\u95f4\u7528\u9017\u53f7\u9694\u5f00")
    @WrapUpResponseBody
    @RequestMapping(value={"/batchChangeState"}, method={RequestMethod.POST})
    public ResponseData batchChangeState(@RequestBody String[] flowCodes) {
        if (!StringUtils.isNoneEmpty((CharSequence[])flowCodes)) {
            return ResponseData.makeErrorMessage((String)"flowCodes\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.flowDefine.deleteByCodes(CollectionsOpt.arrayToList((Object[])flowCodes));
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u6e05\u7a7a\u56de\u6536\u7ad9", notes="\u6e05\u7a7a\u56de\u6536\u7ad9")
    @PostMapping(value={"/clear"})
    @WrapUpResponseBody
    public ResponseData clearRecycle(@RequestBody JSONObject params) {
        String osId = params.getString("osId");
        if (!StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{osId})) {
            return ResponseData.makeErrorMessage((String)"osId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        try {
            this.flowDefine.clearRecycle(osId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ResponseData.makeSuccessResponse();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public FlowInfo getNextId() {
        return new FlowInfo(new FlowInfoId(Long.valueOf(0L), UuidOpt.getUuidAsString22()), "N");
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u56fe\u9875\u9762\u9700\u8981\u7684\u6570\u636e\u5b57\u5178\u53ca\u76f8\u5173\u6570\u636e")
    @RequestMapping(value={"/getdatamap/{flowcode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    @Transactional
    public Map<String, Map<String, String>> getDataMap(@PathVariable String flowcode, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        Map map = this.flowDefine.listAllRole(topUnit);
        LinkedHashMap<String, String> bjMap = new LinkedHashMap<String, String>();
        bjMap.put("", "\u8bf7\u9009\u62e9");
        bjMap.putAll(this.flowDefine.listFlowItemRoles(flowcode, Long.valueOf(0L)));
        map.put("BJ", bjMap);
        Map map2 = this.flowDefine.listAllOptType();
        map.put("OptType", map2);
        Map map4 = this.flowDefine.listAllSubFlow();
        map.put("SubWfcode", map4);
        Map stageMap = this.flowDefine.listFlowStages(flowcode, Long.valueOf(0L));
        map.put("FlowPhase", stageMap);
        Map flowVariableDefineMap = this.flowDefine.listFlowVariableDefines(flowcode, Long.valueOf(0L));
        map.put("FlowVariableDefine", flowVariableDefineMap);
        return map;
    }

    @ApiOperation(value="\u67e5\u8be2\u5185\u7f6e\u7684\u6d41\u7a0b\u673a\u6784\u8868\u8fbe\u5f0f")
    @RequestMapping(value={"/listInsideUnitExp"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, String> listInsideUnitExp() {
        return this.flowDefine.listInsideUnitExp();
    }

    @ApiOperation(value="\u67e5\u8be2\u89d2\u8272\u7c7b\u522b")
    @RequestMapping(value={"/listRoleType"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, String> listRoleType() {
        return this.flowDefine.listRoleType();
    }

    @ApiOperation(value="\u5217\u4e3e\u6240\u6709\u89d2\u8272")
    @RequestMapping(value={"/listAllRole"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, Map<String, String>> listAllRole(HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        return this.flowDefine.listAllRole(topUnit);
    }

    @ApiOperation(value="\u89d2\u8272\u540d\u79f0\u548c\u7c7b\u522b\u5bf9\u5e94\u5217\u8868")
    @RequestMapping(value={"/listRoleByType/{roleType}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, String> listRoleByType(@PathVariable String roleType, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        return this.flowDefine.listRoleByType(roleType, topUnit);
    }

    @ApiOperation(value="\u5217\u4e3e\u6d41\u7a0b\u529e\u4ef6\u89d2\u8272")
    @RequestMapping(value={"/itemrole/{flowCode}/{version}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, String> listFlowItemRoles(@PathVariable String flowCode, @PathVariable Long version) {
        return this.flowDefine.listFlowItemRoles(flowCode, version);
    }

    @ApiOperation(value="\u5217\u4e3e\u6240\u6709\u89d2\u8272")
    @RequestMapping(value={"/variable/{flowCode}/{version}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, String> listFlowVariableDefines(@PathVariable String flowCode, @PathVariable Long version) {
        return this.flowDefine.listFlowVariableDefines(flowCode, version);
    }

    @ApiOperation(value="\u5217\u4e3e\u6240\u6709\u89d2\u8272")
    @RequestMapping(value={"/stage/{flowCode}/{version}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, String> listFlowStages(@PathVariable String flowCode, @PathVariable Long version) {
        return this.flowDefine.listFlowStages(flowCode, version);
    }

    @ApiOperation(value="\u68c0\u67e5\u8868\u8fbe\u5f0f\u662f\u5426\u7b26\u5408\u8bed\u6cd5,\u8fd4\u56de\u9519\u8bef\u4f4d\u7f6e\uff0c0\u8868\u793a\u65e0\u9519\u8bef")
    @WrapUpResponseBody
    @GetMapping(value={"/checkFormula"})
    public Integer checkFormula(String formula) {
        return VariableFormula.checkFormula((String)formula);
    }

    @ApiOperation(value="\u6d4b\u8bd5\u8fd0\u884c\u7ed3\u679c")
    @WrapUpResponseBody
    @GetMapping(value={"/testFormula/{flowCode}"})
    public Object testFormula(@PathVariable String flowCode, String formula) {
        return VariableFormula.calculate((String)formula, (Object)this.flowDefine.listFlowDefaultVariables(flowCode, Long.valueOf(0L)));
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u529e\u4ef6\u89d2\u8272\u5bf9\u5e94\u7684\u7528\u6237\u8303\u56f4\uff0c\u8fd4\u56de\u7a7a\u8868\u793a\u53ef\u4ee5\u9009\u62e9\u4efb\u610f\u4eba\u5458", notes="\u67e5\u8be2\u6d41\u7a0b\u529e\u4ef6\u89d2\u8272\u5bf9\u5e94\u7684\u7528\u6237\u8303\u56f4")
    @WrapUpResponseBody
    @ApiImplicitParams(value={@ApiImplicitParam(name="flowCode", value="\u6d41\u7a0b\u4ee3\u7801", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="version", value="\u6d41\u7a0b\u7248\u672c\u53f7\uff0c<1 \u8868\u793a\u6700\u65b0\u7248\u672c", required=true, paramType="path", dataType="Long"), @ApiImplicitParam(name="itemRoleCode", value="\u529e\u4ef6\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/itemRoleFilter/{flowCode}/{version}/{itemRoleCode}"}, method={RequestMethod.GET})
    public JSONArray viewRoleFormulaUsers(@PathVariable String flowCode, @PathVariable Long version, @PathVariable String itemRoleCode, HttpServletRequest request) {
        OptTeamRole itemRole;
        if (version == null || version < 1L) {
            version = this.flowDefine.getFlowLastVersion(flowCode);
        }
        if (StringUtils.isBlank((CharSequence)(itemRole = this.flowDefine.getFlowItemRole(flowCode, version, itemRoleCode)).getFormulaCode())) {
            return null;
        }
        return this.roleFormulaService.viewRoleFormulaUsers(itemRole.getFormulaCode(), WebOptUtils.getCurrentUserCode((HttpServletRequest)request), WebOptUtils.getCurrentUnitCode((HttpServletRequest)request));
    }

    @DeleteMapping(value={"/stage/{stageId}"})
    @WrapUpResponseBody
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u9636\u6bb5id\u5220\u9664\u6d41\u7a0b\u9636\u6bb5")
    public void deleteFlowStageById(@PathVariable String stageId) {
        this.flowDefine.deleteFlowStageById(stageId);
    }

    @PostMapping(value={"/stage"})
    @WrapUpResponseBody
    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u9636\u6bb5")
    public void saveFlowStage(@RequestBody FlowStage flowStage) {
        this.flowDefine.saveFlowStage(flowStage);
    }

    @ApiOperation(value="\u4fee\u6539\u8868\u5355\u6240\u5c5e\u4e1a\u52a1\u6a21\u5757")
    @PutMapping(value={"/batchUpdateOptId"})
    @WrapUpResponseBody
    public JSONObject batchUpdateOptId(String optId, @RequestBody List<String> flowCodes) {
        int[] flowDefineArr = this.flowDefine.batchUpdateOptId(optId, flowCodes);
        JSONObject result = new JSONObject();
        result.put((Object)"flowDefineArr", (Object)flowDefineArr);
        return result;
    }
}

