/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.impl.ObjectUserUnitVariableTranslate;
import com.centit.framework.core.aop.NoRepeatCommit;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.UserUnitVariableTranslate;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.commons.CreateFlowOptions;
import com.centit.workflow.commons.SubmitOptOptions;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.FlowInstanceGroup;
import com.centit.workflow.po.FlowOrganize;
import com.centit.workflow.po.FlowOrganizeId;
import com.centit.workflow.po.FlowVariable;
import com.centit.workflow.po.FlowWorkTeam;
import com.centit.workflow.po.FlowWorkTeamId;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.po.OptTeamRole;
import com.centit.workflow.po.UserTask;
import com.centit.workflow.service.FlowDefine;
import com.centit.workflow.service.FlowEngine;
import com.centit.workflow.service.FlowManager;
import com.centit.workflow.service.RoleFormulaService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Api(value="\u6d41\u7a0b\u5f15\u64ce", tags={"\u6d41\u7a0b\u5f15\u64ce\u63a5\u53e3\u7c7b"})
@RequestMapping(value={"/flow/engine"})
public class FlowEngineController
extends BaseController {
    @Autowired
    private FlowEngine flowEngine;
    @Autowired
    private FlowManager flowManager;
    @Autowired
    private FlowDefine flowDefine;
    @Autowired
    private RoleFormulaService roleFormulaService;

    @ApiOperation(value="\u521b\u5efa\u6d41\u7a0b", notes="\u521b\u5efa\u6d41\u7a0b\uff0c\u53c2\u6570\u4e3ajson\u683c\u5f0f")
    @WrapUpResponseBody
    @PostMapping(value={"/createInstance"})
    public FlowInstance createFlowInstDefault(@RequestBody CreateFlowOptions newFlowInstanceOptions, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)newFlowInstanceOptions.getTopUnit())) {
            newFlowInstanceOptions.setTopUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        FlowInstance flowInstance = this.flowEngine.createInstance(newFlowInstanceOptions, (UserUnitVariableTranslate)new ObjectUserUnitVariableTranslate((Object)BaseController.collectRequestParameters((HttpServletRequest)request)), null);
        FlowInstance instance = this.flowEngine.getFlowInstById(flowInstance.getFlowInstId());
        instance.setActiveNodeList(new ArrayList(instance.getActiveNodeInstances()));
        return instance;
    }

    @ApiOperation(value="\u63d0\u4ea4\u8282\u70b9", notes="\u63d0\u4ea4\u8282\u70b9")
    @ApiImplicitParam(name="json", value="{'nodeInstId':10,'userCode':'u1','unitCode':'d1','varTrans':'jsonString,\u53ef\u4e0d\u586b'}", paramType="body", examples=@Example(value={@ExampleProperty(value="{'nodeInstId':10,'userCode':'u1','unitCode':'d1','varTrans':'jsonString,\u53ef\u4e0d\u586b'}", mediaType="application/json")}))
    @WrapUpResponseBody
    @PostMapping(value={"/submitOpt"})
    @NoRepeatCommit(delaySeconds=3)
    public Map<String, Object> submitOpt(@RequestBody SubmitOptOptions options, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)options.getTopUnit())) {
            options.setTopUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List nextNodeInstList = this.flowEngine.submitOpt(options, (UserUnitVariableTranslate)new ObjectUserUnitVariableTranslate((Object)BaseController.collectRequestParameters((HttpServletRequest)request)), null);
        HashSet<String> nodeNames = new HashSet<String>();
        for (String nodeInstId : nextNodeInstList) {
            NodeInfo nodeInfo = this.flowEngine.getNodeInfo(nodeInstId);
            if (nodeInfo == null) continue;
            nodeNames.add(nodeInfo.getNodeName());
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("nextNodeInsts", nextNodeInstList);
        resultMap.put("nodeNames", StringUtils.join(nodeNames, (String)","));
        return resultMap;
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u53d8\u91cf", notes="\u4fdd\u5b58\u6d41\u7a0b\u53d8\u91cf")
    @WrapUpResponseBody
    @PostMapping(value={"/saveFlowVariable"})
    public ResponseData saveFlowVariable(@RequestBody FlowVariable flowVariableParam) {
        List vars = JSON.parseArray((String)flowVariableParam.getVarValue(), String.class);
        if (!vars.isEmpty()) {
            this.flowEngine.saveFlowVariable(flowVariableParam.getFlowInstId(), flowVariableParam.getVarName(), (Object)vars);
        }
        return ResponseData.makeResponseData((Object)flowVariableParam.getFlowInstId());
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u53d8\u91cf", notes="\u5220\u9664\u6d41\u7a0b\u53d8\u91cf")
    @WrapUpResponseBody
    @PostMapping(value={"/deleteFlowVariable"})
    public void deleteFlowVariable(@RequestBody FlowVariable flowVariableParam) {
        this.flowEngine.deleteFlowVariable(flowVariableParam.getFlowInstId(), flowVariableParam.getRunToken(), flowVariableParam.getVarName());
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u8282\u70b9\u53d8\u91cf", notes="\u4fdd\u5b58\u6d41\u7a0b\u8282\u70b9\u53d8\u91cf")
    @WrapUpResponseBody
    @PostMapping(value={"/saveFlowNodeVariable"})
    public void saveFlowNodeVariable(@RequestBody String FlowNodeVariable) {
        JSONObject jsonObject = JSON.parseObject((String)FlowNodeVariable);
        String nodeInstId = jsonObject.getString("nodeInstId");
        String varName = jsonObject.getString("varName");
        String varValue = jsonObject.getString("varValue");
        List vars = JSON.parseArray((String)varValue, String.class);
        this.flowEngine.saveFlowNodeVariable(nodeInstId, varName, new HashSet(vars));
    }

    @ApiOperation(value="\u67e5\u770b\u6d41\u7a0b\u53d8\u91cf", notes="\u67e5\u770b\u6d41\u7a0b\u53d8\u91cf")
    @WrapUpResponseBody
    @GetMapping(value={"/viewFlowVariablesByVarname"})
    public List<FlowVariable> viewFlowVariablesByVarname(FlowVariable flowVariableParam) {
        List flowVariables = this.flowEngine.viewFlowVariablesByVarName(flowVariableParam.getFlowInstId(), flowVariableParam.getVarName());
        return flowVariables;
    }

    @ApiOperation(value="\u65b0\u589e\u591a\u4e2a\u529e\u4ef6\u89d2\u8272", notes="\u65b0\u589e\u529e\u4ef6\u89d2\u8272,userCode\u4f20\u4e00\u4e2aStringlist\uff0c\u683c\u5f0f\u4e3auserCode:[\"1\",\"2\"]")
    @WrapUpResponseBody
    @PostMapping(value={"/assignFlowWorkTeam"})
    public void assignFlowWorkTeam(@RequestBody FlowWorkTeamId flowWorkTeam) {
        String userCodeList = flowWorkTeam.getUserCode();
        if (StringUtils.isBlank((CharSequence)userCodeList)) {
            return;
        }
        List userCodes = JSON.parseArray((String)userCodeList, String.class);
        this.flowEngine.assignFlowWorkTeam(flowWorkTeam.getFlowInstId(), flowWorkTeam.getRoleCode(), userCodes);
    }

    @ApiOperation(value="\u65b0\u589e\u5355\u4e2a\u529e\u4ef6\u89d2\u8272", notes="\u65b0\u589e\u5355\u4e2a\u529e\u4ef6\u89d2\u8272")
    @WrapUpResponseBody
    @PostMapping(value={"/addFlowWorkTeam"})
    public void addFlowWorkTeam(@RequestBody FlowWorkTeamId flowWorkTeam) {
        this.flowEngine.assignFlowWorkTeam(flowWorkTeam.getFlowInstId(), flowWorkTeam.getRoleCode(), flowWorkTeam.getRunToken(), CollectionsOpt.createList((Object[])new String[]{flowWorkTeam.getUserCode()}));
    }

    @ApiOperation(value="\u5220\u9664\u529e\u4ef6\u89d2\u8272", notes="\u5220\u9664\u529e\u4ef6\u89d2\u8272")
    @WrapUpResponseBody
    @PostMapping(value={"deleteFlowWorkTeam"})
    public void deleteFlowWorkTeam(@RequestBody FlowWorkTeamId flowWorkTeam) {
        this.flowEngine.deleteFlowWorkTeam(flowWorkTeam.getFlowInstId(), flowWorkTeam.getRoleCode());
    }

    @ApiOperation(value="\u67e5\u770b\u6d41\u7a0b\u8282\u70b9", notes="\u67e5\u770b\u6d41\u7a0b\u8282\u70b9")
    @GetMapping(value={"/listFlowInstNodes"})
    @WrapUpResponseBody
    public List<NodeInstance> listFlowInstNodes(String flowInstId) {
        return this.flowManager.listFlowInstNodes(flowInstId);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u7684\u9996\u8282\u70b9", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u7684\u9996\u8282\u70b9")
    @GetMapping(value={"/getFirstNodeInst"})
    @WrapUpResponseBody
    public NodeInstance getFirstNodeInst(String flowInstId) {
        return this.flowManager.getFirstNodeInst(flowInstId);
    }

    @ApiOperation(value="\u67e5\u770b\u6d41\u7a0b\u6d3b\u52a8\u8282\u70b9", notes="\u67e5\u770b\u6d41\u7a0b\u6d3b\u52a8\u8282\u70b9")
    @GetMapping(value={"/activeNodes"})
    @WrapUpResponseBody
    public List<NodeInstance> listFlowActiveNodes(String flowInstId) {
        return this.flowManager.listFlowActiveNodes(flowInstId);
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u6240\u6709\u5f85\u529e", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u6240\u6709\u5f85\u529e")
    @WrapUpResponseBody
    @GetMapping(value={"/userTasks"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801"), @ApiImplicitParam(name="flowInstId", value="\u6d41\u7a0b\u5b9e\u4f8bID"), @ApiImplicitParam(name="nodeInstId", value="\u8282\u70b9\u5b9e\u4f8bID"), @ApiImplicitParam(name="flowCode", value="\u6d41\u7a0b\u5b9a\u4e49Code"), @ApiImplicitParam(name="flowOptName", value="\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684\u4e1a\u52a1\u540d\u79f0(like)"), @ApiImplicitParam(name="flowOptTag", value="\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684\u4e1a\u52a1\u4e3b\u952e"), @ApiImplicitParam(name="nodeName", value="\u8282\u70b9\u540d\u79f0"), @ApiImplicitParam(name="osId", value="\u4e1a\u52a1\u7cfb\u7edfID"), @ApiImplicitParam(name="nodeCode", value="\u73af\u8282\u4ee3\u7801"), @ApiImplicitParam(name="nodeCodes", value="\u73af\u8282\u4ee3\u7801,\u591a\u4e2a\u8282\u70b9\u4ee5\u9017\u53f7\u5206\u5272"), @ApiImplicitParam(name="stageCode", value="\u9636\u6bb5\u4ee3\u7801"), @ApiImplicitParam(name="stageArr", value="STAGE_CODE in (:stageArr)"), @ApiImplicitParam(name="notNodeCode", value="NODE_CODE not in  (:notNodeCode)"), @ApiImplicitParam(name="notNodeCodes", value="\u73af\u8282\u4ee3\u7801,\u591a\u4e2a\u8282\u70b9\u4ee5\u9017\u53f7\u5206\u5272")})
    public PageQueryResult<UserTask> listUserAllTask(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = FlowEngineController.collectRequestParameters((HttpServletRequest)request);
        if (searchColumn.get("topUnit") == null) {
            searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List userTasks = this.flowEngine.listUserAllTask(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)userTasks, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u9759\u6001\u5f85\u529e", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u9759\u6001\u5f85\u529e")
    @WrapUpResponseBody
    @GetMapping(value={"/staticTasks"})
    public PageQueryResult<UserTask> listUserStaticTask(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = FlowEngineController.collectRequestParameters((HttpServletRequest)request);
        if (searchColumn.get("topUnit") == null) {
            searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List userTasks = this.flowEngine.listUserStaticTask(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)userTasks, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u88ab\u6388\u6743\u7684\u5f85\u529e", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u88ab\u6388\u6743\u7684\u5f85\u529e")
    @WrapUpResponseBody
    @GetMapping(value={"/grantorTasks"})
    public PageQueryResult<UserTask> listUserGrantorTask(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = FlowEngineController.collectRequestParameters((HttpServletRequest)request);
        if (searchColumn.get("topUnit") == null) {
            searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List userTasks = this.flowEngine.listUserGrantorTask(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)userTasks, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u5c97\u4f4d\u5f85\u529e\uff08\u52a8\u6001\u5f85\u529e\uff09", notes="\u67e5\u8be2\u7528\u6237\u5c97\u4f4d\u5f85\u529e\uff08\u52a8\u6001\u5f85\u529e\uff09")
    @WrapUpResponseBody
    @GetMapping(value={"/dynamicTasks"})
    public PageQueryResult<UserTask> listUserDynamicTasks(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = FlowEngineController.collectRequestParameters((HttpServletRequest)request);
        if (searchColumn.get("topUnit") == null) {
            searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List userTasks = this.flowEngine.listUserDynamicTask(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)userTasks, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u9759\u6001\u5f85\u529e\u548c\u88ab\u6388\u6743\u7684\u9759\u6001\u5f85\u529e", notes="\u67e5\u8be2\u7528\u6237\u9759\u6001\u5f85\u529e\u548c\u88ab\u6388\u6743\u7684\u9759\u6001\u5f85\u529e")
    @WrapUpResponseBody
    @GetMapping(value={"/staticAndGrantorTasks"})
    public PageQueryResult<UserTask> listUserTasks(HttpServletRequest request, @RequestParam(value="userCode") String userCode, PageDesc pageDesc) {
        HashMap<String, String> searchColumn = new HashMap<String, String>();
        searchColumn.put("userCode", userCode);
        searchColumn.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        List userTasks = this.flowEngine.listUserStaticAndGrantorTask(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)userTasks, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u8282\u70b9\u5f85\u529e\u7528\u6237", notes="\u67e5\u8be2\u8282\u70b9\u5f85\u529e\u7528\u6237")
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    @GetMapping(value={"/nodeTaskUsers"})
    public List<UserTask> listNodeTaskUsers(String nodeInstId) {
        return this.flowEngine.listNodeOperators(nodeInstId);
    }

    @ApiOperation(value="\u4e1a\u52a1id\u5173\u8054\u6d41\u7a0b", notes="\u6839\u636e\u4e1a\u52a1id\u67e5\u8be2\u5173\u8054\u6d41\u7a0b")
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    @GetMapping(value={"/listAllFlowInstByOptTag"})
    public List<FlowInstance> listAllFlowInstByOptTag(@RequestParam(value="flowOptTag") String flowOptTag) {
        return this.flowEngine.listAllFlowInstByOptTag(flowOptTag);
    }

    @ApiOperation(value="\u66f4\u6539\u6d41\u7a0b\u8282\u70b9\u53c2\u6570", notes="\u66f4\u6539\u6d41\u7a0b\u4e1a\u52a1\u4fe1\u606f\u7a0b")
    @WrapUpResponseBody
    @PostMapping(value={"/updateNodeParam"})
    public void updateNodeInstanceParam(@RequestBody String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        String nodeInstId = jsonObject.getString("nodeInstId");
        String nodeParam = jsonObject.getString("nodeParam");
        this.flowEngine.updateNodeInstanceParam(nodeInstId, nodeParam);
    }

    @ApiOperation(value="\u66f4\u6539\u6d41\u7a0b\u8282\u70b9\u53c2\u6570", notes="\u66f4\u6539\u6d41\u7a0b\u4e1a\u52a1\u4fe1\u606f\u7a0b")
    @WrapUpResponseBody
    @PostMapping(value={"/lockTask"})
    public void lockNodeTask(@RequestBody String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        String nodeInstId = jsonObject.getString("nodeInstId");
        String userCode = jsonObject.getString("userCode");
        this.flowEngine.lockNodeTask(nodeInstId, userCode);
    }

    @ApiOperation(value="\u67e5\u770b\u529e\u4ef6\u89d2\u8272", notes="\u67e5\u770b\u529e\u4ef6\u89d2\u8272")
    @WrapUpResponseBody
    @GetMapping(value={"/viewFlowWorkTeam"})
    public List<String> viewFlowWorkTeam(FlowWorkTeam flowWorkTeam) {
        return this.flowEngine.viewFlowWorkTeam(flowWorkTeam.getFlowInstId(), flowWorkTeam.getRoleCode());
    }

    @ApiOperation(value="\u67e5\u770b\u529e\u4ef6\u89d2\u8272\u7684\u7528\u6237\u4fe1\u606f", notes="\u67e5\u770b\u529e\u4ef6\u89d2\u8272\u7684\u7528\u6237\u4fe1\u606f")
    @WrapUpResponseBody
    @GetMapping(value={"/viewFlowWorkTeamUser"})
    public JSONArray viewFlowWorkTeamUser(HttpServletRequest request, FlowWorkTeam flowWorkTeam) {
        List teamUserCodes = this.flowEngine.viewFlowWorkTeam(flowWorkTeam.getFlowInstId(), flowWorkTeam.getRoleCode());
        ArrayList teamUsers = new ArrayList();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        teamUserCodes.forEach(u -> teamUsers.add(CodeRepositoryUtil.getUserPrimaryUnit((String)topUnit, (String)u)));
        return DictionaryMapUtils.objectsToJSONArray(teamUsers);
    }

    @ApiOperation(value="\u67e5\u770b\u6d41\u7a0b\u7ec4\u7ec7\u673a\u6784", notes="\u67e5\u770b\u6d41\u7a0b\u7ec4\u7ec7\u673a\u6784")
    @WrapUpResponseBody
    @GetMapping(value={"/viewFlowOrganize"})
    public List<String> viewFlowOrganize(FlowOrganize flowOrganize) {
        return this.flowEngine.viewFlowOrganize(flowOrganize.getFlowInstId(), flowOrganize.getRoleCode());
    }

    @WrapUpResponseBody
    @PostMapping(value={"/assignFlowOrganize"})
    public void assignFlowOrganize(@RequestBody String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        String flowInstId = jsonObject.getString("flowInstId");
        String roleCode = jsonObject.getString("roleCode");
        String orgCodeSet = jsonObject.getString("orgCodeSet");
        List orgCodes = JSON.parseArray((String)orgCodeSet, String.class);
        this.flowEngine.assignFlowOrganize(flowInstId, roleCode, orgCodes);
    }

    @ApiOperation(value="\u65b0\u589e\u5355\u4e2a\u6d41\u7a0b\u673a\u6784", notes="\u65b0\u589e\u6d41\u7a0b\u7ec4\u7ec7\u673a\u6784")
    @WrapUpResponseBody
    @PostMapping(value={"/addFlowOrganize"})
    public void addFlowOrganize(@RequestBody FlowOrganizeId flowOrganize) {
        this.flowEngine.assignFlowOrganize(flowOrganize.getFlowInstId(), flowOrganize.getRoleCode(), flowOrganize.getUnitCode());
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u673a\u6784", notes="\u5220\u9664\u6d41\u7a0b\u673a\u6784")
    @WrapUpResponseBody
    @PostMapping(value={"/deleteFlowOrganize"})
    public void deleteFlowOrganize(@RequestBody FlowOrganizeId flowOrganize) {
        this.flowEngine.deleteFlowOrganize(flowOrganize.getFlowInstId(), flowOrganize.getRoleCode());
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u4e2d\u53ef\u4ee5\u521b\u5efa\u7684\u8282\u70b9", notes="\u83b7\u53d6\u6d41\u7a0b\u4e2d\u53ef\u4ee5\u521b\u5efa\u7684\u8282\u70b9")
    @WrapUpResponseBody
    @GetMapping(value={"/nodeForCreate/{flowInstId}"})
    public Map<String, String> listFlowNodeForCreate(@PathVariable String flowInstId) {
        return this.flowEngine.listFlowNodeForCreate(flowInstId);
    }

    @ApiOperation(value="\u521b\u5efa\u6d41\u7a0b\u8282\u70b9", notes="\u521b\u5efa\u6d41\u7a0b\u8282\u70b9")
    @ApiImplicitParam(name="jsonObject", paramType="body", value="{'flowInstId':xxx,'curNodeInstId':'xxx','createUser':'xxx','userCode':'u1','unitCode':'d1','nodeCode':'xxx'}")
    @WrapUpResponseBody
    @PostMapping(value={"/isolatedNode"})
    public NodeInstance createIsolatedNodeInst(@RequestBody JSONObject jsonObject) {
        String flowInstId = jsonObject.getString("flowInstId");
        String curNodeInstId = jsonObject.getString("curNodeInstId");
        String createUser = jsonObject.getString("createUser");
        String userCode = jsonObject.getString("userCode");
        String nodeCode = jsonObject.getString("nodeCode");
        String unitCode = jsonObject.getString("unitCode");
        return this.flowEngine.createIsolatedNodeInst(flowInstId, curNodeInstId, nodeCode, createUser, userCode, unitCode);
    }

    @ApiOperation(value="\u590d\u5236\u591a\u5b9e\u4f8b\u8282\u70b9\uff0c\u4ee3\u66ff\u4ee5\u524d\u6dfb\u52a0\u591a\u4eba\u64cd\u4f5c\u7684\u64cd\u4f5c\u4eba\u5458", notes="\u590d\u5236\u591a\u5b9e\u4f8b\u8282\u70b9\uff0c\u4ee3\u66ff\u4ee5\u524d\u6dfb\u52a0\u591a\u4eba\u64cd\u4f5c\u7684\u64cd\u4f5c\u4eba\u5458")
    @ApiImplicitParam(name="jsonObject", paramType="body", value="{'flowInstId':xxx,'createUser':'xxx','userCode':'u1','unitCode':'d1','nodeCode':'xxx'}")
    @WrapUpResponseBody
    @PostMapping(value={"/duplicateMultiNode"})
    public NodeInstance duplicateMultiNodeInst(@RequestBody JSONObject jsonObject) {
        String flowInstId = jsonObject.getString("flowInstId");
        String createUser = jsonObject.getString("createUser");
        String userCode = jsonObject.getString("userCode");
        String multiNodeCode = jsonObject.getString("nodeCode");
        String unitCode = jsonObject.getString("unitCode");
        return this.flowEngine.duplicateMultiNodeInst(flowInstId, multiNodeCode, createUser, userCode, unitCode);
    }

    @ApiOperation(value="\u521b\u5efa\u6d41\u7a0b\u8282\u70b9", notes="\u521b\u5efa\u6d41\u7a0b\u8282\u70b9")
    @WrapUpResponseBody
    @PostMapping(value={"/prepNode"})
    public NodeInstance createPrepNodeInst(@RequestBody String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        String flowInstId = jsonObject.getString("flowInstId");
        String curNodeInstId = jsonObject.getString("curNodeInstId");
        String createUser = jsonObject.getString("createUser");
        String userCode = jsonObject.getString("userCode");
        String nodeCode = jsonObject.getString("nodeCode");
        String unitCode = jsonObject.getString("unitCode");
        return this.flowEngine.createPrepNodeInst(flowInstId, curNodeInstId, nodeCode, createUser, userCode, unitCode);
    }

    @ApiOperation(value="\u56de\u9000\u8282\u70b9", notes="\u56de\u9000\u8282\u70b9")
    @ApiImplicitParam(name="jsonObject", paramType="body", value="{\"nodeInstId\":\"\",\"managerUserCode\":\"userCode\"}")
    @WrapUpResponseBody
    @PostMapping(value={"/rollBackNode"})
    public String rollBackNode(@RequestBody JSONObject jsonObject) {
        String nodeInstId = jsonObject.getString("nodeInstId");
        String managerUserCode = jsonObject.getString("managerUserCode");
        return this.flowEngine.rollBackNode(nodeInstId, managerUserCode);
    }

    @ApiOperation(value="\u68c0\u67e5\u540e\u7eed\u7684\u8282\u70b9\u662f\u5426\u88ab\u64cd\u4f5c\u8fc7\uff0c\u5305\u62ec\u66f4\u65b0\u548c\u63d0\u4ea4", notes="\u68c0\u67e5\u540e\u7eed\u7684\u8282\u70b9\u662f\u5426\u88ab\u64cd\u4f5c\u8fc7\uff0c\u5305\u62ec\u66f4\u65b0\u548c\u63d0\u4ea4")
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    @GetMapping(value={"/nodeCanBeReclaim/{nodeInstId}"})
    public Boolean checkNodeCanBeReclaim(@PathVariable String nodeInstId) {
        return this.flowEngine.nodeCanBeReclaim(nodeInstId);
    }

    @ApiOperation(value="\u64a4\u56de\u8282\u70b9", notes="\u64a4\u56de\u8282\u70b9\u79fb\u4ea4\u7684\u8282\u70b9")
    @WrapUpResponseBody(contentType=WrapUpContentType.RAW)
    @GetMapping(value={"/reclaimNode/{nodeInstId}"})
    public NodeInstance reclaimNode(@PathVariable String nodeInstId, HttpServletRequest request) {
        String currUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        return this.flowEngine.reclaimNode(nodeInstId, currUser);
    }

    @ApiOperation(value="\u521b\u5efa\u6d41\u7a0b\u5b9e\u4f8b\u5206\u7ec4", notes="\u521b\u5efa\u6d41\u7a0b\u5b9e\u4f8b\u5206\u7ec4")
    @WrapUpResponseBody
    @PostMapping(value={"/flowGroup"})
    public FlowInstanceGroup createFlowInstGroup(@RequestBody String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        String flowGroupName = jsonObject.getString("flowGroupName");
        String flowGroupDesc = jsonObject.getString("flowGroupDesc");
        FlowInstanceGroup flowInstanceGroup = this.flowEngine.createFlowInstGroup(flowGroupName, flowGroupDesc);
        return flowInstanceGroup;
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u5206\u7ec4", notes="\u67e5\u8be2\u6d41\u7a0b\u5b9e\u4f8b\u5206\u7ec4")
    @WrapUpResponseBody
    @GetMapping(value={"/flowGroup"})
    public PageQueryResult<FlowInstanceGroup> listFlowInstGroup(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = FlowEngineController.collectRequestParameters((HttpServletRequest)request);
        List listObjects = this.flowEngine.listFlowInstGroup(searchColumn, pageDesc);
        return PageQueryResult.createResult((Collection)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f")
    @WrapUpResponseBody
    @GetMapping(value={"/inst/{flowInstId}"})
    public FlowInstance getFlowInstance(@PathVariable String flowInstId) {
        return this.flowEngine.getFlowInstById(flowInstId);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9a\u4e49\u4fe1\u606f")
    @WrapUpResponseBody
    @GetMapping(value={"/instDef/{flowInstId}"})
    public FlowInfo getFlowDefine(@PathVariable String flowInstId) {
        FlowInstance instance = this.flowEngine.getFlowInstById(flowInstId);
        if (instance == null) {
            return null;
        }
        return this.flowDefine.getFlowInfo(instance.getFlowCode(), instance.getVersion().longValue());
    }

    @ApiOperation(value="\u83b7\u53d6\u8282\u70b9\u5b9e\u4f8b\u4fe1\u606f", notes="\u83b7\u53d6\u8282\u70b9\u5b9e\u4f8b\u4fe1\u606f")
    @WrapUpResponseBody
    @GetMapping(value={"/nodeInst/{nodeInstId}"})
    public NodeInstance getNodeInstance(@PathVariable String nodeInstId) {
        return this.flowEngine.getNodeInstById(nodeInstId);
    }

    @ApiOperation(value="\u83b7\u53d6\u8282\u70b9\u5b9e\u4f8b\u4fe1\u606f", notes="\u83b7\u53d6\u8282\u70b9\u5b9e\u4f8b\u4fe1\u606f")
    @WrapUpResponseBody
    @GetMapping(value={"/nodeDef/{nodeInstId}"})
    public NodeInfo getNodeInfo(@PathVariable String nodeInstId) {
        NodeInstance inst = this.flowEngine.getNodeInstById(nodeInstId);
        if (inst == null) {
            return null;
        }
        return this.flowDefine.getNodeInfoById(inst.getNodeId());
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u529e\u4ef6\u89d2\u8272\u5bf9\u5e94\u7684\u7528\u6237\u8303\u56f4\uff0c\u8fd4\u56de\u7a7a\u8868\u793a\u53ef\u4ee5\u9009\u62e9\u4efb\u610f\u4eba\u5458", notes="\u67e5\u8be2\u6d41\u7a0b\u529e\u4ef6\u89d2\u8272\u5bf9\u5e94\u7684\u7528\u6237\u8303\u56f4")
    @WrapUpResponseBody
    @ApiImplicitParams(value={@ApiImplicitParam(name="flowInstId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="itemRoleCode", value="\u529e\u4ef6\u89d2\u8272\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/itemRoleFilter/{flowInstId}/{itemRoleCode}"}, method={RequestMethod.GET})
    public JSONArray viewRoleFormulaUsers(@PathVariable String flowInstId, @PathVariable String itemRoleCode, HttpServletRequest request) {
        FlowInstance instance = this.flowEngine.getFlowInstById(flowInstId);
        if (instance == null) {
            return null;
        }
        OptTeamRole itemRole = this.flowDefine.getFlowItemRole(instance.getFlowCode(), instance.getVersion(), itemRoleCode);
        if (StringUtils.isBlank((CharSequence)itemRole.getFormulaCode())) {
            return null;
        }
        return this.roleFormulaService.viewRoleFormulaUsers(itemRole.getFormulaCode(), WebOptUtils.getCurrentUserCode((HttpServletRequest)request), WebOptUtils.getCurrentUnitCode((HttpServletRequest)request));
    }

    @ApiOperation(value="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5df2\u529e", notes="\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5df2\u529e")
    @WrapUpResponseBody
    @GetMapping(value={"/listCompleteTasks"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801"), @ApiImplicitParam(name="flowOptName", value="\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684\u4e1a\u52a1\u540d\u79f0(like)"), @ApiImplicitParam(name="osId", value="\u4e1a\u52a1\u7cfb\u7edfID")})
    public PageQueryResult<UserTask> listCompleteTasks(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = FlowEngineController.collectRequestParameters((HttpServletRequest)request);
        List userTasks = this.flowEngine.listUserCompleteTasks(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)userTasks, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u9884\u5224\u4e0b\u4e00\u6b65\u8282\u70b9\u7684\u8282\u70b9\u7f16\u53f7", notes="\u9884\u5224\u4e0b\u4e00\u6b65\u8282\u70b9\u7684\u8282\u70b9\u7f16\u53f7")
    @WrapUpResponseBody
    @PostMapping(value={"/viewNextNode"})
    public Set<NodeInfo> viewNextNode(@RequestBody SubmitOptOptions options) {
        return this.flowEngine.viewNextNode(options);
    }

    @ApiOperation(value="\u67e5\u770b\u4e0b\u4e00\u8282\u70b9\u53ef\u4ee5\u64cd\u4f5c\u7684\u4eba\u5458\u7c7b\u8868", notes="\u67e5\u770b\u4e0b\u4e00\u8282\u70b9\u53ef\u4ee5\u64cd\u4f5c\u7684\u4eba\u5458\u7c7b\u8868")
    @WrapUpResponseBody
    @PostMapping(value={"/viewNextNodeOperator"})
    public Set<String> viewNextNodeOperator(@RequestBody String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        String nextNodeId = jsonObject.getString("nextNodeId");
        SubmitOptOptions options = (SubmitOptOptions)JSON.parseObject((String)jsonObject.getString("options"), SubmitOptOptions.class);
        return this.flowEngine.viewNextNodeOperator(nextNodeId, options);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u7684\u4e1a\u52a1\u8282\u70b9\u4fe1\u606f", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u7684\u4e1a\u52a1\u8282\u70b9\u4fe1\u606f")
    @WrapUpResponseBody
    @GetMapping(value={"/viewFlowNodes/{flowInstId}"})
    public JSONArray viewFlowNodes(@PathVariable String flowInstId) {
        return this.flowEngine.viewFlowNodes(flowInstId);
    }

    @ApiOperation(value="\u83b7\u53d6\u8282\u70b9\u5b9e\u4f8b\u7684\u5f85\u529e\u8be6\u60c5", notes="\u83b7\u53d6\u8282\u70b9\u5b9e\u4f8b\u7684\u5f85\u529e\u8be6\u60c5")
    @ApiImplicitParam(name="jsonObject", paramType="body", value="{\"nodeInstIds\":[]}")
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    @PostMapping(value={"/listNodeTasks"})
    public List<UserTask> listNodeTasks(@RequestBody JSONObject jsonObject) {
        List nodeInstIds = jsonObject.getJSONArray("nodeInstIds").toJavaList(String.class, new JSONReader.Feature[0]);
        if (nodeInstIds == null || nodeInstIds.size() == 0) {
            return null;
        }
        ArrayList<UserTask> userTasks = new ArrayList<UserTask>(nodeInstIds.size() * 4);
        for (String nodeInstId : nodeInstIds) {
            List uts = this.flowEngine.listNodeOperators(nodeInstId);
            if (uts == null) continue;
            userTasks.addAll(uts);
        }
        return userTasks;
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u6240\u6709\u6d3b\u52a8\u8282\u70b9\u7684\u4efb\u52a1\u5217\u8868", notes="\u83b7\u53d6\u6d41\u7a0b\u6240\u6709\u6d3b\u52a8\u8282\u70b9\u7684\u4efb\u52a1\u5217\u8868")
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    @ApiImplicitParam(name="flowInstId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=true, paramType="path", dataType="String")
    @RequestMapping(value={"/flowActiveNodeTask/{flowInstId}"}, method={RequestMethod.GET})
    public List<UserTask> listFlowActiveNodeOperators(@PathVariable String flowInstId, HttpServletRequest request) {
        return this.flowEngine.listFlowActiveNodeOperators(flowInstId);
    }
}

