/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.JsonResultUtils;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.ResponseMapData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.json.JSONOpt;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.FlowInstanceGroup;
import com.centit.workflow.po.FlowVariable;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.po.TaskMove;
import com.centit.workflow.po.UserTask;
import com.centit.workflow.service.FlowDefine;
import com.centit.workflow.service.FlowEngine;
import com.centit.workflow.service.FlowManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@Api(value="\u6d41\u7a0b\u63a7\u5236", tags={"\u6d41\u7a0b\u63a7\u5236\u63a5\u53e3\u7c7b"})
@RequestMapping(value={"/flow/manager"})
public class FlowManagerController
extends BaseController {
    @Autowired
    private FlowManager flowManager;
    @Autowired
    private FlowEngine flowEngine;
    @Autowired
    private FlowDefine flowDefine;

    @ApiOperation(value="\u6d41\u7a0b\u5b9e\u4f8b\u68c0\u7d22\u67e5\u8be2", notes="\u6d41\u7a0b\u5b9e\u4f8b\u68c0\u7d22\u67e5\u8be2")
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Object> list(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        JSONArray listObjects = this.flowManager.listFlowInstance(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{FlowInstance.class});
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61", notes="\u6839\u636eid\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u8c61")
    @WrapUpResponseBody
    @RequestMapping(value={"/{flowInstId}"}, method={RequestMethod.GET})
    public Map<String, Object> getFlowInstance(@PathVariable String flowInstId) {
        FlowInstance flowInst = this.flowManager.getFlowInstance(flowInstId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List stageList = this.flowManager.listStageInstByFlowInstId(flowInstId);
        result.put("flowInst", flowInst);
        result.put("viewFlowInst", this.flowManager.viewFlowInstance(flowInstId));
        result.put("stageList", stageList);
        return result;
    }

    @ApiOperation(value="\u67e5\u770b\u6d41\u7a0b\u5b9e\u4f8b\u6d41\u7a0b\u56fe", notes="\u67e5\u770b\u6d41\u7a0b\u5b9e\u4f8b\u6d41\u7a0b\u56fe")
    @RequestMapping(value={"/viewxml/{flowInstId}"}, method={RequestMethod.GET})
    public void viewRuntimeXml(@PathVariable String flowInstId, HttpServletResponse response) {
        FlowInstance flowInst = this.flowManager.getFlowInstance(flowInstId);
        String flowCode = flowInst.getFlowCode();
        Long version = flowInst.getVersion();
        if (StringUtils.isNotBlank((CharSequence)flowCode)) {
            FlowInfo obj = this.flowDefine.getFlowInfo(flowCode, version.longValue());
            String wfDefXML = obj.getFlowXmlDesc();
            HashMap<String, Object> result = new HashMap<String, Object>();
            Map flowInstDesc = this.flowManager.viewFlowInstance(flowInstId);
            result.put("json", wfDefXML);
            result.put("viewJson", flowInstDesc);
            JsonResultUtils.writeSingleDataJson(result, (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u67e5\u770b\u6d41\u7a0b\u56fe", notes="\u67e5\u770b\u6d41\u7a0b\u56fe")
    @RequestMapping(value={"/viewxml/{flowCode}/{version}"}, method={RequestMethod.GET})
    public void viewRuntimeXml(@PathVariable String flowCode, @PathVariable Long version, HttpServletRequest request, HttpServletResponse response) {
        FlowInfo obj = this.flowDefine.getFlowInfo(flowCode, version.longValue());
        String xml = obj.getFlowXmlDesc();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("xml", xml);
        JsonResultUtils.writeSingleDataJson(result, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u67e5\u770b\u6d41\u7a0b\u5b9e\u4f8b\u8282\u70b9\u6d41\u7a0b\u56fe", notes="\u67e5\u770b\u6d41\u7a0b\u5b9e\u4f8b\u8282\u70b9\u6d41\u7a0b\u56fe")
    @RequestMapping(value={"/nodesxml/{flowInstId}"}, method={RequestMethod.GET})
    public void viewNodeInstancesXml(@PathVariable String flowInstId, HttpServletResponse response) {
        String nodesxml = this.flowManager.viewFlowNodeInstance(flowInstId);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("nodesxml", nodesxml);
        JsonResultUtils.writeSingleDataJson(result, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5217\u8868", notes="\u83b7\u53d6\u7ec4\u7ec7\u673a\u6784\u5217\u8868")
    @RequestMapping(value={"/getorglist/{flowInstId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Map<String, String>> getOrganizeList(@PathVariable String flowInstId, PageDesc pageDesc) {
        Map organizeMap = this.flowEngine.viewFlowOrganize(flowInstId);
        ArrayList organizeList = new ArrayList();
        for (Map.Entry entry : organizeMap.entrySet()) {
            for (String unitCode : (List)entry.getValue()) {
                HashMap unitTempMap = new HashMap();
                unitTempMap.put("roleCode", entry.getKey());
                unitTempMap.put("unitCode", unitCode);
                unitTempMap.put("unitName", CodeRepositoryUtil.getValue((String)"unitCode", (String)unitCode));
                organizeList.add(unitTempMap);
            }
        }
        pageDesc.setTotalRows(Integer.valueOf(organizeList.size()));
        return PageQueryResult.createResult(organizeList, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u7684\u6d41\u7a0b\u7ec4\u7ec7\u673a\u6784", notes="\u5220\u9664\u6307\u5b9a\u7684\u6d41\u7a0b\u7ec4\u7ec7\u673a\u6784")
    @RequestMapping(value={"/deleteorg/{flowInstId}/{roleCode}/{unitCode}"}, method={RequestMethod.GET})
    public void deleteOrg(@PathVariable String flowInstId, @PathVariable String roleCode, @PathVariable String unitCode, HttpServletResponse response) {
        this.flowEngine.deleteFlowOrganize(flowInstId, roleCode, unitCode);
        JsonResultUtils.writeSingleDataJson((Object)"", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5220\u9664\u6307\u5b9aroleCode\u4e0b\u7684\u6240\u6709\u6d41\u7a0b\u5de5\u4f5c\u673a\u6784", notes="\u5220\u9664\u6307\u5b9aroleCode\u4e0b\u7684\u6240\u6709\u6d41\u7a0b\u5de5\u4f5c\u673a\u6784")
    @RequestMapping(value={"/deleteorg/{flowInstId}/{roleCode}"}, method={RequestMethod.GET})
    public void deleteOrgAll(@PathVariable String flowInstId, @PathVariable String roleCode, HttpServletResponse response) {
        this.flowEngine.deleteFlowOrganize(flowInstId, roleCode);
        JsonResultUtils.writeSingleDataJson((Object)"", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u6dfb\u52a0\u6d41\u7a0b\u5de5\u4f5c\u673a\u6784", notes="\u6dfb\u52a0\u6d41\u7a0b\u5de5\u4f5c\u673a\u6784")
    @RequestMapping(value={"/saveorg/{flowInstId}/{roleCode}/{unitCode}/{authDesc}"}, method={RequestMethod.POST})
    public void assignOrganize(@PathVariable String flowInstId, @PathVariable String roleCode, @PathVariable String unitCode, @PathVariable String authDesc, HttpServletRequest request, HttpServletResponse response) {
        this.flowEngine.assignFlowOrganize(flowInstId, roleCode, unitCode, authDesc);
        JsonResultUtils.writeSingleDataJson((Object)"", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u7ed9\u4e00\u4e2a\u8282\u70b9\u6307\u5b9a\u4efb\u52a1\u3001\u7528\u8fd9\u4e2a\u4ee3\u66ff\u7cfb\u7edf\u81ea\u52a8\u5206\u914d\u4efb\u52a1", notes="\u7ed9\u4e00\u4e2a\u8282\u70b9\u6307\u5b9a\u4efb\u52a1\u3001\u7528\u8fd9\u4e2a\u4ee3\u66ff\u7cfb\u7edf\u81ea\u52a8\u5206\u914d\u4efb\u52a1")
    @RequestMapping(value={"/assign/{nodeInstId}/{userCode}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void assignNodeUser(@PathVariable String nodeInstId, @PathVariable String userCode, @RequestBody UserTask actionTask) {
        this.flowManager.assignNodeTask(nodeInstId, actionTask.getUserCode(), StringUtils.isBlank((CharSequence)userCode) ? "admin" : userCode, actionTask.getAuthDesc());
    }

    @ApiOperation(value="\u67e5\u8be2\u529e\u4ef6\u89d2\u8272\u5217\u8868", notes="\u67e5\u8be2\u529e\u4ef6\u89d2\u8272\u5217\u8868")
    @RequestMapping(value={"/getteamlist/{flowInstId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<Map<String, String>> getTeamList(@PathVariable String flowInstId, PageDesc pageDesc, HttpServletResponse response) {
        Map teamMap = this.flowEngine.viewFlowWorkTeam(flowInstId);
        ArrayList teamList = new ArrayList();
        for (Map.Entry entry : teamMap.entrySet()) {
            HashSet userMap = new HashSet();
            for (String userCode : (List)entry.getValue()) {
                HashMap teamTempMap = new HashMap();
                teamTempMap.put("roleCode", entry.getKey());
                teamTempMap.put("userCode", userCode);
                teamTempMap.put("userName", CodeRepositoryUtil.getValue((String)"userCode", (String)userCode));
                teamList.add(teamTempMap);
            }
        }
        pageDesc.setTotalRows(Integer.valueOf(teamList.size()));
        return PageQueryResult.createResult(teamList, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u5220\u9664\u6307\u5b9aroleCode\u4e0b\u7684\u6240\u6709\u6d41\u7a0b\u5de5\u4f5c\u5c0f\u7ec4", notes="\u5220\u9664\u6307\u5b9aroleCode\u4e0b\u7684\u6240\u6709\u6d41\u7a0b\u5de5\u4f5c\u5c0f\u7ec4")
    @RequestMapping(value={"/deleteteam/{flowInstId}/{roleCode}"}, method={RequestMethod.GET})
    public void deleteWorkTeam(@PathVariable String flowInstId, @PathVariable String roleCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        this.flowEngine.deleteFlowWorkTeam(flowInstId, roleCode);
        JsonResultUtils.writeSingleDataJson((Object)"", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u7684\u6d41\u7a0b\u5de5\u4f5c\u5c0f\u7ec4", notes="\u5220\u9664\u6307\u5b9a\u7684\u6d41\u7a0b\u5de5\u4f5c\u5c0f\u7ec4")
    @RequestMapping(value={"/deleteteam/{flowInstId}/{roleCode}/{userCode}"}, method={RequestMethod.GET})
    public void deleteWorkTeamUser(@PathVariable String flowInstId, @PathVariable String roleCode, @PathVariable String userCode, PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        this.flowEngine.deleteFlowWorkTeam(flowInstId, roleCode, userCode);
        JsonResultUtils.writeSingleDataJson((Object)"", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u67e5\u8be2\u53d8\u91cf\u5217\u8868", notes="\u67e5\u8be2\u53d8\u91cf\u5217\u8868")
    @RequestMapping(value={"/getvariablelist/{flowInstId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<FlowVariable> getVariableList(@PathVariable String flowInstId, PageDesc pageDesc, HttpServletResponse response) {
        List variableList = this.flowEngine.listFlowVariables(flowInstId);
        pageDesc.setTotalRows(Integer.valueOf(variableList.size()));
        return PageQueryResult.createResult((Collection)variableList, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6d41\u7a0b\u53d8\u91cf", notes="\u4fdd\u5b58\u6d41\u7a0b\u53d8\u91cf")
    @RequestMapping(value={"/savevariable/{flowInstId}/{varName}/{varValue}"}, method={RequestMethod.GET})
    public void saveVariable(@PathVariable String flowInstId, @PathVariable String varName, @PathVariable String varValue, HttpServletRequest request, HttpServletResponse response) {
        String runToken = request.getParameter("runToken");
        this.flowEngine.saveFlowNodeVariable(flowInstId, runToken, varName, (Object)(StringUtils.isBlank((CharSequence)varValue) ? null : varValue));
        JsonResultUtils.writeSingleDataJson((Object)"", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u65b0\u589e\u53d8\u91cf\u65f6\u9700\u8981\u7684\u4ee4\u724c\u9009\u62e9\u9879", notes="\u65b0\u589e\u53d8\u91cf\u65f6\u9700\u8981\u7684\u4ee4\u724c\u9009\u62e9\u9879")
    @RequestMapping(value={"/tokens/{flowInstId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public Map<String, String> listTokens(@PathVariable String flowInstId) {
        List flowVariableList = this.flowEngine.listFlowVariables(flowInstId);
        HashSet<String> existTokenSet = new HashSet<String>();
        for (FlowVariable flowVariable : flowVariableList) {
            existTokenSet.add(flowVariable.getRunToken());
        }
        List nodeInstList = this.flowManager.listFlowInstNodes(flowInstId);
        HashSet<String> tokenSet = new HashSet<String>();
        HashMap<String, String> tokenLvbList = new HashMap<String, String>();
        tokenLvbList.put(" ", "------\u8bf7\u9009\u62e9------");
        for (NodeInstance nodeInst : nodeInstList) {
            if (existTokenSet.contains(nodeInst.getRunToken()) || tokenSet.contains(nodeInst.getRunToken())) continue;
            tokenSet.add(nodeInst.getRunToken());
            tokenLvbList.put(nodeInst.getRunToken(), nodeInst.getRunToken());
        }
        return tokenLvbList;
    }

    @ApiOperation(value="\u6682\u6302\u4e00\u4e2a\u6d41\u7a0b\u5b9e\u4f8b", notes="\u6682\u6302\u4e00\u4e2a\u6d41\u7a0b\u5b9e\u4f8b")
    @WrapUpResponseBody
    @RequestMapping(value={"/suspendinst/{wfinstid}"}, method={RequestMethod.GET})
    public String suspendInstance(@PathVariable String wfinstid, HttpServletRequest request) {
        String mangerUserCode = request.getParameter("admin");
        if (StringUtils.isBlank((CharSequence)mangerUserCode)) {
            mangerUserCode = "admin";
        }
        String admindesc = request.getParameter("stopDesc");
        this.flowManager.suspendInstance(wfinstid, mangerUserCode, admindesc);
        return "\u5df2\u6682\u6302";
    }

    @ApiOperation(value="\u7f16\u8f91\u6d41\u7a0b\u5b9e\u4f8b", notes="\u7f16\u8f91\u6d41\u7a0b\u5b9e\u4f8b")
    @WrapUpResponseBody
    @PostMapping
    public void updateFlowInst(@RequestBody String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        String flowInstId = jsonObject.getString("flowInstId");
        String flowOptName = jsonObject.getString("flowOptName");
        String flowOptTag = jsonObject.getString("flowOptTag");
        String userCode = jsonObject.getString("userCode");
        String unitCode = jsonObject.getString("unitCode");
        this.flowManager.updateFlowInstOptInfoAndUser(flowInstId, flowOptName, flowOptTag, userCode, unitCode);
    }

    @ApiOperation(value="\u66f4\u6539\u673a\u6784", notes="\u66f4\u6539\u673a\u6784")
    @PutMapping(value={"/changeunit/{wfinstid}/{unitcode}"})
    public void changeUnit(@PathVariable String wfinstid, @PathVariable String unitcode, HttpServletResponse response) {
        this.flowManager.updateFlowInstUnit(wfinstid, unitcode, "admin");
        JsonResultUtils.writeSingleDataJson((Object)"", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u7ec8\u6b62\u6d41\u7a0b\u5b9e\u4f8b", notes="\u7ec8\u6b62\u6d41\u7a0b\u5b9e\u4f8b")
    @RequestMapping(value={"/stopinst/{flowInstId}"}, method={RequestMethod.GET})
    public void stopInstance(@PathVariable String flowInstId, HttpServletRequest request, HttpServletResponse response) {
        String mangerUserCode = request.getParameter("admin");
        if (StringUtils.isBlank((CharSequence)mangerUserCode)) {
            mangerUserCode = "admin";
        }
        this.flowManager.stopInstance(flowInstId, mangerUserCode, "");
        JsonResultUtils.writeSingleDataJson((Object)"", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b", notes="\u6fc0\u6d3b\u6d41\u7a0b\u5b9e\u4f8b")
    @WrapUpResponseBody
    @RequestMapping(value={"/activizeinst/{flowInstId}"}, method={RequestMethod.GET})
    public void activizeInstance(@PathVariable String flowInstId, HttpServletRequest request) {
        String mangerUserCode = request.getParameter("admin");
        if (StringUtils.isBlank((CharSequence)mangerUserCode)) {
            mangerUserCode = "admin";
        }
        String admindesc = request.getParameter("stopDesc");
        this.flowManager.activizeInstance(flowInstId, mangerUserCode, admindesc);
    }

    @ApiOperation(value="\u6682\u505c\u6d41\u7a0b\u7684\u4e00\u4e2a\u8282\u70b9", notes="\u6682\u505c\u6d41\u7a0b\u7684\u4e00\u4e2a\u8282\u70b9")
    @WrapUpResponseBody
    @RequestMapping(value={"/suspendNodeInst/{nodeInstId}"}, method={RequestMethod.GET})
    public void suspendNodeInstance(@PathVariable String nodeInstId, HttpServletRequest request) {
        String mangerUserCode = request.getParameter("admin");
        if (StringUtils.isBlank((CharSequence)mangerUserCode)) {
            mangerUserCode = "admin";
        }
        this.flowManager.suspendNodeInstance(nodeInstId, mangerUserCode);
    }

    @ApiOperation(value="\u6fc0\u6d3b\u6d41\u7a0b\u7684\u4e00\u4e2a\u8282\u70b9", notes="\u6fc0\u6d3b\u6d41\u7a0b\u7684\u4e00\u4e2a\u8282\u70b9")
    @WrapUpResponseBody
    @RequestMapping(value={"/activizeNodeInst/{nodeInstId}"}, method={RequestMethod.GET})
    public void activizeNodeInstance(@PathVariable String nodeInstId, HttpServletRequest request) {
        String mangerUserCode = request.getParameter("admin");
        if (StringUtils.isBlank((CharSequence)mangerUserCode)) {
            mangerUserCode = "admin";
        }
        this.flowManager.activizeNodeInstance(nodeInstId, mangerUserCode);
    }

    @ApiOperation(value="\u5f3a\u5236\u4fee\u6539\u6d41\u7a0b\u7684\u8282\u70b9\u72b6\u6001", notes="\u5f3a\u5236\u4fee\u6539\u6d41\u7a0b\u7684\u8282\u70b9\u72b6\u6001")
    @WrapUpResponseBody
    @PutMapping(value={"/updateNodeState/{nodeInstId}/{newState}"})
    public void updateNodeState(@PathVariable String nodeInstId, @PathVariable String newState) {
        this.flowManager.updateNodeState(nodeInstId, newState);
    }

    @ApiOperation(value="\u5f3a\u5236\u6d41\u8f6c\u5230\u4e0b\u4e00\u8282\u70b9", notes="\u5f3a\u5236\u6d41\u8f6c\u5230\u4e0b\u4e00\u8282\u70b9")
    @WrapUpResponseBody
    @RequestMapping(value={"/forceCommit/{nodeInstId}"}, method={RequestMethod.GET})
    public String forceCommit(@PathVariable String nodeInstId, HttpServletRequest request) {
        String mangerUserCode = request.getParameter("admin");
        if (StringUtils.isBlank((CharSequence)mangerUserCode)) {
            mangerUserCode = "admin";
        }
        return this.flowManager.forceCommit(nodeInstId, mangerUserCode);
    }

    @ApiOperation(value="\u8282\u70b9\u72b6\u6001\u7ba1\u7406api", notes="1.\u56de\u6eda\u4e00\u4e2a\u6d41\u7a0b\u8282\u70b9\u5230\u4e0a\u4e00\u8282\u70b92.\u63d0\u4ea4\uff0c\u5f3a\u5236\u4e00\u4e2a\u6d41\u7a0b\u8282\u70b9\u524d\u8fdb\u5230\u4e0b\u4e00\u4e2a\u8282\u70b93.\u5bf9\u4e00\u4e2a\u6b63\u5728\u8fd0\u884c\u7684\u8282\u70b9\u5b9e\u4f8b\u5f3a\u5236\u6e38\u79bb6.\u5524\u9192\u4e00\u4e2a\u6682\u6302\u8282\u70b9\u5b9e\u4f8b7.\u4ece\u8fd9\u4e2a\u8282\u70b9\u91cd\u65b0\u8fd0\u884c\u8be5\u6d41\u7a0b\uff0c\u5305\u62ec\u5df2\u7ecf\u7ed3\u675f\u7684\u6d41\u7a0b8.\u6682\u6302\u4e00\u4e2a\u8282\u70b9\u5b9e\u4f8b")
    @RequestMapping(value={"/nodestate/{nodeInstId}/{bo}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public NodeInstance changeFlowInstState(@PathVariable String nodeInstId, HttpServletRequest request, @PathVariable String bo) {
        switch (bo.charAt(0)) {
            case '1': {
                this.flowEngine.rollBackNode(nodeInstId, "admin");
                break;
            }
            case '2': {
                this.flowManager.forceCommit(nodeInstId, "admin");
                break;
            }
            case '3': {
                this.flowManager.forceDissociateRuning(nodeInstId, "admin");
                break;
            }
            case '6': {
                String mangerUserCode = "admin";
                String timeLimit = request.getParameter("timeLimit");
                if (timeLimit != null) {
                    this.flowManager.activizeInstance(this.flowEngine.getNodeInstById(nodeInstId).getFlowInstId(), timeLimit, mangerUserCode);
                    break;
                }
                this.flowManager.activizeNodeInstance(nodeInstId, mangerUserCode);
                break;
            }
            case '7': {
                this.flowManager.resetFlowToThisNode(nodeInstId, "admin");
                break;
            }
            case '8': {
                this.flowManager.suspendNodeInstance(nodeInstId, "admin");
            }
        }
        return this.flowEngine.getNodeInstById(nodeInstId);
    }

    @ApiOperation(value="\u4ece\u8fd9\u4e2a\u8282\u70b9\u91cd\u65b0\u8fd0\u884c\u8be5\u6d41\u7a0b\uff0c\u5305\u62ec\u5df2\u7ecf\u7ed3\u675f\u7684\u6d41\u7a0b", notes="\u4ece\u8fd9\u4e2a\u8282\u70b9\u91cd\u65b0\u8fd0\u884c\u8be5\u6d41\u7a0b\uff0c\u5305\u62ec\u5df2\u7ecf\u7ed3\u675f\u7684\u6d41\u7a0b")
    @RequestMapping(value={"/resetToCurrent/{nodeInstId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public NodeInstance resetToCurrent(@PathVariable String nodeInstId, HttpServletRequest request) {
        Map params = BaseController.collectRequestParameters((HttpServletRequest)request);
        String managerUser = StringBaseOpt.castObjectToString(params.get("userCode"));
        if (StringUtils.isBlank((CharSequence)managerUser)) {
            managerUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        }
        return this.flowManager.resetFlowToThisNode(nodeInstId, managerUser);
    }

    @ApiOperation(value="\u4efb\u52a1\u5217\u8868\u67e5\u8be2\uff0c\u67e5\u8be2\u6761\u4ef6\u53ef\u81ea\u52a9\u6dfb\u52a0", notes="\u4efb\u52a1\u5217\u8868\u67e5\u8be2\uff0c\u67e5\u8be2\u6761\u4ef6\u53ef\u81ea\u52a9\u6dfb\u52a0")
    @RequestMapping(value={"/listNodeOpers/{nodeInstId}"}, method={RequestMethod.GET})
    public void listNodeOperators(@PathVariable String nodeInstId, HttpServletResponse response) {
        List objList = this.flowEngine.listNodeOperators(nodeInstId);
        JsonResultUtils.writeSingleDataJson((Object)objList, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u8fd4\u56de\u8282\u70b9\u7684\u64cd\u4f5c\u8bb0\u5f55\uff0c\u6216\u8005\u65e5\u5fd7", notes="\u8fd4\u56de\u8282\u70b9\u7684\u64cd\u4f5c\u8bb0\u5f55\uff0c\u6216\u8005\u65e5\u5fd7")
    @RequestMapping(value={"/viewnode/{nodeInstId}"}, method={RequestMethod.GET})
    public void viewNodeInstanceInfo(@PathVariable String nodeInstId, HttpServletResponse response) {
        NodeInstance nodeInst = this.flowEngine.getNodeInstById(nodeInstId);
        NodeInfo nodeInfo = this.flowDefine.getNodeInfoById(nodeInst.getNodeId());
        List tasks = this.flowEngine.listNodeOperators(nodeInstId);
        List logs = this.flowManager.listNodeActionLogs(nodeInstId);
        ResponseMapData resData = new ResponseMapData();
        resData.addResponseData("inst", (Object)nodeInst);
        resData.addResponseData("node", (Object)nodeInfo);
        resData.addResponseData("tasks", (Object)tasks);
        resData.addResponseData("logs", (Object)logs);
        JsonResultUtils.writeResponseDataAsJson((ResponseData)resData, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u8fd4\u56de\u8282\u70b9\u7684\u64cd\u4f5c\u8bb0\u5f55\uff0c\u6216\u8005\u65e5\u5fd7", notes="\u8fd4\u56de\u8282\u70b9\u7684\u64cd\u4f5c\u8bb0\u5f55\uff0c\u6216\u8005\u65e5\u5fd7")
    @RequestMapping(value={"/viewflownode/{flowInstId}/{nodeId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public JSONObject viewFlowNodeInfo(@PathVariable String flowInstId, @PathVariable String nodeId, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        String localLang = WebOptUtils.getCurrentLang((HttpServletRequest)request);
        FlowInstance dbobject = this.flowManager.getFlowInstance(flowInstId);
        if (dbobject == null) {
            throw new ObjectException("\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f\uff1aflowInstId=" + flowInstId);
        }
        NodeInfo nodeInfo = this.flowDefine.getNodeInfoById(nodeId);
        JSONObject nodeOptInfo = new JSONObject();
        nodeOptInfo.put((Object)"nodename", (Object)nodeInfo.getNodeName());
        int nodeInstInd = 0;
        List nodeInsts = dbobject.getFlowNodeInstances();
        int nodeCount = nodeInsts.size();
        for (int i = 0; i < nodeCount; ++i) {
            NodeInstance nodeInst = (NodeInstance)nodeInsts.get(i);
            if (!nodeInst.getNodeId().equals(nodeId)) continue;
            JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].createtime"), (Object)DatetimeOpt.convertDatetimeToString((Date)nodeInst.getCreateTime()));
            JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].unitcode"), (Object)nodeInst.getUnitCode());
            JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].unitname"), (Object)CodeRepositoryUtil.getValue((String)"unitCode", (String)nodeInst.getUnitCode(), (String)topUnit, (String)localLang));
            JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].taskAssign"), (Object)nodeInst.getTaskAssigned());
            if ("N".equals(nodeInst.getNodeState()) || "P".equals(nodeInst.getNodeState())) {
                UserInfo user;
                List tasks = this.flowEngine.listNodeOperators(nodeInst.getNodeInstId());
                JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].state"), (Object)"\u529e\u7406\u4e2d");
                if ("B".equals(nodeInfo.getOptRunType())) {
                    JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].rolecode"), (Object)nodeInst.getRoleCode());
                    JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].rolename"), (Object)CodeRepositoryUtil.getValue((String)"roleCode", (String)nodeInst.getRoleCode(), (String)topUnit, (String)localLang));
                    if (tasks != null) {
                        StringBuilder sbUsers = new StringBuilder();
                        for (UserTask task : tasks) {
                            user = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)task.getUserCode());
                            if (user == null) continue;
                            sbUsers.append(user.getUserName()).append("(").append(user.getLoginName()).append(") ");
                        }
                        JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].users"), (Object)sbUsers);
                    }
                } else {
                    int taskInd = 0;
                    if (tasks != null) {
                        for (UserTask task : tasks) {
                            user = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)task.getUserCode());
                            JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].task[" + taskInd + "].usercode"), (Object)task.getUserCode());
                            if (user != null) {
                                JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].task[" + taskInd + "].order"), (Object)user.getUserOrder());
                                StringBuilder sbUsers = new StringBuilder();
                                sbUsers.append(user.getUserName()).append("(").append(user.getLoginName()).append(") ");
                                JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].task[" + taskInd + "].username"), (Object)sbUsers);
                            } else {
                                JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].task[" + taskInd + "].username"), (Object)CodeRepositoryUtil.getValue((String)"userCode", (String)task.getUserCode(), (String)topUnit, (String)localLang));
                            }
                            ++taskInd;
                        }
                    }
                }
            } else {
                JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].state"), (Object)CodeRepositoryUtil.getValue((String)"WFInstType", (String)nodeInst.getNodeState(), (String)topUnit, (String)localLang));
                JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].updateuser"), (Object)CodeRepositoryUtil.getValue((String)"userCode", (String)nodeInst.getLastUpdateUser(), (String)topUnit, (String)localLang));
                JSONOpt.setAttribute((JSONObject)nodeOptInfo, (String)("instance[" + nodeInstInd + "].updatetime"), (Object)DatetimeOpt.convertDatetimeToString((Date)(nodeInst.getLastUpdateTime() == null ? nodeInst.getCreateTime() : nodeInst.getLastUpdateTime())));
            }
            ++nodeInstInd;
        }
        nodeOptInfo.put((Object)"count", (Object)nodeInstInd);
        return nodeOptInfo;
    }

    @ApiOperation(value="\u67e5\u627e\u6240\u6709\u6ca1\u6709\u64cd\u4f5c\u7528\u6237\u7684\u8282\u70b9", notes="\u67e5\u627e\u6240\u6709\u6ca1\u6709\u64cd\u4f5c\u7528\u6237\u7684\u8282\u70b9")
    @RequestMapping(value={"/nooptnodes"}, method={RequestMethod.GET})
    public void listNoOptNodes(HttpServletResponse response) {
        List nodeList = this.flowManager.listNodesWithoutOpt();
        JsonResultUtils.writeSingleDataJson((Object)nodeList, (HttpServletResponse)response);
    }

    @ApiOperation(value="\u65b0\u589e\u5de5\u4f5c\u7ec4", notes="\u65b0\u589e\u5de5\u4f5c\u7ec4")
    @RequestMapping(value={"/assignFlowWorkTeam/{flowInstId}/{roleCode}/{userCode}/{authdesc}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    public void assignFlowWorkTeam(@PathVariable String flowInstId, @PathVariable String roleCode, @PathVariable String userCode, @PathVariable String authdesc) {
        this.flowEngine.assignFlowWorkTeam(flowInstId, roleCode, CollectionsOpt.createList((Object[])new String[]{userCode}));
    }

    @ApiOperation(value="\u5c06 fromUserCode \u6240\u6709\u4efb\u52a1 \u8fc1\u79fb \u7ed9 toUserCode", notes="\u5c06 fromUserCode \u6240\u6709\u4efb\u52a1 \u8fc1\u79fb \u7ed9 toUserCode")
    @WrapUpResponseBody
    @RequestMapping(value={"/moveUserTaskTo"}, method={RequestMethod.POST})
    public void moveUserTaskTo(@RequestBody TaskMove taskMove) {
        this.flowManager.moveUserTaskTo(taskMove.getFormUser(), taskMove.getToUser(), taskMove.getOperatorUser(), taskMove.getMoveDesc());
    }

    @ApiOperation(value="\u5c06 fromUserCode \u6240\u6709\u4efb\u52a1 \u8fc1\u79fb \u7ed9 toUserCode", notes="\u5c06 fromUserCode \u6240\u6709\u4efb\u52a1 \u8fc1\u79fb \u7ed9 toUserCode")
    @WrapUpResponseBody
    @RequestMapping(value={"/moveSelectedUserTaskTo"}, method={RequestMethod.POST})
    public void moveSelectedUserTaskTo(@RequestBody TaskMove taskMove) {
        this.flowManager.moveUserTaskTo(taskMove.getNodeInstIds(), taskMove.getFormUser(), taskMove.getToUser(), taskMove.getOperatorUser(), taskMove.getMoveDesc());
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u8282\u70b9", notes="\u6839\u636eid\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u8282\u70b9")
    @WrapUpResponseBody
    @RequestMapping(value={"/listFlowInstNodes"}, method={RequestMethod.GET})
    public List<NodeInstance> listFlowInstNodes(String flowInstId) {
        return this.flowManager.listFlowInstNodes(flowInstId);
    }

    @ApiOperation(value="\u7ec8\u6b62\u4e00\u4e2a\u6d41\u7a0b\uff0c\u4fee\u6539\u5176\u6d41\u7a0bid\u4e3a\u8d1f\u6570\uff0c\u66f4\u65b0\u6240\u6709\u8282\u70b9\u72b6\u6001\u4e3aF", notes="\u7ec8\u6b62\u4e00\u4e2a\u6d41\u7a0b\uff0c\u4fee\u6539\u5176\u6d41\u7a0bid\u4e3a\u8d1f\u6570\uff0c\u66f4\u65b0\u6240\u6709\u8282\u70b9\u72b6\u6001\u4e3aF")
    @PostMapping(value={"/stopAndChangeInstance/{flowInstId}/{userCode}"})
    @WrapUpResponseBody
    public void stopAndChangeInstance(String flowInstId, String userCode, String desc) {
        this.flowManager.stopInstance(flowInstId, userCode, desc);
    }

    @ApiOperation(value="\u7ec8\u6b62\u4e00\u4e2a\u6d41\u7a0b\uff0c\u66f4\u65b0\u6240\u6709\u8282\u70b9\u72b6\u6001\u4e3aF", notes="\u7ec8\u6b62\u4e00\u4e2a\u6d41\u7a0b\uff0c\u66f4\u65b0\u6240\u6709\u8282\u70b9\u72b6\u6001\u4e3aF")
    @PutMapping(value={"/stopInstance/{flowInstId}/{userCode}"})
    public void stopInstance(@PathVariable String flowInstId, @PathVariable String userCode, HttpServletResponse response) {
        try {
            this.flowManager.stopInstance(flowInstId, userCode, "");
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        }
        catch (Exception e) {
            JsonResultUtils.writeErrorMessageJson((int)1, (String)"\u6d41\u7a0b\u65e0\u6cd5\u5f3a\u884c\u7ed3\u675f", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u5f3a\u5236\u4fee\u6539\u6d41\u7a0b\u72b6\u6001\u4ee5\u53ca\u76f8\u5173\u8282\u70b9\u5b9e\u4f8b\u72b6\u6001", notes="\u5f3a\u5236\u4fee\u6539\u6d41\u7a0b\u72b6\u6001\u4ee5\u53ca\u76f8\u5173\u8282\u70b9\u5b9e\u4f8b\u72b6\u6001")
    @PostMapping(value={"/updateFlowState"})
    @WrapUpResponseBody
    public ResponseData updateFlowState(@RequestBody JSONObject jsonObject) {
        String flowInstId = jsonObject.getString("flowInstId");
        JSONArray flowInstIds = jsonObject.getJSONArray("flowInstIds");
        String userCode = jsonObject.getString("userCode");
        String instState = jsonObject.getString("instState");
        String desc = jsonObject.getString("desc");
        if (flowInstIds != null && !flowInstIds.isEmpty()) {
            for (int i = 0; i < flowInstIds.size(); ++i) {
                this.flowManager.updateFlowState(flowInstIds.getString(i), userCode, instState, desc);
            }
            return ResponseData.makeResponseData((Object)flowInstIds);
        }
        this.flowManager.updateFlowState(flowInstId, userCode, instState, desc);
        return ResponseData.makeResponseData((Object)flowInstId);
    }

    @ApiOperation(value="\u6d41\u7a0b\u62c9\u56de\u5230\u9996\u8282\u70b9", notes="\u6d41\u7a0b\u62c9\u56de\u5230\u9996\u8282\u70b9")
    @PutMapping(value={"/reStartFlow/{flowInstId}/{userCode}"})
    public void reStartFlow(@PathVariable String flowInstId, @PathVariable String userCode, @RequestParam(required=false, defaultValue="false") Boolean force, HttpServletResponse response) {
        NodeInstance startNodeInst = this.flowManager.reStartFlow(flowInstId, userCode, force);
        if (startNodeInst != null) {
            JsonResultUtils.writeSuccessJson((HttpServletResponse)response);
        } else {
            JsonResultUtils.writeErrorMessageJson((int)1, (String)"\u6d41\u7a0b\u5df2\u7ecf\u88ab\u5ba1\u6279\uff0c\u65e0\u6cd5\u64a4\u56de", (HttpServletResponse)response);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u6d41\u7a0b\u5206\u7ec4", notes="\u67e5\u8be2\u6240\u6709\u6d41\u7a0b\u5206\u7ec4")
    @RequestMapping(value={"/group"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult<FlowInstanceGroup> listFlowInstGroup(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        JSONArray listObjects = this.flowManager.listFlowInstGroup(searchColumn, pageDesc);
        List flowInstanceGroupList = listObjects.toJavaList(FlowInstanceGroup.class, new JSONReader.Feature[0]);
        return PageQueryResult.createResult((Collection)flowInstanceGroupList, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u6d41\u7a0b\u5206\u7ec4\u5bf9\u8c61", notes="\u6839\u636eid\u83b7\u53d6\u6d41\u7a0b\u5206\u7ec4\u5bf9\u8c61")
    @RequestMapping(value={"/group/{flowInstGroupId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public FlowInstanceGroup getFlowInstanceGroup(@PathVariable String flowInstGroupId) {
        return this.flowManager.getFlowInstanceGroup(flowInstGroupId);
    }

    @ApiOperation(value="\u8282\u70b9\u64cd\u4f5c\u65e5\u5fd7", notes="\u67e5\u8be2\u67d0\u8282\u70b9\u5b9e\u4f8b\u4e0b\u7684\u65e5\u5fd7\u4fe1\u606f")
    @RequestMapping(value={"/nodelogs/{flowInstId}/{nodeInstId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends OperationLog> listNodeInstLogs(@PathVariable String flowInstId, @PathVariable String nodeInstId) {
        return this.flowManager.listNodeActionLogs(flowInstId, nodeInstId);
    }

    @ApiOperation(value="\u6d41\u7a0b\u64cd\u4f5c\u65e5\u5fd7", notes="\u6d41\u7a0b\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"/flowlogs/{flowInstId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listFlowInstLogs(@PathVariable String flowInstId, String withNodeLog) {
        List operationLogs = this.flowManager.listFlowActionLogs(flowInstId, BooleanBaseOpt.castObjectToBoolean((Object)withNodeLog, (Boolean)false).booleanValue());
        if (CollectionUtils.sizeIsEmpty((Object)operationLogs)) {
            return ResponseData.makeResponseData(Collections.emptyList());
        }
        return ResponseData.makeResponseData((Object)DictionaryMapUtils.objectsToJSONArray((Collection)operationLogs));
    }

    @ApiOperation(value="\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7", notes="\u7528\u6237\u64cd\u4f5c\u65e5\u5fd7")
    @RequestMapping(value={"/userlogs/{userCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public List<? extends OperationLog> listUserOptLogs(@PathVariable String userCode, String lastTime, PageDesc pageDesc) {
        return this.flowManager.listUserActionLogs(userCode, (Date)GeneralAlgorithm.nvl((Object)DatetimeOpt.castObjectToDate((Object)lastTime), (Object)DatetimeOpt.addDays((Date)DatetimeOpt.currentUtilDate(), (int)-30)), pageDesc);
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u7533\u8bf7\u4fe1\u606f", notes="\u83b7\u53d6\u6d41\u7a0b\u7533\u8bf7\u4fe1\u606f\uff08\u83b7\u53d6\u6d41\u7a0b\u521b\u5efa\u7528\u6237\u7684\u4fe1\u606f\uff09")
    @RequestMapping(value={"/inst/{flowInstId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listUserOptLogs(@PathVariable String flowInstId) {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        FlowInstance flowInstance = this.flowManager.getFlowInstance(flowInstId);
        UserInfo createFlowUser = CodeRepositoryUtil.getUserInfoByCode((String)topUnit, (String)flowInstance.getUserCode());
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("createFlowUser", createFlowUser);
        resultMap.put("flowOptName", flowInstance.getFlowOptName());
        resultMap.put("flowInstId", flowInstance.getFlowInstId());
        return ResponseData.makeResponseData(resultMap);
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e", notes="\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e")
    @WrapUpResponseBody
    @RequestMapping(value={"/deleteFlowInstById/{flowInstId}/{userCode}"}, method={RequestMethod.DELETE})
    public ResponseData deleteFlowInstById(@PathVariable String flowInstId, @PathVariable String userCode) {
        boolean b = this.flowManager.deleteFlowInstById(flowInstId, userCode);
        return ResponseData.makeResponseData((Object)b);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e", notes="\u6279\u91cf\u5220\u9664\u6d41\u7a0b\u5b9e\u4f8b\u6570\u636e,\u591a\u4e2aid\u4e4b\u95f4\u7528\u9017\u53f7\u9694\u5f00")
    @WrapUpResponseBody
    @RequestMapping(value={"/batchDeleteFlowInst"}, method={RequestMethod.DELETE})
    public ResponseData batchDeleteFlowInst(HttpServletRequest request) {
        String flowInstIds = MapUtils.getString((Map)FlowManagerController.collectRequestParameters((HttpServletRequest)request), (Object)"flowInstIds");
        if (StringUtils.isBlank((CharSequence)flowInstIds)) {
            return ResponseData.makeErrorMessage((String)"flowInstIds\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        this.flowManager.deleteFlowInstByIds(CollectionsOpt.arrayToList((Object[])flowInstIds.split(",")));
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff0c\u5e76\u67e5\u8be2\u6d41\u7a0b\u76f8\u5173\u4fe1\u606f(fgw\u6536\u6587\u529e\u7ed3\u5217\u8868\u548c\u53d1\u6587\u529e\u7ed3\u5217\u8868)", notes="\u83b7\u53d6\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff0c\u5e76\u67e5\u8be2\u6d41\u7a0b\u76f8\u5173\u4fe1\u606f(fgw\u6536\u6587\u529e\u7ed3\u5217\u8868\u548c\u53d1\u6587\u529e\u7ed3\u5217\u8868)")
    @WrapUpResponseBody
    @GetMapping(value={"/listFlowInstDetailed"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="userCode", value="\u6d41\u7a0b\u521b\u5efa\u7528\u6237"), @ApiImplicitParam(name="flowInstIds", value="\u6d41\u7a0b\u5b9e\u4f8bid\uff0c\u4ee5\u9017\u53f7\u5206\u5272"), @ApiImplicitParam(name="flowCode", value="\u6d41\u7a0b\u7f16\u7801"), @ApiImplicitParam(name="optId", value="\u4e1a\u52a1\u7f16\u7801"), @ApiImplicitParam(name="instState", value="\u6d41\u7a0b\u72b6\u6001 C \u5df2\u5b8c\u6210  N \u529e\u7406\u4e2d"), @ApiImplicitParam(name="flowOptName", value="\u6d41\u7a0b\u5b9e\u4f8b\u5bf9\u5e94\u7684\u4e1a\u52a1\u540d\u79f0(like)")})
    public PageQueryResult<Object> listFlowInstDetailed(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        JSONArray listObjects = this.flowManager.listFlowInstDetailed(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{FlowInstance.class});
    }

    @ApiOperation(value="\u83b7\u53d6\u8282\u70b9\u5b9e\u4f8b\u5217\u8868", notes="\u83b7\u53d6\u8282\u70b9\u5b9e\u4f8b\u5217\u8868")
    @WrapUpResponseBody
    @GetMapping(value={"/listNodeInstance"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="roleCode", value="\u89d2\u8272\u4ee3\u7801"), @ApiImplicitParam(name="flowCode", value="\u6d41\u7a0b\u7f16\u7801"), @ApiImplicitParam(name="instState", value="\u6d41\u7a0b\u72b6\u6001 C \u5df2\u5b8c\u6210  N \u529e\u7406\u4e2d"), @ApiImplicitParam(name="flowInstId", value="\u6d41\u7a0b\u5b9e\u4f8bid"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801")})
    public PageQueryResult<NodeInstance> listNodeInstance(HttpServletRequest request, PageDesc pageDesc) {
        Map searchColumn = FlowManagerController.collectRequestParameters((HttpServletRequest)request);
        List nodeInstanceList = this.flowManager.listNodeInstance(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)nodeInstanceList, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6682\u505c\u6d41\u7a0b\u8ba1\u65f6", notes="\u6682\u505c\u6d41\u7a0b\u8ba1\u65f6")
    @RequestMapping(value={"/suspendFlowInstTimer/{flowInstId}"}, method={RequestMethod.GET})
    public void suspendFlowInstTimer(@PathVariable String flowInstId, HttpServletRequest request, HttpServletResponse response) {
        Map parameters = FlowManagerController.collectRequestParameters((HttpServletRequest)request);
        String userCode = MapUtils.getString((Map)parameters, (Object)"userCode", (String)"admin");
        this.flowManager.suspendFlowInstTimer(flowInstId, userCode);
        JsonResultUtils.writeSingleDataJson((Object)"\u6682\u505c\u8282\u70b9\u8ba1\u65f6\u6210\u529f", (HttpServletResponse)response);
    }

    @ApiOperation(value="\u5524\u9192\u6d41\u7a0b\u8ba1\u65f6", notes="\u5524\u9192\u6d41\u7a0b\u8ba1\u65f6")
    @RequestMapping(value={"/activizeFlowInstTimer/{flowInstId}"}, method={RequestMethod.GET})
    public void activizeFlowInstTimer(@PathVariable String flowInstId, HttpServletRequest request, HttpServletResponse response) {
        Map parameters = FlowManagerController.collectRequestParameters((HttpServletRequest)request);
        String userCode = MapUtils.getString((Map)parameters, (Object)"userCode", (String)"admin");
        this.flowManager.activizeFlowInstTimer(flowInstId, userCode);
        JsonResultUtils.writeSingleDataJson((Object)"\u5524\u9192\u6d41\u7a0b\u8ba1\u65f6\u6210\u529f", (HttpServletResponse)response);
    }
}

