/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.controller;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.po.OptTeamRole;
import com.centit.workflow.po.OptVariableDefine;
import com.centit.workflow.service.FlowOptService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u6d41\u7a0b\u4e1a\u52a1", tags={"\u6d41\u7a0b\u4e1a\u52a1"})
@RequestMapping(value={"/flow/opt"})
public class FlowOptController
extends BaseController {
    @Autowired
    private FlowOptService wfOptService;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u7cfb\u7edf\u5217\u8868", notes="\u83b7\u53d6\u4e1a\u52a1\u7cfb\u7edf\u5217\u8868")
    @WrapUpResponseBody
    @RequestMapping(value={"/oslist"}, method={RequestMethod.GET})
    public List<OsInfo> listAllOs(HttpServletRequest request) {
        return CodeRepositoryUtil.listOsInfo((String)WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
    }

    @GetMapping(value={"/roles/{optId}"})
    @WrapUpResponseBody
    @ApiOperation(value="\u6839\u636eoptId\u83b7\u53d6\u89d2\u8272\u5b9a\u4e49\u5217\u8868")
    public PageQueryResult<OptTeamRole> listOptTeamRolesByOptId(@PathVariable String optId, PageDesc pageDesc) {
        Map filter = CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId});
        List optTeamRoles = this.wfOptService.listOptTeamRolesByFilter(filter, pageDesc);
        return PageQueryResult.createResult((Collection)optTeamRoles, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/allRoles/{optId}"})
    @WrapUpResponseBody
    @ApiOperation(value="\u6839\u636eoptId\u83b7\u53d6\u89d2\u8272\u5b9a\u4e49\u5217\u8868")
    public PageQueryResult<OptTeamRole> listAllOptTeamRolesByOptId(@PathVariable String optId, PageDesc pageDesc) {
        Map filter;
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List allOptInfos = this.platformEnvironment.listAllOptInfo(topUnit);
        List tyRoles = new ArrayList();
        OptInfo optInfo = null;
        String tyOptId = "";
        boolean flag = true;
        for (OptInfo obj : allOptInfos) {
            if (!obj.getOptId().equals(optId)) continue;
            optInfo = obj;
        }
        if (optInfo != null) {
            for (OptInfo obj : allOptInfos) {
                if (!obj.getTopOptId().equals(optInfo.getTopOptId())) continue;
                if (!obj.getOptName().equals("\u901a\u7528\u6a21\u5757") || !(tyOptId = obj.getOptId()).equals(optId)) continue;
                flag = false;
            }
        }
        if (flag) {
            filter = CollectionsOpt.createHashMap((Object[])new Object[]{"optId", tyOptId});
            tyRoles = this.wfOptService.listOptTeamRolesByFilter(filter, pageDesc);
        }
        filter = CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId});
        List optTeamRoles = this.wfOptService.listOptTeamRolesByFilter(filter, pageDesc);
        optTeamRoles.addAll(tyRoles);
        return PageQueryResult.createResult((Collection)optTeamRoles, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/role/{roleId}"})
    @WrapUpResponseBody
    @ApiOperation(value="\u6839\u636e\u4e3b\u952eid\u83b7\u53d6\u89d2\u8272\u5b9a\u4e49")
    public OptTeamRole getOptTeamRoleById(@PathVariable String roleId) {
        return this.wfOptService.getOptTeamRoleById(roleId);
    }

    @PostMapping(value={"/role"})
    @WrapUpResponseBody
    @ApiOperation(value="\u4fdd\u5b58\u89d2\u8272\u5b9a\u4e49")
    public void saveOptTeamRole(@RequestBody OptTeamRole optTeamRole) {
        this.wfOptService.saveOptTeamRole(optTeamRole);
    }

    @PutMapping(value={"/role"})
    @WrapUpResponseBody
    @ApiOperation(value="\u66f4\u65b0\u89d2\u8272\u5b9a\u4e49")
    public void updateOptTeamRole(@RequestBody OptTeamRole optTeamRole) {
        this.wfOptService.updateOptTeamRole(optTeamRole);
    }

    @DeleteMapping(value={"/role/{roleId}"})
    @WrapUpResponseBody
    @ApiOperation(value="\u5220\u9664\u89d2\u8272\u5b9a\u4e49")
    public void deleteOptTeamRole(@PathVariable String roleId) {
        this.wfOptService.deleteOptTeamRoleById(roleId);
    }

    @GetMapping(value={"/variables/{optId}"})
    @WrapUpResponseBody
    @ApiOperation(value="\u6839\u636eoptId\u83b7\u53d6\u53d8\u91cf\u5b9a\u4e49\u5217\u8868")
    public PageQueryResult<OptVariableDefine> listOptVariableDefinesByOptId(@PathVariable String optId, PageDesc pageDesc) {
        Map filter = CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId});
        List optVariableDefines = this.wfOptService.listOptVariableDefinesByFilter(filter, pageDesc);
        return PageQueryResult.createResult((Collection)optVariableDefines, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/allVariables/{optId}"})
    @WrapUpResponseBody
    @ApiOperation(value="\u6839\u636eoptId\u83b7\u53d6\u53d8\u91cf\u5b9a\u4e49\u5217\u8868")
    public PageQueryResult<OptVariableDefine> listAllOptVariableDefinesByOptId(@PathVariable String optId, PageDesc pageDesc) {
        Map filter;
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        List allOptInfos = this.platformEnvironment.listAllOptInfo(topUnit);
        List tyVariables = new ArrayList();
        OptInfo optInfo = null;
        String tyOptId = "";
        boolean flag = true;
        for (OptInfo obj : allOptInfos) {
            if (!obj.getOptId().equals(optId)) continue;
            optInfo = obj;
        }
        if (optInfo != null) {
            for (OptInfo obj : allOptInfos) {
                if (!obj.getTopOptId().equals(optInfo.getTopOptId())) continue;
                if (!obj.getOptName().equals("\u901a\u7528\u6a21\u5757") || !(tyOptId = obj.getOptId()).equals(optId)) continue;
                flag = false;
            }
        }
        if (flag) {
            filter = CollectionsOpt.createHashMap((Object[])new Object[]{"optId", tyOptId});
            tyVariables = this.wfOptService.listOptVariableDefinesByFilter(filter, pageDesc);
        }
        filter = CollectionsOpt.createHashMap((Object[])new Object[]{"optId", optId});
        List optVariableDefines = this.wfOptService.listOptVariableDefinesByFilter(filter, pageDesc);
        optVariableDefines.addAll(tyVariables);
        return PageQueryResult.createResult((Collection)optVariableDefines, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/variable/{variableId}"})
    @WrapUpResponseBody
    @ApiOperation(value="\u6839\u636e\u4e3b\u952eid\u83b7\u53d6\u53d8\u91cf\u5b9a\u4e49")
    public OptVariableDefine getOptVariableDefineById(@PathVariable String variableId) {
        return this.wfOptService.getOptVariableDefineById(variableId);
    }

    @PostMapping(value={"/variable"})
    @WrapUpResponseBody
    @ApiOperation(value="\u4fdd\u5b58\u53d8\u91cf\u5b9a\u4e49")
    public void saveOptVariableDefine(@RequestBody OptVariableDefine optVariableDefine) {
        this.wfOptService.saveOptVariableDefine(optVariableDefine);
    }

    @PutMapping(value={"/variable"})
    @WrapUpResponseBody
    @ApiOperation(value="\u66f4\u65b0\u53d8\u91cf\u5b9a\u4e49")
    public void updateOptVariableDefine(@RequestBody OptVariableDefine optVariableDefine) {
        this.wfOptService.updateOptVariableDefine(optVariableDefine);
    }

    @DeleteMapping(value={"/variable/{variableId}"})
    @WrapUpResponseBody
    @ApiOperation(value="\u5220\u9664\u53d8\u91cf\u5b9a\u4e49")
    public void deleteOptVariableDefine(@PathVariable String variableId) {
        this.wfOptService.deleteOptVariableDefineById(variableId);
    }
}

