/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.adapter.UserUnitFilterCalcContextFactory;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.ObjectTranslate;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.po.RoleFormula;
import com.centit.workflow.service.RoleFormulaService;
import com.centit.workflow.service.impl.FlowOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringEscapeUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@Api(value="\u6743\u9650\u8868\u8fbe\u5f0f", tags={"\u6743\u9650\u8868\u8fbe\u5f0f\u63a5\u53e3\u7c7b"})
@RequestMapping(value={"/formula"})
public class RoleFormulaController
extends BaseController {
    @Autowired
    private RoleFormulaService roleFormulaService;
    @Autowired
    private UserUnitFilterCalcContextFactory userUnitFilterFactory;

    @ApiOperation(value="\u6743\u9650\u8868\u8fbe\u5f0f\u5217\u8868", notes="\u6743\u9650\u8868\u8fbe\u5f0f\u5217\u8868")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public PageQueryResult<RoleFormula> listAllRoleFormula(PageDesc pageDesc, HttpServletRequest request, HttpServletResponse response) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        if (WebOptUtils.isTenantTopUnit((HttpServletRequest)request)) {
            String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
            filterMap.put("topUnit", topUnit);
        }
        List listObjects = this.roleFormulaService.listRoleFormulas(filterMap, pageDesc);
        return PageQueryResult.createResult((Collection)listObjects, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u6743\u9650\u8868\u8fbe\u5f0f", notes="\u67e5\u8be2\u5355\u4e2a\u6743\u9650\u8868\u8fbe\u5f0f")
    @WrapUpResponseBody
    @RequestMapping(value={"/{formulaCode}"}, method={RequestMethod.GET})
    public RoleFormula getRoleFormulaByCode(@PathVariable String formulaCode) {
        return this.roleFormulaService.getRoleFormulaByCode(formulaCode);
    }

    @ApiOperation(value="\u4fdd\u5b58\u6743\u9650\u8868\u8fbe\u5f0f", notes="\u4fdd\u5b58\u6743\u9650\u8868\u8fbe\u5f0f")
    @WrapUpResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public RoleFormula saveFlowRole(HttpServletRequest request, @RequestBody RoleFormula roleFormula) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)RequestThreadLocal.getLocalThreadWrapperRequest());
        if (StringBaseOpt.isNvl((String)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff01");
        }
        if (WebOptUtils.isTenantTopUnit((HttpServletRequest)request)) {
            String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
            roleFormula.setTopUnit(topUnit);
        }
        this.roleFormulaService.saveRoleFormula(roleFormula);
        return roleFormula;
    }

    @ApiOperation(value="\u5220\u9664\u6743\u9650\u8868\u8fbe\u5f0f", notes="\u5220\u9664\u6743\u9650\u8868\u8fbe\u5f0f")
    @WrapUpResponseBody
    @RequestMapping(value={"/{formulaCode}"}, method={RequestMethod.DELETE})
    public void deleteFlowRoleByCode(@PathVariable String formulaCode) {
        this.roleFormulaService.deleteRoleFormulaByCode(formulaCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u6743\u9650\u8868\u8fbe\u5f0f\u5bf9\u5e94\u7528\u6237", notes="\u67e5\u8be2\u6743\u9650\u8868\u8fbe\u5f0f\u5bf9\u5e94\u7528\u6237")
    @WrapUpResponseBody
    @RequestMapping(value={"/usersByFormulaCode/{formulaCode}"}, method={RequestMethod.GET})
    public JSONArray viewRoleFormulaUsers(@PathVariable String formulaCode, HttpServletRequest request) {
        JSONArray listObjects = this.roleFormulaService.viewRoleFormulaUsers(formulaCode, WebOptUtils.getCurrentUserCode((HttpServletRequest)request), WebOptUtils.getCurrentUnitCode((HttpServletRequest)request));
        return listObjects;
    }

    @ApiOperation(value="\u9884\u89c8\u6743\u9650\u8868\u8fbe\u5f0f\u5bf9\u5e94\u7528\u6237", notes="\u8868\u8fbe\u5f0f\u4e3aitemExp ([\u6216| itemExp][\u4e0e& itemExp][\u975e! itemExp])\u7684\u5f62\u5f0f\uff0citemExp\u4e3a\u4e0b\u5217\u5f62\u5f0f\nD()P()DT()DL()GW()XZ()R()UT()UL()U()RO()\n* D \u6839\u636e\u673a\u6784\u4ee3\u7801\u8fc7\u6ee4 D(\u673a\u6784\u8868\u8fbe\u5f0f)\n* P \u6839\u636e\u673a\u6784\u4ee3\u7801\u8fc7\u6ee4\u4e3b\u8981\u673a\u6784\n* DT \u6839\u636e\u673a\u6784\u7c7b\u578b\u8fc7\u6ee4 DT(\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\" [,\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\"])\n* DL \u6839\u636e\u673a\u6784\u6807\u7b7e\u8fc7\u6ee4 DL(\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\" [,\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\"])\n* GW \u6839\u636e\u5c97\u4f4d\u8fc7\u6ee4 GW(\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\" [,\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\"])\n* XZ \u6839\u636e\u884c\u653f\u804c\u52a1\u8fc7\u6ee4 XZ(\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\" [,\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\"])\n* R \u6839\u636e\u884c\u653f\u804c\u52a1\u7b49\u7ea7\u8fc7\u6ee4 R(U) / R(U-) / R(U-1) / R(U--) /R(U-1--)\n* U \u6839\u636e\u7528\u6237\u4ee3\u7801\u8fc7\u6ee4 U(\u7528\u6237\u53d8\u91cf|\"\u7528\u6237\u4ee3\u7801\u5e38\u91cf\" [,\u7528\u6237\u53d8\u91cf|\"\u7528\u6237\u4ee3\u7801\u5e38\u91cf])\n* UT \u6839\u636e\u7528\u6237\u7c7b\u578b\u8fc7\u6ee4 UT(\"\u7528\u6237\u7c7b\u578b\u5e38\u91cf\" [,\"\u7528\u6237\u7c7b\u578b\u5e38\u91cf\"])\n* UL \u6839\u636e\u7528\u6237\u6807\u7b7e\u8fc7\u6ee4 UL(\"\u7528\u6237\u6807\u8bb0\u5e38\u91cf\" [,\"\u7528\u6237\u6807\u8bb0\u5e38\u91cf\"])\n* RO \u6839\u636e\u7528\u6237\u89d2\u8272\u8fc7\u6ee4 RO(\"\u7cfb\u7edf\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\" [,\"\u7cfb\u7edf\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\"])")
    @WrapUpResponseBody
    @RequestMapping(value={"/calcUsers"}, method={RequestMethod.GET})
    public JSONArray viewFormulaUsers(String formula, HttpServletRequest request) {
        if (StringBaseOpt.isNvl((String)formula)) {
            return null;
        }
        return this.roleFormulaService.viewFormulaUsers(StringEscapeUtils.unescapeHtml4((String)formula), WebOptUtils.getCurrentUserCode((HttpServletRequest)request), WebOptUtils.getCurrentUnitCode((HttpServletRequest)request));
    }

    @ApiOperation(value="\u9884\u89c8\u6743\u9650\u8868\u8fbe\u5f0f\u5bf9\u5e94\u673a\u6784", notes="\u8868\u8fbe\u5f0f\u4e3aitemExp ([\u6216| itemExp][\u4e0e& itemExp][\u975e! itemExp])\u7684\u5f62\u5f0f\uff0citemExp\u4e3a\u4e0b\u5217\u5f62\u5f0f\nD()P()DT()DL()\n* D \u6839\u636e\u673a\u6784\u4ee3\u7801\u8fc7\u6ee4 D(\u673a\u6784\u8868\u8fbe\u5f0f)\n* P \u6839\u636e\u673a\u6784\u4ee3\u7801\u8fc7\u6ee4\u4e3b\u8981\u673a\u6784\n* DT \u6839\u636e\u673a\u6784\u7c7b\u578b\u8fc7\u6ee4 DT(\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\" [,\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\"])\n* DL \u6839\u636e\u673a\u6784\u6807\u7b7e\u8fc7\u6ee4 DL(\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\" [,\"\u89d2\u8272\u4ee3\u7801\u5e38\u91cf\"])])")
    @WrapUpResponseBody
    @RequestMapping(value={"/calcUnits"}, method={RequestMethod.GET})
    public JSONArray viewFormulaUnits(String formula, HttpServletRequest request) {
        return this.roleFormulaService.viewFormulaUnits(StringEscapeUtils.unescapeHtml4((String)formula), WebOptUtils.getCurrentUserCode((HttpServletRequest)request), WebOptUtils.getCurrentUnitCode((HttpServletRequest)request));
    }

    private static List<UserInfo> truncateUsers(List<UserInfo> allusers, Integer maxSize) {
        if (maxSize == null || maxSize < 1 || allusers == null || allusers.size() <= maxSize) {
            return allusers;
        }
        return allusers.subList(0, maxSize);
    }

    @ApiOperation(value="\u5217\u4e3e\u6240\u6709\u7528\u6237", notes="\u5217\u4e3e\u6240\u6709\u7528\u6237")
    @WrapUpResponseBody
    @RequestMapping(value={"/allUsers"}, method={RequestMethod.GET})
    public List<UserInfo> listAllUserInfo(Integer maxUsers, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        return RoleFormulaController.truncateUsers(this.roleFormulaService.listAllUserInfo(topUnit), maxUsers);
    }

    @ApiOperation(value="\u6839\u636e\u524d\u7f00\u6216\u8005\u540e\u7f00\u67e5\u8be2\u7528\u6237", notes="\u6839\u636e\u524d\u7f00\u6216\u8005\u540e\u7f00\u67e5\u8be2\u7528\u6237")
    @WrapUpResponseBody
    @RequestMapping(value={"/users/{prefix}"}, method={RequestMethod.GET})
    public List<UserInfo> listUserInfo(@PathVariable String prefix, Integer maxUsers, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        return RoleFormulaController.truncateUsers(this.roleFormulaService.listUserInfo(prefix, topUnit), maxUsers);
    }

    @ApiOperation(value="\u5217\u4e3e\u6240\u6709\u673a\u6784", notes="\u5217\u4e3e\u6240\u6709\u673a\u6784")
    @WrapUpResponseBody
    @RequestMapping(value={"/allUnits"}, method={RequestMethod.GET})
    public List<UnitInfo> listAllUnitInfo(HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        return this.roleFormulaService.listAllUnitInfo(topUnit);
    }

    @ApiOperation(value="\u5217\u4e3e\u6240\u6709\u5b50\u673a\u6784", notes="\u5217\u4e3e\u6240\u6709\u5b50\u673a\u6784")
    @WrapUpResponseBody
    @RequestMapping(value={"/subUnits/{unitCode}"}, method={RequestMethod.GET})
    public List<UnitInfo> listSubUnit(@PathVariable String unitCode) {
        if ("null".equalsIgnoreCase(unitCode)) {
            unitCode = "";
        }
        return this.roleFormulaService.listSubUnit(unitCode);
    }

    @PostMapping(value={"/testformula"})
    @ApiOperation(value="\u6d4b\u8bd5\u8868\u8fbe\u5f0f")
    @WrapUpResponseBody
    public Object testFormula(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        Object object = jsonObject.getOrDefault("jsonString", (Object)"");
        VariableFormula variableFormula = new VariableFormula();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        variableFormula.setExtendFuncMap(FlowOptUtils.createExtendFuncMap(() -> this.userUnitFilterFactory.createCalcContext(topUnit)));
        variableFormula.setTrans((VariableTranslate)new ObjectTranslate(object));
        variableFormula.setFormula(jsonObject.containsKey("formula") ? jsonObject.getString("formula") : "");
        return variableFormula.calcFormula();
    }
}

