/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.UserUnitFilterCalcContext;
import com.centit.framework.model.adapter.UserUnitFilterCalcContextFactory;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.po.RoleRelegate;
import com.centit.workflow.service.RoleRelegateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="\u4efb\u52a1\u7ba1\u7406", tags={"\u6743\u9650\u59d4\u6258\u548c\u4efb\u52a1\u8f6c\u79fb"})
@Controller
@RequestMapping(value={"/flow/relegate"})
public class RoleRelegateController
extends BaseController {
    @Autowired
    private RoleRelegateService roleRelegateService;
    @Autowired
    private UserUnitFilterCalcContextFactory userUnitFilterFactory;

    @ApiOperation(value="\u65b0\u589e\u59d4\u6258", notes="\u65b0\u589e\u59d4\u6258")
    @WrapUpResponseBody
    @PostMapping
    public void saveRelegate(@RequestBody RoleRelegate roleRelegate, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)roleRelegate.getTopUnit())) {
            roleRelegate.setTopUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        this.roleRelegateService.saveRelegate(roleRelegate);
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1id\u6570\u7ec4\u8fdb\u884c\u59d4\u6258", notes="relateType:'batch\uff08\u6309\u7167\u4e1a\u52a1\u5217\u8868\u59d4\u6258\uff09/all(\u8868\u793a\u5168\u90e8\uff09', optIds :['\u8bbe\u7f6e\u4e3a\u6570\u7ec4']")
    @WrapUpResponseBody
    @PostMapping(value={"/batchRelegateByOp"})
    public void batchRelegate(@RequestBody String relegateString, HttpServletRequest request) {
        JSONObject json = JSONObject.parseObject((String)relegateString);
        RoleRelegate roleRelegate = (RoleRelegate)json.toJavaObject(RoleRelegate.class, new JSONReader.Feature[0]);
        if (StringUtils.isBlank((CharSequence)roleRelegate.getTopUnit())) {
            roleRelegate.setTopUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        roleRelegate.setRoleType("OP");
        String relateType = json.getString("relateType");
        Date today = DatetimeOpt.truncateToDay((Date)DatetimeOpt.currentUtilDate());
        if (roleRelegate.getRelegateTime() == null || today.after(roleRelegate.getRelegateTime())) {
            roleRelegate.setRelegateTime(today);
        }
        List optIds = StringBaseOpt.objectToStringList((Object)json.get("optIds"));
        this.roleRelegateService.batchRelegateByOp(roleRelegate, relateType, optIds);
    }

    @ApiOperation(value="\u4fee\u6539\u59d4\u6258", notes="\u4fee\u6539\u59d4\u6258")
    @WrapUpResponseBody
    @RequestMapping(value={"/updateRelegate"}, method={RequestMethod.POST})
    public void updateRelegate(@RequestBody RoleRelegate roleRelegate, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)roleRelegate.getTopUnit())) {
            roleRelegate.setTopUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        this.roleRelegateService.updateRelegate(roleRelegate);
    }

    @ApiOperation(value="\u4fee\u6539\u59d4\u6258\u72b6\u6001", notes="\u4fee\u6539\u59d4\u6258\u72b6\u6001")
    @WrapUpResponseBody
    @RequestMapping(value={"/changeRelegateValid"}, method={RequestMethod.PUT})
    public void changeRelegateValid(@RequestBody RoleRelegate roleRelegate, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)roleRelegate.getTopUnit())) {
            roleRelegate.setTopUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        this.roleRelegateService.changeRelegateValid(roleRelegate);
    }

    @ApiOperation(value="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u59d4\u6258\u5217\u8868", notes="\u83b7\u53d6\u6307\u5b9a\u7528\u6237\u59d4\u6258\u5217\u8868")
    @WrapUpResponseBody
    @RequestMapping(value={"/byGrantor/{grantor}"}, method={RequestMethod.GET})
    public PageQueryResult<Object> getRelegateListByGrantor(@PathVariable String grantor, HttpServletRequest request, PageDesc pageDesc) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("grantor", grantor);
        if (StringUtils.isBlank((CharSequence)StringBaseOpt.objectToString(filterMap.get("topUnit")))) {
            filterMap.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        JSONArray relegates = this.roleRelegateService.listRelegateListByUser(filterMap, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)relegates, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u83b7\u53d6\u59d4\u6258\u7ed9\u6307\u5b9a\u7528\u6237\u59d4\u6258\u5217\u8868", notes="\u83b7\u53d6\u59d4\u6258\u7ed9\u6307\u5b9a\u7528\u6237\u59d4\u6258\u5217\u8868")
    @WrapUpResponseBody
    @RequestMapping(value={"/byGrantee/{grantee}"}, method={RequestMethod.GET})
    public PageQueryResult<Object> getRelegateListByGrantee(@PathVariable String grantee, HttpServletRequest request, PageDesc pageDesc) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        filterMap.put("grantee", grantee);
        if (StringUtils.isBlank((CharSequence)StringBaseOpt.objectToString(filterMap.get("topUnit")))) {
            filterMap.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        JSONArray relegates = this.roleRelegateService.listRelegateListByUser(filterMap, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)relegates, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u59d4\u6258\u5217\u8868\u67e5\u8be2", notes="\u59d4\u6258\u5217\u8868\u67e5\u8be2")
    @WrapUpResponseBody
    @RequestMapping(value={"/listRoleRelegates"}, method={RequestMethod.GET})
    public PageQueryResult<RoleRelegate> listRoleRelegates(HttpServletRequest request, PageDesc pageDesc) {
        Map filterMap = BaseController.collectRequestParameters((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)StringBaseOpt.objectToString(filterMap.get("topUnit")))) {
            filterMap.put("topUnit", WebOptUtils.getCurrentTopUnit((HttpServletRequest)request));
        }
        List relegateList = this.roleRelegateService.listRoleRelegates(filterMap, pageDesc);
        return PageQueryResult.createResultMapDict((Collection)relegateList, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664\u59d4\u6258", notes="\u6839\u636eid\u5220\u9664\u59d4\u6258")
    @WrapUpResponseBody
    @RequestMapping(value={"/{relegateNo}"}, method={RequestMethod.DELETE})
    public void deleteRelegate(@PathVariable String relegateNo) {
        this.roleRelegateService.deleteRoleRelegate(relegateNo);
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u804c\u52a1", notes="\u83b7\u53d6\u7528\u6237\u804c\u52a1")
    @ApiImplicitParam(name="userCode", value="\u7528\u6237\u4ee3\u7801", required=true, paramType="path", dataType="String")
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    @GetMapping(value={"/role/{userCode}"})
    public List<UserUnit> listUserRoles(@PathVariable String userCode, HttpServletRequest request) {
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(topUnit);
        return context.listUserUnits(userCode);
    }
}

