/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.po.FlowInstance;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FlowInstanceDao
extends BaseDaoImpl<FlowInstance, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("flowInstId", "EQUAL");
        filterField.put("flowInstIds", "flow_Inst_Id in (:flowInstIds)");
        filterField.put("flowCode", "EQUAL");
        filterField.put("version", "EQUAL");
        filterField.put("osId", "EQUAL");
        filterField.put("optId", "EQUAL");
        filterField.put("(date)createTimeBeg", " createTime>= :createTimeBeg");
        filterField.put("(date)createTimeEnd", " createTime<= createTimeEnd  ");
        filterField.put("(date)lastUpdateTime", "lastUpdateTime = :lastUpdateTime");
        filterField.put("instState", "EQUAL");
        filterField.put("isSubInst", "EQUAL");
        filterField.put("flowOptName", "LIKE");
        filterField.put("flowOptTag", "LIKE");
        filterField.put("preInstId", "EQUAL");
        filterField.put("preNodeInstId", "EQUAL");
        filterField.put("unitCode", "EQUAL");
        filterField.put("userCode", "EQUAL");
        filterField.put("(long)nodeId", "flowInstId in (select flowInstId from NodeInstance where nodeState='N' and nodeId=:nodeId)");
        filterField.put("optCode", "flowInstId in (select a.flowInstId from NodeInstance a,NodeInfo b where a.nodeId=b.nodeId and a.nodeState='N' and b.optCode=:optCode)");
        filterField.put("nocom", "instState <> :nocom");
        filterField.put("NP_warning", "flowInstId in (select flowInstId from FlowWarning ) ");
        filterField.put("ORDER BY", "createTime desc,flowInstId desc");
        return filterField;
    }

    @Transactional
    public long getNextFlowInstId() {
        return DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_FLOWINSTNO");
    }

    @Transactional
    public void updtFlowInstState(long instid, String state) {
        FlowInstance flowInst = (FlowInstance)this.getObjectById(instid);
        flowInst.setInstState(state);
        this.updateObject((Serializable)flowInst);
    }

    @Transactional
    public List<FlowInstance> listNearExpireFlowInstance(long leaveLimit) {
        String conditionSql = "where FLOW_INST_ID = ?  and inst_State='N' and is_Timer='T'";
        return this.listObjectsByFilter(conditionSql, new Object[]{leaveLimit});
    }

    @Transactional
    public void updateTimeConsume(long consumeTime) {
        String baseSql = "update WF_FLOW_INSTANCE set TIME_LIMIT =TIME_LIMIT- ? where inst_State='N' and is_Timer='T' and time_Limit is not null  ";
        this.getJdbcTemplate().update(baseSql, new Object[]{consumeTime});
    }

    @Transactional
    public List<FlowInstance> listAllActiveFlowInst(PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson("where inst_State = 'N'", new Object[0], pageDesc).toJavaList(FlowInstance.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public List<FlowInstance> listAllActiveTimerFlowInst() {
        String whereSql = "where inst_State = 'N' and (is_Timer='T' or is_Timer='H')";
        return this.listObjectsByFilter(whereSql, null);
    }

    @Transactional
    public List<FlowInstance> listAllActiveTimerFlowInst(PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson("where inst_State = 'N' and (is_Timer='T' or is_Timer='H')", new Object[0], pageDesc).toJavaList(FlowInstance.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public List<FlowInstance> listFlowInstByTimer(String userCode, String isTimer, PageDesc pageDesc) {
        return super.listObjectsByFilterAsJson(" where last_Update_User = ? and is_Timer =? order by last_Update_Time ", new Object[]{userCode, isTimer}, pageDesc).toJavaList(FlowInstance.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public void updateFlowTimerState(String instid, String isTimer, String mangerUserCode) {
        FlowInstance flowInst = (FlowInstance)this.getObjectById(instid);
        flowInst.setIsTimer(isTimer);
        flowInst.setLastUpdateUser(mangerUserCode);
        flowInst.setLastUpdateTime(new Date(System.currentTimeMillis()));
        this.updateObject((Serializable)flowInst);
    }

    @Transactional
    public long calcOtherSubflowSum(String nodeInstId, String curSubFlowId) {
        String baseSql = "select count(1) as otherFlows from WF_FLOW_INSTANCE  where INST_STATE='N' and IS_SUB_INST='Y'  and PRE_NODE_INST_ID = ? and FLOW_INST_ID <> ?";
        Object obj = this.getJdbcTemplate().queryForObject(baseSql, new Object[]{nodeInstId, curSubFlowId}, Long.class);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof String) {
            return Long.valueOf(obj.toString());
        }
        if (obj instanceof BigDecimal) {
            return ((BigDecimal)obj).longValue();
        }
        return 0L;
    }

    @Transactional
    public void updateFlowInstOptInfo(String flowInstId, String flowOptName, String flowOptTag) {
        String sql = "update WF_FLOW_INSTANCE set FLOW_OPT_NAME=?,FLOW_OPT_TAG=? where  FLOW_INST_ID=?";
        this.getJdbcTemplate().update(sql, new Object[]{flowOptName, flowOptTag, flowInstId});
    }

    @Transactional
    public void updateFlowInstOptName(String flowInstId, String flowOptName) {
        String sql = "update WF_FLOW_INSTANCE set FLOW_OPT_NAME=? where  FLOW_INST_ID=?";
        this.getJdbcTemplate().update(sql, new Object[]{flowOptName, flowInstId});
    }

    @Transactional
    public void updateFlowInstOptInfoAndUser(String flowInstId, String flowOptName, String flowOptTag, String userCode, String unitCode) {
        String sql = "update WF_FLOW_INSTANCE set FLOW_OPT_NAME=?,FLOW_OPT_TAG=?,user_code=?,unit_code=? where  FLOW_INST_ID=?";
        this.getJdbcTemplate().update(sql, new Object[]{flowOptName, flowOptTag, userCode, unitCode, flowInstId});
    }

    public List<FlowInstance> listAllFlowInstByOptTag(String flowOptTag) {
        return this.listObjectsByFilter("where FLOW_OPT_TAG=? ", new Object[]{flowOptTag});
    }

    public void updtFlowInstInfo(FlowInstance wfFlowInst) {
        String sql = "update WF_FLOW_INSTANCE set FLOW_INST_ID=?,INST_STATE=?,LAST_UPDATE_TIME=?,LAST_UPDATE_USER=? where  FLOW_INST_ID=?";
        this.getJdbcTemplate().update(sql, new Object[]{wfFlowInst.getFlowInstId(), wfFlowInst.getInstState(), wfFlowInst.getLastUpdateTime(), wfFlowInst.getLastUpdateUser(), wfFlowInst.getFlowInstId()});
    }

    public JSONArray countFlowInstances(Map<String, Object> map) {
        String sql = "SELECT FLOW_CODE,count(1) FROM wf_flow_instance WHERE 1 = 1 [ :flowCode | AND FLOW_CODE in ( :flowCode ) ]  GROUP BY FLOW_CODE";
        return DatabaseOptUtils.listObjectsByParamsDriverSqlAsJson((BaseDaoImpl)this, (String)sql, map);
    }
}

