/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.workflow.po.FlowVariable;
import com.centit.workflow.po.FlowVariableId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FlowVariableDao
extends BaseDaoImpl<FlowVariable, FlowVariableId> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("flowInstId", "EQUAL");
        filterField.put("runToken", "EQUAL");
        filterField.put("varName", "EQUAL");
        filterField.put("varValue", "LIKE");
        filterField.put("varType", "LIKE");
        return filterField;
    }

    @Transactional
    public List<FlowVariable> listFlowVariables(String flowInstId) {
        return this.listObjectsByFilter("where FLOW_INST_ID = ? order by run_Token", new Object[]{flowInstId});
    }

    @Transactional
    public List<FlowVariable> viewFlowVariablesByVarname(String flowInstId, String varname) {
        return this.listObjectsByFilter("where FLOW_INST_ID = ? and var_Name=? order by run_Token", new Object[]{flowInstId, varname});
    }

    @Transactional
    public List<FlowVariable> listFlowDefaultVariables(String flowInstId, String flowCode, long version) {
        List ja = DatabaseOptUtils.listObjectsBySql((BaseDaoImpl)this, (String)" select VARIABLE_NAME, VARIABLE_TYPE, DEFAULT_VALUE from WF_FLOW_VARIABLE_DEFINE where FLOW_CODE = ? and VERSION = ?", (Object[])new Object[]{flowCode, version});
        if (ja == null || ja.size() == 0) {
            return null;
        }
        ArrayList<FlowVariable> variables = new ArrayList<FlowVariable>(ja.size());
        for (Object[] json : ja) {
            String svarValue = StringBaseOpt.castObjectToString((Object)json[2]);
            if (!StringUtils.isNotBlank((CharSequence)svarValue)) continue;
            variables.add(new FlowVariable(flowInstId, "T", StringBaseOpt.castObjectToString((Object)json[0]), StringBaseOpt.castObjectToString((Object)json[1]), svarValue));
        }
        return variables;
    }
}

