/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.po.FlowWarning;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class FlowWarningDao
extends BaseDaoImpl<FlowWarning, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("warningId", "EQUAL");
        filterField.put("nodeInstId", "EQUAL");
        filterField.put("flowInstId", "EQUAL");
        filterField.put("flowStage", "EQUAL");
        filterField.put("warningType", "EQUAL");
        filterField.put("warningCode", "EQUAL");
        filterField.put("warningTime", "LIKE");
        filterField.put("warningState", "EQUAL");
        filterField.put("warningidMsg", "LIKE");
        filterField.put("sendMsgTime", "LIKE");
        filterField.put("sendUsers", "LIKE");
        return filterField;
    }

    @Transactional
    public List<FlowWarning> listFlowWarningByInst(String flowInstId, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson("where flow_Inst_Id = ?", new Object[]{flowInstId}, pageDesc).toJavaList(FlowWarning.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public List<FlowWarning> listFlowWarning(String flowInstId, String nodeInstId, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson("where flow_Inst_Id = ? and node_Inst_Id = ?", new Object[]{flowInstId, nodeInstId}, pageDesc).toJavaList(FlowWarning.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public List<FlowWarning> listFlowWarning(String flowInstId, String nodeInstId, String warningType, String objType, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson("where flow_Inst_Id = ? and node_Inst_Id = ? and OBJ_TYPE = ? and warning_type = ?", new Object[]{flowInstId, nodeInstId, objType, warningType}, pageDesc).toJavaList(FlowWarning.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public List<FlowWarning> listFlowWarning(String flowInstId, String warningType, String objType, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson("where flow_Inst_Id = ? and (node_Inst_Id = '0' or node_Inst_Id = null) and OBJ_TYPE = ? and warning_type = ?", new Object[]{flowInstId, objType, warningType}, pageDesc).toJavaList(FlowWarning.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public List<FlowWarning> listFlowWarningByNodeInst(String nodeInstId, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson("where node_Inst_Id = ?", new Object[]{nodeInstId}, pageDesc).toJavaList(FlowWarning.class, new JSONReader.Feature[0]);
    }

    public List<FlowWarning> listFlowWarningByWarningCode(String warningCode, PageDesc pageDesc) {
        return this.listObjectsByFilterAsJson("where warning_Code = ?", new Object[]{warningCode}, pageDesc).toJavaList(FlowWarning.class, new JSONReader.Feature[0]);
    }

    public List<FlowWarning> listNeedNotifyWarning() {
        return this.listObjectsByFilter("where notice_State = '0'", new Object[0]);
    }
}

