/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import com.centit.workflow.po.OptVariableDefine;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class OptVariableDefineDao
extends BaseDaoImpl<OptVariableDefine, String> {
    public Map<String, String> getFilterField() {
        return null;
    }

    @Transactional
    public void saveNewObject(OptVariableDefine o) {
        if (o.getOptVariableId() == null || "".equals(o.getOptVariableId())) {
            o.setOptVariableId(UuidOpt.getUuidAsString32());
        }
        super.saveNewObject((Serializable)o);
    }

    @Transactional
    public List<OptVariableDefine> listOptVariableByFlowCode(String flowCode, long version) {
        String sql = "select var.* from WF_OPT_VARIABLE_DEFINE var left join WF_FLOW_DEFINE define on var.OPT_ID = define.OPT_ID where 1=1 [:flowCode | and define.FLOW_CODE=:flowCode] [:version | and define.VERSION=:version] ";
        QueryAndNamedParams queryAndNamedParams = QueryUtils.translateQuery((String)sql, (Object)CollectionsOpt.createHashMap((Object[])new Object[]{"flowCode", flowCode, "version", version}));
        JSONArray dataList = DatabaseOptUtils.listObjectsByNamedSqlAsJson((BaseDaoImpl)this, (String)queryAndNamedParams.getQuery(), (Map)queryAndNamedParams.getParams());
        return null == dataList ? Collections.emptyList() : dataList.toJavaList(OptVariableDefine.class, new JSONReader.Feature[0]);
    }

    @Transactional
    public List<OptVariableDefine> listOptVariableByOptId(String optId) {
        return this.listObjectsByFilter("where OPT_ID = ?", new Object[]{optId});
    }
}

