/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.po.RoleRelegate;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class RoleRelegateDao
extends BaseDaoImpl<RoleRelegate, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("relegateNo", "EQUAL");
        filterField.put("grantor", "EQUAL");
        filterField.put("grantee", "EQUAL");
        filterField.put("isValid", "EQUAL");
        filterField.put("(date)relegateTime", "relegateTime < :relegateTime");
        filterField.put("(date)expireTime", "expireTime > :expireTime");
        filterField.put("unitCode", "EQUAL");
        filterField.put("roleType", "EQUAL");
        filterField.put("roleCode", "EQUAL");
        filterField.put("grantDesc", "LIKE");
        filterField.put("recorder", "EQUAL");
        filterField.put("recordDate", "EQUAL");
        filterField.put("optId", "EQUAL");
        filterField.put("topUnit", "EQUAL");
        filterField.put("ORDER BY", "recordDate desc");
        return filterField;
    }

    @Transactional
    public void saveObject(RoleRelegate roleRelegate) {
        if (StringUtils.isBlank((CharSequence)roleRelegate.getRelegateNo())) {
            roleRelegate.setRelegateNo(UuidOpt.getUuidAsString22());
        }
        super.mergeObject((Serializable)roleRelegate);
    }

    public JSONArray listRelegateListByUser(Map<String, Object> filterMap, PageDesc pageDesc) {
        filterMap.put("today", DatetimeOpt.currentUtilDate());
        return DatabaseOptUtils.listObjectsByParamsDriverSqlAsJson((BaseDaoImpl)this, (String)"select a.RELEGATE_NO, a.GRANTOR, a.GRANTEE, a.IS_VALID, a.RELEGATE_TIME, a.EXPIRE_TIME, a.UNIT_CODE, a.ROLE_TYPE, a.ROLE_CODE, a.GRANT_DESC, a.RECORDER, a.RECORD_DATE, a.OPT_ID, b.OPT_NAME, a.TOP_UNIT from WF_ROLE_RELEGATE a left join f_optinfo b on a.OPT_ID = b.OPT_ID  where (a.EXPIRE_TIME is null or a.EXPIRE_TIME> :today)  [:grantor | and a.GRANTOR= :grantor ]  [:grantee | and a.GRANTEE= :grantee ]  [:roleType | and a.ROLE_TYPE= :roleType ]  [:roleCode | and a.ROLE_CODE= :roleCode ]  [:topUnit | and a.TOP_UNIT= :topUnit ]  [:optId | and a.OPT_ID= :optId ]  ORDER BY a.GRANTEE, a.RELEGATE_TIME, a.EXPIRE_TIME, a.RECORD_DATE DESC ", filterMap, (PageDesc)pageDesc);
    }

    public List<RoleRelegate> listGranteeListByRank(String grantor, String unitCode, String userRank) {
        return this.listObjectsByFilter(" where GRANTOR = ?  and (UNIT_CODE is null or UNIT_CODE = ?)and (ROLE_CODE is null or ROLE_CODE = ?)  and RELEGATE_TIME < ? and( EXPIRE_TIME is null or EXPIRE_TIME> ?)", new Object[]{grantor, unitCode, userRank, DatetimeOpt.currentUtilDate(), DatetimeOpt.currentUtilDate()});
    }

    public int checkGrantee(String grantor, String grantee, String unitCode, String userRank) {
        return NumberBaseOpt.castObjectToInteger((Object)DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this, (String)"select count(*) as granted from WF_ROLE_RELEGATE where GRANTOR = ? and GRANTEE = ? and (UNIT_CODE is null or UNIT_CODE = ?)and (ROLE_CODE is null or ROLE_CODE = ?)  and RELEGATE_TIME < ? and( EXPIRE_TIME is null or EXPIRE_TIME> ?)", (Object[])new Object[]{grantor, grantee, unitCode, userRank, DatetimeOpt.currentUtilDate(), DatetimeOpt.currentUtilDate()}), (Integer)0);
    }

    public void deleteOptRelegate(String grantor, String grantee) {
        DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this, (String)"delete from WF_ROLE_RELEGATE where GRANTOR = ? and GRANTEE = ?  and( EXPIRE_TIME is null or EXPIRE_TIME> ?)", (Object[])new Object[]{grantor, grantee, DatetimeOpt.currentUtilDate()});
    }
}

