/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.workflow.po.StageInstance;
import com.centit.workflow.po.StageInstanceId;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class StageInstanceDao
extends BaseDaoImpl<StageInstance, StageInstanceId> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("flowInstId", "flowInstId = :flowInstId");
        filterField.put("stageId", "stageId = :stageId");
        filterField.put("promiseTime", "LIKE");
        filterField.put("timeLimit", "LIKE");
        return filterField;
    }

    @Transactional
    public List<StageInstance> listStageInstByFlowInstId(String flowInstId) {
        return this.listObjectsByFilter("where flow_Inst_Id=?", new Object[]{flowInstId});
    }

    @Transactional
    public StageInstance getObject(String flowInstId, String stageId) {
        return (StageInstance)this.getObjectById(new StageInstanceId(flowInstId, stageId));
    }

    @Transactional
    public StageInstance getStageInstanceByCode(String flowInstId, String stageCode) {
        List stageInstances = this.listObjectsByFilter("where flow_Inst_Id=? and stage_code=?", new Object[]{flowInstId, stageCode});
        if (null != stageInstances && stageInstances.size() > 0) {
            return (StageInstance)stageInstances.get(0);
        }
        return null;
    }
}

