/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.adapter.UserUnitFilterCalcContext;
import com.centit.framework.model.adapter.UserUnitFilterCalcContextFactory;
import com.centit.framework.model.basedata.OptInfo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.dao.FlowInfoDao;
import com.centit.workflow.dao.FlowInstanceDao;
import com.centit.workflow.dao.FlowStageDao;
import com.centit.workflow.dao.NodeInfoDao;
import com.centit.workflow.dao.OptTeamRoleDao;
import com.centit.workflow.dao.OptVariableDefineDao;
import com.centit.workflow.dao.RoleFormulaDao;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowInfoId;
import com.centit.workflow.po.FlowStage;
import com.centit.workflow.po.FlowTransition;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.OptTeamRole;
import com.centit.workflow.po.OptVariableDefine;
import com.centit.workflow.service.FlowDefine;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FlowDefineImpl
implements FlowDefine,
Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private FlowInfoDao flowDefineDao;
    @Autowired
    private NodeInfoDao flowNodeDao;
    @Autowired
    private RoleFormulaDao flowRoleDao;
    @Autowired
    private OptVariableDefineDao optVariableDefineDao;
    @Autowired
    private OptTeamRoleDao optTeamRoleDao;
    @Autowired
    private UserUnitFilterCalcContextFactory userUnitFilterFactory;
    @Autowired
    private FlowStageDao flowStageDao;
    @Autowired
    private FlowInstanceDao flowInstanceDao;
    @Autowired
    private PlatformEnvironment platformEnvironment;
    private static Logger logger = LoggerFactory.getLogger(FlowDefineImpl.class);
    public static final String BEGINNODETAG = "begin";
    public static final String ENDNODETAG = "end";

    @PostConstruct
    public void registerDictionary() {
        CodeRepositoryUtil.registeExtendedCodeRepo((String)"flowCode", this.flowDefineDao.listFlowCodeNameMap());
    }

    @Transactional
    public JSONArray listFlowsByOptId(String optId) {
        List<FlowInfo> flows = this.flowDefineDao.listLastVersionFlowByOptId(optId);
        JSONArray flowDefineJsonArray = new JSONArray();
        if (CollectionUtils.sizeIsEmpty(flows)) {
            return flowDefineJsonArray;
        }
        Object[] flowCodes = flows.stream().map(FlowInfo::getFlowCode).toArray();
        JSONArray jsonArray = this.flowInstanceDao.countFlowInstances(CollectionsOpt.createHashMap((Object[])new Object[]{"flowCode", flowCodes}));
        flows.forEach(flowInfo -> flowDefineJsonArray.add((Object)this.combineFlowInstanceCount(jsonArray, (FlowInfo)flowInfo)));
        return flowDefineJsonArray;
    }

    @Transactional
    public JSONArray listFlowByOsId(String osId) {
        List<FlowInfo> flows = this.flowDefineDao.getFlowsByOsId(osId, "B");
        JSONArray flowDefineJsonArray = new JSONArray();
        if (CollectionUtils.sizeIsEmpty(flows)) {
            return flowDefineJsonArray;
        }
        Object[] flowCodes = flows.stream().map(FlowInfo::getFlowCode).toArray();
        JSONArray jsonArray = this.flowInstanceDao.countFlowInstances(CollectionsOpt.createHashMap((Object[])new Object[]{"flowCode", flowCodes}));
        flows.forEach(flowInfo -> flowDefineJsonArray.add((Object)this.combineFlowInstanceCount(jsonArray, (FlowInfo)flowInfo)));
        return flowDefineJsonArray;
    }

    @Transactional
    public JSONArray listAllFlowsByOptId(String optId) {
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        JSONArray flowDefineJsonArray = new JSONArray();
        List<FlowInfo> flows = this.flowDefineDao.listLastVersionFlowByOptId(optId);
        List allOptInfos = this.platformEnvironment.listAllOptInfo(topUnit);
        List<Object> tyFlows = new ArrayList();
        OptInfo optInfo = null;
        String tyOptId = "";
        boolean flag = true;
        for (OptInfo obj : allOptInfos) {
            if (!obj.getOptId().equals(optId)) continue;
            optInfo = obj;
        }
        if (optInfo != null) {
            for (OptInfo obj : allOptInfos) {
                if (!obj.getTopOptId().equals(optInfo.getTopOptId())) continue;
                if (!obj.getOptName().equals("\u901a\u7528\u6a21\u5757") || !(tyOptId = obj.getOptId()).equals(optId)) continue;
                flag = false;
            }
        }
        if (flag) {
            tyFlows = this.flowDefineDao.listLastVersionFlowByOptId(tyOptId);
        }
        flows.addAll(tyFlows);
        if (CollectionUtils.sizeIsEmpty(flows)) {
            return flowDefineJsonArray;
        }
        Object[] flowCodes = flows.stream().map(FlowInfo::getFlowCode).toArray();
        JSONArray jsonArray = this.flowInstanceDao.countFlowInstances(CollectionsOpt.createHashMap((Object[])new Object[]{"flowCode", flowCodes}));
        flows.forEach(flowInfo -> flowDefineJsonArray.add((Object)this.combineFlowInstanceCount(jsonArray, (FlowInfo)flowInfo)));
        return flowDefineJsonArray;
    }

    private FlowInfo createFlowDefByJSON(String jsonDef, String flowCode, Long version, FlowDataDetail flowData, FlowInfo flow) {
        FlowInfo flowDef = (FlowInfo)JSON.parseObject((String)jsonDef, FlowInfo.class);
        flowDef.setCid(new FlowInfoId(version, flowCode));
        flowData.nodeTagToId.clear();
        flowData.transTagToId.clear();
        String startNodeId = null;
        if (StringUtils.isBlank((CharSequence)flow.getOptId())) {
            flow.setOptId(flow.getOptId());
        }
        if (StringUtils.isBlank((CharSequence)flow.getOsId())) {
            flow.setOsId(flow.getOsId());
        }
        for (NodeInfo node : flowDef.getNodeList()) {
            if ("A".equals(node.getNodeType())) {
                startNodeId = node.getNodeId();
            }
            String thisNodeId = UuidOpt.getUuidAsString32();
            flowData.nodeTagToId.put(node.getNodeId(), thisNodeId);
            node.setNodeId(thisNodeId);
            if (StringUtils.isBlank((CharSequence)node.getOptId())) {
                node.setOptId(flow.getOptId());
            }
            if (!StringUtils.isBlank((CharSequence)node.getOsId())) continue;
            node.setOsId(flow.getOsId());
        }
        for (FlowTransition tran : flowDef.getTransList()) {
            String fromNodeId = flowData.nodeTagToId.get(tran.getStartNodeId());
            String toNodeId = flowData.nodeTagToId.get(tran.getEndNodeId());
            if (StringUtils.equals((CharSequence)startNodeId, (CharSequence)tran.getStartNodeId())) {
                flowDef.setFirstNodeId(toNodeId);
            }
            tran.setStartNodeId(fromNodeId);
            tran.setEndNodeId(toNodeId);
            String thisTransId = UuidOpt.getUuidAsString32();
            flowData.transTagToId.put(tran.getTransId(), thisTransId);
            tran.setTransId(thisTransId);
        }
        return flowDef;
    }

    @Transactional
    public boolean saveDraftFlowDef(FlowInfo wfDef) {
        FlowInfo flowDef = (FlowInfo)this.flowDefineDao.getObjectById(new FlowInfoId(Long.valueOf(0L), wfDef.getFlowCode()));
        if (flowDef == null) {
            wfDef.setVersion(Long.valueOf(0L));
            wfDef.setFlowClass("R");
            wfDef.setFlowState("A");
            this.flowDefineDao.saveNewObject((Serializable)wfDef);
        } else {
            flowDef.copyNotNullProperty(wfDef);
            flowDef.setFlowState("A");
            this.flowDefineDao.updateObject((Serializable)flowDef);
        }
        return true;
    }

    @Transactional
    public boolean saveDraftFlowStage(FlowInfo wfDef) {
        FlowInfo flowDef = this.flowDefineDao.getFlowDefineByID(wfDef.getFlowCode(), 0L);
        if (flowDef == null) {
            return false;
        }
        flowDef.setFlowState("A");
        flowDef.setFlowClass("R");
        flowDef.replaceFlowStages((Collection)wfDef.getFlowStages());
        this.flowDefineDao.saveObjectReferences((Serializable)flowDef);
        return true;
    }

    @Transactional
    public boolean saveDraftFlowRole(FlowInfo wfDef) {
        FlowInfo flowDef = this.flowDefineDao.getFlowDefineByID(wfDef.getFlowCode(), 0L);
        if (flowDef == null) {
            return false;
        }
        flowDef.setFlowState("A");
        flowDef.setFlowClass("R");
        this.flowDefineDao.saveObjectReferences((Serializable)flowDef);
        return true;
    }

    @Transactional
    public boolean saveDraftFlowVariableDef(FlowInfo wfDef) {
        FlowInfo flowDef = this.flowDefineDao.getFlowDefineByID(wfDef.getFlowCode(), 0L);
        if (flowDef == null) {
            return false;
        }
        flowDef.setFlowState("A");
        flowDef.setFlowClass("R");
        this.flowDefineDao.saveObjectReferences((Serializable)flowDef);
        return true;
    }

    @Transactional
    public boolean saveDraftFlowDefJson(String flowCode, String flowDefXML) {
        FlowInfo flowDef = (FlowInfo)this.flowDefineDao.getObjectById(new FlowInfoId(Long.valueOf(0L), flowCode));
        if (flowDef == null) {
            flowDef = new FlowInfo();
            flowDef.setFlowCode(flowCode);
            flowDef.setFlowName(flowCode);
        }
        flowDef.setVersion(Long.valueOf(0L));
        flowDef.setFlowState("A");
        flowDef.setFlowClass("R");
        JSONObject flowAttr = JSONObject.parseObject((String)new String(flowDefXML)).getJSONObject("attr");
        if (flowAttr != null) {
            flowDef.setFlowName(flowAttr.getString("flowName"));
            flowDef.setFlowDesc(flowAttr.getString("flowDesc"));
            flowDef.setTimeLimit(flowAttr.getString("timeLimit"));
            flowDef.setExpireOpt(flowAttr.getString("expireOpt"));
        }
        flowDef.setFlowXmlDesc(flowDefXML);
        this.flowDefineDao.mergeObject((Serializable)flowDef);
        return true;
    }

    @Transactional
    public String getDraftFlowDefJson(String flowCode) {
        return this.getFlowDefXML(flowCode, 0L);
    }

    private void checkFlowDef(FlowInfo newFlowDef) {
        for (NodeInfo nd : newFlowDef.getNodeList()) {
            if ("S".equals(nd.getNodeType())) {
                if (!StringRegularOpt.isNvl((String)nd.getSubFlowCode())) continue;
                throw new ObjectException("\u5b50\u6d41\u7a0b\u8282\u70b9\uff1a" + nd.getNodeName() + ",\u6ca1\u6709\u6307\u5b9a\u6d41\u7a0b\u4ee3\u7801\u3002");
            }
            if ("C".equals(nd.getNodeType())) {
                if (StringRegularOpt.isNvl((String)nd.getOptCode())) {
                    throw new ObjectException("\u8282\u70b9\uff1a" + nd.getNodeName() + ",\u6ca1\u6709\u6307\u5b9a\u4e1a\u52a1\u64cd\u4f5c\u4ee3\u7801\u3002");
                }
                if (StringRegularOpt.isNvl((String)nd.getRoleType())) {
                    throw new ObjectException("\u8282\u70b9\uff1a" + nd.getNodeName() + ",\u6ca1\u6709\u6307\u5b9a\u89d2\u8272\u7c7b\u522b\u3002");
                }
                if ("EN".equalsIgnoreCase(nd.getRoleType())) {
                    if (!StringRegularOpt.isNvl((String)nd.getPowerExp())) continue;
                    throw new ObjectException("\u8282\u70b9\uff1a" + nd.getNodeName() + ",\u6743\u9650\u8868\u8fbe\u5f0f\u4e3a\u7a7a\u3002");
                }
                if (!StringRegularOpt.isNvl((String)nd.getRoleCode()) || "EN".equals(nd.getRoleType())) continue;
                throw new ObjectException("\u8282\u70b9\uff1a" + nd.getNodeName() + ",\u6ca1\u6709\u6307\u5b9a\u89d2\u8272\u4ee3\u7801\u3002");
            }
            if ("D".equals(nd.getNodeType())) {
                if (StringUtils.isBlank((CharSequence)nd.getUnitExp())) {
                    nd.setUnitExp("D(P)");
                }
                if (StringUtils.isBlank((CharSequence)nd.getRoleType())) {
                    nd.setRoleType("EN");
                    nd.setPowerExp("U(P)");
                }
                if ("C".equals(nd.getAutoRunType()) && StringRegularOpt.isNvl((String)nd.getOptCode())) {
                    throw new ObjectException("\u8282\u70b9\uff1a" + nd.getNodeName() + ",\u6ca1\u6709\u6307\u5b9a\u4e1a\u52a1\u64cd\u4f5c\u4ee3\u7801\u3002");
                }
                if ("B".equals(nd.getAutoRunType()) && StringRegularOpt.isNvl((String)nd.getOptBean())) {
                    throw new ObjectException("\u81ea\u52a8\u8fd0\u884c\u8282\u70b9\uff1a" + nd.getNodeName() + ",\u6ca1\u6709\u8fd0\u884c\u7684bean\u3002");
                }
                if (!"S".equals(nd.getAutoRunType()) || !StringRegularOpt.isNvl((String)nd.getOptParam())) continue;
                throw new ObjectException("\u81ea\u52a8\u8fd0\u884c\u8282\u70b9\uff1a" + nd.getNodeName() + ",\u6ca1\u6709\u8fd0\u884c\u7684script\u3002");
            }
            if (!"R".equals(nd.getNodeType()) || !StringRegularOpt.isNvl((String)nd.getRouterType())) continue;
            throw new ObjectException("\u8def\u7531\u8282\u70b9\uff1a" + nd.getNodeName() + ",\u6ca1\u6709\u6307\u5b9a\u8def\u7531\u7c7b\u578b\u3002");
        }
        for (FlowTransition tran : newFlowDef.getTransList()) {
            NodeInfo nd;
            if (!StringUtils.isBlank((CharSequence)tran.getTransCondition()) || (nd = newFlowDef.getFlowNodeById(tran.getStartNodeId())) == null || !"R".equals(nd.getNodeType()) || !"D".equals(nd.getRouterType()) && !"H".equals(nd.getRouterType())) continue;
            throw new ObjectException("\u6d41\u8f6c\uff1a" + tran.getTransName() + ",\u6ca1\u6709\u6307\u5b9a\u6d41\u8f6c\u6761\u4ef6\u3002");
        }
    }

    @Transactional
    public long publishFlowDef(String flowCode) {
        FlowInfo oldflowDef;
        FlowInfo flowDef = (FlowInfo)this.flowDefineDao.getObjectWithReferences(new FlowInfoId(Long.valueOf(0L), flowCode));
        if (flowDef == null) {
            return 0L;
        }
        String wfDefXML = flowDef.getFlowXmlDesc();
        if (StringUtils.isBlank((CharSequence)wfDefXML)) {
            throw new ObjectException("\u6d41\u7a0b\u6ca1\u6709\u5185\u5bb9");
        }
        long nCurVersion = this.flowDefineDao.getLastVersion(flowDef.getFlowCode());
        Long newVersion = nCurVersion + 1L;
        FlowDataDetail flowData = new FlowDataDetail();
        FlowInfo newFlowDef = this.createFlowDefByJSON(flowDef.getFlowXmlDesc(), flowDef.getFlowCode(), newVersion, flowData, flowDef);
        this.checkFlowDef(newFlowDef);
        List newStages = flowDef.getFlowStages();
        for (FlowStage p : newStages) {
            if (p == null) continue;
            p.setStageId(UuidOpt.getUuidAsString32());
            p.setVersion(newVersion);
        }
        newFlowDef.setFlowStages(newStages);
        this.resetNodeTransIdToJSON(flowDef.getFlowXmlDesc(), newFlowDef, flowData);
        newFlowDef.setFlowDesc(flowDef.getFlowDesc());
        newFlowDef.setFlowName(flowDef.getFlowName());
        newFlowDef.setFlowClass(flowDef.getFlowClass());
        newFlowDef.setOptId(flowDef.getOptId());
        newFlowDef.setTimeLimit(flowDef.getTimeLimit());
        newFlowDef.setExpireOpt(flowDef.getExpireOpt());
        newFlowDef.setFlowPublishDate(DatetimeOpt.currentUtilDate());
        newFlowDef.setFlowState("B");
        newFlowDef.setOsId(flowDef.getOsId());
        this.flowDefineDao.saveNewObject((Serializable)newFlowDef);
        this.flowDefineDao.saveObjectReferences((Serializable)newFlowDef);
        flowDef.setFlowState("E");
        this.flowDefineDao.updateObject((Serializable)flowDef);
        if (nCurVersion > 0L && (oldflowDef = (FlowInfo)this.flowDefineDao.getObjectById(new FlowInfoId(Long.valueOf(nCurVersion), flowDef.getFlowCode()))) != null) {
            oldflowDef.setFlowState("C");
            this.flowDefineDao.updateObject((Serializable)oldflowDef);
        }
        return newVersion;
    }

    private void resetNodeTransIdToJSON(String xmlDefineDesc, FlowInfo newFlowDef, FlowDataDetail flowData) {
        JSONObject defJson = JSON.parseObject((String)xmlDefineDesc);
        JSONArray nodes = defJson.getJSONArray("nodeList");
        for (Object nodeObj : nodes) {
            String nodeId = ((JSONObject)nodeObj).getString("nodeId");
            ((JSONObject)nodeObj).put((Object)"nodeId", (Object)flowData.nodeTagToId.get(nodeId));
        }
        JSONArray trans = defJson.getJSONArray("transList");
        for (Object tranObj : trans) {
            JSONObject transJson = (JSONObject)tranObj;
            String transId = transJson.getString("transId");
            transJson.put((Object)"transId", (Object)flowData.transTagToId.get(transId));
            String startNodeId = transJson.getString("startNodeId");
            transJson.put((Object)"startNodeId", (Object)flowData.nodeTagToId.get(startNodeId));
            String endNodeId = transJson.getString("endNodeId");
            transJson.put((Object)"endNodeId", (Object)flowData.nodeTagToId.get(endNodeId));
        }
        newFlowDef.setFlowXmlDesc(defJson.toJSONString(new JSONWriter.Feature[0]));
    }

    @Transactional
    public FlowInfo getFlowInfo(String flowCode, long version) {
        try {
            return (FlowInfo)this.flowDefineDao.getObjectWithReferences(new FlowInfoId(Long.valueOf(version), flowCode));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Transactional
    public FlowInfo getFlowInfo(String flowCode) {
        long version = this.flowDefineDao.getLastVersion(flowCode);
        return this.getFlowInfo(flowCode, version);
    }

    @Transactional
    public NodeInfo getNodeInfoById(String nodeId) {
        return (NodeInfo)this.flowNodeDao.getObjectById(nodeId);
    }

    @Transactional
    public String getFlowDefXML(String flowCode, long version) {
        FlowInfo flowDef = (FlowInfo)this.flowDefineDao.getObjectById(new FlowInfoId(Long.valueOf(version), flowCode));
        if (flowDef == null) {
            return "";
        }
        return flowDef.getFlowXmlDesc();
    }

    @Transactional
    public String getFlowDefXML(String flowCode) {
        long nCurVersion = this.flowDefineDao.getLastVersion(flowCode);
        if (nCurVersion == 0L) {
            return null;
        }
        return this.getFlowDefXML(flowCode, nCurVersion);
    }

    @Transactional
    public void disableFlow(String flowCode) {
        FlowInfo flowDef = this.flowDefineDao.getLastVersionFlowByCode(flowCode);
        flowDef.setFlowState("D");
        this.flowDefineDao.updateObject((Serializable)flowDef);
    }

    @Transactional
    public void enableFlow(String flowCode) {
        FlowInfo flowDef = this.flowDefineDao.getLastVersionFlowByCode(flowCode);
        flowDef.setFlowState("B");
        this.flowDefineDao.updateObject((Serializable)flowDef);
    }

    @Transactional
    public List<FlowInfo> listFlowsByCode(String wfCode, PageDesc pageDesc) {
        ArrayList flows = this.flowDefineDao.getAllVersionFlowsByCode(wfCode, pageDesc);
        return new ArrayList<FlowInfo>(flows == null ? new ArrayList() : flows);
    }

    @Transactional
    public List<FlowInfo> listLastVersionFlow(Map<String, Object> filterMap, PageDesc pageDesc) {
        List<FlowInfo> flows = this.flowDefineDao.listLastVersionFlows(filterMap, pageDesc);
        for (FlowInfo def : flows) {
            FlowInfo wfDef = (FlowInfo)this.flowDefineDao.getObjectById(new FlowInfoId(Long.valueOf(0L), def.getFlowCode()));
            if (wfDef == null) continue;
            def.setFlowState(wfDef.getFlowState());
        }
        return flows;
    }

    @Transactional
    public Set<String> getUnitExp(String flowCode, Long version) {
        return this.flowNodeDao.getUnitExp(flowCode, version);
    }

    @Transactional
    public void deleteFlowDef(String flowCode) {
        this.flowDefineDao.deleteObjectByFlowCode(flowCode);
    }

    public Map<String, String> listAllOptType() {
        HashMap<String, String> optType = new HashMap<String, String>();
        optType.put("A", "\u4e00\u822c");
        optType.put("B", "\u62a2\u5148\u673a\u5236");
        optType.put("C", "\u591a\u4eba\u64cd\u4f5c");
        optType.put("D", "\u81ea\u52a8\u6267\u884c");
        optType.put("S", "\u5b50\u6d41\u7a0b");
        return optType;
    }

    public Map<String, String> listAllNoteType() {
        HashMap<String, String> nodeType = new HashMap<String, String>();
        nodeType.put("A", "\u5f00\u59cb");
        nodeType.put("C", "\u4e1a\u52a1");
        nodeType.put("R", "\u8def\u7531");
        nodeType.put("F", "\u7ed3\u675f");
        return nodeType;
    }

    public Map<String, String> listRoleType() {
        HashMap<String, String> roleTypes = new HashMap<String, String>();
        roleTypes.put("GW", "\u5c97\u4f4d\u804c\u8d23");
        roleTypes.put("XZ", "\u884c\u653f\u804c\u4f4d");
        roleTypes.put("BJ", "\u529e\u4ef6\u89d2\u8272");
        roleTypes.put("RO", "\u7cfb\u7edf\u89d2\u8272");
        roleTypes.put("EN", "\u6743\u9650\u5f15\u64ce");
        roleTypes.put("SF", "\u5df2\u5b9a\u4e49\u8868\u8fbe\u5f0f");
        return roleTypes;
    }

    public Map<String, Map<String, String>> listAllRole(String topUnit) {
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(topUnit);
        HashMap<String, Map<String, String>> roleList = new HashMap<String, Map<String, String>>();
        roleList.put("GW", context.listAllStation());
        roleList.put("XZ", context.listAllRank());
        roleList.put("RO", context.listAllSystemRole());
        roleList.put("SF", this.flowRoleDao.listAllRoleMsg());
        return roleList;
    }

    public Map<String, String> listRoleByType(String stype, String topUnit) {
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(topUnit);
        if ("GW".equalsIgnoreCase(stype)) {
            return context.listAllStation();
        }
        if ("XZ".equalsIgnoreCase(stype)) {
            return context.listAllRank();
        }
        if ("RO".equalsIgnoreCase(stype)) {
            return context.listAllSystemRole();
        }
        if ("SF".equalsIgnoreCase(stype)) {
            return this.flowRoleDao.listAllRoleMsg();
        }
        return null;
    }

    public Map<String, String> listInsideUnitExp() {
        HashMap<String, String> optType = new HashMap<String, String>();
        optType.put("D(P)", "\u540c\u4e0a\u4e00\u4e2a\u8282\u70b9");
        optType.put("D(F)", "\u540c\u6d41\u7a0b");
        optType.put("D(C)", "\u7528\u6237\u7684\u673a\u6784");
        optType.put("D(cursor)", "\u591a\u5b9e\u4f8b\u6e38\u6807");
        optType.put("S(D(L),D(U))", "\u9ed8\u8ba4\u7528\u4e0a\u4e00\u4e2a\u526f\u672c\u673a\u6784");
        return optType;
    }

    @Transactional
    public Map<String, String> listAllSubFlow() {
        HashMap<String, String> subwf = new HashMap<String, String>();
        List<FlowInfo> listflow = this.flowDefineDao.getFlowsByState("B");
        for (FlowInfo wfFlowDefine : listflow) {
            subwf.put(wfFlowDefine.getFlowCode(), wfFlowDefine.getFlowName());
        }
        return subwf;
    }

    @Transactional
    public Long getFlowLastVersion(String flowCode) {
        return this.flowDefineDao.getLastVersion(flowCode);
    }

    @Transactional
    public Map<String, String> listFlowItemRoles(String flowCode, Long version) {
        if (version == null || version < 0L) {
            version = this.flowDefineDao.getLastVersion(flowCode);
        }
        return this.optTeamRoleDao.getRoleByFlowCode(flowCode, version);
    }

    @Transactional
    public OptTeamRole getFlowItemRole(String flowCode, Long version, String roleCode) {
        return this.optTeamRoleDao.getItemRole(flowCode, version, roleCode);
    }

    @Transactional
    public Map<String, String> listFlowStages(String flowCode, Long version) {
        if (version == null || version < 0L) {
            version = this.flowDefineDao.getLastVersion(flowCode);
        }
        FlowInfo flowDef = this.flowDefineDao.getFlowDefineByID(flowCode, version);
        this.flowDefineDao.fetchObjectReference((Serializable)flowDef, "flowStages");
        if (flowDef == null) {
            flowDef = new FlowInfo();
        }
        List stageSet = flowDef.getFlowStages();
        HashMap<String, String> optmap = new HashMap<String, String>();
        if (stageSet != null && !stageSet.isEmpty()) {
            for (FlowStage stage : stageSet) {
                optmap.put(stage.getStageCode(), stage.getStageName());
            }
        }
        return optmap;
    }

    private List<OptVariableDefine> listOptVariables(String flowCode, Long version) {
        if (version == null || version < 0L) {
            version = this.flowDefineDao.getLastVersion(flowCode);
        }
        return this.optVariableDefineDao.listOptVariableByFlowCode(flowCode, version);
    }

    @Transactional
    public Map<String, String> listFlowVariableDefines(String flowCode, Long version) {
        List<OptVariableDefine> optVariableDefines = this.listOptVariables(flowCode, version);
        HashMap<String, String> variableDefineMap = new HashMap<String, String>();
        if (optVariableDefines != null) {
            for (OptVariableDefine optVariableDefine : optVariableDefines) {
                variableDefineMap.put(optVariableDefine.getVariableName(), optVariableDefine.getVariableDesc());
            }
        }
        return variableDefineMap;
    }

    @Transactional
    public Map<String, String> listFlowDefaultVariables(String flowCode, Long version) {
        List<OptVariableDefine> optVariableDefines = this.listOptVariables(flowCode, version);
        HashMap<String, String> variableValueMap = new HashMap<String, String>();
        if (optVariableDefines != null) {
            for (OptVariableDefine optVariableDefine : optVariableDefines) {
                if (!StringUtils.isNotBlank((CharSequence)optVariableDefine.getDefaultValue())) continue;
                variableValueMap.put(optVariableDefine.getVariableName(), optVariableDefine.getDefaultValue());
            }
        }
        return variableValueMap;
    }

    @Transactional
    public Map<String, String> listOptItemRoles(String optId) {
        return this.optTeamRoleDao.getRoleByOptId(optId);
    }

    @Transactional
    public OptTeamRole getOptItemRole(String optId, String roleCode) {
        return this.optTeamRoleDao.getItemRole(optId, roleCode);
    }

    @Transactional
    public Map<String, String> listOptVariableDefines(String optId) {
        List<OptVariableDefine> optVariableDefines = this.optVariableDefineDao.listOptVariableByOptId(optId);
        HashMap<String, String> variableDefineMap = new HashMap<String, String>();
        if (optVariableDefines != null) {
            for (OptVariableDefine optVariableDefine : optVariableDefines) {
                variableDefineMap.put(optVariableDefine.getVariableName(), optVariableDefine.getVariableDesc());
            }
        }
        return variableDefineMap;
    }

    @Transactional
    public Map<String, String> listOptDefaultVariables(String optId) {
        List<OptVariableDefine> optVariableDefines = this.optVariableDefineDao.listOptVariableByOptId(optId);
        HashMap<String, String> variableValueMap = new HashMap<String, String>();
        if (optVariableDefines != null) {
            for (OptVariableDefine optVariableDefine : optVariableDefines) {
                if (!StringUtils.isNotBlank((CharSequence)optVariableDefine.getDefaultValue())) continue;
                variableValueMap.put(optVariableDefine.getVariableName(), optVariableDefine.getDefaultValue());
            }
        }
        return variableValueMap;
    }

    @Transactional
    public void deleteFlowStageById(String stageId) {
        this.flowStageDao.deleteObjectById(stageId);
    }

    public void saveFlowStage(FlowStage flowStage) {
        if (flowStage.getFlowCode() == null) {
            return;
        }
        if (flowStage.getVersion() == null) {
            flowStage.setVersion(Long.valueOf(0L));
        }
        if (flowStage.getStageId() == null) {
            HashMap<String, String> filterMap = new HashMap<String, String>();
            filterMap.put("flowCode", flowStage.getFlowCode());
            filterMap.put("stageCode", flowStage.getStageCode());
            FlowStage stage = (FlowStage)this.flowStageDao.getObjectByProperties(filterMap);
            if (stage != null) {
                flowStage.setStageId(stage.getStageId());
            }
        }
        this.flowStageDao.mergeObject((Serializable)flowStage);
        FlowInfo flowDef = this.flowDefineDao.getFlowDefineByID(flowStage.getFlowCode(), 0L);
        if (flowDef == null) {
            return;
        }
        if (!"A".equals(flowDef.getFlowState())) {
            flowDef.setFlowState("A");
            flowDef.setFlowClass("R");
            this.flowDefineDao.updateObject((Serializable)flowDef);
        }
    }

    @Transactional
    public int[] batchUpdateOptId(final String optId, final List<String> flowCodes) {
        String sql = "UPDATE wf_flow_define SET OPT_ID=? , FLOW_STATE = 'B' WHERE flow_code = ? ";
        return this.flowDefineDao.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                ps.setString(1, optId);
                ps.setString(2, (String)flowCodes.get(i));
            }

            public int getBatchSize() {
                return flowCodes.size();
            }
        });
    }

    @Transactional
    public String copyWorkFlow(Map<String, Object> parameters) {
        String flowCode = MapUtils.getString(parameters, (Object)"flowCode");
        Long version = MapUtils.getLong(parameters, (Object)"version", (Long)0L);
        String flowName = MapUtils.getString(parameters, (Object)"flowName");
        FlowInfo flowInfo = (FlowInfo)this.flowDefineDao.getObjectById(new FlowInfoId(version, flowCode));
        if (null == flowInfo) {
            return null;
        }
        flowInfo.setFlowCode(UuidOpt.getUuidAsString32());
        flowInfo.setVersion(Long.valueOf(0L));
        flowInfo.setFlowName(flowName);
        this.flowDefineDao.saveNewObject((Serializable)flowInfo);
        return flowInfo.getFlowCode();
    }

    public void deleteByCodes(List<String> flowCodes) {
        for (String flowCode : flowCodes) {
            this.deleteFlowDef(flowCode);
        }
    }

    public void clearRecycle(String osId) {
        List<FlowInfo> list = this.flowDefineDao.getFlowsByOsId(osId, "D");
        if (list != null && list.size() > 0) {
            for (FlowInfo flowInfo : list) {
                this.deleteFlowDef(flowInfo.getFlowCode());
            }
        }
    }

    private JSONObject combineFlowInstanceCount(JSONArray jsonArray, FlowInfo flowInfo) {
        String flowCode = flowInfo.getFlowCode();
        JSONObject flowInfoJsonObject = JSON.parseObject((String)JSON.toJSONString((Object)flowInfo));
        for (Object o : jsonArray) {
            JSONObject jsonObject = (JSONObject)o;
            if (!flowCode.equals(jsonObject.getString("flowCode"))) continue;
            flowInfoJsonObject.put((Object)"nodeInstCount", (Object)jsonObject.getLongValue("count"));
            return flowInfoJsonObject;
        }
        flowInfoJsonObject.put((Object)"nodeInstCount", (Object)0L);
        return flowInfoJsonObject;
    }

    private class FlowDataDetail {
        public Map<String, String> nodeTagToId = new HashMap<String, String>();
        public Map<String, String> transTagToId = new HashMap<String, String>();
    }
}

