/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.dde.adapter.DdeDubboTaskRun;
import com.centit.framework.common.ResponseData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.components.SysUserFilterEngine;
import com.centit.framework.components.impl.ObjectUserUnitVariableTranslate;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.adapter.UserUnitFilterCalcContext;
import com.centit.framework.model.adapter.UserUnitFilterCalcContextFactory;
import com.centit.framework.model.adapter.UserUnitVariableTranslate;
import com.centit.framework.model.basedata.NoticeMessage;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.framework.model.basedata.UserUnit;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.common.ObjectException;
import com.centit.support.common.WorkTimeSpan;
import com.centit.support.compiler.Pretreatment;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.commons.CreateFlowOptions;
import com.centit.workflow.commons.FlowOptParamOptions;
import com.centit.workflow.commons.NodeEventSupport;
import com.centit.workflow.commons.SubmitOptOptions;
import com.centit.workflow.commons.WorkflowException;
import com.centit.workflow.dao.FlowInfoDao;
import com.centit.workflow.dao.FlowInstanceDao;
import com.centit.workflow.dao.FlowInstanceGroupDao;
import com.centit.workflow.dao.FlowOrganizeDao;
import com.centit.workflow.dao.FlowTransitionDao;
import com.centit.workflow.dao.FlowVariableDao;
import com.centit.workflow.dao.FlowWarningDao;
import com.centit.workflow.dao.FlowWorkTeamDao;
import com.centit.workflow.dao.NodeInfoDao;
import com.centit.workflow.dao.NodeInstanceDao;
import com.centit.workflow.dao.RoleFormulaDao;
import com.centit.workflow.dao.RoleRelegateDao;
import com.centit.workflow.dao.StageInstanceDao;
import com.centit.workflow.dao.UserTaskListDao;
import com.centit.workflow.po.FlowEventInfo;
import com.centit.workflow.po.FlowInfo;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.FlowInstanceGroup;
import com.centit.workflow.po.FlowOrganize;
import com.centit.workflow.po.FlowOrganizeId;
import com.centit.workflow.po.FlowTransition;
import com.centit.workflow.po.FlowVariable;
import com.centit.workflow.po.FlowVariableId;
import com.centit.workflow.po.FlowWarning;
import com.centit.workflow.po.FlowWorkTeam;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.po.RoleFormula;
import com.centit.workflow.po.StageInstance;
import com.centit.workflow.po.UserTask;
import com.centit.workflow.service.FlowEngine;
import com.centit.workflow.service.FlowEventService;
import com.centit.workflow.service.FlowManager;
import com.centit.workflow.service.FlowScriptRunTime;
import com.centit.workflow.service.impl.FlowOptUtils;
import com.centit.workflow.service.impl.FlowVariableTranslate;
import com.centit.workflow.service.impl.NodeEventSupportFactory;
import com.centit.workflow.service.impl.UserUnitCalcEngine;
import com.centit.workflow.support.CallApiNodeEventSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowEngineImpl
implements FlowEngine,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FlowEngineImpl.class);
    public static final String NODE_INST_ZERO = "0";
    @Autowired
    private FlowScriptRunTime flowScriptRunTime;
    @Autowired
    private FlowInstanceDao flowInstanceDao;
    @Autowired
    private UserUnitFilterCalcContextFactory userUnitFilterFactory;
    @Autowired
    private NodeInstanceDao nodeInstanceDao;
    @Autowired
    private NodeInfoDao flowNodeDao;
    @Autowired
    private FlowTransitionDao flowTransitionDao;
    @Autowired
    private RoleRelegateDao roleRelegateDao;
    @Autowired
    private UserTaskListDao userTaskListDao;
    @Autowired
    private FlowInfoDao flowDefDao;
    @Autowired
    private FlowManager flowManager;
    @Autowired
    private FlowWorkTeamDao flowTeamDao;
    @Autowired
    private RoleFormulaDao roleFormulaDao;
    @Autowired
    private FlowOrganizeDao flowOrganizeDao;
    @Autowired
    private FlowVariableDao flowVariableDao;
    @Autowired
    private FlowWarningDao runtimeWarningDao;
    @Autowired
    private FlowInstanceGroupDao flowInstanceGroupDao;
    @Autowired
    private NotificationCenter notificationCenter;
    @Autowired
    private FlowEventService flowEventService;
    @Autowired
    private StageInstanceDao stageInstanceDao;
    @Autowired
    private DdeDubboTaskRun ddeDubboTaskRun;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    private void saveValueAndRoleInOptions(String flowInstId, String runToken, FlowOptParamOptions options) {
        if (options.getVariables() != null && !options.getVariables().isEmpty()) {
            for (Map.Entry ent : options.getVariables().entrySet()) {
                this.saveFlowNodeVariable(flowInstId, runToken, (String)ent.getKey(), ent.getValue());
            }
        }
        if (options.getGlobalVariables() != null && !options.getGlobalVariables().isEmpty()) {
            for (Map.Entry ent : options.getGlobalVariables().entrySet()) {
                this.saveFlowVariable(flowInstId, (String)ent.getKey(), ent.getValue());
            }
        }
        if (options.getFlowRoleUsers() != null && !options.getFlowRoleUsers().isEmpty()) {
            for (Map.Entry ent : options.getFlowRoleUsers().entrySet()) {
                this.assignFlowWorkTeam(flowInstId, (String)ent.getKey(), runToken, (List)ent.getValue());
            }
        }
        if (options.getFlowOrganizes() != null && !options.getFlowOrganizes().isEmpty()) {
            for (Map.Entry ent : options.getFlowOrganizes().entrySet()) {
                this.assignFlowOrganize(flowInstId, (String)ent.getKey(), (List)ent.getValue());
            }
        }
    }

    public FlowInstance createInstance(CreateFlowOptions options, UserUnitVariableTranslate varTrans, ServletContext application) {
        this.fetchTopUnit((FlowOptParamOptions)options);
        HashMap<String, String> conditions = new HashMap<String, String>(8);
        conditions.put("flowCode", options.getFlowCode());
        conditions.put("instState", "N");
        boolean hasCondition = false;
        if (StringUtils.isNotBlank((CharSequence)options.getFlowInstId())) {
            conditions.put("flowInstId", options.getFlowInstId());
            hasCondition = true;
        }
        if (StringUtils.isNotBlank((CharSequence)options.getModelId())) {
            conditions.put("optId", options.getModelId());
        }
        if (StringUtils.isNotBlank((CharSequence)options.getFlowOptTag())) {
            conditions.put("flowOptTag", options.getFlowOptTag());
            hasCondition = true;
        }
        FlowInstance instance = null;
        if (hasCondition) {
            instance = (FlowInstance)this.flowInstanceDao.getObjectByProperties(conditions);
        }
        if (instance == null) {
            instance = this.createInstanceInside(options, varTrans, application);
        }
        return instance;
    }

    private void fetchTopUnit(FlowOptParamOptions options) {
        UnitInfo ui;
        if (StringUtils.isBlank((CharSequence)options.getTopUnit()) && StringUtils.isNotBlank((CharSequence)options.getUnitCode()) && (ui = this.platformEnvironment.loadUnitInfo(options.getUnitCode())) != null) {
            options.setTopUnit(ui.getTopUnit());
        }
    }

    public FlowInstance createInstance(CreateFlowOptions options) {
        return this.createInstance(options, (UserUnitVariableTranslate)new ObjectUserUnitVariableTranslate((Object)CollectionsOpt.unionTwoMap((Map)options.getVariables(), (Map)options.getGlobalVariables())), null);
    }

    private FlowInstance createInstanceInside(CreateFlowOptions options, UserUnitVariableTranslate varTrans, ServletContext application) {
        OsInfo iOsInfo;
        Date createTime = new Date(System.currentTimeMillis());
        if (options.getFlowVersion() < 1L) {
            options.version(this.flowDefDao.getLastVersion(options.getFlowCode()));
        }
        FlowInfo wf = this.flowDefDao.getFlowDefineByID(options.getFlowCode(), options.getFlowVersion());
        if (StringUtils.isBlank((CharSequence)options.getTopUnit()) && (iOsInfo = this.platformEnvironment.getOsInfo(wf.getOsId())) != null) {
            options.setTopUnit(iOsInfo.getTopUnit());
        }
        String flowInstId = StringUtils.isBlank((CharSequence)options.getFlowInstId()) ? UuidOpt.getUuidAsString32() : options.getFlowInstId();
        FlowInstance flowInst = FlowOptUtils.createFlowInst(options.getTopUnit(), options.getUnitCode(), options.getUserCode(), wf, flowInstId, options.getTimeLimitStr());
        if (options.getModelId() != null) {
            flowInst.setOptId(options.getModelId());
        }
        flowInst.setCreateTime(createTime);
        flowInst.setFlowGroupId(options.getFlowGroupId());
        if (StringUtils.isNotBlank((CharSequence)options.getParentNodeInstId())) {
            flowInst.setPreNodeInstId(options.getParentNodeInstId());
            flowInst.setPreInstId(options.getParentFlowInstId());
            FlowInstance parentInst = (FlowInstance)this.flowInstanceDao.getObjectById(options.getParentFlowInstId());
            if (StringUtils.isBlank((CharSequence)options.getFlowGroupId()) && parentInst != null && StringUtils.isNotBlank((CharSequence)parentInst.getFlowGroupId())) {
                flowInst.setFlowGroupId(parentInst.getFlowGroupId());
            }
            flowInst.setIsSubInst(Boolean.valueOf(true));
        }
        flowInst.setFlowOptName(options.getFlowOptName());
        flowInst.setFlowOptTag(options.getFlowOptTag());
        this.flowInstanceDao.saveNewObject((Serializable)flowInst);
        for (StageInstance flowStageInstance : flowInst.getFlowStageInstances()) {
            this.stageInstanceDao.saveNewObject((Serializable)flowStageInstance);
        }
        this.saveValueAndRoleInOptions(flowInstId, "T", (FlowOptParamOptions)options);
        NodeInfo node = wf.getFirstNode();
        if (node == null) {
            throw new WorkflowException(653, "\u627e\u4e0d\u5230\u9996\u8282\u70b9");
        }
        FlowVariableTranslate flowVarTrans = FlowOptUtils.createVariableTranslate(null, flowInst, this.flowVariableDao, this, (FlowOptParamOptions)options);
        flowVarTrans.setFlowVarTrans(varTrans);
        List<String> nodeInsts = this.submitToNextNode(node, "T", flowInst, wf, null, null, null, (FlowOptParamOptions)options, flowVarTrans, application);
        if (options.isSkipFirstNode() && !"R".equals(node.getNodeType()) && nodeInsts.size() == 1) {
            nodeInsts = this.submitOptInside(SubmitOptOptions.create().copy((FlowOptParamOptions)options).nodeInst(nodeInsts.iterator().next()), varTrans, application, false, false, options.isSkipFirstNode());
        }
        OperationLogCenter.log((OperationLog)FlowOptUtils.createActionLog(options.getUserCode(), flowInstId, "\u521b\u5efa\u6d41\u7a0b\uff0c\u521b\u5efa\u9996\u8282\u70b9:" + StringBaseOpt.castObjectToString(nodeInsts)));
        return flowInst;
    }

    public FlowInstance getFlowInstById(String flowInstId) {
        return (FlowInstance)this.flowInstanceDao.getObjectWithReferences(flowInstId);
    }

    public FlowInfo getFlowDefine(String flowInstId) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (flowInst == null) {
            return null;
        }
        return this.flowDefDao.getFlowDefineByID(flowInst.getFlowCode(), flowInst.getVersion());
    }

    public NodeInstance getNodeInstById(String nodeInstId) {
        return (NodeInstance)this.nodeInstanceDao.getObjectWithReferences(nodeInstId);
    }

    public NodeInfo getNodeInfo(String nodeInstId) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return null;
        }
        return (NodeInfo)this.flowNodeDao.getObjectById(nodeInst.getNodeId());
    }

    public List<FlowInstance> listAllFlowInstByOptTag(String flowOptTag) {
        return this.flowInstanceDao.listAllFlowInstByOptTag(flowOptTag);
    }

    public void updateFlowInstOptInfo(String flowInstId, String flowOptName, String flowOptTag) {
        this.flowInstanceDao.updateFlowInstOptInfo(flowInstId, flowOptName, flowOptTag);
    }

    public void updateNodeInstanceParam(String nodeInstId, String nodeParam) {
        this.nodeInstanceDao.updtNodeInstParam(nodeInstId, nodeParam);
    }

    public void lockNodeTask(String nodeInstId, String userCode) {
        NodeInfo node;
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (!"S".equals(nodeInst.getTaskAssigned()) && "B".equals((node = (NodeInfo)this.flowNodeDao.getObjectById(nodeInst.getNodeId())).getOptRunType())) {
            nodeInst.setUserCode(userCode);
            nodeInst.setTaskAssigned("S");
            this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        }
    }

    public void updateFlowInstParentNode(String flowInstId, String parentFlowInstId, String parentNodeInstId) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (flowInst == null) {
            return;
        }
        flowInst.setPreInstId(parentFlowInstId);
        flowInst.setPreNodeInstId(parentNodeInstId);
        this.flowInstanceDao.updateObject((Serializable)flowInst);
    }

    public String getNodeOptUrl(String nodeInstId, String userCode) {
        UserTask task = this.userTaskListDao.getNodeTaskInfo(nodeInstId);
        if (task == null) {
            return null;
        }
        return task.getNodeOptUrl();
    }

    public Map<String, String> listFlowNodeForCreate(String flowInstId) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (flowInst == null) {
            return null;
        }
        List nodeList = this.flowNodeDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"flowCode", flowInst.getFlowCode(), "version", flowInst.getVersion()}));
        HashMap<String, String> nodes = new HashMap<String, String>();
        for (NodeInfo node : nodeList) {
            if (!StringUtils.isNotBlank((CharSequence)node.getNodeCode())) continue;
            nodes.put(node.getNodeCode(), node.getNodeName());
        }
        return nodes;
    }

    public List<NodeInstance> listNodeInstanceByNodeCode(String flowInstId, String nodeCode) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (flowInst == null) {
            return null;
        }
        List<NodeInfo> nodeList = this.flowNodeDao.listNodeByNodecode(flowInst.getFlowCode(), flowInst.getVersion(), nodeCode);
        if (nodeList == null) {
            return null;
        }
        ArrayList<NodeInstance> nodeInstList = new ArrayList<NodeInstance>();
        for (NodeInfo node : nodeList) {
            nodeInstList.addAll(flowInst.getAllNodeInstancesByNodeid(node.getNodeId()));
        }
        return nodeInstList;
    }

    public StageInstance getStageInstByNodeInstId(String nodeInstId) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return null;
        }
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(nodeInst.getFlowInstId());
        if (flowInst == null) {
            return null;
        }
        NodeInfo nodeinfo = (NodeInfo)this.flowNodeDao.getObjectById(nodeInst.getNodeId());
        if (nodeinfo == null) {
            return null;
        }
        return flowInst.getStageInstanceByCode(nodeinfo.getStageCode());
    }

    private void endFlowInstance(FlowInstance flowInst, FlowInfo flowInfo, NodeInfo endNode, String transPath, FlowTransition trans, String preNodeInstId, String userCode, String unitCode, FlowVariableTranslate varTrans) {
        FlowOptUtils.endInstance(flowInst, "C", userCode, this.flowInstanceDao);
        NodeInstance endNodeInst = FlowOptUtils.createNodeInst(unitCode, userCode, flowInst, null, flowInfo, endNode, trans, varTrans);
        endNodeInst.setNodeInstId(UuidOpt.getUuidAsString32());
        endNodeInst.setNodeState("C");
        Date updateTime = DatetimeOpt.currentUtilDate();
        endNodeInst.setUserCode(userCode);
        endNodeInst.setLastUpdateTime(updateTime);
        endNodeInst.setLastUpdateUser(userCode);
        endNodeInst.setPrevNodeInstId(preNodeInstId);
        if (trans != null) {
            if (StringUtils.isBlank((CharSequence)transPath)) {
                endNodeInst.setTransPath(trans.getTransId());
            } else {
                endNodeInst.setTransPath(transPath + "," + trans.getTransId());
            }
        } else {
            endNodeInst.setTransPath(transPath);
        }
        this.nodeInstanceDao.saveNewObject((Serializable)endNodeInst);
    }

    private UserUnitFilterCalcContext createCalcUserUnitContext(FlowInstance flowInst, NodeInstance preNodeInst, String nodeToken, NodeInfo nextOptNode, FlowOptParamOptions options, FlowVariableTranslate varTrans) {
        UserInfo ui;
        NodeInstance preNode;
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(options.getTopUnit());
        context.setVarTrans((UserUnitVariableTranslate)varTrans);
        NodeInstance oldNodeInst = flowInst.findLastCompletedNodeInst(nextOptNode.getNodeId(), preNodeInst);
        if (oldNodeInst != null) {
            context.addUnitParam("L", oldNodeInst.getUnitCode());
            context.addUserParam("L", oldNodeInst.getLastUpdateUser());
        }
        if ((preNode = flowInst.getNearestNode(preNodeInst, nodeToken)) != null) {
            context.addUnitParam("P", preNode.getUnitCode());
            context.addUserParam("P", preNode.getUserCode());
        }
        String currUnitCode = options.getUnitCode();
        if (options.getUnitCode() == null && options.getUserCode() != null && (ui = context.getUserInfoByCode(options.getUserCode())) != null) {
            currUnitCode = ui.getPrimaryUnit();
        }
        context.addUnitParam("C", currUnitCode);
        context.addUserParam("C", StringUtils.isBlank((CharSequence)options.getUserCode()) ? preNodeInst.getUserCode() : options.getUserCode());
        context.addUnitParam("F", flowInst.getUnitCode());
        context.addUserParam("F", flowInst.getUserCode());
        return context;
    }

    private LeftRightPair<Set<String>, Set<String>> calcNodeUnitAndOperator(FlowInstance flowInst, NodeInstance preNodeInst, String nodeToken, NodeInfo nextOptNode, FlowOptParamOptions options, FlowVariableTranslate varTrans) {
        UserUnitFilterCalcContext context = this.createCalcUserUnitContext(flowInst, preNodeInst, nodeToken, nextOptNode, options, varTrans);
        return this.calcNodeUnitAndOperator(context, flowInst, nodeToken, nextOptNode, options);
    }

    private LeftRightPair<Set<String>, Set<String>> calcNodeUnitAndOperator(UserUnitFilterCalcContext context, FlowInstance flowInst, String nodeToken, NodeInfo nextOptNode, FlowOptParamOptions options) {
        String optUser;
        HashSet nodeUnits = null;
        if (options.getNodeUnits() != null) {
            String nodeUnit = (String)options.getNodeUnits().get(nextOptNode.getNodeId());
            if (StringUtils.isBlank((CharSequence)nodeUnit)) {
                nodeUnit = (String)options.getNodeUnits().get(nextOptNode.getNodeCode());
            }
            if (StringUtils.isNotBlank((CharSequence)nodeUnit)) {
                nodeUnits = CollectionsOpt.createHashSet((Object[])new String[]{nodeUnit});
            }
        }
        if (CollectionUtils.isEmpty(nodeUnits) && StringUtils.isNotBlank((CharSequence)nextOptNode.getUnitExp()) && !"null".equals(nextOptNode.getUnitExp())) {
            nodeUnits = UserUnitCalcEngine.calcUnitsByExp(context, nextOptNode.getUnitExp());
        }
        if (CollectionUtils.isNotEmpty(nodeUnits)) {
            context.addUnitParam("N", nodeUnits);
        }
        if (options.isLockOptUser() && StringUtils.isNotBlank((CharSequence)(optUser = options.getWorkUserCode()))) {
            return new LeftRightPair((Object)nodeUnits, (Object)CollectionsOpt.createHashSet((Object[])new String[]{optUser}));
        }
        Set optUsers = null;
        if (options.getNodeOptUsers() != null) {
            optUsers = (Set)options.getNodeOptUsers().get(nextOptNode.getNodeId());
            if (optUsers != null && !optUsers.isEmpty()) {
                return new LeftRightPair((Object)nodeUnits, (Object)optUsers);
            }
            optUsers = (Set)options.getNodeOptUsers().get(nextOptNode.getNodeCode());
            if (optUsers != null && !optUsers.isEmpty()) {
                return new LeftRightPair((Object)nodeUnits, optUsers);
            }
        }
        if ("EN".equalsIgnoreCase(nextOptNode.getRoleType()) || "SF".equalsIgnoreCase(nextOptNode.getRoleType())) {
            RoleFormula rf;
            String roleFormula = nextOptNode.getPowerExp();
            if ("SF".equalsIgnoreCase(nextOptNode.getRoleType()) && (rf = (RoleFormula)this.roleFormulaDao.getObjectById(nextOptNode.getRoleCode())) != null) {
                roleFormula = rf.getRoleFormula();
            }
            if ((optUsers = UserUnitCalcEngine.calcOperators(context, roleFormula)) == null || optUsers.size() == 0) {
                logger.debug("\u6743\u9650\u5f15\u64ce\u6ca1\u6709\u8bc6\u522b\u51fa\u7b26\u5408\u8868\u8fbe\u5f0f\u7684\u64cd\u4f5c\u4eba\u5458\uff1a" + roleFormula + "\uff0cflow_inst_id:" + flowInst.getFlowInstId() + ",node_inst_id:" + nextOptNode.getNodeId() + "\uff1b\u81ea\u52a8\u8fd0\u884c\u8282\u70b9\u5ffd\u7565\u8fd9\u4e2a\u4fe1\u606f\u3002");
            }
        } else if ("BJ".equalsIgnoreCase(nextOptNode.getRoleType())) {
            optUsers = new HashSet<String>();
            List<FlowWorkTeam> users = this.flowTeamDao.listFlowWorkTeamByRole(flowInst.getFlowInstId(), nextOptNode.getRoleCode());
            String currNodeToken = null;
            for (FlowWorkTeam u : users) {
                if (StringUtils.equals(currNodeToken, (CharSequence)u.getRunToken())) {
                    optUsers.add(u.getUserCode());
                    continue;
                }
                boolean chargeToken = StringUtils.equals((CharSequence)nodeToken, (CharSequence)u.getRunToken()) || currNodeToken == null || StringUtils.isBlank(currNodeToken) || nodeToken.startsWith(u.getRunToken()) && (!nodeToken.startsWith(currNodeToken) || u.getRunToken().length() > currNodeToken.length());
                if (!chargeToken) continue;
                optUsers.clear();
                currNodeToken = u.getRunToken();
                optUsers.add(u.getUserCode());
            }
        } else if (StringUtils.isNotBlank((CharSequence)nextOptNode.getRoleType()) && StringUtils.isNotBlank((CharSequence)nextOptNode.getRoleCode())) {
            String unitCode = CollectionUtils.isEmpty((Collection)nodeUnits) ? null : (String)nodeUnits.iterator().next();
            optUsers = SysUserFilterEngine.getUsersByRoleAndUnit((UserUnitFilterCalcContext)context, (String)nextOptNode.getRoleType(), (String)nextOptNode.getRoleCode(), (String)unitCode);
        }
        return new LeftRightPair((Object)nodeUnits, optUsers);
    }

    private void closeNodeInstanceInside(Collection<NodeInstance> sameNodes, Date currentTime, String userCode) {
        for (NodeInstance ni : sameNodes) {
            FlowInstance subFlowInst;
            if ("W".equals(ni.getNodeState()) && (subFlowInst = (FlowInstance)this.flowInstanceDao.getObjectById(ni.getSubFlowInstId())) != null) {
                FlowOptUtils.endInstance(subFlowInst, "F", userCode, this.flowInstanceDao);
            }
            ni.setNodeState("F");
            ni.setLastUpdateTime(currentTime);
            ni.setLastUpdateUser(userCode);
            this.nodeInstanceDao.updateObject((Serializable)ni);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> submitToNextRouterNode(NodeInfo nextRouterNode, String nodeToken, FlowInstance flowInst, FlowInfo flowInfo, NodeInstance preNodeInst, String transPath, FlowTransition trans, FlowOptParamOptions options, FlowVariableTranslate flowVarTrans, ServletContext application) {
        String routerType = nextRouterNode.getRouterType();
        List<String> resNodes = new ArrayList<String>();
        StringBuilder preTransPath = new StringBuilder();
        if (trans != null) {
            preTransPath = new StringBuilder(StringUtils.isBlank((CharSequence)transPath) ? trans.getTransId() : transPath + "," + trans.getTransId());
        }
        if ("H".equals(routerType) || "D".equals(routerType)) {
            Set<FlowTransition> selTrans = this.selectTransitions(flowInst, preNodeInst, nodeToken, nextRouterNode, options, flowVarTrans);
            if (selTrans.size() < 1) {
                if (nodeToken.startsWith("R")) {
                    return resNodes;
                }
                String errorMsg = "\u627e\u4e0d\u5230\u540e\u7eed\u8282\u70b9\uff1a" + flowInst.getFlowInstId() + (preNodeInst != null ? "; \u8282\u70b9\uff1a" + preNodeInst.getNodeInstId() : ";") + " \u8def\u7531\uff1a" + nextRouterNode.getNodeId();
                logger.error(errorMsg);
                throw new WorkflowException(658, errorMsg);
            }
            if ("D".equals(routerType)) {
                FlowTransition nodeTran = selTrans.iterator().next();
                String nextNodeId = nodeTran.getEndNodeId();
                return this.submitToNextNode((NodeInfo)this.flowNodeDao.getObjectById(nextNodeId), nodeToken, flowInst, flowInfo, preNodeInst, preTransPath.toString(), nodeTran, options, flowVarTrans, application);
            }
            int nNo = 1;
            Iterator<FlowTransition> nextNodeId = selTrans.iterator();
            while (nextNodeId.hasNext()) {
                FlowTransition tran = nextNodeId.next();
                String nextNodeId2 = tran.getEndNodeId();
                List<String> nNs = this.submitToNextNode((NodeInfo)this.flowNodeDao.getObjectById(nextNodeId2), nodeToken + "." + nNo, flowInst, flowInfo, preNodeInst, preTransPath.toString(), tran, options, flowVarTrans, application);
                resNodes.addAll(nNs);
                ++nNo;
            }
            return resNodes;
        }
        if ("E".equals(routerType)) {
            Object transList;
            String preRunToken = NodeInstance.calcSuperToken((String)nodeToken);
            Triple allSubmitState = flowInst.calcSubmitSubNodeTokensByToken(preRunToken, preNodeInst);
            boolean canSubmit = (Integer)allSubmitState.getLeft() == 0;
            String convergeType = nextRouterNode.getConvergeType();
            if (!canSubmit && !"A".equals(convergeType)) {
                Set submitNodeIds = (Set)allSubmitState.getRight();
                canSubmit = true;
                block1: for (String nId : submitNodeIds) {
                    transList = this.flowTransitionDao.getNodeInputTrans(nId);
                    Iterator<FlowTransition> iterator = transList.iterator();
                    while (iterator.hasNext()) {
                        FlowTransition tran = iterator.next();
                        if (tran.getCanIgnore() == null || tran.getCanIgnore().booleanValue()) continue;
                        canSubmit = false;
                        continue block1;
                    }
                }
                if (canSubmit) {
                    canSubmit = StringRegularOpt.isNumber((String)nextRouterNode.getConvergeParam()) ? ("R".equals(convergeType) ? (Integer)allSubmitState.getMiddle() >= Integer.parseInt(nextRouterNode.getConvergeParam()) : ("L".equals(convergeType) ? (Integer)allSubmitState.getLeft() <= Integer.parseInt(nextRouterNode.getConvergeParam()) : ("V".equals(convergeType) ? (double)((Integer)allSubmitState.getMiddle()).intValue() / (double)((Integer)allSubmitState.getMiddle() + (Integer)allSubmitState.getLeft()) >= Double.parseDouble(nextRouterNode.getConvergeParam()) : false))) : false;
                }
            }
            if (!canSubmit) return resNodes;
            Set sameNodes = flowInst.findAllActiveSubNodeInstByToken(preRunToken);
            sameNodes.removeIf(nodeInst -> preNodeInst.getNodeInstId().equals(nodeInst.getNodeInstId()) || nodeInst.getRunToken().indexOf("R", preRunToken.length()) > 0);
            if (!sameNodes.isEmpty()) {
                Date currentTime = new Date(System.currentTimeMillis());
                this.closeNodeInstanceInside(sameNodes, currentTime, options.getUserCode());
            }
            FlowTransition nodeTran = this.selectOptNodeTransition(nextRouterNode);
            String nextNodeId3 = "";
            if (nodeTran != null) {
                nextNodeId3 = nodeTran.getEndNodeId();
            }
            transList = flowInfo.getTransList().iterator();
            while (transList.hasNext()) {
                FlowTransition f = (FlowTransition)transList.next();
                if (!nextRouterNode.getNodeId().equals(f.getEndNodeId()) || trans == null || f.getTransId().equals(trans.getTransId())) continue;
                preTransPath.append(",").append(f.getTransId());
            }
            return this.submitToNextNode((NodeInfo)this.flowNodeDao.getObjectById(nextNodeId3), preRunToken, flowInst, flowInfo, preNodeInst, preTransPath.toString(), nodeTran, options, flowVarTrans, application);
        }
        if ("G".equals(routerType)) {
            FlowTransition nodeTran = this.selectOptNodeTransition(nextRouterNode);
            String nextNodeId = "";
            if (nodeTran != null) {
                nextNodeId = nodeTran.getEndNodeId();
            }
            NodeInfo nextNode = (NodeInfo)this.flowNodeDao.getObjectById(nextNodeId);
            LeftRightPair<Set<String>, Set<String>> unitAndUsers = this.calcNodeUnitAndOperator(flowInst, preNodeInst, nodeToken, nextRouterNode, options, flowVarTrans);
            if ("D".equals(nextRouterNode.getMultiInstType())) {
                Set nextNodeUnits = (Set)unitAndUsers.getLeft();
                if (nextNodeUnits == null || nextNodeUnits.size() == 0) {
                    throw new WorkflowException(657, "\u591a\u5b9e\u4f8b\u8282\u70b9\u5bf9\u5e94\u7684\u673a\u6784\u53d8\u91cf\u4e3a\u7a7a\uff1a" + flowInst.getFlowInstId() + (preNodeInst != null ? "; \u8282\u70b9\uff1a" + preNodeInst.getNodeInstId() : ";") + " \u8def\u7531\uff1a" + nextRouterNode.getNodeId());
                }
                int nRn = 1;
                Iterator nextNodeId3 = nextNodeUnits.iterator();
                while (nextNodeId3.hasNext()) {
                    String uc = (String)nextNodeId3.next();
                    this.saveFlowNodeVariable(flowInst.getFlowInstId(), nodeToken + "." + nRn, "cd_" + (String)GeneralAlgorithm.nvl((Object)nextRouterNode.getNodeCode(), (Object)"unit"), uc);
                    String runToken = preNodeInst == null ? "T" : preNodeInst.getRunToken();
                    flowVarTrans.setInnerVariable("cursor", runToken, uc);
                    resNodes.addAll(this.submitToNextNode(nextNode, nodeToken + "." + nRn, flowInst, flowInfo, preNodeInst, preTransPath.toString(), nodeTran, options, flowVarTrans, application));
                    ++nRn;
                }
                return resNodes;
            }
            if (!"U".equals(nextRouterNode.getMultiInstType())) throw new WorkflowException(653, "\u591a\u5b9e\u4f8b\u8def\u7531\u76ee\u524d\u53ea\u652f\u6301\u4eba\u5458\u548c\u673a\u6784\u6570\u7ec4\uff1a" + flowInst.getFlowInstId() + (preNodeInst != null ? "; \u8282\u70b9\uff1a" + preNodeInst.getNodeInstId() : ";") + " \u8def\u7531\uff1a" + nextRouterNode.getNodeId());
            Set optUsers = (Set)unitAndUsers.getRight();
            if (optUsers == null || optUsers.size() == 0) {
                throw new WorkflowException(657, "\u591a\u5b9e\u4f8b\u8282\u70b9\u5bf9\u5e94\u7684\u6743\u9650\u8868\u8fbe\u5f0f\u4eba\u5458\u4e3a\u7a7a\uff1a" + flowInst.getFlowInstId() + (preNodeInst != null ? "; \u8282\u70b9\uff1a" + preNodeInst.getNodeInstId() : ";") + " \u8def\u7531\uff1a" + nextRouterNode.getNodeId());
            }
            int nRn = 1;
            UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(options.getTopUnit());
            Iterator iterator = optUsers.iterator();
            while (iterator.hasNext()) {
                String uc = (String)iterator.next();
                this.saveFlowNodeVariable(flowInst.getFlowInstId(), nodeToken + "." + nRn, "cu_" + (String)GeneralAlgorithm.nvl((Object)nextRouterNode.getNodeCode(), (Object)"user"), uc);
                String runToken = preNodeInst == null ? "T" : preNodeInst.getRunToken();
                flowVarTrans.setInnerVariable("cursor", runToken, uc);
                resNodes.addAll(this.submitToNextNode(nextNode, nodeToken + "." + nRn, flowInst, flowInfo, preNodeInst, preTransPath.toString(), nodeTran, (FlowOptParamOptions)SubmitOptOptions.create().copy(options).workUser(uc).lockOptUser(true).unit(context.getUserInfoByCode(options.getUserCode()).getPrimaryUnit()), flowVarTrans, application));
                ++nRn;
            }
            return resNodes;
        }
        if (!"R".equals(routerType)) return resNodes;
        FlowTransition nodeTran = this.selectOptNodeTransition(nextRouterNode);
        String nextNodeId = "";
        if (nodeTran == null) return this.submitToNextNode((NodeInfo)this.flowNodeDao.getObjectById(nextNodeId), nodeToken + "." + "R", flowInst, flowInfo, preNodeInst, preTransPath.toString(), nodeTran, options, flowVarTrans, application);
        nextNodeId = nodeTran.getEndNodeId();
        return this.submitToNextNode((NodeInfo)this.flowNodeDao.getObjectById(nextNodeId), nodeToken + "." + "R", flowInst, flowInfo, preNodeInst, preTransPath.toString(), nodeTran, options, flowVarTrans, application);
    }

    private List<String> submitToNextNode(NodeInfo nextNode, String nodeToken, FlowInstance flowInst, FlowInfo flowInfo, NodeInstance preNodeInst, String transPath, FlowTransition nodeTran, FlowOptParamOptions options, FlowVariableTranslate varTrans, ServletContext application) {
        varTrans.setNodeInst(preNodeInst);
        if ("R".equals(nextNode.getNodeType())) {
            return this.submitToNextRouterNode(nextNode, nodeToken, flowInst, flowInfo, preNodeInst, transPath, nodeTran, options, varTrans, application);
        }
        if ("F".equals(nextNode.getNodeType())) {
            this.endFlowInstance(flowInst, flowInfo, nextNode, transPath, nodeTran, preNodeInst.getNodeInstId(), options.getUserCode(), options.getUnitCode(), varTrans);
            if (flowInst.getIsSubInst().booleanValue()) {
                return this.submitOptInside(SubmitOptOptions.create().copy(options).nodeInst(flowInst.getPreNodeInstId()), varTrans, application, true);
            }
            return CollectionsOpt.createList((Object[])new String[]{NODE_INST_ZERO});
        }
        return this.submitToNextOptNode(nextNode, nodeToken, flowInst, flowInfo, preNodeInst, transPath, nodeTran, options, varTrans, application);
    }

    private List<String> submitToNextOptNode(NodeInfo nextOptNode, String nodeToken, FlowInstance flowInst, FlowInfo flowInfo, NodeInstance preNodeInst, String transPath, FlowTransition trans, FlowOptParamOptions options, FlowVariableTranslate varTrans, ServletContext application) {
        StageInstance stage;
        Date currentTime = new Date(System.currentTimeMillis());
        String lastNodeInstId = UuidOpt.getUuidAsString32();
        NodeInstance nodeInst = FlowOptUtils.createNodeInst(options.getUnitCode(), options.getUserCode(), flowInst, preNodeInst, flowInfo, nextOptNode, trans, varTrans);
        nodeInst.setNodeInstId(lastNodeInstId);
        if (trans != null) {
            nodeInst.setTransPath(StringUtils.isBlank((CharSequence)transPath) ? trans.getTransId() : transPath + "," + trans.getTransId());
        }
        nodeInst.setRunToken(nodeToken);
        if (StringUtils.isNotBlank((CharSequence)nextOptNode.getStageCode()) && (stage = flowInst.getStageInstanceByCode(nextOptNode.getStageCode())) != null) {
            if (StageInstance.STAGE_TIMER_STATE_STARTED.equals(stage.getStageBegin())) {
                stage.setLastUpdateTime(DatetimeOpt.currentUtilDate());
            } else {
                stage.setStageBegin(StageInstance.STAGE_TIMER_STATE_STARTED);
                stage.setBeginTime(DatetimeOpt.currentUtilDate());
                stage.setLastUpdateTime(DatetimeOpt.currentUtilDate());
            }
            this.stageInstanceDao.updateObject((Serializable)stage);
        }
        ArrayList<String> createNodes = new ArrayList<String>();
        createNodes.add(nodeInst.getNodeInstId());
        UserUnitFilterCalcContext context = this.createCalcUserUnitContext(flowInst, preNodeInst, nodeToken, nextOptNode, options, varTrans);
        LeftRightPair<Set<String>, Set<String>> unitAndUser = this.calcNodeUnitAndOperator(context, flowInst, nodeToken, nextOptNode, options);
        Set nodeUnits = (Set)unitAndUser.getLeft();
        Set optUsers = (Set)unitAndUser.getRight();
        if (nodeUnits != null && !nodeUnits.isEmpty()) {
            nodeInst.setUnitCode((String)nodeUnits.iterator().next());
        } else {
            nodeInst.setUnitCode(null);
        }
        if ("S".equals(nextOptNode.getNodeType())) {
            nodeInst.setNodeState("W");
            String tempFlowTimeLimit = "";
            if ("T".equals(flowInst.getIsTimer()) && flowInst.getTimeLimit() != null && !"F".equals(nextOptNode.getIsAccountTime())) {
                WorkTimeSpan workTimeSpan = new WorkTimeSpan();
                workTimeSpan.fromNumberAsMinute(flowInst.getTimeLimit().longValue());
                tempFlowTimeLimit = workTimeSpan.toStringAsMinute();
            }
            FlowInstance tempFlow = this.createInstanceInside(CreateFlowOptions.create().copy(options).flow(nextOptNode.getSubFlowCode()).version(this.flowDefDao.getLastVersion(nextOptNode.getSubFlowCode())).optName(flowInst.getFlowOptName() + "--" + nextOptNode.getNodeName()).optTag(flowInst.getFlowOptTag()).parentFlow(nodeInst.getFlowInstId(), lastNodeInstId).timeLimit(tempFlowTimeLimit), varTrans, application);
            nodeInst.setSubFlowInstId(tempFlow.getFlowInstId());
            if (optUsers != null && !optUsers.isEmpty()) {
                nodeInst.setUserCode((String)optUsers.iterator().next());
            }
            NodeInstance tempFirstNode = tempFlow.getFirstNodeInstance();
            createNodes.add(tempFirstNode.getNodeInstId());
        } else if ("C".equals(nextOptNode.getNodeType())) {
            int oldGen;
            NodeInstance sameInst;
            if ("B".equals(nextOptNode.getOptRunType())) {
                nodeInst.setTaskAssigned("D");
            } else {
                if (optUsers == null || optUsers.isEmpty()) {
                    String errorMsg = "\u6d41\u7a0b" + flowInst.getFlowInstId() + "\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9:" + nextOptNode.getNodeName() + ",\u627e\u4e0d\u5230\u6743\u9650\u4e3a" + nextOptNode.getRoleCode() + "\u7684\u64cd\u4f5c\u4eba\u5458";
                    logger.error(errorMsg);
                    throw new WorkflowException(650, errorMsg);
                }
                if (optUsers.size() == 1) {
                    nodeInst.setTaskAssigned("S");
                    nodeInst.setUserCode((String)optUsers.iterator().next());
                } else {
                    String errorMsg = "\u6d41\u7a0b" + flowInst.getFlowInstId() + "\u7684\u4e0b\u4e00\u4e2a\u8282\u70b9:" + nextOptNode.getNodeName() + ",\u6709\u591a\u4e2a\u64cd\u4f5c\u4eba\u5458" + StringBaseOpt.castObjectToString((Object)optUsers);
                    logger.error(errorMsg);
                    throw new WorkflowException(650, errorMsg);
                }
            }
            if (!"F".equals(flowInfo.getFlowClass()) && (sameInst = flowInst.findLastSameNodeInst(nodeInst.getNodeId(), nodeInst, nodeInst.getNodeInstId())) != null && (oldGen = sameInst.getTokenGeneration()) > 0 && nodeInst.getTokenGeneration() > oldGen) {
                String thisToken = NodeInstance.truncTokenGeneration((String)nodeInst.getRunToken(), (int)oldGen);
                nodeInst.setRunToken(thisToken);
                Set sameNodes = flowInst.findAllActiveSubNodeInstByToken(thisToken);
                if (sameNodes != null && !sameNodes.isEmpty()) {
                    this.closeNodeInstanceInside(sameNodes, currentTime, options.getUserCode());
                }
            }
        } else if ("E".equals(nextOptNode.getNodeType())) {
            FlowEventInfo eventInfo;
            nodeInst.setNodeState("T");
            if ("T".equals(nextOptNode.getOptType())) {
                nodeInst.setIsTimer("T");
                nodeInst.setTimeLimit(Long.valueOf(new WorkTimeSpan(nextOptNode.getTimeLimit()).toNumberAsMinute()));
                nodeInst.setPromiseTime(nodeInst.getTimeLimit());
            } else if ("M".equals(nextOptNode.getOptType()) && (eventInfo = this.flowEventService.getEventByFlowEvent(flowInst.getFlowCode(), nextOptNode.getMessageCode())) != null) {
                List<String> ret = this.submitOptInside(SubmitOptOptions.create().copy(options).nodeInst(nodeInst.getNodeInstId()), varTrans, application, false, true, false);
                eventInfo.setOptResult(StringBaseOpt.castObjectToString(ret));
                eventInfo.setOptState("S");
                eventInfo.setOptTime(DatetimeOpt.currentUtilDate());
                this.flowEventService.updateEvent(eventInfo);
            }
        }
        if ("D".equals(nextOptNode.getNoticeType())) {
            boolean notSendMessage = true;
            if (StringUtils.isBlank((CharSequence)nextOptNode.getNoticeUserExp()) && "C".equals(nextOptNode.getNodeType())) {
                if (optUsers != null) {
                    this.notificationCenter.sendMessage("system", (Collection)optUsers, NoticeMessage.create().operation("workflow").method("submit").subject("\u60a8\u6709\u65b0\u4efb\u52a1").content(Pretreatment.mapTemplateString((String)nextOptNode.getNoticeMessage(), (Object)options)));
                }
                notSendMessage = false;
            } else {
                context.addUnitParam("N", nodeUnits);
                context.addUserParam("N", optUsers);
                Set<String> sendMessageUser = UserUnitCalcEngine.calcOperators(context, nextOptNode.getNoticeUserExp());
                if (sendMessageUser != null && sendMessageUser.size() > 0) {
                    this.notificationCenter.sendMessage("system", sendMessageUser, NoticeMessage.create().operation("workflow").method("submit").subject("\u60a8\u6709\u65b0\u4efb\u52a1").content(Pretreatment.mapTemplateString((String)nextOptNode.getNoticeMessage(), (Object)options)));
                    notSendMessage = false;
                }
            }
            if (notSendMessage) {
                logger.error("\u53d1\u9001\u6d88\u606f\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u63a5\u6536\u4eba\uff1a" + JSON.toJSONString((Object)nodeInst));
            }
        }
        this.nodeInstanceDao.saveNewObject((Serializable)nodeInst);
        flowInst.addNodeInstance(nodeInst);
        flowInst.setLastUpdateTime(currentTime);
        flowInst.setLastUpdateUser(options.getUserCode());
        if ("D".equals(nextOptNode.getNodeType())) {
            CallApiNodeEventSupport nodeEventExecutor;
            boolean needSubmit = true;
            SubmitOptOptions autoSubmitOptions = SubmitOptOptions.create().copy(options).nodeInst(lastNodeInstId);
            if ("S".equals(nextOptNode.getAutoRunType())) {
                Map<String, Object> objectMap = this.flowScriptRunTime.runFlowScript(nextOptNode.getOptParam(), flowInst, nodeInst, varTrans);
                String lockUser = StringBaseOpt.castObjectToString((Object)objectMap.get("_lock_user"));
                if (StringUtils.isNotBlank((CharSequence)lockUser)) {
                    autoSubmitOptions.workUser(lockUser);
                }
            } else if ("C".equals(nextOptNode.getAutoRunType())) {
                nodeEventExecutor = new CallApiNodeEventSupport(varTrans, this.ddeDubboTaskRun);
                needSubmit = nodeEventExecutor.runAutoOperator(flowInst, preNodeInst == null ? nodeInst : preNodeInst, nextOptNode, options.getUserCode());
            } else if ("B".equals(nextOptNode.getAutoRunType())) {
                nodeEventExecutor = NodeEventSupportFactory.createNodeEventSupportBean(nextOptNode, this);
                needSubmit = nodeEventExecutor.runAutoOperator(flowInst, preNodeInst == null ? nodeInst : preNodeInst, nextOptNode, options.getUserCode());
            } else if ("M".equals(nextOptNode.getAutoRunType())) {
                FlowEventInfo eventInfo = new FlowEventInfo();
                eventInfo.setFlowInstId(flowInst.getFlowInstId());
                eventInfo.setSenderUser(options.getUserCode());
                eventInfo.setEventName(nextOptNode.getMessageCode());
                eventInfo.setEventParam(nextOptNode.getOptParam());
                this.flowEventService.saveNewEvent(eventInfo);
            }
            if (needSubmit) {
                List<String> nextNodes = this.submitOptInside(autoSubmitOptions, varTrans, application, false);
                createNodes.addAll(nextNodes);
            }
        } else if (StringUtils.isNotBlank((CharSequence)nextOptNode.getOptBean())) {
            NodeEventSupport nodeEventExecutor = NodeEventSupportFactory.createNodeEventSupportBean(nextOptNode, this);
            nodeEventExecutor.runAfterCreate(flowInst, nodeInst, nextOptNode, options.getUserCode());
        }
        return createNodes;
    }

    private NodeInfo selectNextNodeByNodeId(String nodeId) {
        List<FlowTransition> transList = this.flowTransitionDao.getNodeTrans(nodeId);
        if (transList == null || transList.size() < 1) {
            return null;
        }
        return (NodeInfo)this.flowNodeDao.getObjectById(transList.get(0).getEndNodeId());
    }

    private FlowTransition selectOptNodeTransition(NodeInfo currNode) {
        List<FlowTransition> transList = this.flowTransitionDao.getNodeTrans(currNode.getNodeId());
        if (transList == null || transList.size() < 1) {
            return null;
        }
        if (transList.size() > 1) {
            throw new WorkflowException(653, "\u6d41\u7a0b\u56fe\u7ed8\u5236\u95ee\u9898\uff0c\u4e1a\u52a1\u8282\u70b9\u6d41\u8f6c\u8def\u5f84\u4e0d\u662f\u6709\u4e14\u552f\u4e00\u7684\u4e00\u6761\uff1a" + currNode.getFlowCode() + ":" + currNode.getVersion() + ":" + currNode.getNodeId() + ":" + currNode.getNodeCode() + ":" + currNode.getNodeName());
        }
        return transList.get(0);
    }

    private Set<FlowTransition> selectTransitions(FlowInstance flowInst, NodeInstance preNodeInst, String nodeToken, NodeInfo currNode, FlowOptParamOptions options, FlowVariableTranslate varTrans) {
        List<FlowTransition> transList = this.flowTransitionDao.getNodeTrans(currNode.getNodeId());
        HashSet<FlowTransition> selTrans = new HashSet<FlowTransition>();
        if (transList == null || transList.size() < 1) {
            return selTrans;
        }
        String routerType = currNode.getRouterType();
        if ("D".equals(routerType) || "H".equals(routerType)) {
            VariableFormula formula = new VariableFormula();
            formula.setTrans((VariableTranslate)varTrans);
            formula.setExtendFuncMap(FlowOptUtils.createExtendFuncMap(() -> this.createCalcUserUnitContext(flowInst, preNodeInst, nodeToken, currNode, options, varTrans)));
            for (FlowTransition trans : transList) {
                if (StringUtils.isBlank((CharSequence)trans.getTransCondition())) {
                    throw new ObjectException(653, "\u6ca1\u6709\u914d\u7f6e\u76f8\u5173\u7684\u6761\u4ef6\u6d41\u8f6c\u53c2\u6570\uff01");
                }
                if (!BooleanBaseOpt.castObjectToBoolean((Object)formula.calcFormula(trans.getTransCondition()), (Boolean)false).booleanValue()) continue;
                selTrans.add(trans);
                if (!"D".equals(routerType)) continue;
                break;
            }
            if (selTrans.size() < 1) {
                for (FlowTransition trans : transList) {
                    if (!"else".equalsIgnoreCase(trans.getTransCondition())) continue;
                    selTrans.add(trans);
                    break;
                }
            }
        } else {
            selTrans.add(transList.get(0));
        }
        return selTrans;
    }

    @Transactional
    public List<String> submitOpt(SubmitOptOptions options, UserUnitVariableTranslate varTrans, ServletContext application) {
        return this.submitOptInside(options, varTrans, application, true);
    }

    @Transactional
    public Map<String, Object> submitFlowOpt(SubmitOptOptions options) {
        List<String> nextNodeInstList = this.submitOpt(options, (UserUnitVariableTranslate)new ObjectUserUnitVariableTranslate((Object)CollectionsOpt.unionTwoMap((Map)options.getVariables(), (Map)options.getGlobalVariables())), null);
        HashSet<String> nodeNames = new HashSet<String>();
        for (String nodeInstId : nextNodeInstList) {
            NodeInfo nodeInfo = this.getNodeInfo(nodeInstId);
            if (nodeInfo == null) continue;
            nodeNames.add(nodeInfo.getNodeName());
        }
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("nextNodeInsts", nextNodeInstList);
        resultMap.put("nodeNames", StringUtils.join(nodeNames, (String)","));
        return resultMap;
    }

    @Transactional
    public List<String> submitOpt(SubmitOptOptions options) {
        return this.submitOpt(options, (UserUnitVariableTranslate)new ObjectUserUnitVariableTranslate((Object)CollectionsOpt.unionTwoMap((Map)options.getVariables(), (Map)options.getGlobalVariables())), null);
    }

    private List<String> submitOptInside(SubmitOptOptions options, UserUnitVariableTranslate varTrans, ServletContext application, boolean saveOptions) {
        return this.submitOptInside(options, varTrans, application, saveOptions, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> submitOptInside(SubmitOptOptions options, UserUnitVariableTranslate varTrans, ServletContext application, boolean saveOptions, boolean saveLog, boolean isSkipNode) {
        StageInstance stage;
        this.fetchTopUnit((FlowOptParamOptions)options);
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectWithReferences(options.getNodeInstId());
        if (nodeInst == null) {
            logger.error("\u627e\u4e0d\u5230\u8282\u70b9\u5b9e\u4f8b\uff1a" + options.getNodeInstId());
            throw new WorkflowException(651, "\u627e\u4e0d\u5230\u8282\u70b9\u5b9e\u4f8b\uff1a" + options.getNodeInstId());
        }
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(nodeInst.getFlowInstId());
        if (flowInst == null) {
            logger.error("\u627e\u4e0d\u5230\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + nodeInst.getFlowInstId());
            throw new WorkflowException(652, "\u627e\u4e0d\u5230\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + nodeInst.getFlowInstId());
        }
        if (StringUtils.isBlank((CharSequence)options.getTopUnit())) {
            options.setTopUnit(flowInst.getTopUnit());
        }
        FlowInfo flowInfo = this.flowDefDao.getFlowDefineByID(flowInst.getFlowCode(), flowInst.getVersion());
        if ("P".equals(nodeInst.getIsTimer())) {
            logger.error("\u6d41\u7a0b\u8282\u70b9\u5904\u4e8e\u6682\u505c\u8ba1\u65f6 \u72b6\u6001\uff1a" + flowInst.getInstState() + "\u8282\u70b9\uff1a" + options.getNodeInstId());
            throw new WorkflowException(655, "\u6d41\u7a0b\u8282\u70b9\u5904\u4e8e\u6682\u505c\u8ba1\u65f6 \u72b6\u6001\uff1a" + flowInst.getInstState() + "\u8282\u70b9\uff1a" + options.getNodeInstId());
        }
        if (!flowInst.checkIsInRunning() || !nodeInst.checkIsInRunning()) {
            logger.error("\u6d41\u7a0b\u8282\u70b9\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u6d41\u7a0b\uff1a" + nodeInst.getFlowInstId() + " \u72b6\u6001\uff1a" + flowInst.getInstState() + "\u8282\u70b9\uff1a" + options.getNodeInstId() + " \u72b6\u6001\uff1a" + nodeInst.getNodeState());
            throw new WorkflowException(654, "\u6d41\u7a0b\u8282\u70b9\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u6d41\u7a0b\uff1a" + nodeInst.getFlowInstId() + " \u72b6\u6001\uff1a" + flowInst.getInstState() + "\u8282\u70b9\uff1a" + options.getNodeInstId() + " \u72b6\u6001\uff1a" + nodeInst.getNodeState());
        }
        String runAsUser = null;
        NodeInfo currNode = (NodeInfo)this.flowNodeDao.getObjectById(nodeInst.getNodeId());
        if (isSkipNode) {
            runAsUser = options.getUserCode();
        } else if ("GW".equalsIgnoreCase(currNode.getRoleType())) {
            nodeInst.setUserCode(options.getUserCode());
            runAsUser = options.getUserCode();
        } else if ("C".equals(currNode.getNodeType()) && (runAsUser = this.checkTaskGrantor(nodeInst, options.getUserCode())) == null) {
            logger.error("\u7528\u6237\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u8282\u70b9\uff1a" + options.getUserCode() + " -- " + options.getNodeInstId());
            throw new WorkflowException(656, "\u7528\u6237\u6ca1\u6709\u6743\u9650\u64cd\u4f5c\u8be5\u8282\u70b9\uff1a" + options.getUserCode() + " -- " + options.getNodeInstId());
        }
        if (saveOptions) {
            if (StringUtils.length((CharSequence)options.getFlowOptName()) > 1) {
                flowInst.setFlowOptName(options.getFlowOptName());
            }
            this.saveValueAndRoleInOptions(nodeInst.getFlowInstId(), nodeInst.getRunToken(), (FlowOptParamOptions)options);
        }
        Date updateTime = DatetimeOpt.currentUtilDate();
        nodeInst.setLastUpdateTime(updateTime);
        nodeInst.setLastUpdateUser(options.getUserCode());
        nodeInst.setNodeState("C");
        if (saveLog) {
            OperationLog wfactlog = FlowOptUtils.createActionLog(options.getUserCode(), nodeInst, "\u63d0\u4ea4\u8282\u70b9", currNode);
            if ("C".equals(currNode.getNodeType()) && !StringUtils.equals((CharSequence)runAsUser, (CharSequence)options.getUserCode())) {
                nodeInst.setGrantor(runAsUser);
                wfactlog.setNewValue((Object)(runAsUser + " \u6388\u4e88 " + options.getUserCode() + ":" + currNode.getRoleType() + ":" + currNode.getRoleCode()));
            }
            OperationLogCenter.log((OperationLog)wfactlog);
        }
        if ((stage = flowInst.getStageInstanceByCode(currNode.getStageCode())) != null) {
            if (StageInstance.STAGE_TIMER_STATE_STARTED.equals(stage.getStageBegin())) {
                stage.setLastUpdateTime(DatetimeOpt.currentUtilDate());
            } else {
                stage.setStageBegin(StageInstance.STAGE_TIMER_STATE_STARTED);
                stage.setBeginTime(DatetimeOpt.currentUtilDate());
                stage.setLastUpdateTime(DatetimeOpt.currentUtilDate());
            }
            this.stageInstanceDao.updateObject((Serializable)stage);
        }
        flowInst.setLastUpdateTime(updateTime);
        flowInst.setLastUpdateUser(options.getUserCode());
        List<String> nextNodeInsts = new ArrayList<String>();
        NodeEventSupport nodeEventExecutor = NodeEventSupportFactory.createNodeEventSupportBean(currNode, this);
        nodeEventExecutor.runBeforeSubmit(flowInst, nodeInst, currNode, options.getUserCode());
        if (nodeInst.getRunToken().endsWith("L")) {
            if (flowInst.checkNotCommitPreNodes(nodeInst.getPrevNodeInstId()) > 0) {
                NodeInstance preNodeInst = flowInst.getNodeInstanceById(nodeInst.getPrevNodeInstId());
                preNodeInst.setNodeState("N");
                nextNodeInsts.add(nodeInst.getPrevNodeInstId());
                this.nodeInstanceDao.updateObject((Serializable)preNodeInst);
            }
            this.nodeInstanceDao.updateObject((Serializable)nodeInst);
            this.flowInstanceDao.updateObject((Serializable)flowInst);
            return nextNodeInsts;
        }
        FlowTransition nodeTran = this.selectOptNodeTransition(currNode);
        if (nodeTran == null) {
            if (nodeInst.getRunToken().contains("R")) {
                this.nodeInstanceDao.updateObject((Serializable)nodeInst);
                this.flowInstanceDao.updateObject((Serializable)flowInst);
                return nextNodeInsts;
            }
            logger.error("\u6d41\u7a0b\uff1a" + nodeInst.getFlowInstId() + "\u8282\u70b9\uff1a" + options.getNodeInstId() + " " + currNode.getNodeName() + " \u6ca1\u6709\u627e\u5230\u7b26\u5408\u6d41\u8f6c\u6761\u4ef6\u7684\u540e\u7eed\u8282\u70b9\u3002");
            throw new WorkflowException(658, "\u6d41\u7a0b\uff1a" + nodeInst.getFlowInstId() + "\u8282\u70b9\uff1a" + options.getNodeInstId() + " " + currNode.getNodeName() + " \u6ca1\u6709\u627e\u5230\u7b26\u5408\u6d41\u8f6c\u6761\u4ef6\u7684\u540e\u7eed\u8282\u70b9\u3002");
        }
        FlowEngineImpl flowEngineImpl = this;
        synchronized (flowEngineImpl) {
            NodeInstance dbNodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInst.getNodeInstId());
            if (!dbNodeInst.checkIsInRunning()) {
                logger.error("\u6d41\u7a0b\uff1a" + nodeInst.getFlowInstId() + "\u8282\u70b9\uff1a" + options.getNodeInstId() + " " + currNode.getNodeName() + " \u5df2\u7ecf\u88ab\u5176\u4ed6\u7ebf\u7a0b\u63d0\u4ea4\uff0c\u8bf7\u907f\u514d\u91cd\u590d\u63d0\u4ea4\u3002");
                throw new WorkflowException(654, "\u6d41\u7a0b\uff1a" + nodeInst.getFlowInstId() + "\u8282\u70b9\uff1a" + options.getNodeInstId() + " " + currNode.getNodeName() + " \u5df2\u7ecf\u88ab\u5176\u4ed6\u7ebf\u7a0b\u63d0\u4ea4\uff0c\u8bf7\u907f\u514d\u91cd\u590d\u63d0\u4ea4\u3002");
            }
            this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        }
        FlowVariableTranslate flowVarTrans = FlowOptUtils.createVariableTranslate(nodeInst, flowInst, this.flowVariableDao, this, (FlowOptParamOptions)options);
        flowVarTrans.setFlowVarTrans(varTrans);
        String nextNodeId = nodeTran.getEndNodeId();
        nextNodeInsts = this.submitToNextNode((NodeInfo)this.flowNodeDao.getObjectById(nextNodeId), nodeInst.getRunToken(), flowInst, flowInfo, nodeInst, null, nodeTran, (FlowOptParamOptions)options, flowVarTrans, application);
        this.flowInstanceDao.updateObject((Serializable)flowInst);
        return nextNodeInsts;
    }

    public void disableOtherBranchNodes(String nodeInstId, String optUserCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null || !"N".equals(nodeInst.getNodeState())) {
            logger.error("\u627e\u4e0d\u5230\u8282\u70b9\u5b9e\u4f8b\uff1a" + nodeInstId + "\uff0c\u6216\u8005\u5b9e\u4f8b\u4e0d\u662f\u6b63\u5e38\u72b6\u6001\u7684\u8282\u70b9\u3002");
            return;
        }
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(nodeInst.getFlowInstId());
        if (flowInst == null) {
            logger.error("\u627e\u4e0d\u5230\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + nodeInst.getFlowInstId());
            return;
        }
        Date updateTime = DatetimeOpt.currentUtilDate();
        String preToken = NodeInstance.calcSuperToken((String)nodeInst.getRunToken());
        for (NodeInstance ni : flowInst.getFlowNodeInstances()) {
            FlowInstance subFlowInst;
            if (ni.getNodeInstId().equals(nodeInstId) || !"N".equals(ni.getNodeState()) && !"S".equals(ni.getNodeState()) && !"W".equals(ni.getNodeState()) && !"P".equals(ni.getNodeState()) || !preToken.equals(NodeInstance.calcSuperToken((String)ni.getRunToken()))) continue;
            if ("W".equals(ni.getNodeState()) && (subFlowInst = (FlowInstance)this.flowInstanceDao.getObjectById(ni.getSubFlowInstId())) != null) {
                FlowOptUtils.endInstance(subFlowInst, "F", optUserCode, this.flowInstanceDao);
                subFlowInst.setLastUpdateUser(optUserCode);
                this.flowInstanceDao.updateObject((Serializable)subFlowInst);
            }
            ni.setNodeState("F");
            ni.setLastUpdateUser(optUserCode);
            ni.setLastUpdateTime(updateTime);
            this.nodeInstanceDao.updateObject((Serializable)ni);
        }
        flowInst.setLastUpdateUser(optUserCode);
        flowInst.setLastUpdateTime(updateTime);
        this.flowInstanceDao.updateObject((Serializable)flowInst);
    }

    public String rollBackNode(String nodeInstId, String managerUserCode) {
        NodeInstance thisNodeInst;
        try {
            thisNodeInst = (NodeInstance)this.nodeInstanceDao.getObjectWithReferences(nodeInstId);
        }
        catch (NullPointerException e) {
            String msg = "\u6d41\u7a0b\u56de\u9000 flowRollback \u5931\u8d25, \u8282\u70b9\u4e0d\u5b58\u5728\uff1a nodeInstId: " + nodeInstId;
            logger.error(msg);
            throw new WorkflowException(651, msg);
        }
        if (!"N".equals(thisNodeInst.getNodeState())) {
            String msg = "\u6d41\u7a0b\u56de\u9000 flowRollback \u5931\u8d25, \u8282\u70b9\u72b6\u6001\u4e0d\u662f\u529e\u7406\u4e2d\uff1a nodeInstId: " + nodeInstId + "  nodeState :" + thisNodeInst.getNodeState();
            logger.error(msg);
            throw new WorkflowException(654, msg);
        }
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(thisNodeInst.getFlowInstId());
        if (flowInst == null) {
            logger.error("\u627e\u4e0d\u5230\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + thisNodeInst.getFlowInstId());
            throw new WorkflowException(652, "\u627e\u4e0d\u5230\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + thisNodeInst.getFlowInstId());
        }
        NodeInstance prevNodeInst = thisNodeInst.getPrevNodeInstId() != null ? (NodeInstance)this.nodeInstanceDao.getObjectWithReferences(thisNodeInst.getPrevNodeInstId()) : flowInst.getPareNodeInst(nodeInstId);
        boolean subProcess = false;
        FlowInstance prevFlowInst = null;
        if (prevNodeInst == null) {
            if (flowInst.getPreNodeInstId() == null) {
                String msg = "\u6d41\u7a0b\u56de\u9000 rollBackNode \u5931\u8d25,\u627e\u4e0d\u5230\u4e0a\u4e00\u8282\u70b9";
                logger.error(msg);
                throw new WorkflowException(651, msg);
            }
            subProcess = true;
            prevNodeInst = (NodeInstance)this.nodeInstanceDao.getObjectWithReferences(flowInst.getPreNodeInstId());
            prevFlowInst = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(flowInst.getPreInstId());
        }
        NodeInfo nodedef = (NodeInfo)this.flowNodeDao.getObjectById(prevNodeInst.getNodeId());
        HashSet<NodeInstance> pns = new HashSet<NodeInstance>();
        while (StringUtils.equalsAny((CharSequence)nodedef.getNodeType(), (CharSequence[])new CharSequence[]{"D", "E", "S"})) {
            pns.add(prevNodeInst);
            String currentNodeInstId = prevNodeInst.getPrevNodeInstId();
            prevNodeInst = currentNodeInstId != null ? (NodeInstance)this.nodeInstanceDao.getObjectWithReferences(currentNodeInstId) : flowInst.getPareNodeInst(null);
            if (prevNodeInst == null) {
                Object nodeType = "";
                if (StringUtils.equals((CharSequence)nodedef.getNodeType(), (CharSequence)"D")) {
                    nodeType = "\u81ea\u52a8\u8fd0\u884c\u8282\u70b9";
                } else if (StringUtils.equals((CharSequence)nodedef.getNodeType(), (CharSequence)"E")) {
                    nodeType = "\u540c\u6b65\u8282\u70b9";
                } else if (StringUtils.equals((CharSequence)nodedef.getNodeType(), (CharSequence)"S")) {
                    nodeType = "\u5b50\u6d41\u7a0b";
                }
                String msg = "\u6d41\u7a0b\u56de\u9000 rollBackNode \u5931\u8d25,\u7ecf\u8fc7" + (String)nodeType + "\u540e,\u627e\u4e0d\u5230\u4e0a\u4e00\u8282\u70b9";
                logger.error(msg);
                throw new WorkflowException(654, msg);
            }
            if (prevFlowInst != null) {
                for (NodeInstance no : prevFlowInst.getFlowNodeInstances()) {
                    if (!"N,S,P".contains(no.getNodeState()) || !prevNodeInst.getNodeId().equals(no.getNodeId())) continue;
                    String msg = "\u6d41\u7a0b\u56de\u9000 rollBackNode \u5931\u8d25,\u7236\u6d41\u7a0b\u4e2d\u7684\u8282\u70b9\u5df2\u7ecf\u88ab\u9000\u56de";
                    logger.error(msg);
                    throw new WorkflowException(654, msg);
                }
            }
            nodedef = (NodeInfo)this.flowNodeDao.getObjectById(prevNodeInst.getNodeId());
        }
        pns.add(prevNodeInst);
        Date updateTime = DatetimeOpt.currentUtilDate();
        thisNodeInst.setNodeState("B");
        for (NodeInstance pn : pns) {
            pn.setNodeState("B");
            this.nodeInstanceDao.updateObject((Serializable)pn);
        }
        thisNodeInst.setLastUpdateUser(managerUserCode);
        thisNodeInst.setLastUpdateTime(updateTime);
        String lastNodeInstId = UuidOpt.getUuidAsString32();
        NodeInstance nextNodeInst = flowInst.newNodeInstance();
        if (subProcess) {
            nextNodeInst.setFlowInstId(flowInst.getPreInstId());
            flowInst.setInstState("F");
        }
        nextNodeInst.copyNotNullProperty(prevNodeInst);
        nextNodeInst.setNodeInstId(lastNodeInstId);
        nextNodeInst.setCreateTime(updateTime);
        nextNodeInst.setNodeState("N");
        nextNodeInst.setTaskAssigned(prevNodeInst.getTaskAssigned());
        nextNodeInst.setLastUpdateUser(managerUserCode);
        nextNodeInst.setLastUpdateTime(updateTime);
        flowInst.addNodeInstance(nextNodeInst);
        this.nodeInstanceDao.mergeObject((Serializable)thisNodeInst);
        this.nodeInstanceDao.saveNewObject((Serializable)nextNodeInst);
        this.flowInstanceDao.updateObject((Serializable)flowInst);
        NodeEventSupport nodeEventExecutor = NodeEventSupportFactory.createNodeEventSupportBean(nodedef, this);
        nodeEventExecutor.runAfterCreate(flowInst, nextNodeInst, nodedef, managerUserCode);
        OperationLogCenter.log((OperationLog)FlowOptUtils.createActionLog(managerUserCode, flowInst.getFlowInstId(), "\u56de\u9000\u5230\u4e0a\u4e00\u4e2a\u8282\u70b9;"));
        return lastNodeInstId;
    }

    public boolean nodeCanBeReclaim(String nodeInstId) {
        NodeInstance thisnode = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (thisnode == null) {
            return false;
        }
        FlowInstance flow = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(thisnode.getFlowInstId());
        if (flow == null) {
            return false;
        }
        if (!"N".equals(flow.getInstState())) {
            return false;
        }
        int nns = 0;
        for (NodeInstance nextNode : flow.getFlowNodeInstances()) {
            if (!thisnode.getNodeInstId().equals(nextNode.getPrevNodeInstId())) continue;
            ++nns;
            if ("N".equals(nextNode.getNodeState())) continue;
            return false;
        }
        return nns > 0;
    }

    public NodeInstance reclaimNode(String nodeInstId, String userCode) {
        NodeInstance thisnode = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (thisnode == null) {
            throw new ObjectException(611, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u8282\u70b9\u3002");
        }
        FlowInstance flow = (FlowInstance)this.flowInstanceDao.getObjectWithReferences(thisnode.getFlowInstId());
        if (flow == null) {
            throw new ObjectException(611, "\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u3002");
        }
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = thisnode.getUserCode();
        }
        if (!"N".equals(flow.getInstState())) {
            throw new ObjectException(611, "\u6d41\u7a0b\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u4e0d\u80fd\u88ab\u64a4\u56de\uff0c\u53ea\u6709\u8fd0\u884c\u4e2d\u7684\u6d41\u7a0b\u624d\u53ef\u4ee5\u88ab\u64a4\u56de\u3002");
        }
        boolean canBeReclain = true;
        ArrayList<Object> nextNodes = new ArrayList<Object>();
        for (Object nextNode : flow.getFlowNodeInstances()) {
            if (!thisnode.getNodeInstId().equals(nextNode.getPrevNodeInstId())) continue;
            if (!"N".equals(nextNode.getNodeState())) {
                canBeReclain = false;
                break;
            }
            nextNodes.add(nextNode);
        }
        if (!canBeReclain) {
            throw new ObjectException(611, "\u540e\u7eed\u8282\u70b9\u5df2\u7ecf\u88ab\u64cd\u4f5c\uff0c\u4e0d\u80fd\u88ab\u64a4\u56de\u3002");
        }
        if (nextNodes.isEmpty()) {
            throw new ObjectException(611, "\u627e\u4e0d\u5230\u540e\u7eed\u8282\u70b9\uff0c\u4e0d\u80fd\u88ab\u64a4\u56de\u3002");
        }
        Date updateTime = DatetimeOpt.currentUtilDate();
        for (NodeInstance nodeInstance : nextNodes) {
            nodeInstance.setNodeState("B");
            nodeInstance.setLastUpdateUser(userCode);
            nodeInstance.setLastUpdateTime(updateTime);
            this.nodeInstanceDao.updateObject((Serializable)nodeInstance);
        }
        NodeInstance nextNodeInst = flow.newNodeInstance();
        nextNodeInst.copyNotNullProperty(thisnode);
        nextNodeInst.setNodeInstId(UuidOpt.getUuidAsString32());
        nextNodeInst.setNodeState("N");
        nextNodeInst.setTaskAssigned(thisnode.getTaskAssigned());
        nextNodeInst.setLastUpdateUser(userCode);
        nextNodeInst.setLastUpdateTime(updateTime);
        flow.addNodeInstance(nextNodeInst);
        this.nodeInstanceDao.saveNewObject((Serializable)nextNodeInst);
        return nextNodeInst;
    }

    private Set<NodeInfo> viewRouterNextNodeInside(FlowInstance flowInst, NodeInstance preNodeInst, NodeInfo currNode, FlowOptParamOptions options, FlowVariableTranslate varTrans) {
        HashSet<NodeInfo> nextNodes = new HashSet<NodeInfo>();
        Set<FlowTransition> trans = this.selectTransitions(flowInst, preNodeInst, preNodeInst.getRunToken(), currNode, options, varTrans);
        for (FlowTransition tran : trans) {
            NodeInfo tempNode = (NodeInfo)this.flowNodeDao.getObjectById(tran.getEndNodeId());
            if ("C".equals(tempNode.getNodeType())) {
                nextNodes.add(tempNode);
                continue;
            }
            if (!"R".equals(tempNode.getNodeType())) continue;
            nextNodes.addAll(this.viewRouterNextNodeInside(flowInst, preNodeInst, tempNode, options, varTrans));
        }
        return nextNodes;
    }

    public Set<NodeInfo> viewNextNode(SubmitOptOptions options) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(options.getNodeInstId());
        if (nodeInst == null) {
            logger.error("\u627e\u4e0d\u5230\u8282\u70b9\u5b9e\u4f8b\uff1a" + options.getNodeInstId());
            return null;
        }
        FlowInstance flowInst = this.flowManager.getFlowInstance(nodeInst.getFlowInstId());
        if (flowInst == null) {
            logger.error("\u627e\u4e0d\u5230\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + nodeInst.getFlowInstId());
            return null;
        }
        NodeInfo currNode = (NodeInfo)this.flowNodeDao.getObjectById(nodeInst.getNodeId());
        Set<NodeInfo> nextNodes = new HashSet<NodeInfo>();
        NodeInfo nextNode = this.selectNextNodeByNodeId(currNode.getNodeId());
        if (nextNode != null) {
            if ("C".equals(nextNode.getNodeType())) {
                nextNodes.add(nextNode);
            } else if ("R".equals(nextNode.getNodeType())) {
                FlowVariableTranslate flowVarTrans = FlowOptUtils.createVariableTranslate(nodeInst, flowInst, this.flowVariableDao, this, null);
                ObjectUserUnitVariableTranslate varTrans = new ObjectUserUnitVariableTranslate((Object)CollectionsOpt.unionTwoMap(options.getVariables() == null ? new HashMap() : options.getVariables(), options.getGlobalVariables() == null ? new HashMap() : options.getGlobalVariables()));
                flowVarTrans.setFlowVarTrans((UserUnitVariableTranslate)varTrans);
                nextNodes = this.viewRouterNextNodeInside(flowInst, nodeInst, nextNode, (FlowOptParamOptions)options, flowVarTrans);
            }
        }
        return nextNodes;
    }

    public Set<String> viewNextNodeOperator(String nextNodeId, SubmitOptOptions options) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(options.getNodeInstId());
        if (nodeInst == null) {
            logger.error("\u627e\u4e0d\u5230\u8282\u70b9\u5b9e\u4f8b\uff1a" + options.getNodeInstId());
            return null;
        }
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(nodeInst.getFlowInstId());
        if (flowInst == null) {
            logger.error("\u627e\u4e0d\u5230\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + nodeInst.getFlowInstId());
            return null;
        }
        NodeInfo nextNode = (NodeInfo)this.flowNodeDao.getObjectById(nextNodeId);
        if (!"S".equals(nextNode.getNodeType())) {
            FlowVariableTranslate flowVarTrans = FlowOptUtils.createVariableTranslate(nodeInst, flowInst, this.flowVariableDao, this, null);
            ObjectUserUnitVariableTranslate varTrans = new ObjectUserUnitVariableTranslate((Object)CollectionsOpt.unionTwoMap(options.getVariables() == null ? new HashMap() : options.getVariables(), options.getGlobalVariables() == null ? new HashMap() : options.getGlobalVariables()));
            flowVarTrans.setFlowVarTrans((UserUnitVariableTranslate)varTrans);
            LeftRightPair<Set<String>, Set<String>> unitAndUser = this.calcNodeUnitAndOperator(flowInst, nodeInst, nodeInst.getRunToken(), nextNode, (FlowOptParamOptions)SubmitOptOptions.create().user(options.getUserCode()).unit(options.getUnitCode()), flowVarTrans);
            return (Set)unitAndUser.getRight();
        }
        return new HashSet<String>();
    }

    private String checkTaskGrantor(NodeInstance nodeInst, String userCode) {
        if (StringUtils.equals((CharSequence)userCode, (CharSequence)nodeInst.getUserCode())) {
            return userCode;
        }
        int granted = this.roleRelegateDao.checkGrantee(nodeInst.getUserCode(), userCode, nodeInst.getUnitCode(), nodeInst.getRoleCode());
        if (granted > 0) {
            return nodeInst.getUserCode();
        }
        return null;
    }

    public String getTaskGrantor(String nodeInstId, String userCode) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return null;
        }
        return this.checkTaskGrantor(nodeInst, userCode);
    }

    public NodeInstance createPrepNodeInst(String flowInstId, String curNodeInstId, String nodeCode, String createUser, String userCode, String unitCode) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (flowInst == null) {
            logger.error("\u627e\u4e0d\u5230\u6d41\u7a0b\u5b9e\u4f8b\uff1a" + flowInstId);
            return null;
        }
        List<NodeInfo> nodeList = this.flowNodeDao.listNodeByNodecode(flowInst.getFlowCode(), flowInst.getVersion(), nodeCode);
        if (nodeList == null || nodeList.size() < 1) {
            return null;
        }
        if (nodeList.size() > 1) {
            logger.error("\u6d41\u7a0b " + flowInst.getFlowCode() + "\uff08\u7248\u672c\u53f7" + flowInst.getVersion() + "\uff09\u4e2d\u5bf9\u5e94\u73af\u8282\u4ee3\u7801\u4e3a" + nodeCode + "\u7684\u8282\u70b9\u6709\u591a\u4e2a\uff0c\u7cfb\u7edf\u968f\u673a\u7684\u521b\u5efa\u4e00\u4e2a\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u548c\u7ba1\u7406\u4eba\u5458\u8054\u7cfb\u3002");
        }
        String nodeId = nodeList.get(0).getNodeId();
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(curNodeInstId);
        if (nodeInst == null || !"N".equals(nodeInst.getNodeState()) && !"S".equals(nodeInst.getNodeState())) {
            logger.error("\u627e\u4e0d\u5230\u8282\u70b9\u5b9e\u4f8b\uff1a" + curNodeInstId);
            return null;
        }
        if (nodeInst.getRunToken().contains("R")) {
            logger.error("\u6e38\u79bb\u8282\u70b9\u4e0d\u80fd\u521b\u5efa\u524d\u7f6e\u8282\u70b9\uff1a" + curNodeInstId + " token:" + nodeInst.getRunToken() + "\u3002");
            return null;
        }
        FlowInfo flowInfo = this.flowDefDao.getFlowDefineByID(flowInst.getFlowCode(), flowInst.getVersion());
        NodeInfo nextNode = (NodeInfo)this.flowNodeDao.getObjectById(nodeId);
        String lastNodeInstId = UuidOpt.getUuidAsString32();
        NodeInstance nextNodeInst = FlowOptUtils.createNodeInst(unitCode, userCode, flowInst, nodeInst, flowInfo, nextNode, null, null);
        nextNodeInst.setNodeInstId(lastNodeInstId);
        nextNodeInst.setPrevNodeInstId(curNodeInstId);
        nextNodeInst.setRunToken(nodeInst.getRunToken() + "." + "L");
        nextNodeInst.setUserCode(userCode);
        nextNodeInst.setTaskAssigned("S");
        nextNodeInst.setTransPath("");
        nodeInst.setNodeState("S");
        this.nodeInstanceDao.saveNewObject((Serializable)nextNodeInst);
        this.nodeInstanceDao.updateObject((Serializable)nodeInst);
        return nextNodeInst;
    }

    public NodeInstance createIsolatedNodeInst(String flowInstId, String curNodeInstId, String nodeCode, String createUser, String userCode, String unitCode) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (flowInst == null) {
            return null;
        }
        List<NodeInfo> nodeList = this.flowNodeDao.listNodeByNodecode(flowInst.getFlowCode(), flowInst.getVersion(), nodeCode);
        if (nodeList == null || nodeList.size() < 1) {
            return null;
        }
        if (nodeList.size() > 1) {
            logger.error("\u6d41\u7a0b " + flowInst.getFlowCode() + "\uff08\u7248\u672c\u53f7" + flowInst.getVersion() + "\uff09\u4e2d\u5bf9\u5e94\u73af\u8282\u4ee3\u7801\u4e3a" + nodeCode + "\u7684\u8282\u70b9\u6709\u591a\u4e2a\uff0c\u7cfb\u7edf\u968f\u673a\u7684\u521b\u5efa\u4e00\u4e2a\uff0c\u5982\u6709\u95ee\u9898\u8bf7\u548c\u7ba1\u7406\u4eba\u5458\u8054\u7cfb\u3002");
        }
        NodeInstance nodeInst = null;
        nodeInst = NODE_INST_ZERO.equals(curNodeInstId) ? new NodeInstance() : (NodeInstance)this.nodeInstanceDao.getObjectById(curNodeInstId);
        if (nodeInst == null) {
            logger.error("\u627e\u4e0d\u5230\u8282\u70b9\u5b9e\u4f8b\uff1a" + curNodeInstId);
            return null;
        }
        String nodeId = nodeList.get(0).getNodeId();
        FlowInfo flowInfo = this.flowDefDao.getFlowDefineByID(flowInst.getFlowCode(), flowInst.getVersion());
        NodeInfo nextNode = (NodeInfo)this.flowNodeDao.getObjectById(nodeId);
        String lastNodeInstId = UuidOpt.getUuidAsString32();
        NodeInstance nextNodeInst = FlowOptUtils.createNodeInst(unitCode, createUser, flowInst, nodeInst, flowInfo, nextNode, null, null);
        nextNodeInst.setNodeInstId(lastNodeInstId);
        nextNodeInst.setPrevNodeInstId(curNodeInstId);
        nextNodeInst.setRunToken(nodeInst.getRunToken() + "." + "R");
        nextNodeInst.setUserCode(userCode);
        nextNodeInst.setTaskAssigned("S");
        nextNodeInst.setTransPath("");
        this.nodeInstanceDao.saveNewObject((Serializable)nextNodeInst);
        return nextNodeInst;
    }

    public NodeInstance duplicateMultiNodeInst(String flowInstId, String multiNodeCode, String createUser, String userCode, String unitCode) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        if (flowInst == null) {
            return null;
        }
        List<NodeInfo> nodeList = this.flowNodeDao.listNodeByNodecode(flowInst.getFlowCode(), flowInst.getVersion(), multiNodeCode);
        if (nodeList == null || nodeList.size() < 1) {
            return null;
        }
        this.flowInstanceDao.fetchObjectReference((Serializable)flowInst, "flowNodeInstances");
        Set activeNodes = flowInst.getActiveNodeInstances();
        if (activeNodes == null || activeNodes.size() == 0) {
            return null;
        }
        for (NodeInstance inst : activeNodes) {
            String ind;
            int dotPos = inst.getRunToken().lastIndexOf(46);
            int loopInd = -1;
            if (dotPos > 0 && StringRegularOpt.isDigit((String)(ind = inst.getRunToken().substring(dotPos + 1)))) {
                loopInd = NumberBaseOpt.parseInteger((String)ind, (Integer)-1);
            }
            if (loopInd < 0) continue;
            for (NodeInfo node : nodeList) {
                if (!StringUtils.equals((CharSequence)node.getNodeId(), (CharSequence)inst.getNodeId())) continue;
                String lastNodeInstId = UuidOpt.getUuidAsString32();
                NodeInstance nextNodeInst = new NodeInstance();
                nextNodeInst.copy(inst);
                nextNodeInst.setNodeInstId(lastNodeInstId);
                nextNodeInst.setTaskAssigned("S");
                nextNodeInst.setUserCode(userCode);
                nextNodeInst.setUnitCode(unitCode);
                nextNodeInst.setLastUpdateUser(createUser);
                nextNodeInst.setLastUpdateTime(DatetimeOpt.currentUtilDate());
                nextNodeInst.setTimeLimit(nextNodeInst.getPromiseTime());
                int tokenInd = flowInst.fetchTheMaxMultiNodeTokenInd(node.getNodeId()) + 1;
                nextNodeInst.setRunToken(inst.getRunToken().substring(0, dotPos) + "." + tokenInd);
                this.nodeInstanceDao.saveNewObject((Serializable)nextNodeInst);
                return nextNodeInst;
            }
        }
        return null;
    }

    public void assignFlowWorkTeam(String flowInstId, String roleCode, String runToken, List<String> userCodeSet) {
        if (userCodeSet == null) {
            return;
        }
        Date assignDate = new Date(System.currentTimeMillis());
        List<FlowWorkTeam> flowWorkTeams = this.flowTeamDao.listFlowWorkTeamByRole(flowInstId, roleCode, runToken);
        if (flowWorkTeams != null) {
            for (FlowWorkTeam team : flowWorkTeams) {
                if (userCodeSet.contains(team.getUserCode())) continue;
                this.flowTeamDao.deleteObject((Serializable)team);
            }
        }
        for (String usercode : userCodeSet) {
            if (!StringUtils.isNotBlank((CharSequence)usercode)) continue;
            boolean indb = false;
            for (FlowWorkTeam team : flowWorkTeams) {
                if (!usercode.equals(team.getUserCode())) continue;
                indb = true;
                break;
            }
            if (indb) continue;
            this.flowTeamDao.saveNewObject((Serializable)new FlowWorkTeam(flowInstId, usercode, roleCode, runToken, assignDate));
        }
    }

    public void assignFlowWorkTeamByNode(String nodeInstId, String roleCode, List<String> userCodeSet) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        this.assignFlowWorkTeam(nodeInst.getFlowInstId(), roleCode, nodeInst.getRunToken(), userCodeSet);
    }

    public void assignFlowWorkTeam(String flowInstId, String roleCode, List<String> userCodeSet) {
        this.assignFlowWorkTeam(flowInstId, roleCode, "T", userCodeSet);
    }

    public void deleteFlowWorkTeam(String flowInstId, String roleCode, String userCode) {
        this.flowTeamDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"flowInstId", flowInstId, "userCode", userCode, "roleCode", roleCode}));
    }

    public void deleteFlowWorkTeam(String flowInstId, String roleCode) {
        this.flowTeamDao.deleteFlowWorkTeam(flowInstId, roleCode);
    }

    public Map<String, List<String>> viewFlowWorkTeam(String flowInstId) {
        List<FlowWorkTeam> users = this.flowTeamDao.listFlowWorkTeam(flowInstId);
        HashMap<String, List<String>> team = new HashMap<String, List<String>>();
        if (null != users) {
            for (FlowWorkTeam user : users) {
                ArrayList<String> us = (ArrayList<String>)team.get(user.getRoleCode());
                if (us == null) {
                    us = new ArrayList<String>();
                }
                us.add(user.getUserCode());
                team.put(user.getRoleCode(), us);
            }
        }
        return team;
    }

    public List<String> viewFlowWorkTeam(String flowInstId, String roleCode) {
        List<FlowWorkTeam> users = this.flowTeamDao.listFlowWorkTeamByRole(flowInstId, roleCode);
        ArrayList<String> us = new ArrayList<String>();
        for (FlowWorkTeam user : users) {
            us.add(user.getUserCode());
        }
        return us;
    }

    public List<FlowWorkTeam> viewFlowWorkTeamList(String flowInstId, String roleCode) {
        return this.flowTeamDao.listFlowWorkTeamByRole(flowInstId, roleCode);
    }

    public List<FlowWorkTeam> viewFlowWorkTeamList(String flowInstId, String roleCode, String authdesc) {
        return this.flowTeamDao.listFlowWorkTeam(flowInstId, roleCode, authdesc);
    }

    public FlowVariable viewNodeVariable(String flowInstId, String runToken, String varName) {
        FlowVariableId id = new FlowVariableId(flowInstId, runToken, varName);
        return (FlowVariable)this.flowVariableDao.getObjectById(id);
    }

    public void assignFlowOrganize(String flowInstId, String roleCode, String unitCode) {
        Date assignDate = new Date(System.currentTimeMillis());
        FlowOrganize dbObj = (FlowOrganize)this.flowOrganizeDao.getObjectById(new FlowOrganizeId(flowInstId, unitCode, roleCode));
        if (dbObj == null || StringBaseOpt.isNvl((String)dbObj.getUnitCode())) {
            this.flowOrganizeDao.mergeObject((Serializable)new FlowOrganize(flowInstId, unitCode, roleCode, assignDate));
        }
    }

    public void assignFlowOrganize(String flowInstId, String roleCode, List<String> unitCodeSet) {
        if (unitCodeSet == null) {
            return;
        }
        Date assignDate = new Date(System.currentTimeMillis());
        for (String unitCode : unitCodeSet) {
            FlowOrganize dbObj;
            if (unitCode == null || "".equals(unitCode) || (dbObj = (FlowOrganize)this.flowOrganizeDao.getObjectById(new FlowOrganizeId(flowInstId, unitCode, roleCode))) != null && !StringBaseOpt.isNvl((String)dbObj.getUnitCode())) continue;
            this.flowOrganizeDao.mergeObject((Serializable)new FlowOrganize(flowInstId, unitCode, roleCode, assignDate));
        }
    }

    public void assignFlowOrganize(String flowInstId, String roleCode, String unitCode, String authDesc) {
        Date assignDate = new Date(System.currentTimeMillis());
        FlowOrganize dbObj = (FlowOrganize)this.flowOrganizeDao.getObjectById(new FlowOrganizeId(flowInstId, unitCode, roleCode));
        if (dbObj == null || StringBaseOpt.isNvl((String)dbObj.getUnitCode())) {
            FlowOrganize orgObj = new FlowOrganize(flowInstId, unitCode, roleCode, assignDate);
            orgObj.setAuthDesc(authDesc);
            this.flowOrganizeDao.mergeObject((Serializable)orgObj);
        }
    }

    public void assignFlowOrganize(String flowInstId, String roleCode, List<String> unitCodeSet, String authDesc) {
        Date assignDate = new Date(System.currentTimeMillis());
        if (unitCodeSet != null) {
            for (String unitCode : unitCodeSet) {
                FlowOrganize dbObj;
                if (unitCode == null || "".equals(unitCode) || (dbObj = (FlowOrganize)this.flowOrganizeDao.getObjectById(new FlowOrganizeId(flowInstId, unitCode, roleCode))) != null && !StringBaseOpt.isNvl((String)dbObj.getUnitCode())) continue;
                FlowOrganize orgObj = new FlowOrganize(flowInstId, unitCode, roleCode, assignDate);
                orgObj.setAuthDesc(authDesc);
                this.flowOrganizeDao.mergeObject((Serializable)orgObj);
            }
        }
    }

    public void deleteFlowOrganize(String flowInstId, String roleCode, String unitCode) {
        this.flowOrganizeDao.deleteObjectById(new FlowOrganizeId(flowInstId, unitCode, roleCode));
    }

    public void deleteFlowOrganize(String flowInstId, String roleCode) {
        this.flowOrganizeDao.deleteFlowOrganize(flowInstId, roleCode);
    }

    public void deleteFlowOrganizeByAuth(String flowInstId, String roleCode, String authDesc) {
        this.flowOrganizeDao.deleteFlowOrganize(flowInstId, roleCode, authDesc);
    }

    public Map<String, List<String>> viewFlowOrganize(String flowInstId) {
        List<FlowOrganize> units = this.flowOrganizeDao.listFlowOrganize(flowInstId);
        HashMap<String, List<String>> orgs = new HashMap<String, List<String>>();
        if (null != units) {
            for (FlowOrganize unit : units) {
                ArrayList<String> us = (ArrayList<String>)orgs.get(unit.getRoleCode());
                if (us == null) {
                    us = new ArrayList<String>();
                }
                us.add(unit.getUnitCode());
                orgs.put(unit.getRoleCode(), us);
            }
        }
        return orgs;
    }

    public List<String> viewFlowOrganize(String flowInstId, String roleCode) {
        List<FlowOrganize> units = this.flowOrganizeDao.listFlowOrganizeByRole(flowInstId, roleCode);
        ArrayList<String> orgs = new ArrayList<String>();
        if (null != units) {
            for (FlowOrganize unit : units) {
                orgs.add(unit.getUnitCode());
            }
        }
        return orgs;
    }

    public List<FlowOrganize> viewFlowOrganizeList(String flowInstId, String roleCode) {
        return new ArrayList<FlowOrganize>(this.flowOrganizeDao.listFlowOrganizeByRole(flowInstId, roleCode));
    }

    public List<FlowOrganize> viewFlowOrganizeList(String flowInstId, String roleCode, String authDesc) {
        return new ArrayList<FlowOrganize>(this.flowOrganizeDao.listFlowOrganize(flowInstId, roleCode, authDesc));
    }

    public void saveFlowNodeVariable(String flowInstId, String runToken, String sVar, Object sValue) {
        String objStr = StringBaseOpt.objectToString((Object)sValue);
        if (StringUtils.isBlank((CharSequence)objStr)) {
            this.flowVariableDao.deleteObjectById(new FlowVariableId(flowInstId, runToken, sVar));
            return;
        }
        FlowVariableId cid = new FlowVariableId(flowInstId, runToken, sVar);
        String varType = sValue.getClass().isArray() || sValue instanceof Collection || objStr.indexOf(44) > 1 ? "E" : "S";
        FlowVariable varO = (FlowVariable)this.flowVariableDao.getObjectById(cid);
        if (varO == null) {
            varO = new FlowVariable(flowInstId, runToken, sVar, objStr, varType);
            this.flowVariableDao.saveNewObject((Serializable)varO);
        } else {
            varO.setVarType(varType);
            varO.setVarValue(objStr);
            this.flowVariableDao.updateObject((Serializable)varO);
        }
    }

    public void saveFlowVariable(String flowInstId, String sVar, Object sValue) {
        this.saveFlowNodeVariable(flowInstId, "T", sVar, sValue);
    }

    public void saveFlowNodeVariable(String nodeInstId, String sVar, Object sValue) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            logger.error("\u627e\u4e0d\u5230\u8282\u70b9\u5b9e\u4f8b\uff1a" + nodeInstId);
            return;
        }
        String nodeToken = nodeInst.getRunToken();
        this.saveFlowNodeVariable(nodeInst.getFlowInstId(), nodeToken, sVar, sValue);
    }

    public List<FlowVariable> listFlowVariables(String flowInstId) {
        List<FlowVariable> lv = this.flowVariableDao.listFlowVariables(flowInstId);
        if (lv == null) {
            lv = new ArrayList<FlowVariable>();
        }
        return lv;
    }

    public List<FlowVariable> viewFlowVariablesByVarName(String flowInstId, String varName) {
        return this.flowVariableDao.viewFlowVariablesByVarname(flowInstId, varName);
    }

    private List<UserTask> listNodeOperators(NodeInstance nodeInst) {
        UnitInfo ui;
        UserTask userTask = this.userTaskListDao.getNodeTaskInfo(nodeInst.getNodeInstId());
        if ("S".equals(nodeInst.getTaskAssigned())) {
            return CollectionsOpt.createList((Object[])new UserTask[]{userTask});
        }
        if (StringUtils.isBlank((CharSequence)nodeInst.getUnitCode())) {
            FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(nodeInst.getFlowInstId());
            ui = this.platformEnvironment.loadUnitInfo(flowInst.getUnitCode());
        } else {
            ui = this.platformEnvironment.loadUnitInfo(nodeInst.getUnitCode());
        }
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(ui.getTopUnit());
        Set optUsers = SysUserFilterEngine.getUsersByRoleAndUnit((UserUnitFilterCalcContext)context, (String)"GW", (String)userTask.getRoleCode(), (String)userTask.getUnitCode());
        if (optUsers == null || optUsers.size() == 0) {
            return null;
        }
        ArrayList<UserTask> userTaskList = new ArrayList<UserTask>(optUsers.size());
        for (String userCode : optUsers) {
            UserTask ut = new UserTask();
            ut.copy(userTask);
            ut.setUserCode(userCode);
            userTaskList.add(ut);
        }
        return userTaskList;
    }

    public List<UserTask> listNodeOperators(String nodeInstId) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        return nodeInst == null ? null : this.listNodeOperators(nodeInst);
    }

    public List<UserTask> listFlowActiveNodeOperators(String flowInstId) {
        List<NodeInstance> nodeInsts = this.nodeInstanceDao.listNodeInstByState(flowInstId, "N");
        if (nodeInsts == null || nodeInsts.size() == 0) {
            return null;
        }
        ArrayList<UserTask> userTasks = new ArrayList<UserTask>(nodeInsts.size() * 4);
        for (NodeInstance ni : nodeInsts) {
            List<UserTask> uts = this.listNodeOperators(ni);
            if (uts == null) continue;
            userTasks.addAll(uts);
        }
        return userTasks;
    }

    public List<UserTask> listUserDynamicTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        String userCode = StringBaseOpt.castObjectToString((Object)searchColumn.get("userCode"));
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        String topUnit = StringBaseOpt.castObjectToString((Object)searchColumn.get("topUnit"));
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(topUnit);
        List iUserUnits = context.listUserUnits(userCode);
        return this.userTaskListDao.listUserDynamicTask(iUserUnits, searchColumn, pageDesc);
    }

    public ResponseData dubboUserDynamicTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        PageDesc pageDescCopy = new PageDesc();
        pageDescCopy.copy(pageDesc);
        List<UserTask> userTaskList = this.listUserDynamicTask(searchColumn, pageDescCopy);
        PageQueryResult pageQueryResult = PageQueryResult.createResultMapDict(userTaskList, (PageDesc)pageDescCopy);
        return pageQueryResult.toResponseData();
    }

    public List<UserTask> listUserStaticTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return this.userTaskListDao.listUserStaticTask(searchColumn, pageDesc);
    }

    public ResponseData dubboUserStaticTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        PageDesc pageDescCopy = new PageDesc();
        pageDescCopy.copy(pageDesc);
        List<UserTask> userTaskList = this.listUserStaticTask(searchColumn, pageDescCopy);
        PageQueryResult pageQueryResult = PageQueryResult.createResultMapDict(userTaskList, (PageDesc)pageDescCopy);
        return pageQueryResult.toResponseData();
    }

    public List<UserTask> listUserGrantorTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return this.userTaskListDao.listUserGrantorTask(searchColumn, pageDesc);
    }

    public ResponseData dubboUserGrantorTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        PageDesc pageDescCopy = new PageDesc();
        pageDescCopy.copy(pageDesc);
        List<UserTask> userTaskList = this.listUserGrantorTask(searchColumn, pageDescCopy);
        PageQueryResult pageQueryResult = PageQueryResult.createResultMapDict(userTaskList, (PageDesc)pageDescCopy);
        return pageQueryResult.toResponseData();
    }

    public List<UserTask> listUserStaticAndGrantorTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        return this.userTaskListDao.listUserStaticAndGrantorTask(searchColumn, pageDesc);
    }

    public ResponseData dubboUserStaticAndGrantorTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        PageDesc pageDescCopy = new PageDesc();
        pageDescCopy.copy(pageDesc);
        List<UserTask> userTaskList = this.listUserStaticAndGrantorTask(searchColumn, pageDescCopy);
        PageQueryResult pageQueryResult = PageQueryResult.createResultMapDict(userTaskList, (PageDesc)pageDescCopy);
        return pageQueryResult.toResponseData();
    }

    public List<UserTask> listUserAllTask(Map<String, Object> filterMap, PageDesc pageDesc) {
        String userCode = StringBaseOpt.castObjectToString((Object)filterMap.get("userCode"));
        if (StringUtils.isBlank((CharSequence)userCode)) {
            return null;
        }
        String topUnit = StringBaseOpt.castObjectToString((Object)filterMap.get("topUnit"));
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(topUnit);
        List iUserUnits = context.listUserUnits(userCode);
        Integer count = iUserUnits.size();
        for (int i = 0; i < count; ++i) {
            UserUnit iUserUnit = (UserUnit)iUserUnits.get(i);
            filterMap.put("userUnitCode" + i, iUserUnit.getUnitCode());
            filterMap.put("userStation" + i, iUserUnit.getUserStation());
        }
        return this.userTaskListDao.listUserAllTask(iUserUnits, filterMap, pageDesc);
    }

    public ResponseData dubboUserAllTask(Map<String, Object> searchColumn, PageDesc pageDesc) {
        PageDesc pageDescCopy = new PageDesc();
        pageDescCopy.copy(pageDesc);
        List<UserTask> userTaskList = this.listUserAllTask(searchColumn, pageDescCopy);
        PageQueryResult pageQueryResult = PageQueryResult.createResultMapDict(userTaskList, (PageDesc)pageDescCopy);
        return pageQueryResult.toResponseData();
    }

    public boolean canAccess(String nodeInstId, String userCode) {
        if (userCode == null) {
            return false;
        }
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null) {
            return false;
        }
        return StringUtils.isNotBlank((CharSequence)this.checkTaskGrantor(nodeInst, userCode));
    }

    public List<UserTask> listUserCompleteTasks(Map<String, Object> filterMap, PageDesc pageDesc) {
        Object nodeCodes = filterMap.get("nodeCodes");
        if (nodeCodes != null) {
            filterMap.put("nodeCodes", nodeCodes.toString().split(","));
        }
        return this.userTaskListDao.listUserCompletedTask(filterMap, pageDesc);
    }

    public List<FlowWarning> listFlowWarning(Map<String, Object> filterMap, PageDesc pageDesc) {
        return new ArrayList<FlowWarning>(this.runtimeWarningDao.listObjectsByProperties(filterMap, pageDesc));
    }

    public List<FlowWarning> listFlowWarningByInst(String flowInstId, PageDesc pageDesc) {
        return new ArrayList<FlowWarning>(this.runtimeWarningDao.listFlowWarningByInst(flowInstId, pageDesc));
    }

    public List<FlowWarning> listFlowWarningByNodeInst(String nodeInstId, PageDesc pageDesc) {
        return new ArrayList<FlowWarning>(this.runtimeWarningDao.listFlowWarningByNodeInst(nodeInstId, pageDesc));
    }

    public List<FlowWarning> listFlowWarningByWarningCode(String warningCode, PageDesc pageDesc) {
        return new ArrayList<FlowWarning>(this.runtimeWarningDao.listFlowWarningByWarningCode(warningCode, pageDesc));
    }

    public void deleteFlowVariable(String flowInstId, String runToken, String varName) {
        if (flowInstId == null) {
            return;
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("flowInstId", flowInstId);
        if (StringUtils.isNotBlank((CharSequence)runToken)) {
            filterMap.put("runToken", runToken);
        }
        if (StringUtils.isNotBlank((CharSequence)varName)) {
            filterMap.put("varName", varName);
        }
        this.flowVariableDao.deleteObjectsByProperties(filterMap);
    }

    public FlowInstanceGroup createFlowInstGroup(String name, String desc) {
        String flowInstGroupId = UuidOpt.getUuidAsString32();
        FlowInstanceGroup flowInstGroup = new FlowInstanceGroup();
        flowInstGroup.setFlowGroupId(flowInstGroupId);
        flowInstGroup.setFlowGroupName(name);
        flowInstGroup.setFlowGroupDesc(desc);
        this.flowInstanceGroupDao.saveNewObject((Serializable)flowInstGroup);
        return flowInstGroup;
    }

    public List<FlowInstanceGroup> listFlowInstGroup(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.flowInstanceGroupDao.listObjectsByProperties(filterMap, pageDesc);
    }

    public JSONArray viewFlowNodes(String flowInstId) {
        FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(flowInstId);
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        filterMap.put("flowInstId", flowInstId);
        filterMap.put("flowCode", flowInst.getFlowCode());
        filterMap.put("version", flowInst.getVersion());
        JSONArray flowNodes = this.nodeInstanceDao.viewFlowNodes(filterMap);
        for (Object flowNode : flowNodes) {
            JSONObject jsonObject = (JSONObject)flowNode;
            jsonObject.putIfAbsent((Object)"nodeState", (Object)NODE_INST_ZERO);
            if ("N".equals(jsonObject.getString("nodeState"))) {
                List<UserTask> userTasks = this.listNodeOperators(jsonObject.getString("nodeInstId"));
                jsonObject.put((Object)"userTasks", (Object)DictionaryMapUtils.objectsToJSONArray(userTasks));
                continue;
            }
            String lastUpdateUserName = CodeRepositoryUtil.getValue((String)"userCode", (String)jsonObject.getString("lastUpdateUser"));
            jsonObject.put((Object)"lastUpdateUserName", (Object)lastUpdateUserName);
        }
        return flowNodes;
    }

    public void updateFlowWorkTeam(FlowWorkTeam u) {
        this.flowTeamDao.mergeObject((Serializable)u);
    }
}

