/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.basedata.NoticeMessage;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.GeneralAlgorithm;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.LeftRightPair;
import com.centit.support.compiler.Pretreatment;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.compiler.VariableTranslate;
import com.centit.workflow.dao.FlowInstanceDao;
import com.centit.workflow.dao.NodeInstanceDao;
import com.centit.workflow.po.FlowEventInfo;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.service.FlowEngine;
import com.centit.workflow.service.FlowEventService;
import com.centit.workflow.service.FlowManager;
import com.centit.workflow.service.FlowScriptRunTime;
import com.centit.workflow.service.impl.FlowOptUtils;
import com.centit.workflow.service.impl.FlowVariableTranslate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FlowScriptRunTimeImpl
implements FlowScriptRunTime {
    @Autowired
    FlowEngine flowEngine;
    @Autowired
    private FlowManager flowManager;
    @Autowired
    private FlowInstanceDao flowInstanceDao;
    @Autowired
    private NodeInstanceDao nodeInstanceDao;
    @Autowired
    private NotificationCenter notificationCenter;
    @Autowired
    private FlowEventService flowEventService;

    private boolean beginFunction(VariableFormula formula) {
        String currWord = formula.skipAWord();
        return "(".equals(currWord);
    }

    private boolean endFunction(VariableFormula formula) {
        return formula.seekToRightBracket();
    }

    private Object getAFunctionParam(VariableFormula formula) {
        Object object = formula.calcFormula();
        String separatorString = formula.skipAWord();
        if (!",".equals(separatorString)) {
            formula.writeBackAWord(separatorString);
        }
        return object;
    }

    private List<Object> getAllFunctionParams(VariableFormula formula) {
        Object object = formula.calcFormula();
        String separatorString = formula.skipAWord();
        ArrayList<Object> params = new ArrayList<Object>(8);
        params.add(object);
        while (",".equals(separatorString)) {
            object = formula.calcFormula();
            params.add(object);
            separatorString = formula.skipAWord();
        }
        formula.writeBackAWord(separatorString);
        return params;
    }

    @Override
    public Map<String, Object> runFlowScript(String script, FlowInstance flowInst, NodeInstance nodeInst, FlowVariableTranslate varTrans) {
        VariableFormula formula = new VariableFormula();
        HashMap<String, Object> retValueMap = new HashMap<String, Object>(16);
        formula.setFormula(script);
        formula.setTrans((VariableTranslate)varTrans);
        while (true) {
            LeftRightPair<String, Object> value;
            if ((value = this.runWorkflowFunction(flowInst, nodeInst, formula, varTrans)) != null) {
                retValueMap.put((String)value.getLeft(), value.getRight());
            }
            String separatorString = formula.skipAWord();
            while (StringUtils.equalsAny((CharSequence)separatorString, (CharSequence[])new CharSequence[]{",", ";", "(", ")"})) {
                separatorString = formula.skipAWord();
            }
            if (StringUtils.isBlank((CharSequence)separatorString)) break;
            formula.writeBackAWord(separatorString);
        }
        return retValueMap;
    }

    public LeftRightPair<String, Object> runWorkflowFunction(FlowInstance flowInst, NodeInstance nodeInst, VariableFormula formula, FlowVariableTranslate varTrans) {
        String currWord = formula.skipAWord();
        if (StringUtils.isBlank((CharSequence)currWord)) {
            return null;
        }
        switch (currWord) {
            case "setValue": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object name = this.getAFunctionParam(formula);
                Object value = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (name == null || value == null) break;
                varTrans.setInnerVariable(StringBaseOpt.castObjectToString((Object)name), nodeInst.getRunToken(), value);
                return new LeftRightPair((Object)StringBaseOpt.castObjectToString((Object)name), value);
            }
            case "saveValue": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object name = this.getAFunctionParam(formula);
                Object value = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (name == null || value == null) break;
                LeftRightPair retPair = new LeftRightPair((Object)StringBaseOpt.castObjectToString((Object)name), value);
                varTrans.setInnerVariable((String)retPair.getLeft(), nodeInst.getRunToken(), value);
                this.flowEngine.saveFlowNodeVariable(nodeInst.getFlowInstId(), nodeInst.getRunToken(), (String)retPair.getLeft(), value);
                return retPair;
            }
            case "saveGlobalValue": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object name = this.getAFunctionParam(formula);
                Object value = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (name == null || value == null) break;
                LeftRightPair retPair = new LeftRightPair((Object)StringBaseOpt.castObjectToString((Object)name), value);
                varTrans.setInnerVariable((String)retPair.getLeft(), "T", value);
                this.flowEngine.saveFlowNodeVariable(nodeInst.getFlowInstId(), "T", (String)retPair.getLeft(), value);
                return retPair;
            }
            case "saveSuperValue": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object name = this.getAFunctionParam(formula);
                Object value = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (name == null || value == null) break;
                String token = NodeInstance.calcSuperToken((String)nodeInst.getRunToken());
                if (StringUtils.isBlank((CharSequence)token)) {
                    token = "T";
                }
                LeftRightPair retPair = new LeftRightPair((Object)StringBaseOpt.castObjectToString((Object)name), value);
                varTrans.setInnerVariable((String)retPair.getLeft(), token, value);
                this.flowEngine.saveFlowNodeVariable(nodeInst.getFlowInstId(), token, (String)retPair.getLeft(), value);
                return retPair;
            }
            case "setNextOptUser": {
                String lockedUser;
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object param = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (param == null || !StringUtils.isNotBlank((CharSequence)(lockedUser = StringBaseOpt.castObjectToString((Object)param)))) break;
                return new LeftRightPair((Object)"_lock_user", (Object)lockedUser);
            }
            case "closeNodes": {
                String nodecode;
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object param = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (param == null || !StringUtils.isNotBlank((CharSequence)(nodecode = StringBaseOpt.castObjectToString((Object)param)))) break;
                this.closeNodes(nodecode, flowInst);
                break;
            }
            case "closeAllIsolatedNodes": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                this.endFunction(formula);
                this.closeAllIsolatedNodes(flowInst);
                break;
            }
            case "closeAllOtherNodes": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                this.endFunction(formula);
                this.closeAllOtherNodes(flowInst, nodeInst);
                break;
            }
            case "deleteFlowWorkTeam": {
                String roleCode;
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object param = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (param == null || !StringUtils.isNotBlank((CharSequence)(roleCode = StringBaseOpt.castObjectToString((Object)param)))) break;
                this.flowEngine.deleteFlowWorkTeam(flowInst.getFlowInstId(), roleCode);
                break;
            }
            case "assignFlowWorkTeam": {
                String roleCode;
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object name = this.getAFunctionParam(formula);
                Object value = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (name == null || value == null || !StringUtils.isNotBlank((CharSequence)(roleCode = StringBaseOpt.castObjectToString((Object)name)))) break;
                this.flowEngine.assignFlowWorkTeam(flowInst.getFlowInstId(), roleCode, nodeInst.getRunToken(), StringBaseOpt.objectToStringList((Object)value));
                break;
            }
            case "deleteFlowOrganize": {
                String roleCode;
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object param = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (param == null || !StringUtils.isNotBlank((CharSequence)(roleCode = StringBaseOpt.castObjectToString((Object)param)))) break;
                this.flowEngine.deleteFlowOrganize(flowInst.getFlowInstId(), roleCode);
                break;
            }
            case "assignFlowOrganize": {
                String roleCode;
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object name = this.getAFunctionParam(formula);
                Object value = this.getAFunctionParam(formula);
                this.endFunction(formula);
                if (name == null || value == null || !StringUtils.isNotBlank((CharSequence)(roleCode = StringBaseOpt.castObjectToString((Object)name)))) break;
                this.flowEngine.assignFlowOrganize(flowInst.getFlowInstId(), roleCode, StringBaseOpt.objectToStringList((Object)value), "\u6765\u81ea\u811a\u672c\u5f15\u64ce\u7684\u6388\u6743");
                break;
            }
            case "event": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                List<Object> params = this.getAllFunctionParams(formula);
                this.endFunction(formula);
                if (params.size() < 1) {
                    return null;
                }
                FlowEventInfo eventInfo = new FlowEventInfo();
                eventInfo.setFlowInstId(flowInst.getFlowInstId());
                eventInfo.setSenderUser((String)GeneralAlgorithm.nvl((Object)nodeInst.getUserCode(), (Object)"system"));
                eventInfo.setEventName(StringBaseOpt.castObjectToString((Object)params.get(0)));
                if (params.size() > 1) {
                    eventInfo.setEventParam(StringBaseOpt.castObjectToString((Object)params.get(1)));
                }
                this.flowEventService.saveNewEvent(eventInfo);
                break;
            }
            case "parentEvent": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                List<Object> params = this.getAllFunctionParams(formula);
                this.endFunction(formula);
                if (params.size() < 1) {
                    return null;
                }
                FlowEventInfo eventInfo = new FlowEventInfo();
                eventInfo.setFlowInstId(flowInst.getPreInstId());
                eventInfo.setSenderUser((String)GeneralAlgorithm.nvl((Object)nodeInst.getUserCode(), (Object)"system"));
                eventInfo.setEventName(StringBaseOpt.castObjectToString((Object)params.get(0)));
                if (params.size() > 1) {
                    eventInfo.setEventParam(StringBaseOpt.castObjectToString((Object)params.get(1)));
                }
                this.flowEventService.saveNewEvent(eventInfo);
                break;
            }
            case "sendMessage": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                List<Object> params = this.getAllFunctionParams(formula);
                this.endFunction(formula);
                if (params.size() < 3) {
                    return null;
                }
                this.notificationCenter.sendMessage("system", (Collection)StringBaseOpt.objectToStringList((Object)params.get(0)), NoticeMessage.create().operation("workflow").method("submit").subject(StringBaseOpt.castObjectToString((Object)params.get(1))).content(Pretreatment.mapTemplateString((String)StringBaseOpt.castObjectToString((Object)params.get(2)), (Object)varTrans)));
                break;
            }
            case "suspendTimer": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                this.endFunction(formula);
                this.flowManager.suspendFlowInstTimer(flowInst.getFlowInstId(), (String)GeneralAlgorithm.nvl((Object)nodeInst.getUserCode(), (Object)"system"));
                break;
            }
            case "activizeTimer": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                this.endFunction(formula);
                this.flowManager.activizeFlowInstTimer(flowInst.getFlowInstId(), (String)GeneralAlgorithm.nvl((Object)nodeInst.getUserCode(), (Object)"system"));
                break;
            }
            case "resetTimeLimit": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object param = this.getAFunctionParam(formula);
                this.endFunction(formula);
                String timeLimt = StringBaseOpt.castObjectToString((Object)param);
                if (!StringUtils.isNotBlank((CharSequence)timeLimt)) break;
                this.flowManager.resetFlowTimelimt(flowInst.getFlowInstId(), StringBaseOpt.castObjectToString((Object)param), (String)GeneralAlgorithm.nvl((Object)nodeInst.getUserCode(), (Object)"system"), "\u6765\u81ea\u81ea\u52a8\u8fd0\u884c\u8282\u70b9\u7684\u91cd\u7f6e" + nodeInst.getNodeInstId());
                break;
            }
            case "runIf": {
                if (!this.beginFunction(formula)) {
                    return null;
                }
                Object condition = this.getAFunctionParam(formula);
                if (BooleanBaseOpt.castObjectToBoolean((Object)condition, (Boolean)false).booleanValue()) {
                    LeftRightPair<String, Object> trueRet = this.runWorkflowFunction(flowInst, nodeInst, formula, varTrans);
                    this.endFunction(formula);
                    return trueRet;
                }
                formula.skipAOperand();
                String aWord = formula.skipAWord();
                if (!",".equals(aWord)) break;
                LeftRightPair<String, Object> falseRet = this.runWorkflowFunction(flowInst, nodeInst, formula, varTrans);
                this.endFunction(formula);
                return falseRet;
            }
        }
        return null;
    }

    private void closeNodeInstanceInside(NodeInstance ni) {
        FlowInstance subFlowInst;
        if ("W".equals(ni.getNodeState()) && (subFlowInst = (FlowInstance)this.flowInstanceDao.getObjectById(ni.getSubFlowInstId())) != null) {
            FlowOptUtils.endInstance(subFlowInst, "F", "system", this.flowInstanceDao);
        }
        ni.setNodeState("F");
        ni.setLastUpdateTime(DatetimeOpt.currentUtilDate());
        ni.setLastUpdateUser("system");
        this.nodeInstanceDao.updateObject((Serializable)ni);
    }

    private void closeNodes(String nodeCode, FlowInstance flowInst) {
        if (flowInst.getFlowNodeInstances().size() == 0) {
            this.flowInstanceDao.fetchObjectReference((Serializable)flowInst, "flowNodeInstances");
        }
        Set activeNodes = flowInst.getActiveNodeInstances();
        for (NodeInstance ni : activeNodes) {
            String nc = ni.getNodeCode();
            if (nc != null) {
                this.nodeInstanceDao.fetchObjectReference((Serializable)ni, "node");
                nc = ni.getNodeCode();
            }
            if (!StringUtils.equals((CharSequence)nodeCode, (CharSequence)nc)) continue;
            this.closeNodeInstanceInside(ni);
        }
    }

    public Integer closeAllIsolatedNodes(FlowInstance flowInst) {
        if (flowInst.getFlowNodeInstances().size() == 0) {
            this.flowInstanceDao.fetchObjectReference((Serializable)flowInst, "flowNodeInstances");
        }
        Set activeNodes = flowInst.getActiveNodeInstances();
        for (NodeInstance ni : activeNodes) {
            if (!ni.getRunToken().contains("R")) continue;
            this.closeNodeInstanceInside(ni);
        }
        return 1;
    }

    private void closeAllOtherNodes(FlowInstance flowInst, NodeInstance nodeInst) {
        if (flowInst.getFlowNodeInstances().size() == 0) {
            this.flowInstanceDao.fetchObjectReference((Serializable)flowInst, "flowNodeInstances");
        }
        Set activeNodes = flowInst.getActiveNodeInstances();
        for (NodeInstance ni : activeNodes) {
            if (StringUtils.equals((CharSequence)ni.getRunToken(), (CharSequence)nodeInst.getRunToken())) continue;
            this.closeNodeInstanceInside(ni);
        }
    }
}

