/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.framework.model.adapter.NotificationCenter;
import com.centit.framework.model.basedata.NoticeMessage;
import com.centit.product.oa.service.WorkDayManager;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.common.WorkTimeSpan;
import com.centit.workflow.commons.SubmitOptOptions;
import com.centit.workflow.dao.FlowInstanceDao;
import com.centit.workflow.dao.FlowWarningDao;
import com.centit.workflow.dao.NodeInfoDao;
import com.centit.workflow.dao.NodeInstanceDao;
import com.centit.workflow.dao.StageInstanceDao;
import com.centit.workflow.dao.UserTaskListDao;
import com.centit.workflow.po.FlowEventInfo;
import com.centit.workflow.po.FlowInstance;
import com.centit.workflow.po.FlowWarning;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.po.NodeInstance;
import com.centit.workflow.po.StageInstance;
import com.centit.workflow.po.UserTask;
import com.centit.workflow.service.FlowEngine;
import com.centit.workflow.service.FlowEventService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class FlowTaskImpl {
    private static final Logger logger = LoggerFactory.getLogger(FlowTaskImpl.class);
    @Autowired
    NodeInstanceDao nodeInstanceDao;
    @Autowired
    UserTaskListDao userTaskListDao;
    @Autowired
    private NodeInfoDao nodeInfoDao;
    @Autowired
    private FlowWarningDao wfRuntimeWarningDao;
    @Autowired
    private NotificationCenter notificationCenter;
    @Autowired
    private FlowInstanceDao flowInstanceDao;
    @Autowired
    private FlowEventService flowEventService;
    @Autowired
    private FlowEngine flowEngine;
    @Autowired
    private StageInstanceDao stageInstanceDao;
    @Autowired
    private WorkDayManager workDayManager;
    @Value(value="${workflow.flowTimeStart:true}")
    private Boolean flowTimeStart;
    @Value(value="${workflow.amStart:830}")
    private int amStart;
    @Value(value="${workflow.amEnd:1130}")
    private int amEnd;
    @Value(value="${workflow.pmStart:1300}")
    private int pmStart;
    @Value(value="${workflow.pmEnd:1800}")
    private int pmEnd;

    private int sendNotifyMessage(String nodeInstId) {
        NodeInstance nodeInst = (NodeInstance)this.nodeInstanceDao.getObjectById(nodeInstId);
        if (nodeInst == null || "D".equals(nodeInst.getTaskAssigned())) {
            return 0;
        }
        UserTask task = this.userTaskListDao.getNodeTaskInfo(nodeInstId);
        if (task == null || StringUtils.isBlank((CharSequence)task.getUserCode())) {
            return 0;
        }
        NoticeMessage noticeMessage = NoticeMessage.create().subject("\u8282\u70b9\u9884\u62a5\u8b66\u63d0\u793a").content("\u4e1a\u52a1" + task.getFlowOptName() + "(" + task.getFlowInstId() + ")\u7684" + task.getNodeName() + "(" + task.getNodeInstId() + ")\u8282\u70b9\u8d85\u65f6\u9884\u8b66\uff0c\u8bf7\u5c3d\u5feb\u5904\u7406\u3002").operation("WF_WARNING").method("NOTIFY").tag(String.valueOf(nodeInstId));
        this.notificationCenter.sendMessage("system", task.getUserCode(), noticeMessage);
        return 1;
    }

    @Scheduled(cron="0 1/5 8-18 * * ?")
    @Transactional
    public void notifyTimeWaring() {
        List<FlowWarning> warningList = this.wfRuntimeWarningDao.listNeedNotifyWarning();
        if (warningList == null) {
            return;
        }
        int nn = 0;
        for (FlowWarning warn : warningList) {
            List<NodeInstance> nodelist;
            if ("N".equals(warn.getObjType())) {
                nn += this.sendNotifyMessage(warn.getNodeInstId());
            } else if ("F".equals(warn.getObjType())) {
                nodelist = this.nodeInstanceDao.listActiveTimerNodeByFlow(warn.getFlowInstId());
                for (NodeInstance node : nodelist) {
                    nn += this.sendNotifyMessage(node.getNodeInstId());
                }
            } else if ("P".equals(warn.getObjType())) {
                nodelist = this.nodeInstanceDao.listActiveTimerNodeByFlowStage(warn.getFlowInstId(), warn.getFlowStage());
                for (NodeInstance node : nodelist) {
                    nn += this.sendNotifyMessage(node.getNodeInstId());
                }
            }
            warn.setSendMsgTime(DatetimeOpt.currentUtilDate());
            warn.setNoticeState("1");
            this.wfRuntimeWarningDao.updateObject((Serializable)warn);
        }
        logger.info("\u901a\u77e5\u4e2d\u5fc3\u53d1\u73b0 " + warningList.size() + "\u9884\u8b66\u4fe1\u606f\uff0c\u5e76\u901a\u77e5\u4e86" + nn + "\u4e2a\u7528\u6237\u3002");
    }

    @Scheduled(cron="0 1/2 5-23 * * ?")
    @Transactional
    public void runEntity() {
        long consumeTime = 2L;
        this.consumeLifeTime(consumeTime);
        this.runEventTask(500);
    }

    public boolean isWorkTime(Map<String, Boolean> cached, String topUnit) {
        if (cached.containsKey(topUnit)) {
            return cached.get(topUnit);
        }
        Date workTime = DatetimeOpt.currentUtilDate();
        boolean workdDay = this.workDayManager.isWorkDay(topUnit, workTime);
        if (!workdDay) {
            cached.put(topUnit, false);
            return false;
        }
        int m = DatetimeOpt.getMinute((Date)workTime) + 100 * DatetimeOpt.getHour((Date)workTime);
        boolean isWT = m > this.amStart && m < this.amEnd || m > this.pmStart && m < this.pmEnd;
        cached.put(topUnit, isWT);
        return isWT;
    }

    private void consumeLifeTime(long consumeTime) {
        List<FlowInstance> activeFlows = this.flowInstanceDao.listAllActiveTimerFlowInst();
        if (activeFlows == null || activeFlows.size() < 1) {
            return;
        }
        HashMap<String, Boolean> cached = new HashMap<String, Boolean>(100);
        for (FlowInstance flowInst : activeFlows) {
            List<FlowWarning> flowWarnings;
            List<NodeInstance> nodeList;
            if (!this.isWorkTime(cached, flowInst.getTopUnit()) || (nodeList = this.nodeInstanceDao.listActiveTimerNodeByFlow(flowInst.getFlowInstId())) == null || nodeList.size() < 1) continue;
            Boolean flowconsume = false;
            Boolean stopFlow = false;
            HashSet<String> stageCodes = new HashSet<String>();
            for (NodeInstance nodeInst : nodeList) {
                NodeInfo nodeInfo = (NodeInfo)this.nodeInfoDao.getObjectById(nodeInst.getNodeId());
                String warningRule = nodeInfo.getWarningRule();
                String warningParam = nodeInfo.getWarningParam();
                boolean warning = false;
                String warningType = "";
                if ("R".equals(warningRule)) {
                    warning = new WorkTimeSpan(warningParam).toNumberAsMinute() >= nodeInst.getPromiseTime() - nodeInst.getTimeLimit();
                } else if ("L".equals(warningRule)) {
                    warning = new WorkTimeSpan(warningParam).toNumberAsMinute() >= nodeInst.getTimeLimit();
                } else if ("P".equals(warningRule) && StringUtils.isNotBlank((CharSequence)warningParam) && nodeInst.getPromiseTime() > 0L) {
                    boolean bl = warning = this.parse(warningParam) >= nodeInst.getTimeLimit().doubleValue() / nodeInst.getPromiseTime().doubleValue();
                }
                if (nodeInst.getTimeLimit() <= 0L) {
                    warningType = "W";
                } else if (warning) {
                    warningType = "N";
                }
                if (("T".equals(nodeInst.getIsTimer()) || "H".equals(nodeInst.getIsTimer())) && nodeInst.getTimeLimit() <= 0L) {
                    if ("T".equals(nodeInst.getNodeState()) && "T".equals(nodeInfo.getOptType())) {
                        this.flowEngine.submitOpt(SubmitOptOptions.create().nodeInst(nodeInst.getNodeInstId()).user(nodeInst.getUserCode()).unit(nodeInst.getUnitCode()).tenant(flowInst.getTopUnit()));
                    } else {
                        List<FlowWarning> flowWarnings2;
                        if ("E".equals(nodeInfo.getExpireOpt())) {
                            stopFlow = true;
                            break;
                        }
                        if ("C".equals(nodeInfo.getExpireOpt())) {
                            this.flowEngine.submitOpt(SubmitOptOptions.create().nodeInst(nodeInst.getNodeInstId()).user(nodeInst.getUserCode()).unit(nodeInst.getUnitCode()).tenant(flowInst.getTopUnit()));
                        } else if ("N".equals(nodeInfo.getExpireOpt()) && ((flowWarnings2 = this.wfRuntimeWarningDao.listFlowWarning(flowInst.getFlowInstId(), nodeInst.getNodeInstId(), warningType, "N", null)) == null || flowWarnings2.isEmpty())) {
                            FlowWarning flowWarning = new FlowWarning(flowInst.getFlowInstId(), nodeInst.getNodeInstId(), warningType, "N");
                            this.wfRuntimeWarningDao.saveNewObject((Serializable)flowWarning);
                        }
                    }
                }
                if (("T".equals(nodeInst.getIsTimer()) || "H".equals(nodeInst.getIsTimer())) && nodeInst.getTimeLimit() != null) {
                    nodeInst.setTimeLimit(Long.valueOf(nodeInst.getTimeLimit() - consumeTime));
                    DatabaseOptUtils.doExecuteSql((BaseDaoImpl)this.nodeInstanceDao, (String)"update WF_NODE_INSTANCE set TIME_LIMIT = ? where NODE_INST_ID=?", (Object[])new Object[]{nodeInst.getTimeLimit(), nodeInst.getNodeInstId()});
                }
                if (StringUtils.isNotBlank((CharSequence)nodeInst.getStageCode())) {
                    stageCodes.add(nodeInst.getStageCode());
                }
                if (!"T".equals(nodeInst.getIsTimer()) || "T".equals(nodeInst.getNodeState())) continue;
                flowconsume = true;
            }
            if ("T".equals(flowInst.getIsTimer()) && flowInst.getTimeLimit() != null && flowInst.getTimeLimit() <= 0L && ((flowWarnings = this.wfRuntimeWarningDao.listFlowWarning(flowInst.getFlowInstId(), "W", "F", null)) == null || flowWarnings.isEmpty())) {
                FlowWarning flowWarning = new FlowWarning(flowInst.getFlowInstId(), "0", "W", "F");
                this.wfRuntimeWarningDao.saveNewObject((Serializable)flowWarning);
            }
            if (stopFlow.booleanValue()) {
                flowInst.setInstState("C");
                this.flowInstanceDao.updateObject((Serializable)flowInst);
                continue;
            }
            if (flowconsume.booleanValue() && "T".equals(flowInst.getIsTimer()) && flowInst.getTimeLimit() != null) {
                flowInst.setTimeLimit(Long.valueOf(flowInst.getTimeLimit() - consumeTime));
                this.flowInstanceDao.updateObject((Serializable)flowInst);
            }
            for (String stageCode : stageCodes) {
                StageInstance stageInstance = this.stageInstanceDao.getStageInstanceByCode(flowInst.getFlowInstId(), stageCode);
                if (null == stageInstance || stageInstance.getPromiseTime() <= 0L) continue;
                if (stageInstance.getTimeLimit() > 0L && stageInstance.getTimeLimit() - consumeTime < 0L) {
                    FlowWarning flowWarning = new FlowWarning(flowInst.getFlowInstId(), stageCode, "W", "P");
                    this.wfRuntimeWarningDao.saveNewObject((Serializable)flowWarning);
                }
                stageInstance.setTimeLimit(Long.valueOf(stageInstance.getTimeLimit() - consumeTime));
                if (StageInstance.STAGE_TIMER_STATE_STARTED.equals(stageInstance.getStageBegin())) {
                    stageInstance.setLastUpdateTime(DatetimeOpt.currentUtilDate());
                } else {
                    stageInstance.setStageBegin(StageInstance.STAGE_TIMER_STATE_STARTED);
                    stageInstance.setBeginTime(DatetimeOpt.currentUtilDate());
                    stageInstance.setLastUpdateTime(DatetimeOpt.currentUtilDate());
                }
                this.stageInstanceDao.updateObject((Serializable)stageInstance);
            }
        }
    }

    private double parse(String ratio) {
        if (ratio.contains("/")) {
            String[] rat = ratio.split("/");
            if (rat.length > 2) {
                return NumberBaseOpt.castObjectToDouble((Object)rat[0], (Double)0.0) / NumberBaseOpt.castObjectToDouble((Object)rat[1], (Double)100.0);
            }
            return NumberBaseOpt.castObjectToDouble((Object)rat[0], (Double)0.0);
        }
        if (ratio.contains("%")) {
            String percent = ratio.substring(0, ratio.indexOf(37));
            return NumberBaseOpt.castObjectToDouble((Object)percent, (Double)0.0) / 100.0;
        }
        return NumberBaseOpt.castObjectToDouble((Object)ratio, (Double)0.0);
    }

    private void runEventTask(int maxRows) {
        List events = this.flowEventService.listEventForOpt(maxRows);
        if (events != null && events.size() > 0) {
            for (FlowEventInfo eventInfo : events) {
                List<NodeInstance> nodes = this.nodeInstanceDao.listNodeInstByState(eventInfo.getFlowInstId(), "T");
                boolean hasOptEvent = false;
                String successOpt = "S";
                try {
                    if (nodes != null) {
                        for (NodeInstance nodeInst : nodes) {
                            this.nodeInstanceDao.fetchObjectReference((Serializable)nodeInst, "node");
                            if (!"M".equals(nodeInst.getNode().getNodeSyncType()) || !StringUtils.equals((CharSequence)eventInfo.getEventName(), (CharSequence)nodeInst.getNode().getMessageCode())) continue;
                            hasOptEvent = true;
                            List ret = this.flowEngine.submitOpt(SubmitOptOptions.create().nodeInst(nodeInst.getNodeInstId()));
                            eventInfo.setOptResult(StringBaseOpt.castObjectToString((Object)ret));
                        }
                    }
                }
                catch (ObjectException e) {
                    successOpt = "F";
                    eventInfo.setOptResult(e.getMessage());
                }
                if (hasOptEvent) {
                    eventInfo.setOptState(successOpt);
                    eventInfo.setOptTime(DatetimeOpt.currentUtilDate());
                    this.flowEventService.updateEvent(eventInfo);
                    continue;
                }
                FlowInstance flowInst = (FlowInstance)this.flowInstanceDao.getObjectById(eventInfo.getFlowInstId());
                if (flowInst != null && "N".equals(flowInst.getInstState())) continue;
                eventInfo.setOptState("E");
                eventInfo.setOptTime(DatetimeOpt.currentUtilDate());
                eventInfo.setOptResult("\u6d41\u7a0b\u4e0d\u5728\u6b63\u5e38\u8fd0\u884c\u72b6\u6001\uff01");
                this.flowEventService.updateEvent(eventInfo);
            }
        }
    }
}

