/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.centit.framework.appclient.AppSession;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.filter.RequestThreadLocal;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.workflow.commons.NodeEventSupport;
import com.centit.workflow.po.NodeInfo;
import com.centit.workflow.service.FlowEngine;
import com.centit.workflow.support.ApplicationContextRegister;
import com.centit.workflow.support.LocalBeanNodeEventSupport;
import com.centit.workflow.support.RemoteBeanNodeEventSupport;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.WebApplicationContext;

public class NodeEventSupportFactory {
    private static ConcurrentHashMap<String, AppSession> appSessionPoolMap = new ConcurrentHashMap(10);

    private static AppSession fetchAppSession(String url) {
        String sUrl = StringUtils.isBlank((CharSequence)url) ? "blank" : url;
        AppSession appSession = appSessionPoolMap.get(sUrl);
        if (appSession == null) {
            appSession = new AppSession(url, false, null, null);
            appSessionPoolMap.put(sUrl, appSession);
        }
        return appSession;
    }

    public static NodeEventSupport createNodeEventSupportBean(NodeInfo nodeInfo, FlowEngine flowEngine) {
        OsInfo osInfo;
        WebApplicationContext webApplicationContext = ContextLoader.getCurrentWebApplicationContext();
        HttpServletRequest request = RequestThreadLocal.getLocalThreadWrapperRequest();
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        OsInfo osInfo2 = osInfo = StringUtils.isBlank((CharSequence)nodeInfo.getOsId()) ? null : CodeRepositoryUtil.getOsInfo((String)topUnit, (String)nodeInfo.getOsId());
        if (osInfo != null && StringUtils.isNotBlank((CharSequence)osInfo.getOsUrl())) {
            RemoteBeanNodeEventSupport remoteNodeEventExecutor = new RemoteBeanNodeEventSupport(flowEngine);
            remoteNodeEventExecutor.setAppSession(NodeEventSupportFactory.fetchAppSession(osInfo.getOsUrl()));
            return remoteNodeEventExecutor;
        }
        LocalBeanNodeEventSupport localNodeEventExecutor = new LocalBeanNodeEventSupport(flowEngine);
        if (webApplicationContext == null) {
            webApplicationContext = (WebApplicationContext)ApplicationContextRegister.getApplicationContext();
        }
        localNodeEventExecutor.setApplication(webApplicationContext.getServletContext());
        return localNodeEventExecutor;
    }
}

