/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.adapter.UserUnitFilterCalcContext;
import com.centit.framework.model.adapter.UserUnitFilterCalcContextFactory;
import com.centit.framework.model.basedata.UnitInfo;
import com.centit.framework.model.basedata.UserInfo;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.dao.RoleFormulaDao;
import com.centit.workflow.po.RoleFormula;
import com.centit.workflow.service.RoleFormulaService;
import com.centit.workflow.service.impl.UserUnitCalcEngine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleFormulaServiceImpl
implements RoleFormulaService {
    @Autowired
    private PlatformEnvironment platformEnvironment;
    @Autowired
    private UserUnitFilterCalcContextFactory userUnitFilterFactory;
    @Autowired
    private RoleFormulaDao flowRoleDao;

    private String fetchTopUnit(String unitCode) {
        UnitInfo ui;
        if (StringUtils.isNotBlank((CharSequence)unitCode) && (ui = this.platformEnvironment.loadUnitInfo(unitCode)) != null) {
            return ui.getTopUnit();
        }
        return "all";
    }

    @Transactional
    public List<RoleFormula> listRoleFormulas(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.flowRoleDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Transactional
    public RoleFormula getRoleFormulaByCode(String formulaCode) {
        return (RoleFormula)this.flowRoleDao.getObjectById(formulaCode);
    }

    @Transactional
    public void saveRoleFormula(RoleFormula flowRole) {
        this.flowRoleDao.mergeObject((Serializable)flowRole);
    }

    @Transactional
    public void deleteRoleFormulaByCode(String formulaCode) {
        this.flowRoleDao.deleteObjectById(formulaCode);
    }

    public JSONArray viewFormulaUsers(String formula, String userCode, String unitCode) {
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(this.fetchTopUnit(unitCode));
        context.addUserParam("C", userCode);
        context.addUnitParam("C", unitCode);
        context.addUnitParam("N", unitCode);
        Set<String> sUsers = UserUnitCalcEngine.calcOperators(context, formula);
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
        for (String uc : sUsers) {
            userInfos.add(context.getUserInfoByCode(uc));
        }
        Collections.sort(userInfos, new Comparator<UserInfo>(){

            @Override
            public int compare(UserInfo o1, UserInfo o2) {
                Long i = o1.getUserOrder() - o2.getUserOrder();
                return new Long(i).intValue();
            }
        });
        return JSONArray.copyOf(userInfos);
    }

    public JSONArray viewFormulaUnits(String formula, String userCode, String unitCode) {
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(this.fetchTopUnit(unitCode));
        context.addUserParam("C", userCode);
        context.addUnitParam("C", unitCode);
        context.addUnitParam("N", unitCode);
        Set<String> sUnits = UserUnitCalcEngine.calcUnitsByExp(context, formula);
        ArrayList<UnitInfo> userInfos = new ArrayList<UnitInfo>();
        for (String uc : sUnits) {
            userInfos.add(context.getUnitInfoByCode(uc));
        }
        return JSONArray.copyOf(userInfos);
    }

    public JSONArray viewRoleFormulaUsers(String formulaCode, String userCode, String unitCode) {
        RoleFormula flowRole = (RoleFormula)this.flowRoleDao.getObjectById(formulaCode);
        if (flowRole == null) {
            return null;
        }
        return this.viewFormulaUsers(flowRole.getRoleFormula(), userCode, unitCode);
    }

    public List<UserInfo> listAllUserInfo(String topUnit) {
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(topUnit);
        return context.listAllUserInfo();
    }

    public List<UserInfo> listUserInfo(String prefix, String topUnit) {
        List<UserInfo> allUsers = this.listAllUserInfo(topUnit);
        ArrayList<UserInfo> selUsers = new ArrayList<UserInfo>();
        for (UserInfo user : allUsers) {
            if (!user.getUserName().startsWith(prefix) && !user.getUserName().endsWith(prefix) && !user.getLoginName().startsWith(prefix) && !user.getLoginName().endsWith(prefix)) continue;
            selUsers.add(user);
        }
        return selUsers;
    }

    public List<UnitInfo> listAllUnitInfo(String topUnit) {
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(topUnit);
        List unitInfos = context.listAllUnitInfo();
        CollectionsOpt.sortAsTree((List)unitInfos, (p, c) -> StringUtils.equals((CharSequence)p.getUnitCode(), (CharSequence)c.getParentUnit()));
        return unitInfos;
    }

    public List<UnitInfo> listSubUnit(String unitCode) {
        UserUnitFilterCalcContext context = this.userUnitFilterFactory.createCalcContext(this.fetchTopUnit(unitCode));
        return context.listSubUnit(unitCode);
    }
}

