/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.database.utils.PageDesc;
import com.centit.workflow.dao.RoleRelegateDao;
import com.centit.workflow.po.RoleRelegate;
import com.centit.workflow.service.RoleRelegateService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleRelegateServiceImpl
implements RoleRelegateService {
    private static final Logger log = LoggerFactory.getLogger(RoleRelegateServiceImpl.class);
    @Autowired
    private RoleRelegateDao roleRelegateDao;

    private void pretreatment(RoleRelegate roleRelegate) {
        if (roleRelegate.getRelegateTime() == null) {
            roleRelegate.setRelegateTime(new Date());
        }
        if (StringUtils.isBlank((CharSequence)roleRelegate.getRoleType())) {
            if (StringUtils.isBlank((CharSequence)roleRelegate.getOptId())) {
                roleRelegate.setRoleType("XZ");
            } else {
                roleRelegate.setRoleType("OP");
                roleRelegate.setRoleCode(null);
                roleRelegate.setUnitCode(null);
            }
        } else {
            roleRelegate.setOptId(null);
        }
        if (roleRelegate.getIsValid() == null) {
            roleRelegate.setIsValid("T");
        }
    }

    @Transactional
    public void saveRelegate(RoleRelegate roleRelegate) {
        this.pretreatment(roleRelegate);
        roleRelegate.setRecordDate(new Date());
        this.roleRelegateDao.saveNewObject((Serializable)roleRelegate);
    }

    @Transactional
    public void updateRelegate(RoleRelegate roleRelegate) {
        this.pretreatment(roleRelegate);
        this.roleRelegateDao.updateObject(new String[]{"grantor", "grantee", "isValid", "roleType", "roleCode", "unitCode", "optId", "expireTime", "relegateTime", "recordDate", "grantDesc"}, (Serializable)roleRelegate);
    }

    public JSONArray listRelegateListByUser(Map<String, Object> filterMap, PageDesc pageDesc) {
        String topUnit = StringBaseOpt.castObjectToString((Object)filterMap.get("topUnit"));
        JSONArray relegateList = this.roleRelegateDao.listRelegateListByUser(filterMap, pageDesc);
        if (relegateList != null && !relegateList.isEmpty()) {
            for (Object obj : relegateList) {
                String roleCode;
                if (!(obj instanceof JSONObject)) continue;
                JSONObject jsonObject = (JSONObject)obj;
                String unitCode = jsonObject.getString("unitCode");
                if (StringUtils.isNotBlank((CharSequence)unitCode)) {
                    jsonObject.put((Object)"unitName", (Object)CodeRepositoryUtil.getValue((String)"unitCode", (String)unitCode));
                }
                if (!StringUtils.isNotBlank((CharSequence)(roleCode = jsonObject.getString("roleCode"))) || !StringUtils.isNotBlank((CharSequence)topUnit)) continue;
                jsonObject.put((Object)"roleName", (Object)CodeRepositoryUtil.getValue((String)(topUnit + "-RT"), (String)roleCode));
            }
        }
        return relegateList;
    }

    public List<RoleRelegate> listRoleRelegates(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.roleRelegateDao.listObjectsByProperties(filterMap, pageDesc);
    }

    public void deleteRoleRelegate(String relegateNo) {
        this.roleRelegateDao.deleteObjectById(relegateNo);
    }

    public void changeRelegateValid(RoleRelegate roleRelegate) {
        String valid = roleRelegate.getIsValid();
        RoleRelegate relegate = (RoleRelegate)this.roleRelegateDao.getObjectById(roleRelegate.getRelegateNo());
        String isValid = relegate.getIsValid();
        if (!isValid.equalsIgnoreCase(valid)) {
            relegate.setIsValid(valid);
            this.roleRelegateDao.updateObject(new String[]{"isValid"}, (Serializable)relegate);
        }
    }

    public void batchRelegateByOp(RoleRelegate roleRelegate, String relateType, List<String> optIds) {
        this.roleRelegateDao.deleteOptRelegate(roleRelegate.getGrantor(), roleRelegate.getGrantee());
        if ("all".equalsIgnoreCase(relateType)) {
            roleRelegate.setOptId(null);
            roleRelegate.setRelegateNo(UuidOpt.getUuidAsString22());
            this.roleRelegateDao.saveNewObject((Serializable)roleRelegate);
        } else {
            for (String optId : optIds) {
                roleRelegate.setOptId(optId);
                roleRelegate.setRelegateNo(UuidOpt.getUuidAsString22());
                this.roleRelegateDao.saveNewObject((Serializable)roleRelegate);
            }
        }
    }
}

