/*
 * Decompiled with CFR 0.152.
 */
package com.centit.workflow.service.impl;

import com.centit.framework.components.SysUnitFilterEngine;
import com.centit.framework.components.SysUserFilterEngine;
import com.centit.framework.model.adapter.UserUnitFilterCalcContext;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.Lexer;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UserUnitCalcEngine {
    private static final Logger logger = LoggerFactory.getLogger(SysUserFilterEngine.class);

    public static String calcSingleUnitByExp(UserUnitFilterCalcContext ecc, String unitExp) {
        if (unitExp == null) {
            return null;
        }
        ecc.setFormula(unitExp);
        return SysUnitFilterEngine.calcSingleUnitByExp((UserUnitFilterCalcContext)ecc);
    }

    public static Set<String> calcUnitsByExp(UserUnitFilterCalcContext ecc, String unitExp) {
        if (StringUtils.isBlank((CharSequence)unitExp)) {
            return null;
        }
        ecc.setFormula(unitExp);
        Set units = SysUnitFilterEngine.calcUnitsExp((UserUnitFilterCalcContext)ecc);
        if (ecc.hasError()) {
            logger.error(unitExp + ":" + ecc.getLastErrMsg());
            throw new ObjectException((Object)ecc, 608, unitExp + ":" + ecc.getLastErrMsg());
        }
        return units;
    }

    public static Set<String> calcOperators(UserUnitFilterCalcContext ecc, String roleExp) {
        if (StringUtils.isBlank((CharSequence)roleExp)) {
            return null;
        }
        if (Lexer.isSingleWord((String)roleExp)) {
            ecc.setFormula("U(" + roleExp + ")");
        } else {
            ecc.setFormula(roleExp);
        }
        Set sUsers = SysUserFilterEngine.calcRolesExp((UserUnitFilterCalcContext)ecc);
        if (ecc.hasError()) {
            logger.error(roleExp + ":" + ecc.getLastErrMsg());
            throw new ObjectException((Object)ecc, 608, roleExp + ":" + ecc.getLastErrMsg());
        }
        return sUsers;
    }
}

