/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.controller;

import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.product.oa.po.BbsPiece;
import com.centit.product.oa.service.BbsManager;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/bbs"})
@Api(tags={"BBS\u64cd\u4f5c\u63a5\u53e3"}, value="BBS\u63a5\u53e3\u7ef4\u62a4")
public class BbsController
extends BaseController {
    @Autowired
    private BbsManager bbsManager;

    public String getOptId() {
        return "BbsPiece";
    }

    @PostMapping(value={"/addPiece"})
    @ApiOperation(value="\u65b0\u589e\u8bc4\u8bba\u4fe1\u606f")
    @WrapUpResponseBody
    public void createBbsPiece(@RequestBody BbsPiece bbsPiece) {
        this.bbsManager.saveBbsPiece(bbsPiece);
    }

    @GetMapping(value={"/getPiece"})
    @ApiOperation(value="\u5206\u9875\u663e\u793a\u51fa\u8bc4\u8bba\u4fe1\u606f")
    @WrapUpResponseBody
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", required=true, paramType="query"), @ApiImplicitParam(name="optTag", required=true, paramType="query"), @ApiImplicitParam(name="optId", required=true, paramType="query"), @ApiImplicitParam(name="pageDesc", value="\u5206\u9875\u5bf9\u8c61", paramType="query", dataTypeClass=PageDesc.class)})
    public PageQueryResult<BbsPiece> listBbsPieces(@Valid PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        List<BbsPiece> bbsPieces = this.bbsManager.listBbsPieces(searchColumn, pageDesc);
        return PageQueryResult.createResultMapDict(bbsPieces, (PageDesc)pageDesc);
    }

    @GetMapping(value={"/getPieceContent"})
    @ApiOperation(value="\u5206\u9875\u663e\u793a\u51fapieceContent\u4e2d\u7684\u4fe1\u606f")
    @WrapUpResponseBody
    @ApiImplicitParams(value={@ApiImplicitParam(name="applicationId", required=true, paramType="query"), @ApiImplicitParam(name="optTag", required=true, paramType="query"), @ApiImplicitParam(name="optId", required=true, paramType="query")})
    public PageQueryResult<BbsPiece> listPieceContents(PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = BaseController.collectRequestParameters((HttpServletRequest)request);
        return PageQueryResult.createResultMapDict(this.bbsManager.listBbsPiecesByPieceContentType(searchColumn, pageDesc), (PageDesc)pageDesc);
    }

    @DeleteMapping(value={"/deletePiece/{pieceId}"})
    @ApiOperation(value="\u7528\u6237\u5220\u9664\u81ea\u5df1\u53d1\u8868\u7684\u8bc4\u8bba\u4fe1\u606f")
    @ApiImplicitParam(name="pieceId", required=true)
    @WrapUpResponseBody
    public boolean deleteBbsPieces(@PathVariable String pieceId) {
        return this.bbsManager.deleteBbsPieceByID(pieceId);
    }

    @GetMapping(value={"/getPiece/{pieceId}"})
    @ApiOperation(value="\u901a\u8fc7pieceId\u83b7\u53d6\u8bc4\u8bba\u4fe1\u606f")
    @ApiImplicitParam(name="pieceId", required=true)
    @WrapUpResponseBody
    public BbsPiece getBbsPieces(@PathVariable String pieceId) {
        return this.bbsManager.getBbsPieces(pieceId);
    }
}

