/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.service.impl;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.product.oa.dao.BbsPieceDao;
import com.centit.product.oa.dao.BbsScoreDao;
import com.centit.product.oa.po.BbsPiece;
import com.centit.product.oa.po.BbsScore;
import com.centit.product.oa.service.BbsManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BbsManagerImpl
implements BbsManager {
    @Autowired
    private BbsPieceDao bbsPieceDao;
    @Autowired
    private BbsScoreDao bbsScoreDao;

    @Override
    public void saveBbsPiece(BbsPiece bbsPiece) {
        bbsPiece.setPieceId(null);
        this.bbsPieceDao.saveNewObject(bbsPiece);
    }

    @Override
    public void updateBbsPiece(BbsPiece bbsPiece) {
        bbsPiece.setPieceState("U");
        this.bbsPieceDao.updateObject(bbsPiece);
    }

    @Override
    public List<BbsPiece> listBbsPieces(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.bbsPieceDao.listObjects(filterMap, pageDesc);
    }

    @Override
    public List<BbsPiece> listBbsPiecesByPieceContentType(Map<String, Object> filterMap, PageDesc pageDesc) {
        if (null == filterMap.get("contentType") || !filterMap.get("contentType").equals("file")) {
            return null;
        }
        filterMap.put("pieceContent_lk", "%\"contentType\":\"file\"%");
        filterMap.remove("contentType");
        return this.bbsPieceDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    public BbsPiece getBbsPieces(String pieceId) {
        List pieces = this.bbsPieceDao.listObjectsByProperty("pieceId", pieceId);
        if (pieces.isEmpty()) {
            return null;
        }
        return (BbsPiece)pieces.get(0);
    }

    @Override
    public boolean deleteBbsPieceByID(String pieceId) {
        List piece = this.bbsPieceDao.listObjectsByProperty("pieceId", pieceId);
        if (piece.isEmpty()) {
            return false;
        }
        this.bbsPieceDao.deleteObjectById(pieceId);
        return true;
    }

    @Override
    public void deleteBbsPieceByRefObject(String applicationId, String optId, String refObjectId) {
        this.bbsPieceDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"applicationId", applicationId, "optId", optId, "refObjectId", refObjectId}));
    }

    @Override
    public void replyPiece(String pieceId, BbsPiece bbsPiece) {
        BbsPiece oldPiece = (BbsPiece)this.bbsPieceDao.getObjectById(pieceId);
        if (oldPiece == null) {
            throw new ObjectException("\u627e\u4e0d\u5230\u88ab\u56de\u590d\u7684\u5bf9\u8c61\uff1a" + pieceId);
        }
        bbsPiece.setReplyId(pieceId);
        bbsPiece.setOptId(oldPiece.getOptId());
        bbsPiece.setApplicationId(oldPiece.getApplicationId());
        bbsPiece.setRefObjectId(oldPiece.getRefObjectId());
        this.bbsPieceDao.saveNewObject(bbsPiece);
    }

    @Override
    public void saveBbsScore(BbsScore bbsScore) {
        int isExists = this.bbsScoreDao.countObject(CollectionsOpt.createHashMap((Object[])new Object[]{"applicationId", bbsScore.getApplicationId(), "optId", bbsScore.getOptId(), "refObjectId", bbsScore.getRefObjectId(), "userCode", bbsScore.getUserCode()}));
        if (isExists > 0) {
            throw new ObjectException("\u7528\u6237" + bbsScore.getUserCode() + "\u5df2\u7ecf\u5bf9\uff1a" + bbsScore.getRefObjectId() + "\u8bc4\u5206\u8fc7\uff01");
        }
        this.bbsScoreDao.saveNewObject(bbsScore);
    }

    @Override
    public List<BbsScore> listBbsScore(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.bbsScoreDao.listObjectsByProperties(filterMap, pageDesc);
    }

    @Override
    public String statBbsScore(String applicationId, String optId, String refObjectId) {
        Object obj = DatabaseOptUtils.getScalarObjectQuery((BaseDaoImpl)this.bbsScoreDao, (String)"select avg(BBS_SCORE) as score from M_BBS_SCORE where APPLICATION_ID=? and OPT_ID=? and REF_OBJECT_ID=?", (Object[])new Object[]{applicationId, optId, refObjectId});
        return StringBaseOpt.castObjectToString((Object)obj);
    }

    @Override
    public void deleteBbsScoreById(String scoreId) {
        this.bbsScoreDao.deleteObjectById(scoreId);
    }

    @Override
    public void deleteBbsScoreByRefObject(String applicationId, String optId, String refObjectId) {
        this.bbsScoreDao.deleteObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"applicationId", applicationId, "optId", optId, "refObjectId", refObjectId}));
    }
}

