/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.graphql;

import com.centit.product.metadata.graphql.GraphQLSchemaBuilder;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.support.database.utils.DataSourceDescription;
import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.transaction.annotation.Transactional;

public class GraphQLExecutor {
    @Resource
    private MetaDataService metaDataService;
    private DataSourceDescription dataSourceDesc;
    private GraphQL graphQL;
    private GraphQLSchema graphQLSchema;
    private GraphQLSchema.Builder builder;

    protected GraphQLExecutor() {
        this.createGraphQL();
    }

    public GraphQLExecutor(MetaDataService metaDataService, DataSourceDescription databaseId) {
        this.metaDataService = metaDataService;
        this.dataSourceDesc = databaseId;
        this.createGraphQL();
    }

    @PostConstruct
    protected synchronized void createGraphQL() {
        if (this.metaDataService != null) {
            if (this.builder == null) {
                this.builder = new GraphQLSchemaBuilder(this.metaDataService, this.dataSourceDesc);
            }
            this.graphQLSchema = this.builder.build();
            this.graphQL = GraphQL.newGraphQL((GraphQLSchema)this.graphQLSchema).build();
        }
    }

    public GraphQLSchema getGraphQLSchema() {
        return this.graphQLSchema;
    }

    @Transactional
    public ExecutionResult execute(String query) {
        return this.graphQL.execute(query);
    }

    @Transactional
    public ExecutionResult execute(String query, Map<String, Object> arguments) {
        if (arguments == null) {
            return this.graphQL.execute(query);
        }
        return this.graphQL.execute(ExecutionInput.newExecutionInput().query(query).variables(arguments).build());
    }

    public GraphQLSchema.Builder getBuilder() {
        return this.builder;
    }

    public GraphQLSchema getSchema() {
        return this.graphQLSchema;
    }

    public GraphQLExecutor updateSchema(GraphQLSchema.Builder builder) {
        this.builder = builder;
        this.createGraphQL();
        return this;
    }
}

