/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.graphql;

import com.centit.product.metadata.graphql.JavaScalars;
import com.centit.product.metadata.graphql.MetadataDataFetcher;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.FieldType;
import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaBuilder
extends GraphQLSchema.Builder {
    public static final String PAGINATION_REQUEST_PARAM_NAME = "paginationRequest";
    private static final Logger log = LoggerFactory.getLogger(GraphQLSchemaBuilder.class);
    private final MetaDataService metaDataService;
    private final DataSourceDescription dataSourceDesc;
    private final Map<String, GraphQLObjectType> entityCache = new HashMap<String, GraphQLObjectType>();
    private static final GraphQLArgument paginationArgument = GraphQLArgument.newArgument().name("paginationRequest").type((GraphQLInputType)GraphQLInputObjectType.newInputObject().name("PaginationObject").description("Query object for Pagination Requests, specifying the requested page, and that page's size.\n\nNOTE: 'page' parameter is 1-indexed, NOT 0-indexed.\n\nExample: paginationRequest { page: 1, size: 20 }").field(GraphQLInputObjectField.newInputObjectField().name("pageNo").description("Which page should be returned, starting with 1 (1-indexed)").type((GraphQLInputType)Scalars.GraphQLInt).build()).field(GraphQLInputObjectField.newInputObjectField().name("pageSize").description("How many results should this page contain").type((GraphQLInputType)Scalars.GraphQLInt).build()).build()).build();
    private static final GraphQLEnumType orderByDirectionEnum = GraphQLEnumType.newEnum().name("OrderByDirection").description("Describes the direction (Ascending / Descending) to sort a field.").value("ASC", (Object)0, "Ascending").value("DESC", (Object)1, "Descending").build();

    public GraphQLSchemaBuilder(MetaDataService metaDataService, DataSourceDescription databaseId) {
        this.metaDataService = metaDataService;
        this.dataSourceDesc = databaseId;
        super.query(this.getQueryType());
        super.mutation(this.getSaveType());
    }

    @Deprecated
    public GraphQLSchema getGraphQLSchema() {
        return super.build();
    }

    GraphQLObjectType getSaveType() {
        List metaTables = this.metaDataService.listAllMetaTablesWithDetail(this.dataSourceDesc.getDatabaseCode());
        GraphQLObjectType.Builder queryType = GraphQLObjectType.newObject().name("Mutation_MD").description("All encompassing schema for this database metadata environment");
        queryType.fields(metaTables.stream().map(this::getObjectSaveDefinition).collect(Collectors.toList()));
        return queryType.build();
    }

    GraphQLFieldDefinition getObjectSaveDefinition(MetaTable entityType) {
        String entityName = FieldType.mapPropName((String)entityType.getTableName());
        return GraphQLFieldDefinition.newFieldDefinition().name(entityName).description(entityType.getTableLabelName() + " \u5355\u4e2a\u5bf9\u8c61\u4fdd\u5b58").type((GraphQLOutputType)this.getObjectType(entityType)).dataFetcher((DataFetcher)new MetadataDataFetcher(this.metaDataService, this.dataSourceDesc, entityType, 3)).argument(entityType.getColumns().stream().flatMap(this::getArgument).collect(Collectors.toList())).build();
    }

    GraphQLObjectType getQueryType() {
        List metaTables = this.metaDataService.listAllMetaTablesWithDetail(this.dataSourceDesc.getDatabaseCode());
        GraphQLObjectType.Builder queryType = GraphQLObjectType.newObject().name("QueryType_MD").description("All encompassing schema for this database metadata environment");
        queryType.fields(metaTables.stream().map(this::getObjectFieldDefinition).collect(Collectors.toList()));
        queryType.fields(metaTables.stream().map(this::getQueryFieldDefinition).collect(Collectors.toList()));
        queryType.fields(metaTables.stream().map(this::getQueryFieldPageableDefinition).collect(Collectors.toList()));
        return queryType.build();
    }

    GraphQLFieldDefinition getObjectFieldDefinition(MetaTable entityType) {
        String entityName = FieldType.mapPropName((String)entityType.getTableName());
        return GraphQLFieldDefinition.newFieldDefinition().name(entityName).description(entityType.getTableLabelName() + " \u5355\u4e2a\u5bf9\u8c61\u67e5\u8be2").type((GraphQLOutputType)this.getObjectType(entityType)).dataFetcher((DataFetcher)new MetadataDataFetcher(this.metaDataService, this.dataSourceDesc, entityType, 0)).argument(entityType.getColumns().stream().flatMap(this::getArgument).collect(Collectors.toList())).build();
    }

    GraphQLFieldDefinition getQueryFieldDefinition(MetaTable entityType) {
        String entityName = FieldType.mapPropName((String)entityType.getTableName());
        return GraphQLFieldDefinition.newFieldDefinition().name(entityName + "List").description(entityType.getTableLabelName() + " \u5217\u8868").type((GraphQLOutputType)new GraphQLList((GraphQLType)this.getObjectType(entityType))).dataFetcher((DataFetcher)new MetadataDataFetcher(this.metaDataService, this.dataSourceDesc, entityType, 1)).argument(entityType.getColumns().stream().flatMap(this::getArgument).collect(Collectors.toList())).build();
    }

    private GraphQLFieldDefinition getQueryFieldPageableDefinition(MetaTable entityType) {
        String entityName = FieldType.mapPropName((String)entityType.getTableName());
        GraphQLObjectType pageType = GraphQLObjectType.newObject().name(entityName + "Page").description(entityType.getTableLabelName() + " \u5206\u9875\u67e5\u8be2\u5217\u8868").field(GraphQLFieldDefinition.newFieldDefinition().name("pageNo").description("Total index of current page.").type((GraphQLOutputType)Scalars.GraphQLLong).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("pageSize").description("Total max number of one page.").type((GraphQLOutputType)Scalars.GraphQLLong).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("totalRows").description("Total number of results on the database for this query.").type((GraphQLOutputType)Scalars.GraphQLLong).build()).field(GraphQLFieldDefinition.newFieldDefinition().name("objList").description("The actual object results").type((GraphQLOutputType)new GraphQLList((GraphQLType)this.getObjectType(entityType))).build()).build();
        return GraphQLFieldDefinition.newFieldDefinition().name(entityName + "Connection").description("'Connection' request wrapper object for " + entityName + ".  Use this object in a query to request things like pagination or aggregation in an argument.  Use the 'content' field to request actual fields ").type((GraphQLOutputType)pageType).dataFetcher((DataFetcher)new MetadataDataFetcher(this.metaDataService, this.dataSourceDesc, entityType, 2)).argument(paginationArgument).build();
    }

    private Stream<GraphQLArgument> getArgument(MetaColumn attribute) {
        return this.getAttributeType(attribute).filter(type -> type instanceof GraphQLInputType).map(type -> {
            String name = attribute.getPropertyName();
            return GraphQLArgument.newArgument().name(name).type((GraphQLInputType)type).build();
        });
    }

    private GraphQLObjectType getObjectType(MetaTable entityType) {
        String entityName = FieldType.mapPropName((String)entityType.getTableName());
        if (this.entityCache.containsKey(entityName)) {
            return this.entityCache.get(entityName);
        }
        GraphQLObjectType.Builder builder = GraphQLObjectType.newObject().name(entityName).description(entityType.getTableLabelName() + ":" + entityType.getTableComment()).fields(entityType.getColumns().stream().flatMap(this::getObjectField).collect(Collectors.toList()));
        if (entityType.getMdRelations() != null) {
            builder.fields(entityType.getMdRelations().stream().flatMap(this::getObjectRefenceField).collect(Collectors.toList()));
        }
        GraphQLObjectType answer = builder.build();
        this.entityCache.put(entityName, answer);
        return answer;
    }

    private Stream<GraphQLFieldDefinition> getObjectRefenceField(MetaRelation attribute) {
        if (attribute.getTableName() == null) {
            return null;
        }
        return this.getAttributeType(attribute).filter(type -> type instanceof GraphQLOutputType).map(type -> {
            ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
            arguments.add(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)orderByDirectionEnum).build());
            String name = attribute.getReferenceName();
            return GraphQLFieldDefinition.newFieldDefinition().name(name).description(attribute.getRelationComment()).type((GraphQLOutputType)type).argument(arguments).build();
        });
    }

    private Stream<GraphQLFieldDefinition> getObjectField(MetaColumn attribute) {
        return this.getAttributeType(attribute).filter(type -> type instanceof GraphQLOutputType).map(type -> {
            ArrayList<GraphQLArgument> arguments = new ArrayList<GraphQLArgument>();
            arguments.add(GraphQLArgument.newArgument().name("orderBy").type((GraphQLInputType)orderByDirectionEnum).build());
            String name = attribute.getPropertyName();
            return GraphQLFieldDefinition.newFieldDefinition().name(name).description(attribute.getFieldLabelName()).type((GraphQLOutputType)type).argument(arguments).build();
        });
    }

    private GraphQLType getBasicAttributeType(MetaColumn attribute) {
        String columnType = attribute.getColumnType();
        if ("NUMBER".equalsIgnoreCase(columnType) || "INTEGER".equalsIgnoreCase(columnType) || "DECIMAL".equalsIgnoreCase(columnType)) {
            if (attribute.getScale() > 0) {
                return Scalars.GraphQLFloat;
            }
            return Scalars.GraphQLLong;
        }
        if ("FLOAT".equalsIgnoreCase(columnType)) {
            return Scalars.GraphQLFloat;
        }
        if ("CHAR".equalsIgnoreCase(columnType) || "VARCHAR".equalsIgnoreCase(columnType) || "VARCHAR2".equalsIgnoreCase(columnType) || "STRING".equalsIgnoreCase(columnType)) {
            return Scalars.GraphQLString;
        }
        if ("DATE".equalsIgnoreCase(columnType) || "TIME".equalsIgnoreCase(columnType) || "DATETIME".equalsIgnoreCase(columnType)) {
            return JavaScalars.GraphQLLocalDateTime;
        }
        if ("TIMESTAMP".equalsIgnoreCase(columnType)) {
            return JavaScalars.GraphQLLocalDateTime;
        }
        if ("CLOB".equalsIgnoreCase(columnType)) {
            return Scalars.GraphQLString;
        }
        if ("BLOB".equalsIgnoreCase(columnType)) {
            return Scalars.GraphQLByte;
        }
        if ("BOOLEAN".equalsIgnoreCase(columnType)) {
            return Scalars.GraphQLBoolean;
        }
        if ("MONEY".equalsIgnoreCase(columnType)) {
            return Scalars.GraphQLBigDecimal;
        }
        return Scalars.GraphQLString;
    }

    private Stream<GraphQLType> getAttributeType(MetaRelation attribute) {
        return Stream.of(new GraphQLList((GraphQLType)new GraphQLTypeReference(FieldType.mapPropName((String)attribute.getTableName()))));
    }

    private Stream<GraphQLType> getAttributeType(MetaColumn attribute) {
        return Stream.of(this.getBasicAttributeType(attribute));
    }
}

