/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.graphql;

import com.alibaba.fastjson.JSONArray;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.TransactionHandler;
import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.IntValue;
import graphql.language.ObjectValue;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataDataFetcher
implements DataFetcher {
    private final int queryType;
    protected static final Logger logger = LoggerFactory.getLogger(MetadataDataFetcher.class);
    protected MetaTable entityType;
    private MetaDataService metaDataService;
    private DataSourceDescription dataSourceDesc;

    public MetadataDataFetcher(MetaDataService metaDataService, DataSourceDescription dataSourceDesc, MetaTable entityType, int queryType) {
        this.metaDataService = metaDataService;
        this.dataSourceDesc = dataSourceDesc;
        this.entityType = entityType;
        this.queryType = queryType;
    }

    public Object get(DataFetchingEnvironment environment) {
        Field field = (Field)environment.getFields().iterator().next();
        switch (this.queryType) {
            case 0: {
                return this.getObject(environment);
            }
            case 1: {
                return this.listObjects(environment);
            }
            case 2: {
                return this.pageQueryObjects(environment, field);
            }
            case 3: {
                return this.saveObject(environment);
            }
        }
        return null;
    }

    private Long getCountQuery(DataFetchingEnvironment environment, Map<String, Object> filters) {
        try {
            return (Long)TransactionHandler.executeQueryInTransaction((DataSourceDescription)this.dataSourceDesc, conn -> NumberBaseOpt.castObjectToLong((Object)DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)("select count(1) as c from " + this.entityType.getTableName()))));
        }
        catch (IOException | SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return 0L;
        }
    }

    private Optional<Field> getSelectionField(Field field, String fieldName) {
        return field.getSelectionSet().getSelections().stream().filter(it -> it instanceof Field).map(it -> (Field)it).filter(it -> fieldName.equals(it.getName())).findFirst();
    }

    private PageDesc extractPageInformation(DataFetchingEnvironment environment, Field field) {
        Optional<Argument> paginationRequest = field.getArguments().stream().filter(it -> "paginationRequest".equals(it.getName())).findFirst();
        if (paginationRequest.isPresent()) {
            field.getArguments().remove(paginationRequest.get());
            ObjectValue paginationValues = (ObjectValue)paginationRequest.get().getValue();
            IntValue page = (IntValue)paginationValues.getObjectFields().stream().filter(it -> "pageNo".equals(it.getName())).findFirst().get().getValue();
            IntValue size = (IntValue)paginationValues.getObjectFields().stream().filter(it -> "pageSize".equals(it.getName())).findFirst().get().getValue();
            return new PageDesc(page.getValue().intValue(), size.getValue().intValue());
        }
        return new PageDesc(1, Integer.MAX_VALUE);
    }

    private List<Object> listObjects(DataFetchingEnvironment environment) {
        try {
            return (List)TransactionHandler.executeQueryInTransaction((DataSourceDescription)this.dataSourceDesc, conn -> GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)this.entityType).listObjectsByProperties(environment.getArguments()));
        }
        catch (IOException | SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return new ArrayList<Object>();
        }
    }

    private Object getObject(DataFetchingEnvironment environment) {
        try {
            JSONArray ja = (JSONArray)TransactionHandler.executeQueryInTransaction((DataSourceDescription)this.dataSourceDesc, conn -> GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)this.entityType).listObjectsByProperties(environment.getArguments()));
            if (ja != null) {
                return ja.get(0);
            }
        }
        catch (IOException | SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        return null;
    }

    private Object saveObject(DataFetchingEnvironment environment) {
        try {
            TransactionHandler.executeQueryInTransaction((DataSourceDescription)this.dataSourceDesc, conn -> GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)this.entityType).mergeObject(environment.getArguments()));
            return environment.getArguments();
        }
        catch (IOException | SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> pageQueryObjects(DataFetchingEnvironment environment, Field field) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        PageDesc pageInformation = this.extractPageInformation(environment, field);
        try {
            result.put("objList", TransactionHandler.executeQueryInTransaction((DataSourceDescription)this.dataSourceDesc, conn -> GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)this.entityType).listObjectsByProperties(environment.getArguments(), pageInformation.getRowStart(), pageInformation.getPageSize())));
        }
        catch (IOException | SQLException e) {
            logger.error(e.getLocalizedMessage(), (Throwable)e);
        }
        Long totalElements = this.getCountQuery(environment, environment.getArguments());
        result.put("pageSize", pageInformation.getPageSize());
        result.put("totalRows", totalElements);
        result.put("pageNo", pageInformation.getPageNo());
        return result;
    }
}

