/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpContentType;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataCache;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.product.metadata.vo.MetaTableCascade;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.transaction.ConnectThreadHolder;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6570\u636e\u5e93\u5143\u6570\u636e\u67e5\u8be2", tags={"\u5143\u6570\u636e\u67e5\u8be2"})
@RestController
@RequestMapping(value={"query"})
public class MetadataQueryController
extends BaseController {
    @Autowired
    private MetaDataService metaDataService;
    @Autowired
    private MetaDataCache metaDataCache;
    @Autowired
    private IntegrationEnvironment integrationEnvironment;

    @ApiOperation(value="\u6570\u636e\u5e93\u5217\u8868")
    @GetMapping(value={"/databases"})
    @WrapUpResponseBody
    public List<DatabaseInfo> databases(String osId) {
        return this.metaDataService.listDatabase(osId);
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u4e2d\u8868\u5206\u9875\u67e5\u8be2")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93\u4ee3\u7801")
    @GetMapping(value={"/{databaseCode}/tables"})
    @WrapUpResponseBody
    public PageQueryResult<Object> metaTables(@PathVariable String databaseCode, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = MetadataQueryController.collectRequestParameters((HttpServletRequest)request);
        searchColumn.put("databaseCode", databaseCode);
        JSONArray list = this.metaDataService.listMetaTables(searchColumn, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)list, (PageDesc)pageDesc, (Class[])new Class[]{MetaTable.class});
    }

    @ApiOperation(value="\u6570\u636e\u5e93\u4e2d\u7684\u8868\uff08JDBC\u5143\u6570\u636e\uff09\u524d\u6bb5\u5e94\u8be5\u4e0d\u9700\u8981\u8bbf\u95ee\u8fd9\u4e2a\u63a5\u53e3")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93ID")
    @GetMapping(value={"/{databaseCode}/dbtables"})
    public List<SimpleTableInfo> databaseTables(@PathVariable String databaseCode) {
        return this.metaDataService.listRealTables(databaseCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u8868\u5143\u6570\u636e")
    @ApiImplicitParam(name="tableId", value="\u8868ID")
    @GetMapping(value={"/table/{tableId}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public MetaTable getMetaTable(@PathVariable String tableId) {
        return this.metaDataService.getMetaTable(tableId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u8868\u5143\u6570\u636e(\u5305\u62ec\u5b57\u6bb5\u4fe1\u606f\u548c\u5173\u8054\u8868\u4fe1\u606f)")
    @ApiImplicitParam(name="tableId", value="\u8868ID")
    @GetMapping(value={"/table/{tableId}/all"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public MetaTable getMetaTableWithRelations(@PathVariable String tableId) {
        return this.metaDataService.getMetaTableWithRelations(tableId);
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868ID")})
    @GetMapping(value={"/{tableId}/columns"})
    @WrapUpResponseBody
    public PageQueryResult<MetaColumn> listColumns(@PathVariable String tableId, PageDesc pageDesc) {
        List<MetaColumn> list = this.metaDataService.listMetaColumns(tableId, pageDesc);
        return PageQueryResult.createResult(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5217\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868\u5143\u6570\u636eID"), @ApiImplicitParam(name="columnName", value="\u5217\u540d")})
    @GetMapping(value={"/{tableId}/column/{columnName}"})
    @WrapUpResponseBody(contentType=WrapUpContentType.MAP_DICT)
    public MetaColumn getColumn(@PathVariable String tableId, @PathVariable String columnName) {
        return this.metaDataService.getMetaColumn(tableId, columnName);
    }

    @ApiOperation(value="\u67e5\u8be2\u5173\u8054\u5173\u7cfb\u5143\u6570\u636e")
    @GetMapping(value={"/{tableId}/relations"})
    @WrapUpResponseBody
    public PageQueryResult<MetaRelation> metaRelation(@PathVariable String tableId, HttpServletRequest request, PageDesc pageDesc) {
        Map condition = BaseController.collectRequestParameters((HttpServletRequest)request);
        condition.put("parentTableId", tableId);
        List<MetaRelation> list = this.metaDataService.listMetaRelation(condition, pageDesc);
        return PageQueryResult.createResultMapDict(list, (PageDesc)pageDesc);
    }

    @ApiOperation(value="\u5143\u6570\u636e\u7ea7\u8054\u5b57\u6bb5\uff0c\u53ea\u67e5\u8be2\u4e00\u5c42")
    @GetMapping(value={"/tablecascade/{tableId}/{tableAlias}"})
    @WrapUpResponseBody
    public MetaTableCascade getMetaTableCascade(@PathVariable String tableId, @PathVariable String tableAlias) {
        return this.metaDataService.getMetaTableCascade(tableId, tableAlias);
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5217\u53c2\u7167\u6570\u636e\uff0c REFERENCE_TYPE\uff01=\u20180\u2019\u6709\u6548")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868\u5143\u6570\u636eID"), @ApiImplicitParam(name="columnName", value="\u5217\u540d")})
    @GetMapping(value={"/{tableId}/reference/{columnName}"})
    @WrapUpResponseBody
    public Map<String, String> getColumnReferenceData(@PathVariable String tableId, @PathVariable String columnName, HttpServletRequest request) {
        MetaColumn col = this.metaDataService.getMetaColumn(tableId, columnName);
        if (col == null || StringUtils.isBlank((CharSequence)col.getReferenceType()) || "0".equals(col.getReferenceType())) {
            return null;
        }
        switch (col.getReferenceType()) {
            case "1": {
                return CodeRepositoryUtil.getLabelValueMap((String)col.getReferenceData());
            }
            case "2": {
                return CollectionsOpt.objectMapToStringMap((Map)CollectionsOpt.objectToMap((Object)JSON.parse((String)col.getReferenceData())));
            }
            case "3": {
                Map searchColumn = MetadataQueryController.collectRequestParameters((HttpServletRequest)request);
                MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
                DatabaseInfo databaseInfo = this.integrationEnvironment.getDatabaseInfo(tableInfo.getDatabaseCode());
                try {
                    Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
                    QueryAndNamedParams qAp = QueryUtils.translateQuery((String)col.getReferenceData(), (Map)searchColumn);
                    List objects = DatabaseAccess.findObjectsBySql((Connection)conn, (String)qAp.getQuery(), (Object)qAp.getParams());
                    if (objects != null) {
                        HashMap<String, String> stringMap = new HashMap<String, String>(objects.size() * 3 / 2 + 1);
                        for (Object[] objs : objects) {
                            if (objs == null || objs.length < 2) continue;
                            stringMap.put(StringBaseOpt.objectToString((Object)objs[0]), StringBaseOpt.objectToString((Object)objs[1]));
                        }
                        return stringMap;
                    }
                }
                catch (IOException | SQLException e) {
                    throw new ObjectException((Object)col, 620, (Throwable)e);
                }
                return null;
            }
            case "Y": {
                HashMap<String, String> stringMap = new HashMap<String, String>(120);
                for (int i = 1; i < 100; ++i) {
                    stringMap.put(String.valueOf(1950 + i), String.valueOf(1950 + i));
                }
                return stringMap;
            }
            case "M": {
                HashMap<String, String> stringMap = new HashMap<String, String>(100);
                for (int i = 1; i < 13; ++i) {
                    stringMap.put(String.valueOf(i), String.valueOf(i));
                }
                return stringMap;
            }
        }
        return null;
    }
}

