/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.controller;

import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.support.database.utils.FieldType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6570\u636e\u5e93\u5143\u6570\u636e\u4fe1\u606f\u5b8c\u5584", tags={"\u5143\u6570\u636e\u4fe1\u606f\u5b8c\u5584"})
@RestController
@RequestMapping(value={"update"})
public class MetadataUpdateController
extends BaseController {
    @Autowired
    private MetaDataService metaDataService;

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u4e1a\u52a1\u6570\u636e\u7c7b\u578bMap")
    @GetMapping(value={"/fieldType"})
    @WrapUpResponseBody
    public Map<String, String> listFieldType() {
        return FieldType.getAllTypeMap();
    }

    @ApiOperation(value="\u540c\u6b65\u6570\u636e\u5e93")
    @ApiImplicitParam(name="databaseCode", value="\u6570\u636e\u5e93ID")
    @GetMapping(value={"/sync/{databaseCode}"})
    @WrapUpResponseBody
    public void syncDb(@PathVariable String databaseCode, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        this.metaDataService.syncDb(databaseCode, userCode);
    }

    @ApiOperation(value="\u4fee\u6539\u8868\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868ID"), @ApiImplicitParam(name="tableLabelName", value="\u4e2d\u6587\u540d"), @ApiImplicitParam(name="tableComment", value="\u63cf\u8ff0")})
    @PutMapping(value={"/table/{tableId}"})
    @WrapUpResponseBody
    public void updateMetaTable(@PathVariable String tableId, @RequestBody MetaTable metaTable, HttpServletRequest request) {
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        metaTable.setTableId(tableId);
        metaTable.setRecorder(userCode);
        this.metaDataService.updateMetaTable(metaTable);
    }

    @ApiOperation(value="\u4fee\u6539\u5217\u5143\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868ID"), @ApiImplicitParam(name="fieldLabelName", value="\u5217\u540d")})
    @PutMapping(value={"/column/{tableId}/{columnCode}"})
    @WrapUpResponseBody
    public void updateMetaColumns(@PathVariable String tableId, @PathVariable String columnCode, @RequestBody MetaColumn metaColumn) {
        metaColumn.setTableId(tableId);
        metaColumn.setColumnName(columnCode);
        this.metaDataService.updateMetaColumn(metaColumn);
    }

    @ApiOperation(value="\u65b0\u5efa\u5173\u8054\u5173\u7cfb\u5143\u6570\u636e")
    @PostMapping(value={"/{tableId}/relation"})
    @WrapUpResponseBody
    public void createRelations(@PathVariable String tableId, MetaTable metaTable) {
        this.metaDataService.saveRelations(tableId, metaTable.getMdRelations());
    }
}

