/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.product.metadata.service.DatabaseRunTime;
import com.centit.support.common.ObjectException;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.transaction.ConnectThreadHolder;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatabaseRunTimeImpl
implements DatabaseRunTime {
    @Autowired
    private IntegrationEnvironment integrationEnvironment;

    private DataSourceDescription fetchDataSource(String databaseCode) {
        DatabaseInfo databaseInfo = this.integrationEnvironment.getDatabaseInfo(databaseCode);
        return DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo);
    }

    @Override
    public JSONArray query(String databaseId, String sql, Object[] params) {
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)this.fetchDataSource(databaseId));
            return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)sql, (Object[])params);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(620, e.getMessage());
        }
    }

    @Override
    public JSONArray query(String databaseId, String sql) {
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)this.fetchDataSource(databaseId));
            return DatabaseAccess.findObjectsAsJSON((Connection)conn, (String)sql);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(620, e.getMessage());
        }
    }

    @Override
    public int execute(String databaseId, String sql, Object[] params) {
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)this.fetchDataSource(databaseId));
            return DatabaseAccess.doExecuteSql((Connection)conn, (String)sql, (Object[])params);
        }
        catch (SQLException e) {
            throw new ObjectException(620, e.getMessage());
        }
    }

    @Override
    public int execute(String databaseId, String sql) {
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)this.fetchDataSource(databaseId));
            return DatabaseAccess.doExecuteSql((Connection)conn, (String)sql) ? 1 : 0;
        }
        catch (SQLException e) {
            throw new ObjectException(620, e.getMessage());
        }
    }
}

