/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.centit.product.metadata.dao.MetaRelationDao;
import com.centit.product.metadata.dao.MetaTableDao;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataCache;
import com.centit.support.common.CachedMap;
import org.apache.commons.lang3.tuple.MutablePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetaDataCacheImpl
implements MetaDataCache {
    private CachedMap<String, MutablePair<Integer, MetaTable>> metaTableCache = new CachedMap(tableId -> new MutablePair((Object)0, (Object)this.getTableInfoWithColumns((String)tableId)), 10L);
    @Autowired
    private MetaTableDao metaTableDao;
    @Autowired
    private MetaRelationDao metaRelationDao;

    private MetaTable getTableInfoWithColumns(String tableId) {
        MetaTable metaTable = (MetaTable)this.metaTableDao.getObjectById(tableId);
        this.metaTableDao.fetchObjectReference(metaTable, "mdColumns");
        return metaTable;
    }

    @Override
    public MetaTable getTableInfo(String tableId) {
        if (this.metaTableCache.getCachedValue((Object)tableId) != null) {
            return (MetaTable)((MutablePair)this.metaTableCache.getCachedValue((Object)tableId)).getRight();
        }
        return null;
    }

    private MetaTable fetchTableRelations(MetaTable metaTable) {
        this.metaTableDao.fetchObjectReference(metaTable, "mdRelations");
        if (metaTable.getMdRelations().size() > 0) {
            for (MetaRelation mr : metaTable.getMdRelations()) {
                this.metaRelationDao.fetchObjectReference(mr, "relationDetails");
            }
        }
        return metaTable;
    }

    private MetaTable fetchTableParents(MetaTable metaTable) {
        this.metaTableDao.fetchObjectReference(metaTable, "parents");
        if (metaTable.getParents().size() > 0) {
            for (MetaRelation parent : metaTable.getParents()) {
                this.metaRelationDao.fetchObjectReference(parent, "relationDetails");
            }
        }
        return metaTable;
    }

    @Override
    public MetaTable getTableInfoWithRelations(String tableId) {
        MutablePair tablePair = (MutablePair)this.metaTableCache.getCachedValue((Object)tableId);
        MetaTable metaTable = (MetaTable)tablePair.getRight();
        if ((Integer)tablePair.getLeft() % 10 == 0) {
            this.fetchTableRelations(metaTable);
            tablePair.setLeft((Object)((Integer)tablePair.getLeft() + 1));
        }
        return metaTable;
    }

    @Override
    public MetaTable getTableInfoWithParents(String tableId) {
        MutablePair tablePair = (MutablePair)this.metaTableCache.getCachedValue((Object)tableId);
        MetaTable metaTable = (MetaTable)tablePair.getRight();
        if ((Integer)tablePair.getLeft() / 10 == 0) {
            this.fetchTableParents(metaTable);
            tablePair.setLeft((Object)((Integer)tablePair.getLeft() + 10));
        }
        return metaTable;
    }

    @Override
    public MetaTable getTableInfoAll(String tableId) {
        MutablePair tablePair = (MutablePair)this.metaTableCache.getCachedValue((Object)tableId);
        MetaTable metaTable = (MetaTable)tablePair.getRight();
        if ((Integer)tablePair.getLeft() % 10 == 0) {
            this.fetchTableRelations(metaTable);
        }
        if ((Integer)tablePair.getLeft() / 10 == 0) {
            this.fetchTableParents(metaTable);
        }
        tablePair.setLeft((Object)11);
        return metaTable;
    }
}

