/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.product.metadata.dao.MetaColumnDao;
import com.centit.product.metadata.dao.MetaRelationDao;
import com.centit.product.metadata.dao.MetaTableDao;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataService;
import com.centit.product.metadata.vo.MetaTableCascade;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.metadata.JdbcMetadata;
import com.centit.support.database.metadata.SimpleTableField;
import com.centit.support.database.metadata.SimpleTableInfo;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DbcpConnectPools;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MetaDataServiceImpl
implements MetaDataService {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataServiceImpl.class);
    @Autowired
    private IntegrationEnvironment integrationEnvironment;
    @Autowired
    private MetaTableDao metaTableDao;
    @Autowired
    private MetaColumnDao metaColumnDao;
    @Autowired
    private MetaRelationDao metaRelationDao;

    @Override
    public List<DatabaseInfo> listDatabase(String osId) {
        List list = this.integrationEnvironment.listDatabaseInfo();
        if (StringUtils.isBlank((CharSequence)osId)) {
            return list;
        }
        ArrayList<DatabaseInfo> listReturn = new ArrayList<DatabaseInfo>();
        for (DatabaseInfo databaseInfo : list) {
            if (!StringUtils.equals((CharSequence)osId, (CharSequence)databaseInfo.getOsId())) continue;
            listReturn.add(databaseInfo);
        }
        return listReturn;
    }

    @Override
    public JSONArray listMetaTables(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.metaTableDao.listObjectsAsJson(filterMap, pageDesc);
    }

    @Override
    public List<MetaTable> listAllMetaTables(String databaseCode) {
        return this.metaTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode}));
    }

    @Override
    public List<MetaTable> listAllMetaTablesWithDetail(String databaseCode) {
        List metaTables = this.metaTableDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"databaseCode", databaseCode}));
        for (MetaTable mt : metaTables) {
            this.metaTableDao.fetchObjectReferences(mt);
            if (mt.getMdRelations() == null) continue;
            for (MetaRelation mr : mt.getMdRelations()) {
                this.metaRelationDao.fetchObjectReferences(mr);
            }
        }
        return metaTables;
    }

    @Override
    public List<SimpleTableInfo> listRealTables(String databaseCode) {
        DatabaseInfo databaseInfo = this.integrationEnvironment.getDatabaseInfo(databaseCode);
        JdbcMetadata jdbcMetadata = new JdbcMetadata();
        try {
            jdbcMetadata.setDBConfig(DbcpConnectPools.getDbcpConnect((IDatabaseInfo)databaseInfo));
            if (databaseInfo.getDatabaseUrl().indexOf("oracle") > -1) {
                jdbcMetadata.setDBSchema(databaseInfo.getUsername().toUpperCase());
            }
        }
        catch (SQLException e) {
            logger.error("\u8fde\u63a5\u6570\u636e\u5e93\u3010{}\u3011\u51fa\u9519", (Object)databaseInfo.getDatabaseName());
            throw new ObjectException("\u8fde\u63a5\u6570\u636e\u5e93\u51fa\u9519");
        }
        return jdbcMetadata.listAllTable();
    }

    @Override
    public void syncDb(String databaseCode, String recorder) {
        Comparator comparator;
        List<SimpleTableInfo> dbTables = this.listRealTables(databaseCode);
        List metaTables = this.metaTableDao.listObjectsByFilter("where DATABASE_CODE = ?", new Object[]{databaseCode});
        Triple triple = MetaDataServiceImpl.compareMetaBetweenDbTables(metaTables, dbTables, comparator = (o1, o2) -> StringUtils.compare((String)o1.getTableName().toUpperCase(), (String)o2.getTableName().toUpperCase()));
        if (triple.getLeft() != null && ((List)triple.getLeft()).size() > 0) {
            for (Object table : (List)triple.getLeft()) {
                MetaTable metaTable = new MetaTable().convertFromDbTable((SimpleTableInfo)table);
                metaTable.setDatabaseCode(databaseCode);
                if (metaTable.getTableLabelName() == null || "".equals(metaTable.getTableLabelName())) {
                    metaTable.setTableLabelName(table.getTableName());
                }
                metaTable.setRecorder(recorder);
                this.metaTableDao.saveNewObject(metaTable);
                List columns = table.getColumns();
                for (SimpleTableField tableField : columns) {
                    MetaColumn column = new MetaColumn().convertFromTableField(tableField);
                    column.setTableId(metaTable.getTableId());
                    if (column.getFieldLabelName() == null || "".equals(column.getFieldLabelName())) {
                        column.setFieldLabelName(column.getColumnName());
                    }
                    this.metaColumnDao.saveNewObject(column);
                }
            }
        }
        if (triple.getRight() != null && ((List)triple.getRight()).size() > 0) {
            for (Object table : (List)triple.getRight()) {
                this.metaTableDao.deleteObjectReferences((Serializable)table);
                this.metaTableDao.deleteObject((Serializable)table);
            }
        }
        if (triple.getMiddle() != null && ((List)triple.getMiddle()).size() > 0) {
            for (Pair pair : (List)triple.getMiddle()) {
                MetaTable oldTable = (MetaTable)pair.getLeft();
                oldTable.setRecorder(recorder);
                SimpleTableInfo newTable = (SimpleTableInfo)pair.getRight();
                this.metaTableDao.updateObject(oldTable.convertFromDbTable(newTable));
                oldTable = (MetaTable)this.metaTableDao.fetchObjectReferences(oldTable);
                List<MetaColumn> oldColumns = oldTable.getColumns();
                List newColumns = newTable.getColumns();
                Comparator columnComparator = (o1, o2) -> StringUtils.compare((String)o1.getColumnName().toUpperCase(), (String)o2.getColumnName().toUpperCase());
                Triple columnCompared = MetaDataServiceImpl.compareMetaBetweenDbTables(oldColumns, newColumns, columnComparator);
                if (columnCompared.getLeft() != null && ((List)columnCompared.getLeft()).size() > 0) {
                    for (SimpleTableField tableField : (List)columnCompared.getLeft()) {
                        MetaColumn metaColumn = new MetaColumn().convertFromTableField(tableField);
                        metaColumn.setTableId(oldTable.getTableId());
                        metaColumn.setRecorder(recorder);
                        if (metaColumn.getFieldLabelName() == null || "".equals(metaColumn.getFieldLabelName())) {
                            metaColumn.setFieldLabelName(metaColumn.getColumnName());
                        }
                        this.metaColumnDao.saveNewObject(metaColumn);
                    }
                }
                if (columnCompared.getRight() != null && ((List)columnCompared.getRight()).size() > 0) {
                    for (MetaColumn metaColumn : (List)columnCompared.getRight()) {
                        this.metaColumnDao.deleteObject(metaColumn);
                    }
                }
                if (columnCompared.getMiddle() == null || ((List)columnCompared.getMiddle()).size() <= 0) continue;
                for (Pair columnPair : (List)columnCompared.getMiddle()) {
                    MetaColumn oldColumn = (MetaColumn)columnPair.getLeft();
                    oldColumn.setRecorder(recorder);
                    SimpleTableField newColumn = (SimpleTableField)columnPair.getRight();
                    this.metaColumnDao.updateObject(oldColumn.convertFromTableField(newColumn));
                }
            }
        }
    }

    public static <K, V> Triple<List<K>, List<Pair<V, K>>, List<V>> compareMetaBetweenDbTables(List<V> metaTables, List<K> simpleTableInfos, Comparator comparator) {
        if (metaTables == null || metaTables.size() == 0) {
            return new ImmutableTriple(simpleTableInfos, null, null);
        }
        if (simpleTableInfos == null || simpleTableInfos.size() == 0) {
            return new ImmutableTriple(null, null, metaTables);
        }
        List oldList = CollectionsOpt.cloneList(metaTables);
        List newList = CollectionsOpt.cloneList(simpleTableInfos);
        Collections.sort(oldList, comparator);
        Collections.sort(newList, comparator);
        int i = 0;
        int sl = oldList.size();
        int j = 0;
        int dl = newList.size();
        ArrayList insertList = new ArrayList();
        ArrayList delList = new ArrayList();
        ArrayList<ImmutablePair> updateList = new ArrayList<ImmutablePair>();
        while (i < sl && j < dl) {
            int n = comparator.compare(oldList.get(i), newList.get(j));
            if (n < 0) {
                delList.add(oldList.get(i));
                ++i;
                continue;
            }
            if (n == 0) {
                updateList.add(new ImmutablePair(oldList.get(i), newList.get(j)));
                ++i;
                ++j;
                continue;
            }
            insertList.add(newList.get(j));
            ++j;
        }
        while (i < sl) {
            delList.add(oldList.get(i));
            ++i;
        }
        while (j < dl) {
            insertList.add(newList.get(j));
            ++j;
        }
        return new ImmutableTriple(insertList, updateList, delList);
    }

    @Override
    public void updateMetaTable(MetaTable metaTable) {
        this.metaTableDao.updateObject(metaTable);
    }

    @Override
    public MetaTable getMetaTable(String tableId) {
        return (MetaTable)this.metaTableDao.getObjectById(tableId);
    }

    @Override
    public MetaTable getMetaTable(String databaseCode, String tableName) {
        return this.metaTableDao.getMetaTable(databaseCode, tableName);
    }

    private void fetchMetaTableRelations(MetaTable metaTable) {
        this.metaTableDao.fetchObjectReference(metaTable, "mdColumns");
        this.metaTableDao.fetchObjectReference(metaTable, "mdRelations");
        if (metaTable.getMdRelations() != null) {
            for (MetaRelation mr : metaTable.getMdRelations()) {
                this.metaRelationDao.fetchObjectReference(mr, "relationDetails");
            }
        }
    }

    @Override
    public MetaTable getMetaTableWithRelations(String tableId) {
        MetaTable metaTable = (MetaTable)this.metaTableDao.getObjectById(tableId);
        this.fetchMetaTableRelations(metaTable);
        return metaTable;
    }

    @Override
    public MetaTable getMetaTableWithRelations(String databaseCode, String tableName) {
        MetaTable metaTable = this.metaTableDao.getMetaTable(databaseCode, tableName);
        this.fetchMetaTableRelations(metaTable);
        return metaTable;
    }

    private void fetchMetaRelationDetail(MetaRelation relation) {
        this.metaRelationDao.fetchObjectReferences(relation);
        MetaTable table = (MetaTable)this.metaTableDao.getObjectCascadeById(relation.getChildTableId());
        if (table != null) {
            relation.setChildTable(table);
        }
    }

    @Override
    public MetaRelation getMetaRelationById(String relationId) {
        MetaRelation relation = (MetaRelation)this.metaRelationDao.getObjectById(relationId);
        this.metaRelationDao.fetchObjectReferences(relation);
        return relation;
    }

    @Override
    public List<MetaRelation> listMetaRelation(String tableId) {
        List list = this.metaRelationDao.listObjectsByProperty("parentTableId", tableId);
        for (MetaRelation relation : list) {
            this.fetchMetaRelationDetail(relation);
        }
        return list;
    }

    @Override
    public MetaRelation getMetaRelationByName(String tableId, String relationName) {
        return (MetaRelation)this.metaRelationDao.getObjectByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"parentTableId", tableId, "relationName", relationName}));
    }

    @Override
    public List<MetaColumn> listMetaColumns(String tableId) {
        return this.metaColumnDao.listObjectsByProperty("tableId", tableId);
    }

    @Override
    public List<MetaRelation> listMetaRelation(Map<String, Object> condition, PageDesc pageDesc) {
        List list = this.metaRelationDao.listObjectsByProperties(condition, pageDesc);
        for (MetaRelation relation : list) {
            this.fetchMetaRelationDetail(relation);
        }
        return list;
    }

    @Override
    public List<MetaRelation> listMetaRelation(String tableId, PageDesc pageDesc) {
        List list = this.metaRelationDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"parentTableId", tableId}), pageDesc);
        for (MetaRelation relation : list) {
            this.fetchMetaRelationDetail(relation);
        }
        return list;
    }

    @Override
    public List<MetaColumn> listMetaColumns(String tableId, PageDesc pageDesc) {
        return this.metaColumnDao.listObjectsByProperties(CollectionsOpt.createHashMap((Object[])new Object[]{"tableId", tableId}), pageDesc);
    }

    @Override
    public void createRelation(MetaRelation relation) {
        this.metaRelationDao.saveNewObject(relation);
        this.metaRelationDao.saveObjectReferences(relation);
    }

    @Override
    public void saveRelations(String tableId, List<MetaRelation> relations) {
        List dbRelations = this.metaRelationDao.listObjectsByProperty("parentTableId", tableId);
        Triple comparedRelation = CollectionsOpt.compareTwoList((List)dbRelations, relations, (o1, o2) -> StringUtils.compare((String)o1.getChildTableId(), (String)o2.getChildTableId()));
        if (comparedRelation.getLeft() != null) {
            for (MetaRelation relation : (List)comparedRelation.getLeft()) {
                this.metaRelationDao.saveNewObject(relation);
                this.metaRelationDao.saveObjectReference(relation, "relationDetails");
            }
        }
        if (comparedRelation.getRight() != null) {
            for (MetaRelation relation : (List)comparedRelation.getRight()) {
                relation = (MetaRelation)this.metaRelationDao.fetchObjectReferences(relation);
                this.metaRelationDao.deleteObject(relation);
                this.metaRelationDao.deleteObjectReference(relation, "relationDetails");
            }
        }
        if (comparedRelation.getMiddle() != null) {
            for (Pair pair : (List)comparedRelation.getMiddle()) {
                MetaRelation oldRelation = (MetaRelation)pair.getLeft();
                oldRelation = (MetaRelation)this.metaRelationDao.fetchObjectReference(oldRelation, "relationDetails");
                MetaRelation newRelation = (MetaRelation)pair.getRight();
                oldRelation.setRelationName(newRelation.getRelationName());
                oldRelation.setRelationComment(newRelation.getRelationComment());
                this.metaRelationDao.updateObject(oldRelation);
                this.metaRelationDao.deleteObjectReference(oldRelation, "relationDetails");
                newRelation.setRelationId(oldRelation.getRelationId());
                this.metaRelationDao.saveObjectReference(newRelation, "relationDetails");
            }
        }
    }

    @Override
    public MetaColumn getMetaColumn(String tableId, String columnName) {
        return (MetaColumn)this.metaColumnDao.getObjectById(new MetaColumn(tableId, columnName));
    }

    @Override
    public void updateMetaColumn(MetaColumn metaColumn) {
        this.metaColumnDao.updateObject(metaColumn);
    }

    @Override
    public MetaTableCascade getMetaTableCascade(String tableId, String token) {
        MetaTableCascade tableCascade = new MetaTableCascade();
        MetaTable metaTable = (MetaTable)this.metaTableDao.getObjectById(tableId);
        tableCascade.setTableInfo(metaTable);
        String tableToken = StringUtils.isBlank((CharSequence)token) ? "T" : token;
        DatabaseInfo dbInfo = this.integrationEnvironment.getDatabaseInfo(metaTable.getDatabaseCode());
        DBType dbType = DBType.mapDBType((String)dbInfo.getDatabaseUrl());
        tableCascade.setDatabaseType(dbType.toString());
        tableCascade.setTableAlias(tableToken);
        this.metaTableDao.fetchObjectReferences(metaTable);
        int n = 0;
        for (MetaRelation relation : metaTable.getMdRelations()) {
            String childTableId = relation.getChildTableId();
            MetaTable childTable = (MetaTable)this.metaTableDao.getObjectById(childTableId);
            this.metaRelationDao.fetchObjectReferences(relation);
            tableCascade.addRelationTable(childTable, relation.getRelationDetails(), tableToken + "_" + n);
            ++n;
        }
        tableCascade.setTableFields(metaTable.getMdColumns());
        return tableCascade;
    }
}

