/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.framework.ip.service.IntegrationEnvironment;
import com.centit.product.metadata.po.MetaColumn;
import com.centit.product.metadata.po.MetaRelation;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataCache;
import com.centit.product.metadata.service.MetaObjectService;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.compiler.VariableFormula;
import com.centit.support.database.jsonmaptable.GeneralJsonObjectDao;
import com.centit.support.database.jsonmaptable.JsonObjectDao;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.metadata.TableField;
import com.centit.support.database.metadata.TableInfo;
import com.centit.support.database.transaction.ConnectThreadHolder;
import com.centit.support.database.utils.DBType;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.database.utils.QueryAndNamedParams;
import com.centit.support.database.utils.QueryUtils;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetaObjectServiceImpl
implements MetaObjectService {
    @Autowired
    private IntegrationEnvironment integrationEnvironment;
    @Autowired
    private MetaDataCache metaDataCache;

    private static Map<String, Object> prepareObjectForSave(Map<String, Object> object, MetaTable metaTable) {
        for (MetaColumn col : metaTable.getMdColumns()) {
            Object fieldValue = object.get(col.getPropertyName());
            if (fieldValue == null) continue;
            switch (col.getFieldType()) {
                case "date": 
                case "datetime": 
                case "timestamp": {
                    object.put(col.getPropertyName(), DatetimeOpt.castObjectToSqlTimestamp((Object)fieldValue));
                    break;
                }
                case "integer": 
                case "long": {
                    object.put(col.getPropertyName(), NumberBaseOpt.castObjectToLong((Object)fieldValue));
                    break;
                }
                case "money": {
                    object.put(col.getPropertyName(), NumberBaseOpt.castObjectToBigDecimal((Object)fieldValue));
                    break;
                }
                case "float": 
                case "double": {
                    object.put(col.getPropertyName(), NumberBaseOpt.castObjectToDouble((Object)fieldValue));
                    break;
                }
                case "string": 
                case "text": {
                    object.put(col.getPropertyName(), StringBaseOpt.castObjectToString((Object)fieldValue));
                    break;
                }
                case "boolean": {
                    object.put(col.getPropertyName(), BooleanBaseOpt.castObjectToBoolean((Object)fieldValue, (Boolean)false) != false ? "T" : "F");
                    break;
                }
            }
        }
        return object;
    }

    private static void makeObjectValueByGenerator(Map<String, Object> object, Map<String, Object> extParams, MetaTable metaTable, JsonObjectDao sqlDialect, long pkOrder, boolean isGetObject) throws SQLException, IOException {
        for (MetaColumn field : metaTable.getMdColumns()) {
            if (!StringUtils.equalsAny((CharSequence)field.getAutoCreateRule(), (CharSequence[])new CharSequence[]{"C", "U", "S", "F", "O"}) || object.get(field.getPropertyName()) != null) continue;
            switch (field.getAutoCreateRule()) {
                case "U": {
                    object.put(field.getPropertyName(), UuidOpt.getUuidAsString32());
                    break;
                }
                case "S": {
                    if (sqlDialect == null) break;
                    object.put(field.getPropertyName(), sqlDialect.getSequenceNextValue(field.getAutoCreateParam()));
                    break;
                }
                case "C": {
                    object.put(field.getPropertyName(), field.getAutoCreateParam());
                    break;
                }
                case "F": {
                    if (extParams != null) {
                        HashMap<String, Object> objectMap = new HashMap<String, Object>(extParams.size() + object.size() + 2);
                        objectMap.putAll(extParams);
                        objectMap.putAll(object);
                        object.put(field.getPropertyName(), VariableFormula.calculate((String)field.getAutoCreateParam(), objectMap));
                        break;
                    }
                    object.put(field.getPropertyName(), VariableFormula.calculate((String)field.getAutoCreateParam(), object));
                    break;
                }
                case "O": {
                    if (isGetObject) break;
                    int pkCount = metaTable.countPkColumn();
                    if (pkCount < 2 || !field.isPrimaryKey()) {
                        throw new ObjectException(627, "\u4e3b\u952e\u751f\u6210\u89c4\u5219SUB_ORDER\u5fc5\u987b\u7528\u4e8e\u590d\u5408\u4e3b\u952e\u8868\u4e2d\uff0c\u5e76\u4e14\u53ea\u80fd\u7528\u4e8e\u6574\u578b\u5b57\u6bb5\uff01");
                    }
                    StringBuilder sqlBuilder = new StringBuilder("select max(");
                    sqlBuilder.append(field.getColumnName()).append(" ) as maxOrder from ").append(metaTable.getTableName()).append(" where ");
                    int pki = 0;
                    Object[] pkValues = new Object[pkCount - 1];
                    for (MetaColumn col : metaTable.getColumns()) {
                        if (!col.isPrimaryKey() || StringUtils.equals((CharSequence)col.getPropertyName(), (CharSequence)field.getPropertyName())) continue;
                        if (pki > 0) {
                            sqlBuilder.append(" and ");
                        }
                        sqlBuilder.append(col.getColumnName()).append(" = ?");
                        pkValues[pki] = object.get(col.getPropertyName());
                        ++pki;
                    }
                    Long pkSubOrder = NumberBaseOpt.castObjectToLong((Object)DatabaseAccess.fetchScalarObject((List)sqlDialect.findObjectsBySql(sqlBuilder.toString(), pkValues)));
                    object.put(field.getPropertyName(), pkSubOrder == null ? pkOrder : pkSubOrder + pkOrder);
                    break;
                }
            }
        }
    }

    private DatabaseInfo fetchDatabaseInfo(String databaseCode) {
        return this.integrationEnvironment.getDatabaseInfo(databaseCode);
    }

    private Map<String, Object> innerGetObjectById(Connection conn, MetaTable tableInfo, Map<String, Object> pk) throws IOException, SQLException {
        GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
        if (pk.size() == 0) {
            throw new ObjectException(tableInfo.getTableName() + "\u6ca1\u6709\u4f20\u5165\u4e3b\u952e");
        }
        if (dao.checkHasAllPkColumns(pk)) {
            return dao.getObjectById(pk);
        }
        if (pk.containsKey("flowInstId")) {
            return dao.getObjectByProperties(pk);
        }
        throw new ObjectException("\u8868\u6216\u8005\u89c6\u56fe " + tableInfo.getTableName() + " \u7f3a\u5c11\u5bf9\u5e94\u4e3b\u952e:" + JSON.toJSONString(pk));
    }

    private Map<String, Object> innerGetObjectPartFieldsById(Connection conn, MetaTable tableInfo, Map<String, Object> pk, String[] fields) throws IOException, SQLException {
        String filter;
        if (pk.size() == 0) {
            throw new ObjectException(tableInfo.getTableName() + "\u6ca1\u6709\u4f20\u5165\u4e3b\u952e");
        }
        HashSet<String> fieldSet = this.collectPartFields(tableInfo, fields);
        Pair q = GeneralJsonObjectDao.buildPartFieldSqlWithFields((TableInfo)tableInfo, fieldSet, null, (boolean)false);
        if (GeneralJsonObjectDao.checkHasAllPkColumns((TableInfo)tableInfo, pk)) {
            filter = GeneralJsonObjectDao.buildFilterSqlByPk((TableInfo)tableInfo, null);
        } else if (pk.containsKey("flowInstId")) {
            filter = GeneralJsonObjectDao.buildFilterSql((TableInfo)tableInfo, null, (Collection)CollectionsOpt.createList((Object[])new String[]{"flowInstId", "nodeInstId"}));
        } else {
            throw new ObjectException(tableInfo.getTableName() + "\u6ca1\u6709\u4f20\u5165\u4e3b\u952e");
        }
        String querySql = "select " + (String)q.getLeft() + " from " + tableInfo.getTableName() + " where " + filter;
        JSONArray objs = GeneralJsonObjectDao.findObjectsByNamedSql((Connection)conn, (String)querySql, pk, (TableField[])((TableField[])q.getRight()));
        if (objs != null && objs.size() == 1) {
            return (JSONObject)objs.get(0);
        }
        return null;
    }

    @Override
    public Map<String, Object> getObjectById(String tableId, Map<String, Object> pk) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            return this.innerGetObjectById(conn, tableInfo, pk);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    private void fetchObjectParent(Connection conn, Map<String, Object> mainObj, MetaRelation md) throws SQLException, IOException {
        MetaTable parentTableInfo = this.metaDataCache.getTableInfo(md.getParentTableId());
        Map<String, Object> ref = md.fetchParentPk(mainObj);
        if (ref != null && GeneralJsonObjectDao.checkHasAllPkColumns((TableInfo)parentTableInfo, ref)) {
            JSONObject ja = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)parentTableInfo).getObjectById(ref);
            mainObj.put(md.getRelationName(), DictionaryMapUtils.mapJsonObject((Map)ja, parentTableInfo.fetchDictionaryMapColumns(this.integrationEnvironment)));
        }
    }

    private void fetchObjectParents(Connection conn, Map<String, Object> mainObj, MetaTable tableInfo) throws SQLException, IOException {
        List<MetaRelation> mds = tableInfo.getParents();
        if (mds != null) {
            for (MetaRelation md : mds) {
                if (md.getRelationDetails() == null) continue;
                this.fetchObjectParent(conn, mainObj, md);
            }
        }
    }

    private void fetchObjectRefrence(Connection conn, Map<String, Object> mainObj, MetaRelation md) throws SQLException, IOException {
        MetaTable subTableInfo = this.metaDataCache.getTableInfoWithRelations(md.getChildTableId());
        Map<String, Object> ref = md.fetchChildFk(mainObj);
        if (ref != null) {
            JSONArray ja = DictionaryMapUtils.mapJsonArray((JSONArray)GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)subTableInfo).listObjectsByProperties(ref), subTableInfo.fetchDictionaryMapColumns(this.integrationEnvironment));
            mainObj.put(md.getRelationName(), ja);
        }
    }

    private void fetchObjectRefrences(Connection conn, Map<String, Object> mainObj, MetaTable tableInfo, int withChildrenDeep) throws SQLException, IOException {
        List<MetaRelation> mds = tableInfo.getMdRelations();
        if (mds != null) {
            for (MetaRelation md : mds) {
                MetaTable subTableInfo = this.metaDataCache.getTableInfoWithRelations(md.getChildTableId());
                Map<String, Object> ref = md.fetchChildFk(mainObj);
                if (ref == null) continue;
                JSONArray ja = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)subTableInfo).listObjectsByProperties(ref);
                ja = DictionaryMapUtils.mapJsonArray((JSONArray)ja, subTableInfo.fetchDictionaryMapColumns(this.integrationEnvironment));
                if (withChildrenDeep > 1 && ja != null) {
                    for (Object subObject : ja) {
                        if (!(subObject instanceof Map)) continue;
                        this.fetchObjectRefrences(conn, (Map)subObject, subTableInfo, withChildrenDeep - 1);
                    }
                }
                mainObj.put(md.getRelationName(), ja);
            }
        }
    }

    @Override
    public Map<String, Object> getObjectWithChildren(String tableId, Map<String, Object> pk, String[] fields, String[] parents, String[] children) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoAll(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            Map<String, Object> mainObj = fields != null && fields.length > 0 ? this.innerGetObjectPartFieldsById(conn, tableInfo, pk, fields) : this.innerGetObjectById(conn, tableInfo, pk);
            mainObj = DictionaryMapUtils.mapJsonObject(mainObj, tableInfo.fetchDictionaryMapColumns(this.integrationEnvironment));
            return this.fetchObjectParentAndChildren(tableInfo, mainObj, parents, children);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> fetchObjectParentAndChildren(MetaTable tableInfo, Map<String, Object> mainObj, String[] parents, String[] children) {
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            List<MetaRelation> mds;
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            if (parents != null && parents.length > 0 && (mds = tableInfo.getParents()) != null) {
                for (MetaRelation md : mds) {
                    if (!StringUtils.equalsAny((CharSequence)md.getReferenceName(), (CharSequence[])parents) || md.getRelationDetails() == null) continue;
                    this.fetchObjectParent(conn, mainObj, md);
                }
            }
            if ((mds = tableInfo.getMdRelations()) != null) {
                for (MetaRelation md : mds) {
                    if (!StringUtils.equalsAny((CharSequence)md.getReferenceName(), (CharSequence[])children) || md.getRelationDetails() == null) continue;
                    this.fetchObjectRefrence(conn, mainObj, md);
                }
            }
            return mainObj;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(mainObj, 620, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> getObjectWithChildren(String tableId, Map<String, Object> pk, int withChildrenDeep) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoAll(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            Map mainObj = this.innerGetObjectById(conn, tableInfo, pk);
            mainObj = DictionaryMapUtils.mapJsonObject(mainObj, tableInfo.fetchDictionaryMapColumns(this.integrationEnvironment));
            if (withChildrenDeep > 0 && mainObj != null) {
                this.fetchObjectRefrences(conn, mainObj, tableInfo, withChildrenDeep);
            }
            this.fetchObjectParents(conn, mainObj, tableInfo);
            return mainObj;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> makeNewObject(String tableId, Map<String, Object> extParams) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoWithParents(tableId);
        JSONObject objectMap = new JSONObject();
        if (extParams != null && !extParams.isEmpty()) {
            for (MetaColumn col : tableInfo.getColumns()) {
                Object colValue = extParams.get(col.getPropertyName());
                if (colValue == null) continue;
                objectMap.put(col.getPropertyName(), colValue);
            }
        }
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            MetaObjectServiceImpl.makeObjectValueByGenerator((Map<String, Object>)objectMap, extParams, tableInfo, (JsonObjectDao)dao, 1L, true);
            this.fetchObjectParents(conn, (Map<String, Object>)objectMap, tableInfo);
            return objectMap;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException((Object)objectMap, 620, (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> makeNewObject(String tableId) {
        return this.makeNewObject(tableId, null);
    }

    @Override
    public int saveObject(String tableId, Map<String, Object> object, Map<String, Object> extParams) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            MetaObjectServiceImpl.makeObjectValueByGenerator(object, extParams, tableInfo, (JsonObjectDao)dao, 1L, false);
            MetaObjectServiceImpl.prepareObjectForSave(object, tableInfo);
            return dao.saveNewObject(object);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(object, 620, (Throwable)e);
        }
    }

    @Override
    public int saveObject(String tableId, Map<String, Object> object) {
        return this.saveObject(tableId, object, null);
    }

    @Override
    public int updateObject(String tableId, Map<String, Object> object) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        MetaObjectServiceImpl.prepareObjectForSave(object, tableInfo);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            return GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).updateObject(object);
        }
        catch (SQLException e) {
            throw new ObjectException(object, 620, (Throwable)e);
        }
    }

    @Override
    public int updateObjectFields(String tableId, Collection<String> fields, Map<String, Object> object) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        MetaObjectServiceImpl.prepareObjectForSave(object, tableInfo);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            return dao.updateObjectsByProperties(fields, object, dao.makePkFieldMap(object));
        }
        catch (SQLException e) {
            throw new ObjectException(object, 620, (Throwable)e);
        }
    }

    @Override
    public int updateObjectsByProperties(String tableId, Collection<String> fields, Map<String, Object> fieldValues, Map<String, Object> filterProperties) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        MetaObjectServiceImpl.prepareObjectForSave(fieldValues, tableInfo);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            return GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).updateObjectsByProperties(fields, fieldValues, filterProperties);
        }
        catch (SQLException e) {
            throw new ObjectException(fieldValues, 620, (Throwable)e);
        }
    }

    @Override
    public int updateObjectsByProperties(String tableId, Map<String, Object> fieldValues, Map<String, Object> filterProperties) {
        return this.updateObjectsByProperties(tableId, fieldValues.keySet(), fieldValues, filterProperties);
    }

    @Override
    public void deleteObject(String tableId, Map<String, Object> pk) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).deleteObjectById(pk);
        }
        catch (SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    public int innerSaveObject(String tableId, Map<String, Object> mainObj, Map<String, Object> extParams, boolean isUpdate) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoWithRelations(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            if (isUpdate) {
                MetaObjectServiceImpl.prepareObjectForSave(mainObj, tableInfo);
                GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).updateObject(mainObj);
            } else {
                GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
                MetaObjectServiceImpl.makeObjectValueByGenerator(mainObj, extParams, tableInfo, (JsonObjectDao)dao, 1L, false);
                MetaObjectServiceImpl.prepareObjectForSave(mainObj, tableInfo);
                dao.saveNewObject(mainObj);
            }
            List<MetaRelation> mds = tableInfo.getMdRelations();
            if (mds != null) {
                for (MetaRelation md : mds) {
                    Object subObjects;
                    MetaTable relTableInfo = this.metaDataCache.getTableInfo(md.getChildTableId());
                    if (!"T".equals(relTableInfo.getTableType()) || !((subObjects = mainObj.get(md.getRelationName())) instanceof List)) continue;
                    List subTable = (List)subObjects;
                    GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)relTableInfo);
                    Map<String, Object> ref = md.fetchChildFk(mainObj);
                    long order = 1L;
                    for (Map subObj : subTable) {
                        subObj.putAll(ref);
                        MetaObjectServiceImpl.makeObjectValueByGenerator(subObj, extParams, relTableInfo, (JsonObjectDao)dao, order, false);
                        ++order;
                        MetaObjectServiceImpl.prepareObjectForSave(subObj, relTableInfo);
                    }
                    dao.replaceObjectsAsTabulation(subTable, ref);
                }
            }
            return 1;
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(mainObj, 620, (Throwable)e);
        }
    }

    @Override
    public int saveObjectWithChildren(String tableId, Map<String, Object> object, Map<String, Object> extParams) {
        return this.innerSaveObject(tableId, object, extParams, false);
    }

    @Override
    public int saveObjectWithChildren(String tableId, Map<String, Object> object) {
        return this.innerSaveObject(tableId, object, null, false);
    }

    @Override
    public int updateObjectWithChildren(String tableId, Map<String, Object> object) {
        return this.innerSaveObject(tableId, object, null, true);
    }

    @Override
    public void deleteObjectWithChildren(String tableId, Map<String, Object> pk) {
        MetaTable tableInfo = this.metaDataCache.getTableInfoWithRelations(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            JSONObject mainObj = dao.getObjectById(pk);
            List<MetaRelation> mds = tableInfo.getMdRelations();
            if (mds != null) {
                for (MetaRelation md : mds) {
                    MetaTable relTableInfo = this.metaDataCache.getTableInfo(md.getChildTableId());
                    if (!"T".equals(relTableInfo.getTableType())) continue;
                    GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)relTableInfo).deleteObjectsByProperties(md.fetchChildFk((Map<String, Object>)mainObj));
                }
            }
            dao.deleteObjectById(pk);
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(pk, 620, (Throwable)e);
        }
    }

    @Override
    public JSONArray listObjectsByProperties(String tableId, Map<String, Object> filter) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            JSONArray ja = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo).listObjectsByProperties(filter);
            return DictionaryMapUtils.mapJsonArray((JSONArray)ja, tableInfo.fetchDictionaryMapColumns(this.integrationEnvironment));
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(filter, 620, (Throwable)e);
        }
    }

    private HashSet<String> collectPartFields(MetaTable tableInfo, String[] fields) {
        HashSet<String> fieldSet = new HashSet<String>((fields.length + 5) * 3 / 2);
        for (TableField pkField : tableInfo.getPkFields()) {
            fieldSet.add(pkField.getPropertyName());
        }
        if (!"0".equals(tableInfo.getWorkFlowOptType())) {
            fieldSet.add("flowInstId");
            fieldSet.add("nodeInstId");
        }
        if (BooleanBaseOpt.castObjectToBoolean((Object)tableInfo.getUpdateCheckTimeStamp(), (Boolean)false).booleanValue()) {
            fieldSet.add("lastModifyTime");
        }
        Collections.addAll(fieldSet, fields);
        return fieldSet;
    }

    @Override
    public JSONArray pageQueryObjects(String tableId, String extFilter, Map<String, Object> params, String[] fields, PageDesc pageDesc) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        try {
            String orderBy;
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            HashSet<String> fieldSet = null;
            if (fields != null && fields.length > 0) {
                fieldSet = this.collectPartFields(tableInfo, fields);
            }
            Pair q = fieldSet == null ? GeneralJsonObjectDao.buildFieldSqlWithFields((TableInfo)tableInfo, null, (boolean)true) : GeneralJsonObjectDao.buildPartFieldSqlWithFields((TableInfo)tableInfo, fieldSet, null, (boolean)false);
            String filter = GeneralJsonObjectDao.buildFilterSql((TableInfo)tableInfo, null, params.keySet());
            if (StringUtils.isNotBlank((CharSequence)extFilter)) {
                filter = StringUtils.isNotBlank((CharSequence)filter) ? extFilter + " and " + filter : extFilter;
            }
            String sql = "select " + (String)q.getLeft() + " from " + tableInfo.getTableName();
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                sql = sql + " where " + filter;
            }
            if (StringUtils.isNotBlank((CharSequence)(orderBy = GeneralJsonObjectDao.fetchSelfOrderSql((String)sql, params)))) {
                sql = sql + " order by " + QueryUtils.cleanSqlStatement((String)orderBy);
            }
            String querySql = QueryUtils.buildLimitQuerySQL((String)sql, (int)pageDesc.getRowStart(), (int)pageDesc.getPageSize(), (boolean)false, (DBType)databaseInfo.getDBType());
            JSONArray objs = GeneralJsonObjectDao.findObjectsByNamedSql((Connection)conn, (String)querySql, params, (TableField[])((TableField[])q.getRight()));
            String sGetCountSql = "select count(1) as totalRows from " + tableInfo.getTableName();
            if (StringUtils.isNotBlank((CharSequence)filter)) {
                sGetCountSql = sGetCountSql + " where " + filter;
            }
            Object obj = DatabaseAccess.getScalarObjectQuery((Connection)conn, (String)sGetCountSql, params);
            pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)obj));
            return DictionaryMapUtils.mapJsonArray((JSONArray)objs, tableInfo.fetchDictionaryMapColumns(this.integrationEnvironment));
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(params, 620, (Throwable)e);
        }
    }

    @Override
    public JSONArray pageQueryObjects(String tableId, Map<String, Object> params, String[] fields, PageDesc pageDesc) {
        return this.pageQueryObjects(tableId, null, params, fields, pageDesc);
    }

    @Override
    public JSONArray pageQueryObjects(String tableId, Map<String, Object> params, PageDesc pageDesc) {
        return this.pageQueryObjects(tableId, null, params, null, pageDesc);
    }

    @Override
    public JSONArray pageQueryObjects(String tableId, String namedSql, Map<String, Object> params, PageDesc pageDesc) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        DatabaseInfo databaseInfo = this.fetchDatabaseInfo(tableInfo.getDatabaseCode());
        String orderBy = GeneralJsonObjectDao.fetchSelfOrderSql((String)namedSql, params);
        String querySql = StringUtils.isBlank((CharSequence)orderBy) ? namedSql : QueryUtils.removeOrderBy((String)namedSql) + " order by " + QueryUtils.cleanSqlStatement((String)orderBy);
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)databaseInfo));
            GeneralJsonObjectDao dao = GeneralJsonObjectDao.createJsonObjectDao((Connection)conn, (TableInfo)tableInfo);
            JSONArray objs = dao.findObjectsByNamedSqlAsJSON(querySql, params, null, pageDesc.getPageNo(), pageDesc.getPageSize());
            pageDesc.setTotalRows(NumberBaseOpt.castObjectToInteger((Object)DatabaseAccess.queryTotalRows((Connection)conn, (String)querySql, params)));
            return DictionaryMapUtils.mapJsonArray((JSONArray)objs, tableInfo.fetchDictionaryMapColumns(this.integrationEnvironment));
        }
        catch (IOException | SQLException e) {
            throw new ObjectException(params, 620, (Throwable)e);
        }
    }

    @Override
    public JSONArray paramDriverPageQueryObjects(String tableId, String paramDriverSql, Map<String, Object> params, PageDesc pageDesc) {
        QueryAndNamedParams qap = QueryUtils.translateQuery((String)paramDriverSql, params);
        return this.pageQueryObjects(tableId, qap.getQuery(), qap.getParams(), pageDesc);
    }
}

