/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.service.impl;

import com.centit.framework.ip.po.DatabaseInfo;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.metadata.IDatabaseInfo;
import com.centit.support.database.transaction.ConnectThreadHolder;
import com.centit.support.database.utils.DataSourceDescription;
import com.centit.support.database.utils.DatabaseAccess;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlDictionaryMapSupplier
implements Supplier<Map<String, String>> {
    private static final Logger logger = LoggerFactory.getLogger(SqlDictionaryMapSupplier.class);
    private DatabaseInfo databaseInfo;
    private String sqlSen;

    public SqlDictionaryMapSupplier(DatabaseInfo databaseInfo, String sqlSen) {
        this.databaseInfo = databaseInfo;
        this.sqlSen = sqlSen;
    }

    @Override
    public Map<String, String> get() {
        try {
            Connection conn = ConnectThreadHolder.fetchConnect((DataSourceDescription)DataSourceDescription.valueOf((IDatabaseInfo)this.databaseInfo));
            List datas = DatabaseAccess.findObjectsBySql((Connection)conn, (String)this.sqlSen);
            if (datas != null) {
                HashMap<String, String> dictionary = new HashMap<String, String>(datas.size() * 5 / 4 + 1);
                for (Object[] objs : datas) {
                    if (objs == null || objs.length <= 1) continue;
                    dictionary.put(StringBaseOpt.castObjectToString((Object)objs[0]), StringBaseOpt.castObjectToString((Object)objs[1]));
                }
                return dictionary;
            }
        }
        catch (IOException | SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

