/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.controller;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.components.OperationLogCenter;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.framework.model.basedata.OperationLog;
import com.centit.framework.model.basedata.OsInfo;
import com.centit.product.metadata.po.MetaTable;
import com.centit.product.metadata.service.MetaDataCache;
import com.centit.product.metadata.service.MetaObjectService;
import com.centit.product.metadata.transaction.MetadataJdbcTransaction;
import com.centit.product.metadata.utils.SessionDataUtils;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import com.centit.support.security.SecurityOptUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"object"})
@Api(value="\u57fa\u4e8e\u5143\u6570\u636e\u7684\u6570\u636e\u8bbf\u95ee\u670d\u52a1", tags={"\u6570\u636e\u8bbf\u95ee"})
public class MetaObjectController
extends BaseController {
    @Autowired
    private MetaObjectService metaObjectService;
    @Autowired
    private MetaDataCache metaDataCache;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6570\u636e\u5e93\u8868\u6570\u636e\u5217\u8868")
    @RequestMapping(value={"/{tableId}/list"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public PageQueryResult<Object> listObjects(@PathVariable String tableId, PageDesc pageDesc, String[] fields, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        Map params = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        JSONArray ja = this.metaObjectService.pageQueryObjects(tableId, params, pageDesc);
        return PageQueryResult.createJSONArrayResult((JSONArray)ja, (PageDesc)pageDesc, (String[])fields);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e00\u4e2a\u6570\u636e\uff0c\u4e3b\u952e\u4f5c\u4e3a\u53c2\u6570\u4ee5key-value\u5f62\u5f0f\u63d0\u4ea4")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public Map<String, Object> getObject(@PathVariable String tableId, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        Map parameters = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        return this.metaObjectService.getObjectById(tableId, parameters);
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u5e93\u8868\u6570\u636e")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public ResponseData updateObject(@PathVariable String tableId, @RequestBody String jsonString, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        this.metaObjectService.updateObject(tableId, (Map<String, Object>)JSON.parseObject((String)jsonString));
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u6839\u636e\u5c5e\u6027\u4fee\u6539\u6570\u636e\u5e93\u8868\u6570\u636e")
    @RequestMapping(value={"/{tableId}/batch"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public ResponseData batchUpdateObject(@PathVariable String tableId, @RequestBody String fieldsObject, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        Map params = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        JSONObject object = JSON.parseObject((String)fieldsObject);
        int iReturn = this.metaObjectService.updateObjectsByProperties(tableId, (Map<String, Object>)object, params);
        if (iReturn == 0) {
            return ResponseData.makeErrorMessage((String)"\u65e0\u5bf9\u5e94sql\u751f\u6210");
        }
        return ResponseData.makeSuccessResponse((String)("\u6210\u529f\u66f4\u65b0" + iReturn + "\u6761"));
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u6570\u636e\u5e93\u8868\u6570\u636e")
    @RequestMapping(value={"/{tableId}/batchDelete"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public ResponseData batchDeleteObject(@PathVariable String tableId, @RequestBody String primaryArray, Integer withChildrenDeep, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        JSONArray tempJsonArray = JSON.parseArray((String)primaryArray);
        tempJsonArray.forEach(object -> this.metaObjectService.deleteObjectWithChildren(tableId, CollectionsOpt.objectToMap((Object)object), withChildrenDeep == null ? 1 : withChildrenDeep));
        return ResponseData.makeSuccessResponse((String)("\u6210\u529f\u5220\u9664" + tempJsonArray.size() + "\u6761"));
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5e93\u8868\u6570\u636e")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public ResponseData saveObject(@PathVariable String tableId, @RequestBody String jsonString, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        this.metaObjectService.saveObject(tableId, (Map<String, Object>)JSON.parseObject((String)jsonString));
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5e93\u8868\u6570\u636e")
    @RequestMapping(value={"/{tableId}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public ResponseData deleteObject(@PathVariable String tableId, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        Map parameters = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        this.metaObjectService.deleteObject(tableId, parameters);
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u6279\u91cfmerge\u6570\u636e\u5e26\u5b50\u8868")
    @RequestMapping(value={"/{tableId}/batchMerge"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public List<Map<String, Object>> batchMergeObjectWithChildren(@PathVariable String tableId, @RequestBody String mergeArray, Integer withChildrenDeep, HttpServletRequest request) {
        HashMap<String, Object> hashMap = SessionDataUtils.createSessionDataMap(WebOptUtils.getCurrentUserDetails((HttpServletRequest)request));
        this.checkUserOptPower(request, true);
        JSONArray jsonArray = JSON.parseArray((String)mergeArray);
        MetaTable tableInfo = this.metaDataCache.getTableInfo(tableId);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        jsonArray.forEach(object -> {
            this.innerMergeObject(tableId, tableInfo, (JSONObject)object, hashMap, withChildrenDeep == null ? 1 : withChildrenDeep);
            Map primaryKey = tableInfo.fetchObjectPk((Map)((JSONObject)object));
            list.add(primaryKey);
        });
        return list;
    }

    private void innerMergeObject(String tableId, MetaTable tableInfo, JSONObject object, Map<String, Object> extParams, Integer withChildrenDeep) {
        Map<String, Object> dbObject;
        Map dbObjectPk = tableInfo.fetchObjectPk((Map)object);
        Map<String, Object> map = dbObject = dbObjectPk == null ? null : this.metaObjectService.getObjectById(tableId, dbObjectPk);
        if (dbObject == null) {
            this.metaObjectService.saveObjectWithChildren(tableId, (Map<String, Object>)object, extParams, withChildrenDeep);
        } else {
            this.metaObjectService.updateObjectWithChildren(tableId, (Map<String, Object>)object, extParams, withChildrenDeep);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u4e00\u4e2a\u6570\u636e\u5e26\u5b50\u8868\uff0c\u4e3b\u952e\u4f5c\u4e3a\u53c2\u6570\u4ee5key-value\u5f62\u5f0f\u63d0\u4ea4")
    @RequestMapping(value={"/{tableId}/withChildren"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public Map<String, Object> getObjectWithChildren(@PathVariable String tableId, Integer withChildrenDeep, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        Map parameters = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        return this.metaObjectService.getObjectWithChildren(tableId, parameters, withChildrenDeep == null ? 1 : withChildrenDeep);
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e\u5e93\u8868\u6570\u636e\u5e26\u5b50\u8868")
    @RequestMapping(value={"/{tableId}/withChildren"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public ResponseData updateObjectWithChildren(@PathVariable String tableId, Integer withChildrenDeep, @RequestBody String jsonString, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        this.metaObjectService.updateObjectWithChildren(tableId, (Map<String, Object>)JSON.parseObject((String)jsonString), SessionDataUtils.createSessionDataMap(WebOptUtils.getCurrentUserDetails((HttpServletRequest)request)), withChildrenDeep == null ? 1 : withChildrenDeep);
        this.saveOperationLog(request, jsonString, tableId, "update");
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e\u5e93\u8868\u6570\u636e\u5e26\u5b50\u8868")
    @RequestMapping(value={"/{tableId}/withChildren"}, method={RequestMethod.POST})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public ResponseData saveObjectWithChildren(@PathVariable String tableId, Integer withChildrenDeep, @RequestBody String jsonString, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        this.metaObjectService.saveObjectWithChildren(tableId, (Map<String, Object>)JSON.parseObject((String)jsonString), withChildrenDeep == null ? 1 : withChildrenDeep);
        this.saveOperationLog(request, jsonString, tableId, "save");
        return ResponseData.makeSuccessResponse();
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e\u5e93\u8868\u6570\u636e\u5e26\u5b50\u8868")
    @RequestMapping(value={"/{tableId}/withChildren"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public ResponseData deleteObjectWithChildren(@PathVariable String tableId, Integer withChildrenDeep, HttpServletRequest request) {
        this.checkUserOptPower(request, true);
        Map parameters = MetaObjectController.collectRequestParameters((HttpServletRequest)request);
        this.metaObjectService.deleteObjectWithChildren(tableId, parameters, withChildrenDeep == null ? 1 : withChildrenDeep);
        this.saveOperationLog(request, parameters, tableId, "delete");
        return ResponseData.makeSuccessResponse();
    }

    private void saveOperationLog(HttpServletRequest request, Object newValue, String optTag, String optMethod) {
        MetaTable tableInfo = this.metaDataCache.getTableInfo(optTag);
        if (tableInfo != null && tableInfo.isWriteOptLog()) {
            OperationLogCenter.log((OperationLog)OperationLog.create().user(WebOptUtils.getCurrentUserCode((HttpServletRequest)request)).unit(WebOptUtils.getCurrentUnitCode((HttpServletRequest)request)).topUnit(WebOptUtils.getCurrentTopUnit((HttpServletRequest)request)).correlation(WebOptUtils.getCorrelationId((HttpServletRequest)request)).tag(optTag).method(optMethod).operation("metaData").content("\u5143\u6570\u636e\u64cd\u4f5c").newObject(newValue));
        }
    }

    private void checkUserOptPower(HttpServletRequest request, boolean checkInWorkGroup) {
        String osIds;
        String userCode = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)userCode)) {
            userCode = WebOptUtils.getRequestFirstOneParameter((HttpServletRequest)request, (String[])new String[]{"userCode"});
        }
        if (StringUtils.isBlank((CharSequence)userCode)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55!");
        }
        String topUnit = WebOptUtils.getCurrentTopUnit((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)topUnit)) {
            throw new ObjectException(703, "\u60a8\u8fd8\u672a\u52a0\u5165\u4efb\u4f55\u79df\u6237!");
        }
        List osInfos = CodeRepositoryUtil.listOsInfo((String)topUnit);
        if (CollectionUtils.sizeIsEmpty((Object)osInfos)) {
            throw new ObjectException(703, "\u60a8\u5f53\u524d\u6240\u5728\u7684\u79df\u6237\u8fd8\u672a\u521b\u5efa\u4efb\u4f55\u5e94\u7528!");
        }
        if (checkInWorkGroup && !this.platformEnvironment.loginUserIsExistWorkGroup(osIds = osInfos.stream().map(OsInfo::getOsId).collect(Collectors.joining(",")), userCode)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff01");
        }
    }

    @ApiOperation(value="\u6839\u636e\u81ea\u5b9a\u4e49\u67e5\u8be2\u83b7\u53d6\u6570\u636e")
    @RequestMapping(value={"/sqlQuery"}, method={RequestMethod.PUT})
    @ApiImplicitParam(name="queryJson", value="\u67e5\u8be2\u8bed\u53e5\uff1a\u5c5e\u6027 database \u6570\u636e\u5e93id\uff0csql \u67e5\u8be2\u8bed\u53e5\uff0c\u4ee5aescbc:\u5f00\u5934 \uff0cparams \u53c2\u6570Map \u5982\u6709\u662f\u5206\u9875\u67e5\u8be2\u5fc5\u987b\u6709\u53c2\u6570 pageSize ", required=true, paramType="path", dataType="String")
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public JSONArray queryDatabaseBySql(@RequestBody String queryJson, HttpServletRequest request) {
        this.checkUserOptPower(request, false);
        JSONObject json = JSONObject.parseObject((String)queryJson);
        String sqlSen = json.getString("sql");
        if (StringUtils.isBlank((CharSequence)sqlSen) || !sqlSen.startsWith("aescbc:")) {
            throw new ObjectException(611, "\u67e5\u8be2\u8bed\u53e5\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        if (!StringUtils.startsWithIgnoreCase((CharSequence)(sqlSen = SecurityOptUtils.decodeSecurityString((String)sqlSen)), (CharSequence)"select") || StringUtils.containsAnyIgnoreCase((CharSequence)sqlSen, (CharSequence[])new CharSequence[]{";", "update", "delete", "insert", "drop", "create"})) {
            throw new ObjectException(611, "\u67e5\u8be2\u8bed\u53e5\u683c\u5f0f\u4e0d\u6b63\u786e!");
        }
        String databaseCode = json.getString("database");
        JSONObject params = json.getJSONObject("params");
        PageDesc pageDesc = null;
        Object pageSize = params.get("pageSize");
        if (pageSize != null && NumberBaseOpt.castObjectToInteger((Object)pageSize, (Integer)-1) > 0) {
            pageDesc = new PageDesc();
            pageDesc.setPageSize(NumberBaseOpt.castObjectToInteger((Object)pageSize, (Integer)-1).intValue());
            pageDesc.setPageNo(NumberBaseOpt.castObjectToInteger((Object)params.get("pageNo"), (Integer)1).intValue());
        }
        if (pageDesc != null) {
            return this.metaObjectService.pageQueryDatas(databaseCode, sqlSen, (Map<String, Object>)params, pageDesc);
        }
        return this.metaObjectService.queryDatas(databaseCode, sqlSen, (Map<String, Object>)params);
    }

    @ApiOperation(value="\u83b7\u53d6\u8868\u5b57\u6bb5\u7684\u53c2\u7167\u5f15\u7528\u6570\u636e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="tableId", value="\u8868id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="columnCode", value="\u5b57\u6bb5\u4ee3\u7801", required=true, paramType="path", dataType="String")})
    @RequestMapping(value={"/refData/{tableId}/{columnCode}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    @MetadataJdbcTransaction
    public Map<String, String> getColumnRefDictionary(@PathVariable String tableId, @PathVariable String columnCode, HttpServletRequest request) {
        return this.metaObjectService.fetchColumnRefData(tableId, columnCode, WebOptUtils.getCurrentTopUnit((HttpServletRequest)request), WebOptUtils.getCurrentLang((HttpServletRequest)request));
    }
}

