/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.metadata.transaction;

import com.centit.product.metadata.api.ISourceInfo;
import com.centit.support.algorithm.BooleanBaseOpt;
import com.centit.support.network.HttpExecutor;
import com.centit.support.network.HttpExecutorContext;
import java.io.IOException;
import java.util.Map;
import org.apache.http.client.CookieStore;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpContextCreator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractHttpContextCreator.class);

    private AbstractHttpContextCreator() {
        throw new IllegalAccessError("Utility class");
    }

    private static void loginOpt(ISourceInfo dsDesc, HttpClientContext context, CloseableHttpClient httpClient) throws IOException {
        if (dsDesc.getExtProps() != null && dsDesc.getExtProps().get("loginUrl") != null) {
            HttpExecutor.formPost((HttpExecutorContext)HttpExecutorContext.create((CloseableHttpClient)httpClient).context((HttpContext)context), (String)((String)dsDesc.getExtProps().get("loginUrl")), (Object)dsDesc.getExtProps(), (boolean)false);
        }
    }

    static synchronized HttpExecutorContext createHttpConnect(ISourceInfo dsDesc) throws Exception {
        Map extProps = dsDesc.getExtProps();
        if (extProps.containsKey("SSL") && BooleanBaseOpt.castObjectToBoolean(extProps.get("SSL")).booleanValue()) {
            CloseableHttpClient keepSessionHttpsClient = HttpExecutor.createKeepSessionHttpsClient();
            return HttpExecutorContext.create((CloseableHttpClient)keepSessionHttpsClient);
        }
        HttpClientContext context = HttpClientContext.create();
        BasicCookieStore cookieStore = new BasicCookieStore();
        CloseableHttpClient httpClient = HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();
        AbstractHttpContextCreator.loginOpt(dsDesc, context, httpClient);
        context.setCookieStore((CookieStore)cookieStore);
        return HttpExecutorContext.create((CloseableHttpClient)httpClient).context((HttpContext)context).header("Connection", "close").timout(10000);
    }
}

