/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.dao;

import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.product.oa.po.WorkDay;
import com.centit.support.algorithm.CollectionsOpt;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class WorkDayDao
extends BaseDaoImpl<WorkDay, String> {
    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("workDay", "EQUAL");
        filterField.put("dayType", "EQUAL");
        filterField.put("workTimeType", "EQUAL");
        filterField.put("startDate", "WORK_DAY >= :startDate");
        filterField.put("endDate", "WORK_DAY <= :endDate");
        return filterField;
    }

    public WorkDay getWorkDay(String topUnit, Date currDate) {
        List workDays = super.listObjectsByFilter("where WORK_DAY = ? and (TOP_UNIT = 'system' or TOP_UNIT = ?)", new Object[]{WorkDay.toWorkDayId(currDate), topUnit});
        if (workDays.size() < 1) {
            return null;
        }
        if (workDays.size() == 1) {
            return (WorkDay)workDays.get(0);
        }
        for (WorkDay wd : workDays) {
            if (!StringUtils.equals((CharSequence)topUnit, (CharSequence)wd.getTopUnit())) continue;
            return wd;
        }
        return null;
    }

    public List<WorkDay> listWorkDays(String topUnit, Date startDate, Date endDate) {
        List workDays = super.listObjectsByFilter("where WORK_DAY >= ? and WORK_DAY <= ? and (TOP_UNIT = 'system' or TOP_UNIT = ?) order by WORK_DAY", new Object[]{WorkDay.toWorkDayId(startDate), WorkDay.toWorkDayId(endDate), topUnit});
        HashMap<String, WorkDay> dayMaps = new HashMap<String, WorkDay>();
        for (WorkDay wd : workDays) {
            if (!StringUtils.equals((CharSequence)topUnit, (CharSequence)wd.getTopUnit()) && dayMaps.containsKey(wd.getWorkDay())) continue;
            dayMaps.put(wd.getWorkDay(), wd);
        }
        return CollectionsOpt.cloneList(dayMaps.values());
    }
}

