/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.po;

import com.alibaba.fastjson2.annotation.JSONField;
import com.centit.fileserver.common.FileBaseInfo;
import com.centit.framework.core.dao.DictionaryMap;
import com.centit.support.algorithm.DatetimeOpt;
import com.centit.support.database.orm.GeneratorCondition;
import com.centit.support.database.orm.GeneratorTime;
import com.centit.support.database.orm.GeneratorType;
import com.centit.support.database.orm.ValueGenerator;
import com.centit.support.file.FileType;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;

@Entity
@Table(name="FILE_INFO")
public class FileInfo
implements FileBaseInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FILE_CATALOG_APPLICATION = "A";
    public static final String FILE_CATALOG_MODEL = "B";
    public static final String FILE_CATALOG_RUN = "C";
    public static final String FOLDER_RESOURCES_NAME = "resources";
    public static final String FOLDER_ATTACHMENTS_NAME = "attachments";
    public static final String FOLDER_DEFAULT_BREAK = "/";
    @Id
    @Column(name="FILE_ID")
    @ValueGenerator(strategy=GeneratorType.UUID, condition=GeneratorCondition.IFNULL)
    private String fileId;
    @Column(name="FILE_MD5")
    private String fileMd5;
    @Column(name="FILE_NAME")
    private String fileName;
    @Column(name="FILE_SHOW_PATH")
    private String fileShowPath;
    @Column(name="FILE_TYPE")
    private String fileType;
    @Column(name="FILE_STATE")
    private String fileState = "N";
    @Column(name="FILE_DESC")
    private String fileDesc;
    @Column(name="INDEX_STATE")
    private String indexState = "N";
    @Column(name="DOWNLOAD_TIMES")
    private Long downloadTimes = 0L;
    @Column(name="OS_ID")
    private String osId = "NOTSET";
    @Column(name="OPT_ID")
    private String optId = "NOTSET";
    @Column(name="OPT_METHOD")
    private String optMethod;
    @Column(name="OPT_TAG")
    private String optTag;
    @Column(name="CREATED")
    private String created;
    @Column(name="CREATE_TIME")
    @ValueGenerator(strategy=GeneratorType.FUNCTION, occasion=GeneratorTime.NEW, value="today()")
    private Date createTime = DatetimeOpt.currentUtilDate();
    @Column(name="ENCRYPT_TYPE")
    private String encryptType = "N";
    @Column(name="FILE_OWNER")
    @DictionaryMap(fieldName={"ownerName"}, value={"userCode"})
    private String fileOwner;
    @Column(name="FILE_UNIT")
    private String fileUnit;
    @Column(name="ATTACHED_FILE_MD5")
    private String attachedFileMd5;
    @Column(name="ATTACHED_TYPE")
    private String attachedType;
    @Column(name="auth_code")
    @JSONField(serialize=false)
    private String authCode;
    @Column(name="library_id")
    private String libraryId;
    @Column(name="parent_folder")
    private String parentFolder;
    @Column(name="file_catalog")
    private String fileCatalog;
    @Transient
    private long fileSize;

    public static String mapEncryptType(String encryptType) {
        if (FILE_CATALOG_APPLICATION.equalsIgnoreCase(encryptType)) {
            return "AES";
        }
        if ("S".equalsIgnoreCase(encryptType)) {
            return "AES_CBC";
        }
        if ("G".equalsIgnoreCase(encryptType)) {
            return "SM4_CBC";
        }
        if ("M".equalsIgnoreCase(encryptType)) {
            return "SM4";
        }
        if ("Z".equalsIgnoreCase(encryptType)) {
            return "ZIP";
        }
        return "NO";
    }

    @Override
    public String getParentFolder() {
        if (StringUtils.isBlank((CharSequence)this.parentFolder)) {
            return StringUtils.substringAfterLast((String)this.fileShowPath, (String)FOLDER_DEFAULT_BREAK);
        }
        return this.parentFolder;
    }

    public void setFileName(String fileName) {
        String fileExtName;
        this.fileName = fileName;
        if (StringUtils.isNotBlank((CharSequence)fileName) && StringUtils.isNotBlank((CharSequence)(fileExtName = FileType.getFileExtName((String)fileName)))) {
            this.fileType = fileExtName;
        }
    }

    public Long addDownloadTimes() {
        this.downloadTimes = this.downloadTimes == null ? Long.valueOf(1L) : Long.valueOf(this.downloadTimes + 1L);
        return this.downloadTimes;
    }

    public void copyNotNullProperty(FileInfo other) {
        if (StringUtils.isNotBlank((CharSequence)other.getFileMd5())) {
            this.fileMd5 = other.getFileMd5();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getFileId())) {
            this.fileId = other.getFileId();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getFileState())) {
            this.fileState = other.getFileState();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getFileName())) {
            this.fileName = other.getFileName();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getFileShowPath())) {
            this.fileShowPath = other.getFileShowPath();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getFileType())) {
            this.fileType = other.getFileType();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getFileState())) {
            this.fileState = other.getFileState();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getFileDesc())) {
            this.fileDesc = other.getFileDesc();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getOsId())) {
            this.osId = other.getOsId();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getOptId())) {
            this.optId = other.getOptId();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getOptMethod())) {
            this.optMethod = other.getOptMethod();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getOptTag())) {
            this.optTag = other.getOptTag();
        }
        if (other.getCreated() != null) {
            this.created = other.getCreated();
        }
        if (other.getCreateTime() != null) {
            this.createTime = other.getCreateTime();
        }
        this.fileSize = other.getFileSize();
        if (StringUtils.isNotBlank((CharSequence)other.getFileOwner())) {
            this.fileOwner = other.getFileOwner();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getFileUnit())) {
            this.fileUnit = other.getFileUnit();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getParentFolder())) {
            this.parentFolder = other.getParentFolder();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getLibraryId())) {
            this.libraryId = other.getLibraryId();
        }
        if (StringUtils.isNotBlank((CharSequence)other.getFileMd5())) {
            this.fileMd5 = other.getFileMd5();
        }
    }

    public void copy(Object other) {
        FileBaseInfo otherFile;
        if (other instanceof FileBaseInfo) {
            otherFile = (FileBaseInfo)other;
            this.fileId = otherFile.getFileId();
            this.fileMd5 = otherFile.getFileMd5();
            this.fileType = otherFile.getFileType();
            this.fileName = otherFile.getFileName();
            this.osId = otherFile.getOsId();
            this.optId = otherFile.getOptId();
            this.fileOwner = otherFile.getFileOwner();
            this.fileUnit = otherFile.getFileUnit();
            this.libraryId = otherFile.getLibraryId();
        }
        if (other instanceof FileInfo) {
            otherFile = (FileInfo)other;
            this.fileShowPath = ((FileInfo)otherFile).getFileShowPath();
            this.fileState = ((FileInfo)otherFile).getFileState();
            this.fileDesc = ((FileInfo)otherFile).getFileDesc();
            this.optMethod = ((FileInfo)otherFile).getOptMethod();
            this.optTag = ((FileInfo)otherFile).getOptTag();
            this.created = ((FileInfo)otherFile).getCreated();
            this.createTime = ((FileInfo)otherFile).getCreateTime();
            this.authCode = ((FileInfo)otherFile).getAuthCode();
            this.parentFolder = ((FileInfo)otherFile).getParentFolder();
        }
    }

    @Override
    public String getFileId() {
        return this.fileId;
    }

    @Override
    public String getFileMd5() {
        return this.fileMd5;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getFileShowPath() {
        return this.fileShowPath;
    }

    @Override
    public String getFileType() {
        return this.fileType;
    }

    @Override
    public String getFileState() {
        return this.fileState;
    }

    @Override
    public String getFileDesc() {
        return this.fileDesc;
    }

    @Override
    public String getIndexState() {
        return this.indexState;
    }

    public Long getDownloadTimes() {
        return this.downloadTimes;
    }

    @Override
    public String getOsId() {
        return this.osId;
    }

    @Override
    public String getOptId() {
        return this.optId;
    }

    @Override
    public String getOptMethod() {
        return this.optMethod;
    }

    @Override
    public String getOptTag() {
        return this.optTag;
    }

    public String getCreated() {
        return this.created;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getEncryptType() {
        return this.encryptType;
    }

    @Override
    public String getFileOwner() {
        return this.fileOwner;
    }

    @Override
    public String getFileUnit() {
        return this.fileUnit;
    }

    @Override
    public String getAttachedFileMd5() {
        return this.attachedFileMd5;
    }

    @Override
    public String getAttachedType() {
        return this.attachedType;
    }

    @Override
    public String getAuthCode() {
        return this.authCode;
    }

    @Override
    public String getLibraryId() {
        return this.libraryId;
    }

    @Override
    public String getFileCatalog() {
        return this.fileCatalog;
    }

    @Override
    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setFileMd5(String fileMd5) {
        this.fileMd5 = fileMd5;
    }

    public void setFileShowPath(String fileShowPath) {
        this.fileShowPath = fileShowPath;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public void setFileState(String fileState) {
        this.fileState = fileState;
    }

    public void setFileDesc(String fileDesc) {
        this.fileDesc = fileDesc;
    }

    public void setIndexState(String indexState) {
        this.indexState = indexState;
    }

    public void setDownloadTimes(Long downloadTimes) {
        this.downloadTimes = downloadTimes;
    }

    public void setOsId(String osId) {
        this.osId = osId;
    }

    public void setOptId(String optId) {
        this.optId = optId;
    }

    public void setOptMethod(String optMethod) {
        this.optMethod = optMethod;
    }

    public void setOptTag(String optTag) {
        this.optTag = optTag;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setEncryptType(String encryptType) {
        this.encryptType = encryptType;
    }

    public void setFileOwner(String fileOwner) {
        this.fileOwner = fileOwner;
    }

    public void setFileUnit(String fileUnit) {
        this.fileUnit = fileUnit;
    }

    public void setAttachedFileMd5(String attachedFileMd5) {
        this.attachedFileMd5 = attachedFileMd5;
    }

    public void setAttachedType(String attachedType) {
        this.attachedType = attachedType;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public void setParentFolder(String parentFolder) {
        this.parentFolder = parentFolder;
    }

    public void setFileCatalog(String fileCatalog) {
        this.fileCatalog = fileCatalog;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileInfo)) {
            return false;
        }
        FileInfo other = (FileInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFileSize() != other.getFileSize()) {
            return false;
        }
        Long this$downloadTimes = this.getDownloadTimes();
        Long other$downloadTimes = other.getDownloadTimes();
        if (this$downloadTimes == null ? other$downloadTimes != null : !((Object)this$downloadTimes).equals(other$downloadTimes)) {
            return false;
        }
        String this$fileId = this.getFileId();
        String other$fileId = other.getFileId();
        if (this$fileId == null ? other$fileId != null : !this$fileId.equals(other$fileId)) {
            return false;
        }
        String this$fileMd5 = this.getFileMd5();
        String other$fileMd5 = other.getFileMd5();
        if (this$fileMd5 == null ? other$fileMd5 != null : !this$fileMd5.equals(other$fileMd5)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$fileShowPath = this.getFileShowPath();
        String other$fileShowPath = other.getFileShowPath();
        if (this$fileShowPath == null ? other$fileShowPath != null : !this$fileShowPath.equals(other$fileShowPath)) {
            return false;
        }
        String this$fileType = this.getFileType();
        String other$fileType = other.getFileType();
        if (this$fileType == null ? other$fileType != null : !this$fileType.equals(other$fileType)) {
            return false;
        }
        String this$fileState = this.getFileState();
        String other$fileState = other.getFileState();
        if (this$fileState == null ? other$fileState != null : !this$fileState.equals(other$fileState)) {
            return false;
        }
        String this$fileDesc = this.getFileDesc();
        String other$fileDesc = other.getFileDesc();
        if (this$fileDesc == null ? other$fileDesc != null : !this$fileDesc.equals(other$fileDesc)) {
            return false;
        }
        String this$indexState = this.getIndexState();
        String other$indexState = other.getIndexState();
        if (this$indexState == null ? other$indexState != null : !this$indexState.equals(other$indexState)) {
            return false;
        }
        String this$osId = this.getOsId();
        String other$osId = other.getOsId();
        if (this$osId == null ? other$osId != null : !this$osId.equals(other$osId)) {
            return false;
        }
        String this$optId = this.getOptId();
        String other$optId = other.getOptId();
        if (this$optId == null ? other$optId != null : !this$optId.equals(other$optId)) {
            return false;
        }
        String this$optMethod = this.getOptMethod();
        String other$optMethod = other.getOptMethod();
        if (this$optMethod == null ? other$optMethod != null : !this$optMethod.equals(other$optMethod)) {
            return false;
        }
        String this$optTag = this.getOptTag();
        String other$optTag = other.getOptTag();
        if (this$optTag == null ? other$optTag != null : !this$optTag.equals(other$optTag)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$encryptType = this.getEncryptType();
        String other$encryptType = other.getEncryptType();
        if (this$encryptType == null ? other$encryptType != null : !this$encryptType.equals(other$encryptType)) {
            return false;
        }
        String this$fileOwner = this.getFileOwner();
        String other$fileOwner = other.getFileOwner();
        if (this$fileOwner == null ? other$fileOwner != null : !this$fileOwner.equals(other$fileOwner)) {
            return false;
        }
        String this$fileUnit = this.getFileUnit();
        String other$fileUnit = other.getFileUnit();
        if (this$fileUnit == null ? other$fileUnit != null : !this$fileUnit.equals(other$fileUnit)) {
            return false;
        }
        String this$attachedFileMd5 = this.getAttachedFileMd5();
        String other$attachedFileMd5 = other.getAttachedFileMd5();
        if (this$attachedFileMd5 == null ? other$attachedFileMd5 != null : !this$attachedFileMd5.equals(other$attachedFileMd5)) {
            return false;
        }
        String this$attachedType = this.getAttachedType();
        String other$attachedType = other.getAttachedType();
        if (this$attachedType == null ? other$attachedType != null : !this$attachedType.equals(other$attachedType)) {
            return false;
        }
        String this$authCode = this.getAuthCode();
        String other$authCode = other.getAuthCode();
        if (this$authCode == null ? other$authCode != null : !this$authCode.equals(other$authCode)) {
            return false;
        }
        String this$libraryId = this.getLibraryId();
        String other$libraryId = other.getLibraryId();
        if (this$libraryId == null ? other$libraryId != null : !this$libraryId.equals(other$libraryId)) {
            return false;
        }
        String this$parentFolder = this.getParentFolder();
        String other$parentFolder = other.getParentFolder();
        if (this$parentFolder == null ? other$parentFolder != null : !this$parentFolder.equals(other$parentFolder)) {
            return false;
        }
        String this$fileCatalog = this.getFileCatalog();
        String other$fileCatalog = other.getFileCatalog();
        return !(this$fileCatalog == null ? other$fileCatalog != null : !this$fileCatalog.equals(other$fileCatalog));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fileSize = this.getFileSize();
        result = result * 59 + (int)($fileSize >>> 32 ^ $fileSize);
        Long $downloadTimes = this.getDownloadTimes();
        result = result * 59 + ($downloadTimes == null ? 43 : ((Object)$downloadTimes).hashCode());
        String $fileId = this.getFileId();
        result = result * 59 + ($fileId == null ? 43 : $fileId.hashCode());
        String $fileMd5 = this.getFileMd5();
        result = result * 59 + ($fileMd5 == null ? 43 : $fileMd5.hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $fileShowPath = this.getFileShowPath();
        result = result * 59 + ($fileShowPath == null ? 43 : $fileShowPath.hashCode());
        String $fileType = this.getFileType();
        result = result * 59 + ($fileType == null ? 43 : $fileType.hashCode());
        String $fileState = this.getFileState();
        result = result * 59 + ($fileState == null ? 43 : $fileState.hashCode());
        String $fileDesc = this.getFileDesc();
        result = result * 59 + ($fileDesc == null ? 43 : $fileDesc.hashCode());
        String $indexState = this.getIndexState();
        result = result * 59 + ($indexState == null ? 43 : $indexState.hashCode());
        String $osId = this.getOsId();
        result = result * 59 + ($osId == null ? 43 : $osId.hashCode());
        String $optId = this.getOptId();
        result = result * 59 + ($optId == null ? 43 : $optId.hashCode());
        String $optMethod = this.getOptMethod();
        result = result * 59 + ($optMethod == null ? 43 : $optMethod.hashCode());
        String $optTag = this.getOptTag();
        result = result * 59 + ($optTag == null ? 43 : $optTag.hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $encryptType = this.getEncryptType();
        result = result * 59 + ($encryptType == null ? 43 : $encryptType.hashCode());
        String $fileOwner = this.getFileOwner();
        result = result * 59 + ($fileOwner == null ? 43 : $fileOwner.hashCode());
        String $fileUnit = this.getFileUnit();
        result = result * 59 + ($fileUnit == null ? 43 : $fileUnit.hashCode());
        String $attachedFileMd5 = this.getAttachedFileMd5();
        result = result * 59 + ($attachedFileMd5 == null ? 43 : $attachedFileMd5.hashCode());
        String $attachedType = this.getAttachedType();
        result = result * 59 + ($attachedType == null ? 43 : $attachedType.hashCode());
        String $authCode = this.getAuthCode();
        result = result * 59 + ($authCode == null ? 43 : $authCode.hashCode());
        String $libraryId = this.getLibraryId();
        result = result * 59 + ($libraryId == null ? 43 : $libraryId.hashCode());
        String $parentFolder = this.getParentFolder();
        result = result * 59 + ($parentFolder == null ? 43 : $parentFolder.hashCode());
        String $fileCatalog = this.getFileCatalog();
        result = result * 59 + ($fileCatalog == null ? 43 : $fileCatalog.hashCode());
        return result;
    }

    public String toString() {
        return "FileInfo(fileId=" + this.getFileId() + ", fileMd5=" + this.getFileMd5() + ", fileName=" + this.getFileName() + ", fileShowPath=" + this.getFileShowPath() + ", fileType=" + this.getFileType() + ", fileState=" + this.getFileState() + ", fileDesc=" + this.getFileDesc() + ", indexState=" + this.getIndexState() + ", downloadTimes=" + this.getDownloadTimes() + ", osId=" + this.getOsId() + ", optId=" + this.getOptId() + ", optMethod=" + this.getOptMethod() + ", optTag=" + this.getOptTag() + ", created=" + this.getCreated() + ", createTime=" + this.getCreateTime() + ", encryptType=" + this.getEncryptType() + ", fileOwner=" + this.getFileOwner() + ", fileUnit=" + this.getFileUnit() + ", attachedFileMd5=" + this.getAttachedFileMd5() + ", attachedType=" + this.getAttachedType() + ", authCode=" + this.getAuthCode() + ", libraryId=" + this.getLibraryId() + ", parentFolder=" + this.getParentFolder() + ", fileCatalog=" + this.getFileCatalog() + ", fileSize=" + this.getFileSize() + ")";
    }
}

