/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.utils;

import com.centit.support.algorithm.NumberBaseOpt;
import com.centit.support.algorithm.StringRegularOpt;
import com.centit.support.algorithm.UuidOpt;
import com.centit.support.file.FileMD5Maker;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SystemTempFileUtils {
    private static Logger logger = LoggerFactory.getLogger(SystemTempFileUtils.class);
    private static String TEMP_FILE_DIRECTORY = null;

    public static synchronized void setTempFileDirectory(String tempFileDirectory) {
        TEMP_FILE_DIRECTORY = tempFileDirectory.endsWith("/") || tempFileDirectory.endsWith("\\") ? tempFileDirectory : tempFileDirectory + File.separatorChar;
    }

    public static String getTempFilePath(String fileId) {
        return SystemTempFileUtils.getTempDirectory() + fileId + ".tmp";
    }

    public static String getTempFilePath(String fileMd5, long size) {
        return SystemTempFileUtils.getTempDirectory() + fileMd5 + "_" + size + ".tmp";
    }

    public static String getTempDirectory() {
        if (StringUtils.isBlank((CharSequence)TEMP_FILE_DIRECTORY)) {
            SystemTempFileUtils.setTempFileDirectory(System.getProperty("java.io.tmpdir"));
        }
        return TEMP_FILE_DIRECTORY;
    }

    public static String getRandomTempFilePath() {
        return SystemTempFileUtils.getTempDirectory() + UuidOpt.getUuidAsString32() + ".tmp";
    }

    public static long checkTempFileSize(String filePath) {
        File f = new File(filePath);
        if (!f.exists()) {
            return 0L;
        }
        return f.length();
    }

    public static boolean checkFileCompleted(String filePath, String fileMd5) {
        try {
            return StringUtils.equals((CharSequence)fileMd5, (CharSequence)FileMD5Maker.makeFileMD5((File)new File(filePath)));
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean checkMd5AndSize(String md5SizeExt) {
        int len = md5SizeExt.length();
        if (len < 34) {
            return false;
        }
        if (md5SizeExt.charAt(32) != '_') {
            return false;
        }
        int pos = md5SizeExt.indexOf(46);
        String fileSize = pos < 0 ? md5SizeExt.substring(33) : md5SizeExt.substring(33, pos);
        return StringRegularOpt.isNumber((String)fileSize);
    }

    public static Pair<String, Long> fetchMd5AndSize(String md5SizeExt) {
        String fileMd5 = md5SizeExt.substring(0, 32);
        int pos = md5SizeExt.indexOf(46);
        long fileSize = pos < 0 ? NumberBaseOpt.parseLong((String)md5SizeExt.substring(33), (Long)0L) : NumberBaseOpt.parseLong((String)md5SizeExt.substring(33, pos), (Long)0L);
        return Pair.of((Object)fileMd5, (Object)fileSize);
    }
}

