/*
 * Decompiled with CFR 0.152.
 */
package com.centit.fileserver.task.plugin;

import com.centit.fileserver.common.FileTaskInfo;
import com.centit.fileserver.common.FileTaskQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisFileTaskQueue
implements FileTaskQueue {
    private static final Logger logger = LoggerFactory.getLogger(RedisFileTaskQueue.class);
    private static final String FILE_TASK_INFO_KEY = "file:task:info:list";
    private RedisTemplate redisTemplate;

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean add(FileTaskInfo taskInfo) {
        this.redisTemplate.opsForList().rightPush((Object)FILE_TASK_INFO_KEY, (Object)taskInfo);
        logger.info("\u4efb\u52a1\u52a0\u5165Redis\u961f\u5217");
        return true;
    }

    public FileTaskInfo get() {
        return (FileTaskInfo)this.redisTemplate.opsForList().leftPop((Object)FILE_TASK_INFO_KEY);
    }
}

