/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.dao;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.jdbc.dao.BaseDaoImpl;
import com.centit.framework.jdbc.dao.DatabaseOptUtils;
import com.centit.product.oa.po.InnerMsg;
import com.centit.support.algorithm.StringBaseOpt;
import com.centit.support.database.utils.PageDesc;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository(value="innerMsgDao")
public class InnerMsgDao
extends BaseDaoImpl<InnerMsg, String> {
    public InnerMsg getObjectById(String msgCode) {
        return (InnerMsg)super.getObjectById((Object)msgCode);
    }

    public List<InnerMsg> listObjects(Map<String, Object> filterMap) {
        return super.listObjectsByProperties(filterMap);
    }

    public Map<String, String> getFilterField() {
        HashMap<String, String> filterField = new HashMap<String, String>();
        filterField.put("msgType", "EQUAL");
        filterField.put("msgTitle", "LIKE");
        filterField.put("msgContent", "LIKE");
        filterField.put("msgStateNot", "msgState != :msgStateNot");
        filterField.put("sender", "EQUAL");
        filterField.put("receive", "msgCode in (select re.MSG_CODE from f_inner_msg_recipient re Where re.RECEIVE = :receive )");
        return filterField;
    }

    @Transactional
    public void updateInnerMsg(InnerMsg innerMsg) {
        super.updateObject((Serializable)innerMsg);
    }

    public List<InnerMsg> listUnreadMessage(String userCode) {
        String queryString = "where MSG_CODE in (Select im.MSG_CODE from f_inner_msg_recipient im where  im.MAIL_TYPE='T' and im.msg_state='U' and RECEIVE= ?) order by SEND_DATE desc";
        return this.listObjectsByFilter(queryString, new Object[]{userCode});
    }

    @Transactional
    public String getNextKey() {
        return StringBaseOpt.objectToString((Object)DatabaseOptUtils.getSequenceNextValue((BaseDaoImpl)this, (String)"S_MSGCODE"));
    }

    @Transactional
    public List<InnerMsg> getExchangeMsgs(String sender, String receiver) {
        String queryString = "where( (MSG_CODE in (Select im.MSG_CODE from f_inner_msg_recipient im where im.RECEIVE= ?  ) and SENDER= ? and (MAIL_TYPE='I' or MAIL_TYPE='O')) or (MSG_CODE in(Select  im.MSG_CODE from f_inner_msg_recipient im where im.RECEIVE= ?  ) and SENDER= ? and (MAIL_TYPE='I' or MAIL_TYPE='O'))) order by SEND_DATE desc";
        return this.listObjectsByFilter(queryString, new Object[]{sender, receiver, receiver, sender});
    }

    public List<InnerMsg> getInnerMsgsByRecipientMsgCode(Map<String, Object> filterMap, PageDesc pageDesc) {
        String sql = " where OPT_ID = :optId and MSG_CODE in (SELECT Msg_Code FROM `f_inner_msg_recipient` WHERE Receive = :receive ";
        sql = null != filterMap.get("msgState") ? sql + " and msg_State = :msgState ) ORDER BY SEND_DATE desc " : sql + " ) ORDER BY SEND_DATE desc ";
        JSONArray objects = this.listObjectsByFilterAsJson(sql, filterMap, pageDesc);
        return objects.toJavaList(InnerMsg.class);
    }
}

