/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.oa.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.centit.framework.common.ResponseData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.core.dao.DictionaryMapUtils;
import com.centit.framework.model.adapter.MessageSender;
import com.centit.framework.model.basedata.IUnitInfo;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.NoticeMessage;
import com.centit.product.oa.dao.InnerMsgAnnexDao;
import com.centit.product.oa.dao.InnerMsgDao;
import com.centit.product.oa.dao.InnerMsgRecipientDao;
import com.centit.product.oa.po.InnerMsg;
import com.centit.product.oa.po.InnerMsgRecipient;
import com.centit.product.oa.service.InnerMessageManager;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="innerMessageManager")
public class InnerMessageManagerImpl
implements InnerMessageManager,
MessageSender {
    @Autowired
    @NotNull
    private InnerMsgRecipientDao innerMsgRecipientDao;
    @Autowired
    private InnerMsgDao innerMsgDao;
    @Autowired
    private InnerMsgAnnexDao innerMsgAnnexDao;
    protected static Logger logger = LoggerFactory.getLogger(InnerMessageManagerImpl.class);

    @Override
    @Transactional
    public void updateRecipient(InnerMsgRecipient recipient, InnerMsgRecipient recipientCopy) {
        recipient.setMsgCode(recipientCopy.getMsgCode());
        recipient.setReceive(recipientCopy.getReceive());
        this.innerMsgRecipientDao.updateInnerMsgRecipient(recipient);
    }

    @Override
    @Transactional
    public boolean sendInnerMsg(InnerMsg innerMsg, String sysUserCode) {
        boolean flag = this.innerMsgValidate(innerMsg, sysUserCode);
        if (!flag) {
            return false;
        }
        innerMsg.setSender(innerMsg.getSender());
        innerMsg.setMsgState("R");
        this.sendToMany(innerMsg);
        return true;
    }

    private void sendToMany(InnerMsg innerMsg) {
        List<InnerMsgRecipient> recipients = innerMsg.getRecipients();
        String receiveName = "";
        int bo = 0;
        for (InnerMsgRecipient recipient : recipients) {
            String receive = recipient.getReceive();
            String nextReceiveName = null;
            try {
                nextReceiveName = CodeRepositoryUtil.getUserInfoByCode((String)receive).getUserName();
            }
            catch (NullPointerException e) {
                logger.error(e.getMessage());
            }
            if (bo > 0) {
                receiveName = receiveName + ",";
            }
            ++bo;
            receiveName = receiveName + (nextReceiveName == null ? receive : nextReceiveName);
        }
        innerMsg.setReceiveName(receiveName);
        this.innerMsgDao.saveNewObject(innerMsg);
        this.innerMsgDao.saveObjectReferences(innerMsg);
    }

    @Override
    @Transactional
    public JSONArray getExchangeMsgRecipients(String sender, String receiver) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sender", sender);
        map.put("receiver", receiver);
        List<InnerMsg> exchangeMsgs = this.innerMsgDao.getExchangeMsgs(sender, receiver);
        return DictionaryMapUtils.objectsToJSONArray(exchangeMsgs);
    }

    @Override
    @Transactional
    public void noticeByUnitCode(String unitCode, InnerMsg msg) throws ObjectException {
        List unitList = CodeRepositoryUtil.getSubUnits((String)unitCode);
        Set userList = CodeRepositoryUtil.getUnitUsers((String)unitCode);
        for (IUnitInfo ui : unitList) {
            userList.addAll(CodeRepositoryUtil.getUnitUsers((String)ui.getUnitCode()));
        }
        if (userList.size() > 0) {
            String receiveName = CodeRepositoryUtil.getUnitName((String)unitCode);
            msg.setReceiveName(receiveName);
            msg.setMsgType("A");
            msg.setMailType("O");
            msg.setMsgState("R");
            this.innerMsgDao.saveNewObject(msg);
            for (IUserInfo ui : userList) {
                if (Objects.equals(msg.getSender(), ui.getUserCode())) continue;
                InnerMsgRecipient recipient = new InnerMsgRecipient();
                recipient.setMsgState("U");
                recipient.setMailType("T");
                recipient.setMsgCode(msg.getMsgCode());
                recipient.setReceive(ui.getUserCode());
                this.innerMsgRecipientDao.saveNewObject(recipient);
            }
        } else {
            throw new ObjectException("\u8be5\u673a\u6784\u4e2d\u6682\u65e0\u7528\u6237");
        }
    }

    @Override
    @Transactional
    public void updateMsgRecipientStateById(Map<String, Object> id, String msgState) {
        InnerMsgRecipient re = this.innerMsgRecipientDao.getObjectById(id);
        re.setMsgState(msgState);
        this.innerMsgRecipientDao.updateInnerMsgRecipient(re);
    }

    @Override
    @Transactional
    public long getUnreadMessageCount(String userCode) {
        return this.innerMsgRecipientDao.getUnreadMessageCount(userCode);
    }

    @Override
    @Transactional
    public List<InnerMsg> listUnreadMessage(String userCode) {
        return this.innerMsgDao.listUnreadMessage(userCode);
    }

    @Transactional
    public ResponseData sendMessage(String sender, String receiver, NoticeMessage message) {
        InnerMsg msg = InnerMsg.valueOf(message);
        msg.setSendDate(new Date());
        msg.setMsgType("M");
        msg.setMailType("O");
        msg.setMsgState("U");
        msg.setSender(sender);
        InnerMsgRecipient recipient = new InnerMsgRecipient();
        recipient.setMailType("T");
        recipient.setMsgState("U");
        String[] receives = new String[]{receiver};
        return ResponseData.successResponse;
    }

    @Override
    public List<InnerMsgRecipient> listMsgRecipients(Map<String, Object> filterMap) {
        return this.innerMsgRecipientDao.listObjects(filterMap);
    }

    @Override
    public List<InnerMsgRecipient> listMsgRecipients(Map<String, Object> filterMap, PageDesc pageDesc) {
        return this.innerMsgRecipientDao.listObjects(filterMap, pageDesc);
    }

    @Override
    public InnerMsgRecipient getMsgRecipientById(Map<String, Object> id) {
        return this.innerMsgRecipientDao.getObjectById(id);
    }

    @Override
    public List<InnerMsgRecipient> getMsgRecipientByMsgCode(Map<String, Object> msgCode) {
        return this.innerMsgRecipientDao.listObjectsByProperties(msgCode);
    }

    @Override
    public List<InnerMsgRecipient> listMsgRecipientsCascade(Map<String, Object> filterMap) {
        return this.innerMsgRecipientDao.listObjects(filterMap);
    }

    @Override
    public List<InnerMsg> listMsgRecipientsCascade(Map<String, Object> filterMap, PageDesc pageDesc) {
        List<InnerMsg> innerMsgs = this.innerMsgDao.getInnerMsgsByRecipientMsgCode(filterMap, pageDesc);
        List innerMsgRecipients = this.innerMsgRecipientDao.listObjectsByProperties(filterMap);
        HashMap<String, InnerMsg> temMsgHashMap = new HashMap<String, InnerMsg>();
        for (InnerMsg innerMsg : innerMsgs) {
            temMsgHashMap.put(innerMsg.getMsgCode(), innerMsg);
        }
        HashMap<String, String> annerxFilterMap = new HashMap<String, String>();
        for (InnerMsgRecipient innerMsgRecipient : innerMsgRecipients) {
            InnerMsg innerMsg = (InnerMsg)temMsgHashMap.get(innerMsgRecipient.getMsgCode());
            if (innerMsg == null) continue;
            innerMsg.setMsgState(innerMsgRecipient.getMsgState());
            annerxFilterMap.put("msgCode", innerMsg.getMsgCode());
            List innerMsgAnnexes = this.innerMsgAnnexDao.listObjectsByProperties(annerxFilterMap);
            innerMsg.setInnerMsgAnnexs(innerMsgAnnexes);
        }
        ArrayList<InnerMsg> arrayList = new ArrayList<InnerMsg>();
        for (Map.Entry entry : temMsgHashMap.entrySet()) {
            arrayList.add((InnerMsg)entry.getValue());
        }
        arrayList.sort(Comparator.comparing(InnerMsg::getSendDate));
        return arrayList;
    }

    @Override
    @Transactional
    public void updateInnerMsg(InnerMsg msg, InnerMsg copMsg) {
        this.innerMsgDao.updateInnerMsg(msg);
        this.innerMsgDao.saveObjectReferences(msg);
    }

    @Override
    @Transactional
    public void deleteInnerMsgById(String msgCode) {
        InnerMsg msg = this.innerMsgDao.getObjectById(msgCode);
        msg.setMsgState("D");
        this.innerMsgDao.updateInnerMsg(msg);
    }

    @Override
    public List<InnerMsg> listInnerMsgs(Map<String, Object> filterMap) {
        return this.innerMsgDao.listObjects(filterMap);
    }

    @Override
    public List<InnerMsg> listInnerMsgs(Map<String, Object> filterMap, PageDesc pageDesc) {
        if (null == filterMap.get("sort") || null == filterMap.get("SORT")) {
            filterMap.put("sort", "desc");
        }
        filterMap.put("order_by", "SEND_DATE");
        return this.innerMsgDao.listObjects(filterMap, pageDesc);
    }

    @Override
    public InnerMsg getInnerMsgById(String msgCode) {
        if (this.innerMsgDao.getObjectById(msgCode) == null) {
            return null;
        }
        return (InnerMsg)this.innerMsgDao.getObjectWithReferences(msgCode);
    }

    private boolean innerMsgValidate(InnerMsg innerMsg, String sysUserCode) {
        if (!StringUtils.isNotBlank((CharSequence)sysUserCode)) {
            return false;
        }
        if (null == innerMsg.getRecipients() || innerMsg.getRecipients().size() == 0) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(innerMsg.getMsgTitle());
        arrayList.add(innerMsg.getMsgContent());
        arrayList.add(innerMsg.getMailType());
        arrayList.add(innerMsg.getOptId());
        arrayList.add(innerMsg.getRecipients().get(0).getReceive());
        for (String s : arrayList) {
            if (StringUtils.isNotBlank((CharSequence)s)) continue;
            return false;
        }
        return true;
    }
}

