/*
 * Decompiled with CFR 0.152.
 */
package com.centit.product.message;

import com.centit.framework.common.ResponseData;
import com.centit.framework.components.CodeRepositoryUtil;
import com.centit.framework.model.adapter.MessageSender;
import com.centit.framework.model.basedata.IUserInfo;
import com.centit.framework.model.basedata.NoticeMessage;
import java.io.UnsupportedEncodingException;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailMessageSenderImpl
implements MessageSender {
    private static final Logger logger = LoggerFactory.getLogger(EmailMessageSenderImpl.class);
    private String hostName;
    private int smtpPort;
    private String userName;
    private String userPassword;
    private String serverEmail;

    public EmailMessageSenderImpl() {
        this.smtpPort = 25;
    }

    public EmailMessageSenderImpl(String hostName, int smtpPort) {
        this.hostName = hostName;
        this.smtpPort = smtpPort;
    }

    private void sendEmailMessage(String mailTo, String mailFrom, String msgSubject, String msgContent) throws EmailException, UnsupportedEncodingException {
        MultiPartEmail multMail = new MultiPartEmail();
        multMail.setHostName(this.hostName);
        multMail.setSmtpPort(this.smtpPort);
        multMail.setAuthentication(this.userName, this.userPassword);
        multMail.setFrom(mailFrom);
        multMail.addTo(mailTo);
        multMail.setCharset("utf-8");
        multMail.setSubject(msgSubject);
        if (msgContent.endsWith("</html>") || msgContent.endsWith("</HTML>")) {
            multMail.addPart(msgContent, "text/html;charset=utf-8");
        } else {
            multMail.setContent((Object)msgContent, "text/plain;charset=gb2312");
        }
        multMail.send();
    }

    public ResponseData sendMessage(String sender, String receiver, NoticeMessage message) {
        IUserInfo userinfo = CodeRepositoryUtil.getUserInfoByCode((String)sender);
        String mailFrom = userinfo == null ? this.serverEmail : userinfo.getRegEmail();
        userinfo = CodeRepositoryUtil.getUserInfoByCode((String)receiver);
        if (userinfo == null) {
            logger.error("\u627e\u4e0d\u5230\u7528\u6237\uff1a" + receiver);
            return ResponseData.makeErrorMessage((int)710, (String)("\u627e\u4e0d\u5230\u7528\u6237\uff1a" + receiver));
        }
        String email = userinfo.getRegEmail();
        if (email != null && !"".equals(email)) {
            try {
                this.sendEmailMessage(email, mailFrom, message.getMsgSubject(), message.getMsgContent());
                return ResponseData.successResponse;
            }
            catch (UnsupportedEncodingException | EmailException e) {
                logger.error(e.getMessage(), e);
                return ResponseData.makeErrorMessage((String)e.getMessage());
            }
        }
        return ResponseData.makeErrorMessage((int)711, (String)("\u7528\u6237\uff1a" + receiver + "\u6ca1\u6709\u8bbe\u7f6e\u6ce8\u518c\u90ae\u7bb1"));
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setUserPassword(String userPassword) {
        this.userPassword = userPassword;
    }

    public void setServerEmail(String serverEmail) {
        this.serverEmail = serverEmail;
    }
}

