/*
 * Decompiled with CFR 0.152.
 */
package com.centit.metaform.controller;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.centit.framework.common.ResponseData;
import com.centit.framework.common.WebOptUtils;
import com.centit.framework.core.controller.BaseController;
import com.centit.framework.core.controller.WrapUpResponseBody;
import com.centit.framework.core.dao.PageQueryResult;
import com.centit.framework.model.adapter.PlatformEnvironment;
import com.centit.metaform.po.MetaFormModel;
import com.centit.metaform.service.MetaFormModelManager;
import com.centit.support.algorithm.CollectionsOpt;
import com.centit.support.common.ObjectException;
import com.centit.support.database.utils.PageDesc;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/metaformmodel"})
@Api(value="\u5df2\u53d1\u5e03\u7684\u81ea\u5b9a\u4e49\u8868\u5355\u7ba1\u7406", tags={"\u5df2\u53d1\u5e03\u7684\u81ea\u5b9a\u4e49\u8868\u5355\u7ba1\u7406"})
public class MetaFormModelController
extends BaseController {
    @Autowired
    private MetaFormModelManager metaFormModelMag;
    @Autowired
    private PlatformEnvironment platformEnvironment;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5df2\u53d1\u5e03\u7684\u901a\u7528\u6a21\u5757")
    @RequestMapping(method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult list(String[] field, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = MetaFormModelController.collectRequestParameters((HttpServletRequest)request);
        JSONArray listObjects = this.metaFormModelMag.listFormModeAsJson(field, searchColumn, pageDesc);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (String[])field, (Class[])new Class[]{MetaFormModel.class});
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{MetaFormModel.class});
    }

    @ApiOperation(value="\u67e5\u8be2\u5df2\u53d1\u5e03\u7684\u5de5\u4f5c\u6d41\u76f8\u5173\u6a21\u5757")
    @RequestMapping(value={"/workflow"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public PageQueryResult listFlowModel(String[] field, String optType, PageDesc pageDesc, HttpServletRequest request) {
        Map searchColumn = MetaFormModelController.collectRequestParameters((HttpServletRequest)request);
        if ("flow".equalsIgnoreCase(optType)) {
            searchColumn.put("flowOptType", "1");
        } else if ("node".equalsIgnoreCase(optType)) {
            searchColumn.put("flowOptType", "2");
        } else {
            searchColumn.put("allFlowOpt", "all");
        }
        JSONArray listObjects = this.metaFormModelMag.listFormModeAsJson(field, searchColumn, pageDesc);
        if (ArrayUtils.isNotEmpty((Object[])field)) {
            return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (String[])field, (Class[])new Class[]{MetaFormModel.class});
        }
        return PageQueryResult.createJSONArrayResult((JSONArray)listObjects, (PageDesc)pageDesc, (Class[])new Class[]{MetaFormModel.class});
    }

    @ApiOperation(value="\u67e5\u8be2\u5355\u4e2a\u5df2\u53d1\u5e03\u7684\u901a\u7528\u6a21\u5757,\u5176\u4e2dkeyProps\u4e3a\u5176\u4e3b\u8868\u5bf9\u5e94\u7684\u4e3b\u952e\u5b57\u6bb5\u540d\u79f0\u6570\u7ec4", response=MetaFormModel.class)
    @RequestMapping(value={"/{modelId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public MetaFormModel getMetaFormModel(@PathVariable String modelId) {
        return this.metaFormModelMag.getObjectById(modelId);
    }

    @ApiOperation(value="\u65b0\u589e\u901a\u7528\u6a21\u5757")
    @RequestMapping(method={RequestMethod.POST})
    @WrapUpResponseBody
    public String createMetaFormModel(@RequestBody MetaFormModel metaFormModel, HttpServletRequest request) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff01");
        }
        if (!this.platformEnvironment.loginUserIsExistWorkGroup(metaFormModel.getOsId(), loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff01");
        }
        MetaFormModel model = new MetaFormModel();
        model.copyNotNullProperty(metaFormModel);
        model.setRecorder(loginUser);
        this.metaFormModelMag.saveNewMetaFormModel(model);
        return model.getModelId();
    }

    @ApiOperation(value="\u5220\u9664\u5355\u4e2a\u901a\u7528\u6a21\u5757")
    @RequestMapping(value={"/{modelId}"}, method={RequestMethod.DELETE})
    @WrapUpResponseBody
    public void deleteMetaFormModel(@PathVariable String modelId, HttpServletRequest request) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff01");
        }
        MetaFormModel metaFormModel = this.metaFormModelMag.getObjectById(modelId);
        if (null == metaFormModel) {
            throw new ObjectException("\u8868\u5355\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        if (!this.platformEnvironment.loginUserIsExistWorkGroup(metaFormModel.getOsId(), loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff01");
        }
        this.metaFormModelMag.deleteObjectById(modelId);
    }

    @ApiOperation(value="\u7f16\u8f91\u901a\u7528\u6a21\u5757")
    @RequestMapping(value={"/{modelId}"}, method={RequestMethod.PUT})
    @WrapUpResponseBody
    public Date updateMetaFormModel(@PathVariable String modelId, @RequestBody MetaFormModel metaFormModel, HttpServletRequest request) {
        metaFormModel.setModelId(modelId);
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff01");
        }
        if (!this.platformEnvironment.loginUserIsExistWorkGroup(metaFormModel.getOsId(), loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff01");
        }
        this.metaFormModelMag.updateMetaFormModel(metaFormModel);
        return metaFormModel.getLastModifyDate();
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u5185\u5bb9")
    @RequestMapping(value={"/{modelId}/template"}, method={RequestMethod.GET})
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u8868\u5355\u6a21\u5757id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="type", value="\u8868\u5355\u7c7b\u578b\uff0c m\u3001mo\u3001mobile\u4e3a\u79fb\u52a8\u8868\u5355\uff0c\u5176\u4ed6\u7684\u9ed8\u8ba4\u8fd4\u56depc\u8868\u5355 ", paramType="query", dataType="String")})
    @WrapUpResponseBody
    public JSONObject getFormTemplate(@PathVariable String modelId, String type, HttpServletRequest request) {
        JSONObject model;
        boolean isFromMobile;
        MetaFormModel metaFormModel = this.metaFormModelMag.getObjectById(modelId);
        boolean bl = isFromMobile = StringUtils.isBlank((CharSequence)type) ? WebOptUtils.isFromMobile((HttpServletRequest)request) : StringUtils.equalsAnyIgnoreCase((CharSequence)type, (CharSequence[])new CharSequence[]{"m", "mo", "mobile"});
        if (isFromMobile && (model = metaFormModel.getMobileFormTemplate()) != null) {
            return model;
        }
        return metaFormModel.getFormTemplate();
    }

    @ApiOperation(value="\u4fee\u6539\u6a21\u677f\u5185\u5bb9")
    @RequestMapping(value={"/{modelId}/template"}, method={RequestMethod.PUT})
    @ApiImplicitParams(value={@ApiImplicitParam(name="modelId", value="\u8868\u5355\u6a21\u5757id", required=true, paramType="path", dataType="String"), @ApiImplicitParam(name="formTemplate", value="\u8868\u5355\u7c7b\u578b\uff0c m\u3001mo\u3001mobile\u4e3a\u66f4\u6539\u79fb\u52a8\u8868\u5355\uff0c\u5176\u4ed6\u7684\u9ed8\u8ba4\u66f4\u6539pc\u8868\u5355", required=true, paramType="body", dataType="String"), @ApiImplicitParam(name="type", value="\u8868\u5355\u7c7b\u578b\uff0c m\u3001mo\u3001mobile\u4e3a\u66f4\u6539\u79fb\u52a8\u8868\u5355\uff0c\u5176\u4ed6\u7684\u9ed8\u8ba4\u66f4\u6539pc\u8868\u5355", paramType="query", dataType="String")})
    @WrapUpResponseBody
    public void updateFormTemplate(@PathVariable String modelId, @RequestBody JSONObject formTemplate, String type, HttpServletRequest request) {
        String loginUser = WebOptUtils.getCurrentUserCode((HttpServletRequest)request);
        if (StringUtils.isBlank((CharSequence)loginUser)) {
            throw new ObjectException(302, "\u60a8\u672a\u767b\u5f55\uff01");
        }
        MetaFormModel metaFormModel = this.metaFormModelMag.getObjectById(modelId);
        if (!this.platformEnvironment.loginUserIsExistWorkGroup(metaFormModel.getOsId(), loginUser)) {
            throw new ObjectException(203, "\u60a8\u6ca1\u6709\u6743\u9650\uff01");
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)type, (CharSequence[])new CharSequence[]{"m", "mo", "mobile"})) {
            metaFormModel.setMobileFormTemplate(formTemplate);
        } else {
            metaFormModel.setFormTemplate(formTemplate);
        }
        this.metaFormModelMag.updateMetaFormModel(metaFormModel);
    }

    @ApiOperation(value="\u6839\u636eoptId\u83b7\u53d6\u6a21\u677f\u540d\u548c\u6a21\u5757id")
    @RequestMapping(value={"/metaform/{optId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData listModelByOptId(@PathVariable String optId) {
        return ResponseData.makeResponseData((Object)this.metaFormModelMag.listModelByOptId(optId));
    }

    @ApiOperation(value="\u9a8c\u8bc1\u5df2\u53d1\u5e03\u7684\u81ea\u5b9a\u4e49\u8868\u5355\u662f\u5426\u5b58\u5728")
    @RequestMapping(value={"/metaform/isexist/{modelId}"}, method={RequestMethod.GET})
    @WrapUpResponseBody
    public ResponseData checkMetaFormModelIsExist(@PathVariable String modelId) {
        int counts = this.metaFormModelMag.countMetaFormModels(CollectionsOpt.createHashMap((Object[])new Object[]{"modelId", modelId}));
        return ResponseData.makeResponseData((Object)(counts > 0 ? 1 : 0));
    }
}

